/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.segy;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.geo.Ellipsoid;
import de.gfz_potsdam.gipp.common.seis.EquallySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.segy.SegyException;
import de.gfz_potsdam.gipp.common.seis.segy.SegyFile;
import de.gfz_potsdam.gipp.common.seis.segy.SeismicUnix;
import de.gfz_potsdam.gipp.common.seis.segy.StandardSegy;
import de.gfz_potsdam.gipp.common.time.ParserException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import de.gfz_potsdam.gipp.tool.segy.GatherEntry;
import de.gfz_potsdam.gipp.tool.segy.ReceiverPoint;
import de.gfz_potsdam.gipp.tool.segy.Selection;
import de.gfz_potsdam.gipp.tool.segy.ShotPoint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class TraceToSection
extends GippToolsApplication {
    private static final TimeSpan DEFAULT_TRACE_LENGTH = new TimeSpan.Builder().addMinutes(1L).build();
    protected GatherMode gatherMode;
    protected Selection<Integer> gatherSelection;
    protected final CmdLineString shotGatherOption = new CmdLineString("shot-gather", "Write seismic sections organized by shot gather. If no 'FFID' range is specified, the program will try to write shot gathers for all 'FFID's found in the projects (geometry) configuration file.\nExample: To produce seismic sections of the shots with 'FFID' 1, 4, 5 and 6 you would use \"--shot-gather=1,4..6\". (Note: No spaces around the FFID numbers!)\nOnly one of the gather options (\"--shot-gather\" or \"--receiver-gather\") may be used at a time!");
    protected final CmdLineString receiverGatherOption = new CmdLineString("receiver-gather", "Write seismic sections organized by receiver gather. If no 'channel' range is specified, the program will try to write receiver gathers for all 'channel's found in the projects (geometry) configuration file.\nExample: To produce seismic sections for receivers with the 'channel' id 1, 4, 5 and 6 you would use \"--receiver-gather=1,4..6\". (Note: No spaces around the channel numbers!)\nOnly one of the gather options (\"--shot-gather\" or \"--receiver-gather\") may be used at a time!");
    protected final CmdLineString projectOption = new CmdLineString("project", "Use this option to indicate the file describing the experiment layout.\nNote: Sometimes, this file is also called the  \"master\" or the \"geometry\" file.");
    protected SeismicSectionFormat sectionFormat;
    protected final CmdLineString sectionFormatOption = new CmdLineString("segy-format", "Select the seismic section file format used for writing files. Pick one of the following:\n  SEGY ... SEG-Y revision 1 format (default)\n  SUOLD .. Seismic Unix  (old) native binary format\n  SUXDR .. Seismic Unix  platform independent XDR format", new String[]{"SEGY", "SUOLD", "SUXDR"});
    protected File outputDir = null;
    protected final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    protected boolean forceOverwrite = false;
    protected final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private boolean forceConcatenate = false;
    private final CmdLineBoolean forceConcatenateOption = new CmdLineBoolean("force-concat", "Concatenate the resulting shot/receiver gathers into a single file.\nBy default however, a new output file is created for every single gather.");
    protected TimeSpan traceLength;
    protected final CmdLineString traceLengthOption = new CmdLineString("trace-length", "Length of the traces in the resulting seismic section. The input format is \"SS.ssssss\" and is given in seconds.\nExample: To extract 2 minutes of data use \"--trace-length=120\".\nIf no trace length is given, the program will default to " + DEFAULT_TRACE_LENGTH + " length.");
    protected double traceOffset = 0.0;
    protected final CmdLineString traceOffsetOption = new CmdLineString("trace-offset", "Use this option to shift the start time of the traces in the seismic section relative to the trigger time of the shot. The input format is \"SS.ssssss\" and is given in seconds.\nExample: To start the seismic section 2 seconds before the shot time use \"--trace-offset=-2\". (Note the minus sign! No spaces!)\nIf no time offset is given, the program will default to begin the trace precisely at the shot time.");
    protected double reductionVelocity = 0.0;
    protected final CmdLineString reductionVelocityOption = new CmdLineString("reduction-velocity", "Reduction velocity used for the seismic section in meters per second.");
    protected final SortedSet<ShotPoint> shotList;
    protected final SortedSet<ReceiverPoint> receiverList;

    protected abstract EquallySpacedTimeSeries readTrace(GatherEntry var1);

    protected static SortedSet<GatherEntry> shotGather(ShotPoint shot, SortedSet<ReceiverPoint> receivers, double velocity, TimeSpan length, double offset) {
        assert (shot != null) : "Argument 'shot' must not be null!";
        assert (receivers != null) : "Argument 'receivers' must not be null!";
        TreeSet<GatherEntry> gather = new TreeSet<GatherEntry>();
        for (ReceiverPoint receiver : receivers) {
            TimeMoment traceStop;
            TimeMoment traceStart = shot.getTriggerTime();
            if (velocity != 0.0) {
                TimeSpan redShift = new TimeSpan.Builder().addSeconds(Ellipsoid.WGS84.distance(shot.getPosition(), receiver.getPosition()) / velocity).build();
                traceStart = TimeSpan.add(traceStart, redShift);
            }
            if (offset > 0.0) {
                traceStart = TimeSpan.add(traceStart, new TimeSpan.Builder().addSeconds(offset).build());
            } else if (offset < 0.0) {
                traceStart = TimeSpan.subtract(traceStart, new TimeSpan.Builder().addSeconds(offset).build());
            }
            if (!(traceStop = TimeSpan.add(traceStart, length)).after(receiver.getRecorderStart()) || !traceStart.before(receiver.getRecorderStop())) continue;
            gather.add(new GatherEntry(shot, receiver, traceStart, traceStop));
        }
        return gather;
    }

    protected static SortedSet<GatherEntry> receiverGather(ReceiverPoint receiver, SortedSet<ShotPoint> shots, double velocity, TimeSpan length, double offset) {
        assert (shots != null) : "Argument 'shots' must not be null!";
        assert (receiver != null) : "Argument 'receiver' must not be null!";
        TreeSet<GatherEntry> gather = new TreeSet<GatherEntry>();
        for (ShotPoint shot : shots) {
            TimeMoment traceStop;
            TimeMoment traceStart = shot.getTriggerTime();
            if (velocity != 0.0) {
                TimeSpan redShift = new TimeSpan.Builder().addSeconds(Ellipsoid.WGS84.distance(shot.getPosition(), receiver.getPosition()) / velocity).build();
                traceStart = TimeSpan.add(traceStart, redShift);
            }
            if (offset > 0.0) {
                traceStart = TimeSpan.add(traceStart, new TimeSpan.Builder().addSeconds(offset).build());
            } else if (offset < 0.0) {
                traceStart = TimeSpan.subtract(traceStart, new TimeSpan.Builder().addSeconds(offset).build());
            }
            if (!(traceStop = TimeSpan.add(traceStart, length)).after(receiver.getRecorderStart()) || !traceStart.before(receiver.getRecorderStop())) continue;
            gather.add(new GatherEntry(shot, receiver, traceStart, traceStop));
        }
        return gather;
    }

    protected static void checkShotList(SortedSet<ShotPoint> list) throws IllegalArgumentException {
        assert (list != null) : "Argument 'list' must not be null!";
    }

    protected static void checkReceiverList(SortedSet<ReceiverPoint> list) throws IllegalArgumentException {
        assert (list != null) : "Argument 'list' must not be null!";
        for (ReceiverPoint rp : list) {
            if (!rp.getRecorderStop().before(rp.getRecorderStart())) continue;
            throw new IllegalArgumentException("Impossible values! The recording of " + rp + " was started (" + rp.getRecorderStart().toDateTimeString() + ") after (!) it was already stopped (" + rp.getRecorderStop().toDateTimeString() + ").");
        }
        for (ReceiverPoint rp1 : list) {
            for (ReceiverPoint rp2 : list) {
                if (rp1.equals(rp2) || !rp1.getRecorderName().equals(rp2.getRecorderName()) || !rp1.getRecorderChannel().equals(rp2.getRecorderChannel()) || rp1.getRecorderStop().before(rp2.getRecorderStart()) || rp1.getRecorderStart().after(rp2.getRecorderStop())) continue;
                throw new IllegalArgumentException("Impossible values! The unit '" + rp1.getRecorderName() + "' records simultaneously at " + rp1 + " and " + rp2 + "!");
            }
        }
    }

    protected TraceToSection(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.sectionFormat = SeismicSectionFormat.STANDARD_SEGY;
        this.gatherMode = GatherMode.SHOT;
        this.traceLength = DEFAULT_TRACE_LENGTH;
        this.gatherSelection = new Selection();
        this.shotList = new TreeSet<ShotPoint>();
        this.receiverList = new TreeSet<ReceiverPoint>();
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.registerOption(this.forceConcatenateOption);
        this.cmdLineParser.registerOption(this.sectionFormatOption);
        this.cmdLineParser.registerOption(this.shotGatherOption);
        this.cmdLineParser.registerOption(this.receiverGatherOption);
        this.cmdLineParser.registerOption(this.projectOption);
        this.cmdLineParser.registerOption(this.traceLengthOption);
        this.cmdLineParser.registerOption(this.traceOffsetOption);
        this.cmdLineParser.registerOption(this.reductionVelocityOption);
    }

    protected SegyFile getSegyFile(String prefix, int id) throws FileNotFoundException, IOException {
        SegyFile file;
        switch (this.sectionFormat) {
            case SEISMIC_UNIX_NATIVE: {
                file = new SeismicUnix(this.getOutputFile(this.outputDir, prefix + id, "su", this.forceOverwrite), ByteOrder.nativeOrder());
                break;
            }
            case SEISMIC_UNIX_XDR: {
                file = new SeismicUnix(this.getOutputFile(this.outputDir, prefix + id, "su", this.forceOverwrite), ByteOrder.BIG_ENDIAN);
                break;
            }
            case STANDARD_SEGY: {
                file = new StandardSegy(this.getOutputFile(this.outputDir, prefix + id, "segy", this.forceOverwrite));
                break;
            }
            default: {
                throw new AssertionError((Object)"Illegal or unexpected seismic section file format.");
            }
        }
        return file;
    }

    protected SegyFile getSegyFile(String prefix, Selection<Integer> range) throws FileNotFoundException, IOException {
        StringBuilder basename = new StringBuilder(prefix);
        String selection = range.getSelection();
        for (char letter : selection.toCharArray()) {
            if (Character.isISOControl(letter) || Character.isSpaceChar(letter) || letter == File.separatorChar) continue;
            basename.append(letter);
        }
        switch (this.sectionFormat) {
            case SEISMIC_UNIX_NATIVE: {
                return new SeismicUnix(this.getOutputFile(this.outputDir, basename.toString(), "su", this.forceOverwrite), ByteOrder.nativeOrder());
            }
            case SEISMIC_UNIX_XDR: {
                return new SeismicUnix(this.getOutputFile(this.outputDir, basename.toString(), "su", this.forceOverwrite), ByteOrder.BIG_ENDIAN);
            }
            case STANDARD_SEGY: {
                return new StandardSegy(this.getOutputFile(this.outputDir, basename.toString(), "segy", this.forceOverwrite));
            }
        }
        throw new AssertionError((Object)"Illegal or unexpected seismic section file format.");
    }

    protected Selection<Integer> parseIntegerRange(String text) {
        Selection<Integer> select = new Selection<Integer>();
        if (text == null || text.length() == 0) {
            select.selectEverything();
        } else {
            for (String value : text.split(",")) {
                if (value.length() == 0) continue;
                try {
                    String[] numbers = value.split("\\.{2,}");
                    switch (numbers.length) {
                        case 1: {
                            select.add(new Integer[]{Integer.valueOf(numbers[0])});
                            break;
                        }
                        case 2: {
                            select.addRange(Integer.valueOf(numbers[0]), Integer.valueOf(numbers[1]));
                            break;
                        }
                        default: {
                            this.log.warning("Could not completely parse the string \"" + text + "\". Expected one or two numbers separated by two dots while processing the \"" + value + "\" part (but found " + numbers.length + " integers instead). Ignoring \"" + value + "\".");
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    this.log.warning("Could not completely parse the string \"" + text + "\". The problematic part is \"" + value + "\", which will be ignored!");
                }
            }
        }
        return select;
    }

    /*
     * Exception decompiling
     */
    protected void parseProjectFile() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleGatherOptions() throws ParserException, NumberFormatException {
        int modeCounter = 0;
        if (this.shotGatherOption.isMatched()) {
            ++modeCounter;
        }
        if (this.receiverGatherOption.isMatched()) {
            ++modeCounter;
        }
        if (modeCounter > 1) {
            this.log.severe("This program can only run in \"shot\" OR \"receiver gather\" mode. Please decide for one mode only and then try again.");
            System.exit(64);
        }
        if (this.shotGatherOption.isMatched()) {
            this.gatherMode = GatherMode.SHOT;
            this.gatherSelection = this.parseIntegerRange(this.shotGatherOption.getValue());
            this.log.info("Switching to \"shot gather\" mode, processing FFID: " + this.gatherSelection);
        } else if (this.receiverGatherOption.isMatched()) {
            this.gatherMode = GatherMode.RECEIVER;
            this.gatherSelection = this.parseIntegerRange(this.receiverGatherOption.getValue());
            this.log.info("Switching to \"receiver gather\" mode, processing the channel: " + this.gatherSelection);
        } else {
            this.gatherSelection.selectEverything();
            this.log.fine("Using the default \"" + this.gatherMode.toString().toLowerCase() + " gather\" mode.");
        }
        if (this.reductionVelocityOption.isMatched()) {
            this.reductionVelocity = Double.parseDouble(this.reductionVelocityOption.getValue());
            this.log.info("The reduction velocity is: " + this.reductionVelocity + " meters/s");
        } else {
            this.log.fine("Using the default reduction velocity (" + this.reductionVelocity + " meters/s).");
        }
        if (this.traceOffsetOption.isMatched()) {
            this.traceOffset = Double.parseDouble(this.traceOffsetOption.getValue());
            this.log.info("The beginning of the trace will be shifted by " + this.traceOffset + " seconds relative to the shot time.");
        } else {
            this.log.fine("Using the default start time offset of " + this.traceOffset + " seconds.");
        }
        if (this.traceLengthOption.isMatched()) {
            this.traceLength = TimeSpan.parse(this.traceLengthOption.getValue());
            this.log.fine("The trace length is: " + this.traceLength);
        } else {
            this.log.fine("Will use the default SEG-Y trace length (" + this.traceLength + ").");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleOutputOptions() {
        block11: {
            if (this.outputDirOption.isMatched()) {
                this.outputDir = new File(this.outputDirOption.getValue());
                if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
                    this.log.info("Resulting seismic sections will be written to the \"" + this.outputDir.getAbsolutePath() + "\" directory.");
                    break block11;
                } else {
                    this.outputDir = null;
                    throw new CmdLineException("Cannot write seismic sections to \"" + this.outputDirOption.getValue() + "\". Does this directory exist and if yes, is it writable?");
                }
            }
            this.log.fine("Seismic sections will be written to the current working directory.");
        }
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing files will NOT be overwritten.");
        }
        if (this.forceConcatenateOption.isMatched()) {
            this.forceConcatenate = true;
            this.log.info("All gathers will be written into a single output file.");
        } else {
            this.forceConcatenate = false;
            this.log.fine("A separate file will be created for each gather.");
        }
        if (!this.sectionFormatOption.isMatched()) {
            this.log.fine("Using the default output format (" + this.sectionFormat.toString() + ").");
            return;
        }
        String pattern = this.sectionFormatOption.getValue();
        if (pattern.equalsIgnoreCase("SUOLD") || pattern.equalsIgnoreCase("Seismic_Unix_Old")) {
            this.sectionFormat = SeismicSectionFormat.SEISMIC_UNIX_NATIVE;
            this.log.info("Switching to  \"Seismic Unix (native binary)\"  output format.");
            return;
        }
        if (pattern.equalsIgnoreCase("SUXDR") || pattern.equalsIgnoreCase("SUNEW") || pattern.equalsIgnoreCase("Seismic_Unix_XDR")) {
            this.sectionFormat = SeismicSectionFormat.SEISMIC_UNIX_XDR;
            this.log.info("Switching to  \"Seismic Unix (XDR)\"  output format.");
            return;
        }
        if (!pattern.equalsIgnoreCase("SEGY") && !pattern.equalsIgnoreCase("REV1")) {
            if (!pattern.equalsIgnoreCase("Standard_SEGY")) throw new CmdLineException("Unknown SEG-Y variant \"" + this.sectionFormatOption.getValue() + "\". Please see help for supported seismic section formats.");
        }
        this.sectionFormat = SeismicSectionFormat.STANDARD_SEGY;
        this.log.info("Switching to  \"SEG-Y (Revision 1)\"  output format.");
    }

    protected void writeSections() {
        if (this.shotList.size() == 0) {
            this.log.severe("The shot point list is empty! Cannot process any gathers.");
            return;
        }
        if (this.receiverList.size() == 0) {
            this.log.severe("The receiver point list is empty! Cannot process any gathers.");
            return;
        }
        switch (this.gatherMode) {
            case SHOT: {
                this.writeShotGather();
                break;
            }
            case RECEIVER: {
                this.writeReceiverGather();
                break;
            }
            default: {
                throw new AssertionError((Object)"Illegal or unexpected gather mode.");
            }
        }
        this.log.info("Finally done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeShotGather() {
        SegyFile sectionFile = null;
        try {
            this.log.info("Begin processing shot gathers.");
            for (ShotPoint sp : this.shotList) {
                if (!this.gatherSelection.contains(sp.getFfid())) {
                    this.log.fine("FFID #" + sp.getFfid() + " This shot was not mentioned in the '--shot-gather=...' command line option. Skipping to next shot.");
                    continue;
                }
                SortedSet<GatherEntry> gather = TraceToSection.shotGather(sp, this.receiverList, this.reductionVelocity, this.traceLength, this.traceOffset);
                this.log.info("FFID #" + sp.getFfid() + " -- begin conversion --");
                this.log.info("FFID #" + sp.getFfid() + " Expecting " + gather.size() + " traces for this shot gather.");
                TimeSpan expectedPeriod = null;
                int numOfSamples = -1;
                for (GatherEntry traceInfo : gather) {
                    this.log.info("FFID #" + sp.getFfid() + " Processing receiver channel #" + traceInfo.getChannel() + ".");
                    this.log.fine("FFID #" + sp.getFfid() + " Reading data (" + traceInfo + ").");
                    EquallySpacedTimeSeries traceData = this.readTrace(traceInfo);
                    if (traceData == null) {
                        this.log.severe("FFID #" + sp.getFfid() + " Could not find/read any seismic data for channel #" + traceInfo.getChannel() + " in the input data (" + traceInfo + " is missing).");
                        continue;
                    }
                    if (expectedPeriod == null) {
                        expectedPeriod = traceData.getSamplePeriod();
                        numOfSamples = (int)Math.round(this.traceLength.divide(expectedPeriod));
                    } else if (!expectedPeriod.equals(traceData.getSamplePeriod())) {
                        this.log.severe("FFID #" + sp.getFfid() + " Sample rate mismatch! The first trace in the seismic section uses a sample period of " + expectedPeriod + " and the current trace uses a sample rate of " + traceData.getSamplePeriod() + ". Ignoring trace!");
                        continue;
                    }
                    if (traceData.getNumberOfSamples() > numOfSamples) {
                        this.log.warning("FFID #" + sp.getFfid() + " Read trace is longer than expected (" + traceData.getNumberOfSamples() + " samples)! Channel # " + traceInfo.getChannel() + " will be trimmed to " + numOfSamples + " samples length!");
                        traceData = EquallySpacedTimeSeries.trim(traceData, traceInfo.getStartTime(), numOfSamples);
                    } else if (traceData.getNumberOfSamples() < numOfSamples) {
                        this.log.warning("FFID #" + sp.getFfid() + " Read trace is shorter than expected(" + traceData.getNumberOfSamples() + " samples)! Channel #" + traceInfo.getChannel() + " will be padded to " + numOfSamples + " samples length!");
                        traceData = EquallySpacedTimeSeries.pad(traceData, traceInfo.getStartTime(), numOfSamples);
                    } else {
                        this.log.fine("FFID #" + sp.getFfid() + " Read " + traceData.getNumberOfSamples() + " samples for channel #" + traceInfo.getChannel() + ".");
                    }
                    if (sectionFile == null) {
                        sectionFile = this.forceConcatenate ? this.getSegyFile("csp_", this.gatherSelection) : this.getSegyFile("csp_", sp.getFfid());
                        this.log.info("FFID #" + sp.getFfid() + " Writing to file \"" + sectionFile.getFileName() + "\".");
                    } else {
                        this.log.fine("FFID #" + sp.getFfid() + " Appending trace to file '" + sectionFile.getFileName() + "'.");
                    }
                    sectionFile.setTraceChannel(traceInfo.getChannel());
                    sectionFile.setTraceFFID(traceInfo.getFFID());
                    sectionFile.setTraceTiming(traceInfo.getShotTime(), traceInfo.getStartTime(), traceData.getStartTime());
                    sectionFile.setTraceGeomety(traceInfo.getShot().getPosition(), traceInfo.getShot().getElevation(), traceInfo.getReceiver().getPosition(), traceInfo.getReceiver().getElevation());
                    sectionFile.setTraceOptional(traceInfo.getShot().getOptionalValues());
                    sectionFile.setTraceData(traceData.getValuesOfChannel(0), traceData.getSamplePeriod());
                    sectionFile.appendTraceToFile();
                }
                if (this.forceConcatenate || sectionFile == null) continue;
                sectionFile.closeFile();
                sectionFile = null;
            }
        }
        catch (SegyException e) {
            this.log.severe(e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.log.severe("Could not open SEG-Y file for writing.");
        }
        catch (IOException e) {
            this.log.severe("An error occurred while writing to the SEG-Y file.");
        }
        finally {
            if (sectionFile != null) {
                sectionFile.closeFile();
                sectionFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeReceiverGather() {
        SegyFile sectionFile = null;
        try {
            this.log.info("Begin processing receiver gathers.");
            for (ReceiverPoint rp : this.receiverList) {
                if (!this.gatherSelection.contains(rp.getSegyChannel())) {
                    this.log.fine("Channel #" + rp.getSegyChannel() + " This receiver was not mentioned in the '--receiver-gather=...' command line option. Skipping to next receiver.");
                    continue;
                }
                SortedSet<GatherEntry> gather = TraceToSection.receiverGather(rp, this.shotList, this.reductionVelocity, this.traceLength, this.traceOffset);
                this.log.info("Channel #" + rp.getSegyChannel() + " -- begin conversion --");
                this.log.info("Channel #" + rp.getSegyChannel() + " Expecting " + gather.size() + " traces for this receiver gather.");
                TimeSpan expectedPeriod = null;
                int numOfSamples = -1;
                for (GatherEntry traceInfo : gather) {
                    this.log.info("Channel #" + rp.getSegyChannel() + " Processing shot FFID #" + traceInfo.getFFID() + ".");
                    this.log.fine("Channel #" + rp.getSegyChannel() + " Reading data (" + traceInfo + ").");
                    EquallySpacedTimeSeries traceData = this.readTrace(traceInfo);
                    if (traceData == null) {
                        this.log.severe("Channel #" + rp.getSegyChannel() + " Could not find/read any seismic data for FFID #" + traceInfo.getFFID() + " (" + traceInfo + " is missing).");
                        continue;
                    }
                    if (expectedPeriod == null) {
                        expectedPeriod = traceData.getSamplePeriod();
                        numOfSamples = (int)Math.round(this.traceLength.divide(expectedPeriod));
                    } else if (!expectedPeriod.equals(traceData.getSamplePeriod())) {
                        this.log.severe("Channel #" + rp.getSegyChannel() + " Sample rate mismatch! The first trace in the seismic section uses a sample period of " + expectedPeriod + " and the current trace uses a sample rate of " + traceData.getSamplePeriod() + ". Ignoring this trace!");
                        continue;
                    }
                    if (traceData.getNumberOfSamples() > numOfSamples) {
                        this.log.warning("Channel #" + rp.getSegyChannel() + " Read trace is longer than expected(" + traceData.getNumberOfSamples() + " samples)! The FFID # " + traceInfo.getFFID() + " will be trimmed to " + numOfSamples + " samples length!");
                        traceData = EquallySpacedTimeSeries.trim(traceData, traceInfo.getStartTime(), numOfSamples);
                    } else if (traceData.getNumberOfSamples() < numOfSamples) {
                        this.log.warning("Channel #" + rp.getSegyChannel() + " Read trace is shorter than expected(" + traceData.getNumberOfSamples() + " samples)! The FFID #" + traceInfo.getFFID() + " will be padded to " + numOfSamples + " samples length!");
                        traceData = EquallySpacedTimeSeries.pad(traceData, traceInfo.getStartTime(), numOfSamples);
                    } else {
                        this.log.fine("Channel #" + rp.getSegyChannel() + " Read " + traceData.getNumberOfSamples() + " samples for FFID #" + traceInfo.getFFID() + ".");
                    }
                    if (sectionFile == null) {
                        sectionFile = this.forceConcatenate ? this.getSegyFile("crp_", this.gatherSelection) : this.getSegyFile("crp_", rp.getSegyChannel());
                        this.log.info("Channel #" + rp.getSegyChannel() + " Writing to file \"" + sectionFile.getFileName() + "\".");
                    } else {
                        this.log.fine("Channel #" + rp.getSegyChannel() + " Appending trace to file '" + sectionFile.getFileName() + "'.");
                    }
                    sectionFile.setTraceChannel(traceInfo.getChannel());
                    sectionFile.setTraceFFID(traceInfo.getFFID());
                    sectionFile.setTraceTiming(traceInfo.getShotTime(), traceInfo.getStartTime(), traceData.getStartTime());
                    sectionFile.setTraceGeomety(traceInfo.getShot().getPosition(), traceInfo.getShot().getElevation(), traceInfo.getReceiver().getPosition(), traceInfo.getReceiver().getElevation());
                    sectionFile.setTraceOptional(traceInfo.getShot().getOptionalValues());
                    sectionFile.setTraceData(traceData.getValuesOfChannel(0), traceData.getSamplePeriod());
                    sectionFile.appendTraceToFile();
                }
                if (this.forceConcatenate || sectionFile == null) continue;
                sectionFile.closeFile();
                sectionFile = null;
            }
        }
        catch (SegyException e) {
            this.log.severe(e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.log.severe("Could not open SEG-Y file for writing.");
        }
        catch (IOException e) {
            this.log.severe("An i/o error occurred while writing to the SEG-Y file");
        }
        finally {
            if (sectionFile != null) {
                sectionFile.closeFile();
                sectionFile = null;
            }
        }
    }

    protected static enum SeismicSectionFormat {
        STANDARD_SEGY,
        SEISMIC_UNIX_NATIVE,
        SEISMIC_UNIX_XDR;

    }

    protected static enum GatherMode {
        SHOT,
        RECEIVER;

    }
}

