/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.segy;

import de.gfz_potsdam.gipp.common.geo.LatLonPoint;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShotPoint
implements Comparable<ShotPoint> {
    private static final Pattern COLUMN_PATTERN = Pattern.compile("(\\S+)");
    private final String name;
    private final int ffid;
    private final double xCoordinate;
    private final double yCoordinate;
    private final double zCoordinate;
    private final TimeMoment trigger;
    private final List<Float> optional;

    public static ShotPoint parseProjectFileLine(String text) throws InputMismatchException {
        TimeMoment shotTime;
        int shotFFID;
        double shotZ;
        double shotX;
        double shotY;
        ArrayList<Float> shotOptional = new ArrayList<Float>();
        if (text == null) {
            throw new InputMismatchException("Shot point description is missing. (Parser was called with 'null' argument.)");
        }
        if (text.length() == 0) {
            throw new InputMismatchException("Shot point description is missing. (Parser was called with an empty line.)");
        }
        Matcher m = COLUMN_PATTERN.matcher(text);
        if (m.find()) {
            if (!m.group().equalsIgnoreCase("S")) {
                throw new InputMismatchException("Could not find the expected 'S' character in column #1 indicating that a \"source point\" line is parsed.");
            }
        } else {
            throw new InputMismatchException("Could not find the expected 'S' character (column #1).");
        }
        if (!m.find()) {
            throw new InputMismatchException("Could not find a shot point name (column #2).");
        }
        String shotName = m.group();
        if (m.find()) {
            try {
                shotY = Double.parseDouble(m.group());
            }
            catch (NumberFormatException e) {
                throw new InputMismatchException("Could not parse the latitude/y-coordinate in column #3. (A floating point number was expected but the column text is \"" + m.group() + "\".)");
            }
        } else {
            throw new InputMismatchException("Could not find a shot point latitude/y-coordinate (column #3).");
        }
        if (m.find()) {
            try {
                shotX = Double.parseDouble(m.group());
            }
            catch (NumberFormatException e) {
                throw new InputMismatchException("Could not parse the longitude/x-coordinate in column #4. (A floating point number was expected but the column text is \"" + m.group() + "\".)");
            }
        } else {
            throw new InputMismatchException("Could not find a shot point longitude/x-coordinate (column #4).");
        }
        if (m.find()) {
            try {
                shotZ = Double.parseDouble(m.group());
            }
            catch (NumberFormatException e) {
                throw new InputMismatchException("Could not parse the elevation/z-coordinate in column #5. (A floating point number was expected but the column text is \"" + m.group() + "\".)");
            }
        } else {
            throw new InputMismatchException("Could not find a shot point elevation/z-coordinate (column #5).");
        }
        if (m.find()) {
            try {
                shotFFID = Integer.parseInt(m.group());
            }
            catch (NumberFormatException e) {
                throw new InputMismatchException("Could not parse the FFID in column #6. (An integer number was expected but the column text is \"" + m.group() + "\".)");
            }
        } else {
            throw new InputMismatchException("Could not find a FFID for the shot point (column #6).");
        }
        if (m.find()) {
            try {
                shotTime = TimeMoment.parse(m.group());
            }
            catch (TimeException e) {
                throw new InputMismatchException("Could not parse the trigger time of the shot in column #7. " + e.getMessage());
            }
        } else {
            throw new InputMismatchException("Could not find a trigger time for the shot (column #7).");
        }
        while (m.find()) {
            try {
                shotOptional.add(Float.valueOf(Float.parseFloat(m.group())));
            }
            catch (NumberFormatException e) {
                throw new InputMismatchException("Could not parse one of the optional columns at the end of the line. The problematic text is \"" + m.group() + "\". (A floating point number was expected!)");
            }
        }
        return new ShotPoint(shotName, shotX, shotY, shotZ, shotFFID, shotTime, shotOptional);
    }

    protected ShotPoint(String name, double xCoordinate, double yCoordinate, double zCoordinate, int ffid, TimeMoment trigger, List<Float> optional) {
        this.name = name;
        this.ffid = ffid;
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.zCoordinate = zCoordinate;
        this.trigger = trigger;
        this.optional = optional;
    }

    public String toString() {
        StringBuilder optValues = new StringBuilder();
        optValues.append('[');
        if (this.optional.size() > 0) {
            optValues.append(this.optional.get(0));
            for (int i = 1; i < this.optional.size(); ++i) {
                optValues.append(", ").append(this.optional.get(i));
            }
        }
        optValues.append(']');
        return "'" + this.name + "' (ffid #" + this.ffid + ", " + this.trigger.toDateTimeString() + ", " + optValues + ")";
    }

    public int hashCode() {
        return this.ffid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShotPoint other = (ShotPoint)obj;
        return this.ffid == other.ffid;
    }

    @Override
    public int compareTo(ShotPoint other) {
        if (other == null) {
            throw new NullPointerException();
        }
        long diff = this.ffid - other.ffid;
        return Long.compare(diff, 0L);
    }

    public String getName() {
        return this.name;
    }

    public LatLonPoint getPosition() {
        return new LatLonPoint(this.yCoordinate, this.xCoordinate);
    }

    public double getElevation() {
        return this.zCoordinate;
    }

    public int getFfid() {
        return this.ffid;
    }

    public TimeMoment getTriggerTime() {
        return this.trigger;
    }

    public List<Float> getOptionalValues() {
        return this.optional;
    }
}

