/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.segy;

import java.util.ArrayList;
import java.util.List;

public class Selection<T extends Comparable<T>> {
    private final List<Range<T>> allRanges;

    public Selection() {
        this.allRanges = new ArrayList<Range<T>>();
    }

    @SafeVarargs
    public Selection(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Cannot use 'null' to initialize a selection");
        }
        this.allRanges = new ArrayList<Range<T>>(elements.length);
        this.add((Comparable[])elements);
    }

    public Selection<T> add(Range<T> range) {
        assert (range != null) : "The range to be added must not be 'null'!";
        this.allRanges.add(range);
        return this;
    }

    public Selection<T> add(Selection<T> other) {
        assert (other != null) : "The selection to be added must not be 'null'!";
        this.allRanges.addAll(other.allRanges);
        return this;
    }

    @SafeVarargs
    public final Selection<T> add(T ... elements) {
        assert (elements != null) : "The elements to be added must not be 'null'!";
        for (T obj : elements) {
            if (obj == null) continue;
            this.allRanges.add(new Range(this, obj, obj));
        }
        return this;
    }

    public Selection<T> addRange(T first, T last) {
        this.allRanges.add(new Range(this, first, last));
        return this;
    }

    public void selectEverything() {
        this.allRanges.clear();
        this.allRanges.add(new Range(this, null, null));
    }

    public boolean contains(T element) {
        if (element == null) {
            return false;
        }
        for (Range<T> range : this.allRanges) {
            if (!range.contains(element)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.allRanges.size() == 0) {
            return "empty";
        }
        StringBuilder content = new StringBuilder(this.allRanges.get(0).toString());
        for (int i = 1; i < this.allRanges.size(); ++i) {
            content.append(", ").append(this.allRanges.get(i).toString());
        }
        return content.toString();
    }

    public String getSelection() {
        if (this.allRanges.size() == 0) {
            return "empty";
        }
        StringBuilder content = new StringBuilder(this.allRanges.get(0).getRange());
        for (int i = 1; i < this.allRanges.size(); ++i) {
            content.append("+").append(this.allRanges.get(i).getRange());
        }
        return content.toString();
    }

    private static class Range<E extends Comparable<E>> {
        private final E first;
        private final E last;
        final /* synthetic */ Selection this$0;

        public Range(E start, E stop) {
            this.this$0 = var1_1;
            this.first = start;
            this.last = stop;
        }

        public boolean contains(E element) {
            if (element == null) {
                return false;
            }
            if (this.first == null && this.last == null) {
                return true;
            }
            if (this.first != null && element.compareTo(this.first) < 0) {
                return false;
            }
            return this.last == null || element.compareTo(this.last) <= 0;
        }

        public String toString() {
            if (this.first == null && this.last == null) {
                return "all";
            }
            if (this.first == null && this.last != null) {
                return "first to " + this.last.toString();
            }
            if (this.first != null && this.last == null) {
                return this.first.toString() + " to last";
            }
            if (this.first.equals(this.last)) {
                return this.first.toString();
            }
            return this.first.toString() + " to " + this.last.toString();
        }

        public String getRange() {
            if (this.first == null && this.last == null) {
                return "all";
            }
            if (this.first == null && this.last != null) {
                return "first-" + this.last.toString();
            }
            if (this.first != null && this.last == null) {
                return this.first.toString() + "-last";
            }
            if (this.first.equals(this.last)) {
                return this.first.toString();
            }
            return this.first.toString() + '-' + this.last.toString();
        }
    }
}

