/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.segy;

import de.gfz_potsdam.gipp.common.geo.LatLonPoint;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.util.InputMismatchException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReceiverPoint
implements Comparable<ReceiverPoint> {
    private static final Pattern COLUMN_PATTERN = Pattern.compile("(\\S+)");
    private final String name;
    private final int channel;
    private final double xCoordinate;
    private final double yCoordinate;
    private final double zCoordinate;
    private final String recorderName;
    private final String recorderChannel;
    private final TimeMoment recorderStart;
    private final TimeMoment recorderStop;

    public static ReceiverPoint parseProjectFileLine(String text) throws InputMismatchException, IllegalArgumentException {
        TimeMoment loggerStop;
        TimeMoment loggerStart;
        int receiverChannel;
        double receiverZ;
        double receiverX;
        double receiverY;
        if (text == null) {
            throw new InputMismatchException("Receiver point description is missing. (Parser was called with 'null' argument.)");
        }
        if (text.length() == 0) {
            throw new InputMismatchException("Receiver point description is missing. (Parser was called with an empty line.)");
        }
        Matcher m = COLUMN_PATTERN.matcher(text);
        if (m.find()) {
            if (!m.group().equalsIgnoreCase("R")) {
                throw new InputMismatchException("Could not find the expected 'R' character in column #1 indicating that a \"receiver point\" line is parsed.");
            }
        } else {
            throw new InputMismatchException("Could not find the expected 'R' character (column #1).");
        }
        if (!m.find()) {
            throw new InputMismatchException("Could not find a receiver point name (column #2).");
        }
        String receiverName = m.group();
        if (m.find()) {
            try {
                receiverY = Double.parseDouble(m.group());
            }
            catch (NumberFormatException e) {
                throw new InputMismatchException("Could not parse the latitude/y-coordinate in column #3. (A floating point number was expected but the column text is \"" + m.group() + "\".)");
            }
        } else {
            throw new InputMismatchException("Could not find a receiver point latitude/y-coordinate (column #3).");
        }
        if (m.find()) {
            try {
                receiverX = Double.parseDouble(m.group());
            }
            catch (NumberFormatException e) {
                throw new InputMismatchException("Could not parse the longitude/x-coordinate in column #4. (A floating point number was expected but the column text is \"" + m.group() + "\".)");
            }
        } else {
            throw new InputMismatchException("Could not find a receiver point longitude/x-coordinate (column #4).");
        }
        if (m.find()) {
            try {
                receiverZ = Double.parseDouble(m.group());
            }
            catch (NumberFormatException e) {
                throw new InputMismatchException("Could not parse the elevation/z-coordinate in column #5. (A floating point number was expected but the column text is \"" + m.group() + "\".)");
            }
        } else {
            throw new InputMismatchException("Could not find a receiver point elevation/z-coordinate (column #5).");
        }
        if (m.find()) {
            try {
                receiverChannel = Integer.parseInt(m.group());
            }
            catch (NumberFormatException e) {
                throw new InputMismatchException("Could not parse the channel number in column #6. (An integer number was expected but the column text is \"" + m.group() + "\".)");
            }
        } else {
            throw new InputMismatchException("Could not find a channel number for the receiver point (column #6).");
        }
        if (!m.find()) {
            throw new InputMismatchException("Could not find the name of the recording unit (column #7).");
        }
        String loggerName = m.group();
        if (!m.find()) {
            throw new InputMismatchException("Could not find channel name used by the recording unit (column #8).");
        }
        String loggerChannel = m.group();
        if (m.find()) {
            try {
                loggerStart = TimeMoment.parse(m.group());
            }
            catch (TimeException e) {
                throw new InputMismatchException("Could not parse the \"begin of recording\" time in column #9. " + e.getMessage());
            }
        } else {
            throw new InputMismatchException("Could not find a \"begin of recording\" time (column #9).");
        }
        if (m.find()) {
            try {
                loggerStop = TimeMoment.parse(m.group());
            }
            catch (TimeException e) {
                throw new InputMismatchException("Could not parse the \"end of recording\" time in column #10. " + e.getMessage());
            }
        } else {
            throw new InputMismatchException("Could not find a \"end of recording\" time (column #10).");
        }
        if (loggerStop.before(loggerStart)) {
            throw new IllegalArgumentException("Impossible values! The recording of " + receiverName + " (channel " + receiverChannel + " was started after it was stopped.");
        }
        return new ReceiverPoint(receiverName, receiverX, receiverY, receiverZ, receiverChannel, loggerName, loggerChannel, loggerStart, loggerStop);
    }

    protected ReceiverPoint(String name, double xCoordinate, double yCoordinate, double zCoordinate, int channel, String recorderName, String recorderChannel, TimeMoment recorderStart, TimeMoment recorderStop) {
        this.name = name;
        this.channel = channel;
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.zCoordinate = zCoordinate;
        this.recorderName = recorderName;
        this.recorderChannel = recorderChannel;
        this.recorderStart = recorderStart;
        this.recorderStop = recorderStop;
    }

    public String toString() {
        return "'" + this.name + "' (channel #" + this.channel + ", " + this.recorderName + ", " + this.recorderChannel + ")";
    }

    public int hashCode() {
        return this.channel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReceiverPoint other = (ReceiverPoint)obj;
        return this.channel == other.channel;
    }

    @Override
    public int compareTo(ReceiverPoint other) {
        if (other == null) {
            throw new NullPointerException();
        }
        long diff = this.channel - other.channel;
        return Long.compare(diff, 0L);
    }

    public String getName() {
        return this.name;
    }

    public LatLonPoint getPosition() {
        return new LatLonPoint(this.yCoordinate, this.xCoordinate);
    }

    public double getElevation() {
        return this.zCoordinate;
    }

    public int getSegyChannel() {
        return this.channel;
    }

    public String getRecorderName() {
        return this.recorderName;
    }

    public String getRecorderChannel() {
        return this.recorderChannel;
    }

    public TimeMoment getRecorderStart() {
        return this.recorderStart;
    }

    public TimeMoment getRecorderStop() {
        return this.recorderStop;
    }
}

