/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.segy;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortByExtension;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.EquallySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.MiniseedException;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import de.gfz_potsdam.gipp.tool.segy.GatherEntry;
import de.gfz_potsdam.gipp.tool.segy.MiniseedSegment;
import de.gfz_potsdam.gipp.tool.segy.TraceToSection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;

public class MseedToSegy
extends TraceToSection {
    protected final CmdLineString inputFilterOption = GippToolsCommonOptions.newMiniseedInputFilterOption();
    private final SortedSet<MiniseedSegment> miniseedIndex;
    protected RegexFilenameFilter inputFilter = null;
    protected CmdLineString cacheFileOption = new CmdLineString("index-cache", "Enable caching of the index of all available miniSEED input files.\nA file must be given as argument. If the file already exist the index will be read from it. If the file does not exist yet, the currently used \"miniSEED data index\" will be written to it.\nBy default (i.e. without this option) caching of the index is disabled.");
    private File cacheFile = null;

    public static void main(String[] args) {
        MseedToSegy mseed2segy = new MseedToSegy(args);
        try {
            mseed2segy.handleCommonOptions();
            mseed2segy.handleGippToolOptions();
            mseed2segy.parseProjectFile();
            mseed2segy.handleGatherOptions();
            mseed2segy.handleInputOptions();
            mseed2segy.handleOutputOptions();
            mseed2segy.readIndexFromCache();
            mseed2segy.buildFileIndex();
            mseed2segy.writeIndexToCache();
            mseed2segy.writeSections();
        }
        catch (CmdLineException e) {
            mseed2segy.logThrowable(e);
            System.exit(64);
        }
        catch (IntegrityException e) {
            mseed2segy.logThrowable(e);
            System.exit(65);
        }
        catch (IOException e) {
            mseed2segy.logThrowable(e);
            System.exit(74);
        }
        catch (Exception e) {
            mseed2segy.logThrowable(e);
            System.exit(99);
        }
    }

    public MseedToSegy(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.miniseedIndex = new TreeSet<MiniseedSegment>();
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.cacheFileOption);
        this.cmdLineParser.setProgramName("mseed2segy");
        this.cmdLineParser.setProgramDescription("convert miniSEED files to SEG-Y format");
        this.cmdLineParser.setProgramArguments("miniSEED-FILE|DIRECTORY ...");
    }

    private void handleInputOptions() {
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addMseedFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP miniSEED filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the \"" + pattern + "\" pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
        if (this.cacheFileOption.isMatched()) {
            String fileName = this.cacheFileOption.getValue();
            if (fileName.length() == 0) {
                this.log.severe("The option '--index-cache' is missing a filename argument!");
                System.exit(64);
            } else {
                this.cacheFile = new File(this.cacheFileOption.getValue());
                this.log.info("Using '" + this.cacheFile.getAbsolutePath() + "' as cache file for the \"miniSEED data index\".");
            }
        } else {
            this.cacheFile = null;
            this.log.fine("Index caching is disabled!");
        }
    }

    protected void buildFileIndex() {
        if (this.miniseedIndex.size() > 0) {
            this.log.fine("The \"miniSEED data index\" already exists. There is no need to build a new one from scratch.");
            return;
        }
        if (this.cmdLineParser.getArgumentList().size() == 0) {
            throw new CmdLineException("No path to miniSEED input files was given. At least one input file or directory is required as this program does not read from console / standard input!");
        }
        this.log.info("Building list of input files for indexing...");
        SortedFileSet inputList = new SortedFileSet(new SortByExtension(), this.inputFilter);
        for (String fileName : this.cmdLineParser.getArgumentList()) {
            File file = new File(fileName);
            if (file.exists()) {
                inputList.add(file);
                continue;
            }
            this.log.warning("File or directory '" + fileName + "' given at the command line does not exist! Maybe a typing error?");
        }
        if (inputList.size() == 0) {
            this.log.severe("No suitable input files found.");
            System.exit(66);
        } else {
            this.log.info("Found " + inputList.size() + " file(s). This may take a while...");
        }
        for (File file : inputList) {
            try {
                this.miniseedIndex.addAll(MiniseedSegment.scan(file));
            }
            catch (IntegrityException e) {
                this.log.warning("'" + file.getName() + "' seems not to be a valid miniSEED file. Skipping.");
                continue;
            }
            catch (MiniseedException e) {
                String reason = e.getMessage();
                if (reason != null) {
                    this.log.warning("Could not completely index file '" + file.getName() + "'. Reason: " + reason);
                    continue;
                }
                this.log.warning("Could not completely index file '" + file.getName() + "'. Skipping.");
                continue;
            }
            catch (FileNotFoundException e) {
                this.log.warning("File '" + file + "' seems to have disappeared from the file system. Skipping.");
                continue;
            }
            catch (IOException e) {
                this.log.warning("Failed while reading from file '" + file + "'. Skipping.");
                continue;
            }
            if (this.miniseedIndex.size() % 500 != 0) continue;
            this.log.info("  " + this.miniseedIndex.size() + " of " + inputList.size() + " segments indexed.");
        }
        this.log.info(this.miniseedIndex.size() + " miniSEED segments indexed. Done with indexing.");
    }

    /*
     * Exception decompiling
     */
    protected void writeIndexToCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void readIndexFromCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected EquallySpacedTimeSeries readTrace(GatherEntry traceInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

