/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.segy;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.SortedSet;
import java.util.TreeSet;

public class MiniseedSegment
implements Comparable<MiniseedSegment>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String network;
    private final String station;
    private final String location;
    private final String channel;
    private final TimeMoment start;
    private final TimeMoment stop;
    private final File path;
    private final long offset;

    public static SortedSet<MiniseedSegment> scan(File file) throws IntegrityException, FileNotFoundException, IOException {
        TreeSet<MiniseedSegment> segments = new TreeSet<MiniseedSegment>();
        FileInputStream inStream = null;
        Record current = new Record();
        Record first = null;
        Record last = null;
        long offsetCurrent = 0L;
        long offsetFirst = 0L;
        try {
            inStream = new FileInputStream(file);
            while (current.read(inStream) > 0) {
                if (first == null) {
                    first = current;
                }
                if (last != null && !Record.isContinuous(last, current)) {
                    segments.add(new MiniseedSegment(file, offsetFirst, first, last));
                    first = current;
                    offsetFirst = offsetCurrent;
                }
                offsetCurrent += (long)current.size();
                last = current;
                current = new Record();
            }
        }
        catch (EOFException e) {
            try {
                throw new IntegrityException("Incomplete last miniSEED record! " + e.getMessage());
            }
            catch (Throwable throwable) {
                FileUtils.flushClose(inStream);
                throw throwable;
            }
        }
        FileUtils.flushClose(inStream);
        if (first != null) {
            segments.add(new MiniseedSegment(file, offsetFirst, first, last));
        }
        return segments;
    }

    private MiniseedSegment(File miniseedFile, long fileOffset, Record first, Record last) {
        this.path = miniseedFile;
        this.offset = fileOffset;
        this.station = first.getStationId();
        this.channel = first.getChannelId();
        this.location = first.getLocationId();
        this.network = first.getNetworkId();
        this.start = first.getStartTime();
        this.stop = last.getStopTime();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getNetworkId() == null ? 0 : this.getNetworkId().hashCode());
        result = 31 * result + (this.getStationId() == null ? 0 : this.getStationId().hashCode());
        result = 31 * result + (this.getLocationId() == null ? 0 : this.getLocationId().hashCode());
        result = 31 * result + (this.getChannelId() == null ? 0 : this.getChannelId().hashCode());
        result = 31 * result + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        result = 31 * result + (this.getStopTime() == null ? 0 : this.getStopTime().hashCode());
        result = 31 * result + (this.getFile() == null ? 0 : this.getFile().hashCode());
        result = 31 * result + Long.hashCode(this.offset);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MiniseedSegment other = (MiniseedSegment)obj;
        if (this.getNetworkId() == null ? other.getNetworkId() != null : !this.getNetworkId().equals(other.getNetworkId())) {
            return false;
        }
        if (this.getStationId() == null ? other.getStationId() != null : !this.getStationId().equals(other.getStationId())) {
            return false;
        }
        if (this.getLocationId() == null ? other.getLocationId() != null : !this.getLocationId().equals(other.getLocationId())) {
            return false;
        }
        if (this.getChannelId() == null ? other.getChannelId() != null : !this.getChannelId().equals(other.getChannelId())) {
            return false;
        }
        if (this.getStartTime() == null ? other.getStartTime() != null : !this.getStartTime().equals(other.getStartTime())) {
            return false;
        }
        if (this.getStopTime() == null ? other.getStopTime() != null : !this.getStopTime().equals(other.getStopTime())) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.offset == other.offset;
    }

    public String toString() {
        return this.getFileName() + ", offset: #" + this.getOffset() + " ( " + this.getStationId() + ", " + this.getChannelId() + ", " + this.getStartTime().toDateTimeString() + " to " + this.getStopTime().toDateTimeString() + ")";
    }

    @Override
    public int compareTo(MiniseedSegment other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (!this.getNetworkId().equals(other.getNetworkId())) {
            return this.getNetworkId().compareTo(other.getNetworkId());
        }
        if (!this.getStationId().equals(other.getStationId())) {
            return this.getStationId().compareTo(other.getStationId());
        }
        if (!this.getLocationId().equals(other.getLocationId())) {
            return this.getLocationId().compareTo(other.getLocationId());
        }
        if (!this.getChannelId().equals(other.getChannelId())) {
            return this.getChannelId().compareTo(other.getChannelId());
        }
        if (!this.getStartTime().equals(other.getStartTime())) {
            return this.getStartTime().compareTo(other.getStartTime());
        }
        if (!this.getStopTime().equals(other.getStopTime())) {
            return this.getStopTime().compareTo(other.getStopTime());
        }
        if (!this.path.equals(other.path)) {
            return this.path.compareTo(other.path);
        }
        return Long.compare(this.offset, other.offset);
    }

    public File getFile() {
        return this.path;
    }

    public String getFileName() {
        if (this.path != null) {
            return this.path.getName();
        }
        return null;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getStationId() {
        return this.station;
    }

    public String getChannelId() {
        return this.channel;
    }

    public String getLocationId() {
        return this.location;
    }

    public String getNetworkId() {
        return this.network;
    }

    public TimeMoment getStartTime() {
        return this.start;
    }

    public TimeMoment getStopTime() {
        return this.stop;
    }
}

