/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.segy;

import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.tool.segy.ReceiverPoint;
import de.gfz_potsdam.gipp.tool.segy.ShotPoint;

public class GatherEntry
implements Comparable<GatherEntry> {
    private final ShotPoint seismicSource;
    private final ReceiverPoint seismicReceiver;
    private final TimeMoment startTime;
    private final TimeMoment stopTime;

    public GatherEntry(ShotPoint shot, ReceiverPoint receiver, TimeMoment start, TimeMoment stop) {
        this.seismicSource = shot;
        this.seismicReceiver = receiver;
        this.startTime = start;
        this.stopTime = stop;
    }

    public String toString() {
        return this.getRecorderName() + ", " + this.getRecorderChannel() + ", " + this.getStartTime().toDateTimeString() + " to " + this.getStopTime().toDateTimeString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.seismicSource == null ? 0 : this.seismicSource.hashCode());
        result = 31 * result + (this.seismicReceiver == null ? 0 : this.seismicReceiver.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + (this.stopTime == null ? 0 : this.stopTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GatherEntry other = (GatherEntry)obj;
        if (this.seismicSource == null ? other.seismicSource != null : !this.seismicSource.equals(other.seismicSource)) {
            return false;
        }
        if (this.seismicReceiver == null ? other.seismicReceiver != null : !this.seismicReceiver.equals(other.seismicReceiver)) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        if (this.stopTime == null) {
            return other.stopTime == null;
        }
        return this.stopTime.equals(other.stopTime);
    }

    @Override
    public int compareTo(GatherEntry other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (!this.seismicSource.equals(other.seismicSource)) {
            return this.seismicSource.compareTo(other.seismicSource);
        }
        if (!this.seismicReceiver.equals(other.seismicReceiver)) {
            return this.seismicReceiver.compareTo(other.seismicReceiver);
        }
        if (!this.startTime.equals(other.startTime)) {
            return this.startTime.compareTo(other.startTime);
        }
        return this.stopTime.compareTo(other.stopTime);
    }

    public String getRecorderName() {
        return this.seismicReceiver.getRecorderName();
    }

    public String getRecorderChannel() {
        return this.seismicReceiver.getRecorderChannel();
    }

    public TimeMoment getStartTime() {
        return this.startTime;
    }

    public TimeMoment getStopTime() {
        return this.stopTime;
    }

    public int getChannel() {
        return this.seismicReceiver.getSegyChannel();
    }

    public int getFFID() {
        return this.seismicSource.getFfid();
    }

    public TimeMoment getShotTime() {
        return this.seismicSource.getTriggerTime();
    }

    public ShotPoint getShot() {
        return this.seismicSource;
    }

    public ReceiverPoint getReceiver() {
        return this.seismicReceiver;
    }
}

