/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.segy;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.EquallySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.cube.CubeException;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.FringeSampleUtils;
import de.gfz_potsdam.gipp.common.seis.cube.TimingQualityUtils;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.seis.cube.WnroUtil;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.Stopwatch;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import de.gfz_potsdam.gipp.tool.segy.GatherEntry;
import de.gfz_potsdam.gipp.tool.segy.TraceToSection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;

public class CubeToSegy
extends TraceToSection {
    protected final CmdLineString inputFilterOption = GippToolsCommonOptions.newCubeInputFilterOption();
    private final SortedSet<TraceInfo> cubeIndex;
    private final CmdLineString wnroCorrectionOption = GippToolsCommonOptions.newWnroCorrectionOption();
    private final CmdLineString timingControlOption = new CmdLineString("timing-control", "Select an algorithm to quality control the timing information contained in the Cube input data.\n LLS .... Use a \"local least squares\" (LLS) approximation to\n          detect outliers and other suspicious time information.\n          (Default)\n RULE ... Do a rule-based evaluation. The rules are predefined\n          and were determined by trial and error.\n NONE ... Skip quality control altogether! This will use any\n          available (GPS) timing information without further\n          qualification.\nPlease see the documentation for more details about the quality control of the timing information recorded by the Cube.", null);
    private final CmdLineString fringeSampleOption = new CmdLineString("fringe-samples", "Decide how to treat samples that were recorded before the first GPS time fix or after the last GPS time fix taken by the Cube unit. Determining the precise recording time of these \"fringe samples\" is problematic because without a second time tag on the other side of the sample the precise sampling rate cannot be computed. However, sometimes it might be beneficial to use fringe samples for further processing anyhow. Valid options are:\n SKIP ....... Exclude all samples without good time control\n              from the conversion. (Default)\n NOMINAL .... Include samples assuming a perfect nominal (as\n              configured) sample rate.\n CONSTANT ... Include samples assuming a constant clock drift\n              over the whole recording.\nPlease see the documentation for more details about fringe sample treatment.", null);
    protected CmdLineString cacheFileOption = new CmdLineString("index-cache", "Enable caching of the index of all available Cube input files.\nA file must be given as argument. If the file already exist the index will be read from it. If the file does not exist yet, the currently used \"Cube data index\" will be written to it.\nBy default (i.e. without this option) caching of the index is disabled.");
    protected RegexFilenameFilter inputFilter = null;
    private File cacheFile = null;
    private TimeSpan wnroCorrection = null;
    private TimingQualityUtils.QualityControlAlgorithm timingControl;
    private FringeSampleUtils.FringeSampleTreatment fringeSamples;

    public CubeToSegy(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cubeIndex = new TreeSet<TraceInfo>();
        this.timingControl = TimingQualityUtils.QualityControlAlgorithm.LOCAL_LEAST_SQUARES;
        this.fringeSamples = FringeSampleUtils.FringeSampleTreatment.SKIP;
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.cacheFileOption);
        this.cmdLineParser.registerOption(this.wnroCorrectionOption).set(CmdLineOption.Visibility.HIDDEN);
        this.cmdLineParser.registerOption(this.timingControlOption);
        this.cmdLineParser.registerOption(this.fringeSampleOption);
        this.cmdLineParser.setProgramName("cube2segy");
        this.cmdLineParser.setProgramDescription("convert Cube files to SEG-Y format");
        this.cmdLineParser.setProgramArguments("Cube-FILE|DIRECTORY ...");
    }

    public static void main(String[] args) {
        CubeToSegy cube2segy = new CubeToSegy(args);
        try {
            cube2segy.handleCommonOptions();
            cube2segy.handleGippToolOptions();
            cube2segy.handleInputOptions();
            cube2segy.handleDataQualityOptions();
            cube2segy.handleCubeDataOptions();
            cube2segy.parseProjectFile();
            cube2segy.handleGatherOptions();
            cube2segy.handleOutputOptions();
            cube2segy.readIndexFromCache();
            cube2segy.buildFileIndex();
            cube2segy.writeIndexToCache();
            cube2segy.writeSections();
        }
        catch (CmdLineException e) {
            cube2segy.logThrowable(e);
            System.exit(64);
        }
        catch (CubeException e) {
            cube2segy.logThrowable(e);
            System.exit(65);
        }
        catch (IOException e) {
            cube2segy.logThrowable(e);
            System.exit(74);
        }
        catch (Exception e) {
            cube2segy.logThrowable(e);
            System.exit(99);
        }
    }

    private void handleInputOptions() {
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addCubeFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP Cube filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the \"" + pattern + "\" pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
        if (this.cacheFileOption.isMatched()) {
            String fileName = this.cacheFileOption.getValue();
            if (fileName.isEmpty()) {
                this.log.severe("The option '--index-cache' is missing a filename argument!");
                System.exit(64);
            } else {
                this.cacheFile = new File(this.cacheFileOption.getValue());
                this.log.info("Using '" + this.cacheFile.getAbsolutePath() + "' as cache file for the \"Cube data index\".");
            }
        } else {
            this.cacheFile = null;
            this.log.fine("Index caching is disabled!");
        }
    }

    protected void handleDataQualityOptions() {
        this.wnroCorrection = GippToolsCommonOptions.evalWnroCorrectionOption(this.log, this.wnroCorrectionOption);
    }

    private void handleCubeDataOptions() {
        if (this.fringeSampleOption.isMatched()) {
            String temp = this.fringeSampleOption.getValue().toUpperCase();
            if (temp.startsWith(FringeSampleUtils.FringeSampleTreatment.SKIP.toString().substring(0, 3))) {
                this.fringeSamples = FringeSampleUtils.FringeSampleTreatment.SKIP;
                this.log.info("All samples before the first and after the last GPS time fix will be ignored.");
            } else if (temp.startsWith(FringeSampleUtils.FringeSampleTreatment.NOMINAL.toString().substring(0, 3))) {
                this.fringeSamples = FringeSampleUtils.FringeSampleTreatment.NOMINAL;
                this.log.info("Sample before the first and after the last GPS time fix will be processed assuming the nominal sampling rate.");
            } else if (temp.startsWith(FringeSampleUtils.FringeSampleTreatment.CONSTANT.toString().substring(0, 3))) {
                this.fringeSamples = FringeSampleUtils.FringeSampleTreatment.CONSTANT;
                this.log.info("Samples before the first and after the last GPS time fix will be processed assuming a constant clock drift over the whole recording.");
            } else {
                this.log.severe("Unknown fringe sample treatment method '" + temp + "'. Please use one of " + Arrays.toString((Object[])FringeSampleUtils.FringeSampleTreatment.values()) + " instead.");
                System.exit(64);
            }
        } else {
            this.log.fine("Using the default fringe sample treatment method ('" + this.fringeSamples.toString() + "').");
        }
        if (this.timingControlOption.isMatched()) {
            String qc = this.timingControlOption.getValue().toUpperCase();
            if (qc.startsWith("RUL")) {
                this.timingControl = TimingQualityUtils.QualityControlAlgorithm.RULE_BASED;
                this.log.info("Switching to 'rule based' timing quality control.");
            } else if (qc.startsWith("LLS")) {
                this.timingControl = TimingQualityUtils.QualityControlAlgorithm.LOCAL_LEAST_SQUARES;
                this.log.info("Switching to 'local least squares' fitting for timing quality control.");
            } else if (qc.startsWith("NO")) {
                this.timingControl = TimingQualityUtils.QualityControlAlgorithm.NONE;
                this.log.info("Disabling any timing quality control! Every time tag will be used no matter the quality.");
            } else if (qc.startsWith("FAK")) {
                this.timingControl = TimingQualityUtils.QualityControlAlgorithm.FAKE_TIME;
                this.log.info("Replacing all (recorded) time information by a new, made-up \"fake\" time!");
                if (this.fringeSamples != FringeSampleUtils.FringeSampleTreatment.NOMINAL) {
                    this.log.severe("Selecting the \"fake\" time algorithm requires the '--fringe-samples=" + (Object)((Object)FringeSampleUtils.FringeSampleTreatment.NOMINAL) + "' command line option to be given as well.");
                    System.exit(64);
                }
            } else {
                this.log.severe("Unknown timing quality control method '" + qc + "'. Please use one of \"LLS\" (Local Least Squares fitting), \"RULE\", \"NONE\" or \"FAKE\" instead.");
                System.exit(64);
            }
        } else {
            this.log.fine("Using the default timing quality control method ('" + this.timingControl.toString() + "').");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildFileIndex() {
        if (!this.cubeIndex.isEmpty()) {
            this.log.fine("The \"Cube data index\" already exists. There is no need to build a new one from scratch.");
            return;
        }
        SortedFileSet fileList = null;
        if (!this.cmdLineParser.getArgumentList().isEmpty()) {
            fileList = CubeUtils.buildCubeFileList(this.cmdLineParser.getArgumentList(), this.inputFilter);
        } else {
            this.log.severe("No input file was given. At least one Cube input file or directory containing one is required!");
            System.exit(64);
        }
        Stopwatch totalRunTime = new Stopwatch();
        Stopwatch traceRunTime = new Stopwatch();
        long traceSize = 0L;
        long totalSize = 0L;
        TraceInfo traceInfo = new TraceInfo();
        for (File cubeFile : fileList) {
            try {
                if (!traceInfo.isContinuous(cubeFile)) {
                    this.log.info("End of trace detected");
                    try {
                        WnroUtil.wnroCorrection(traceInfo, this.wnroCorrection);
                        TimingQualityUtils.qualityControl(traceInfo, this.timingControl);
                        FringeSampleUtils.includeFringeSamples(traceInfo, this.fringeSamples);
                        if (this.cubeIndex.add(traceInfo)) {
                            this.log.fine("Indexed " + StringUtils.toShortIecByteCount(traceSize) + " in " + traceRunTime);
                        } else {
                            this.log.warning("Trace already exists in the index! Information was not indexed a second time.");
                        }
                    }
                    catch (CubeException | TimeException e) {
                        this.log.severe("Indexing of trace failed! Reason: " + e.getMessage());
                    }
                    finally {
                        traceInfo = new TraceInfo();
                        traceRunTime.restart();
                    }
                }
                this.log.info("Indexing file '" + cubeFile.getName() + "'  (" + StringUtils.toShortIecByteCount(cubeFile.length()) + ")");
                if (CubeUtils.isLeapSecondListOutdated(cubeFile)) {
                    this.log.severe("The available leap second table is too old to process the file '" + cubeFile.getAbsolutePath() + "'! You need an update!!!");
                    continue;
                }
                traceInfo.append(cubeFile);
                traceSize = cubeFile.length();
                totalSize += cubeFile.length();
            }
            catch (FileNotFoundException e) {
                this.log.severe("File '" + cubeFile.getAbsolutePath() + "' disappeared!");
            }
            catch (IOException e) {
                this.log.severe("Couldn't read from file '" + cubeFile.getAbsolutePath() + "'! Permissions?");
            }
            catch (CubeException e) {
                this.log.severe("Cube file format problem! Reason: " + e.getMessage());
            }
        }
        this.log.info("End of last trace detected");
        try {
            WnroUtil.wnroCorrection(traceInfo, this.wnroCorrection);
            TimingQualityUtils.qualityControl(traceInfo, this.timingControl);
            FringeSampleUtils.includeFringeSamples(traceInfo, this.fringeSamples);
            if (this.cubeIndex.add(traceInfo)) {
                this.log.fine("Indexed " + StringUtils.toShortIecByteCount(traceSize) + " in " + traceRunTime);
            } else {
                this.log.warning("Trace already exists in the index! Information was not indexed a second time.");
            }
        }
        catch (CubeException | TimeException e) {
            this.log.severe("Conversion of trace failed! Reason: " + e.getMessage());
        }
        if (!this.cubeIndex.isEmpty()) {
            this.log.info(this.cubeIndex.size() + " continuous traces were indexed in " + totalRunTime + "  (" + StringUtils.toShortIecByteCount(totalSize) + " total)");
        } else {
            this.log.severe("Failed to successfully index any trace. There is no data to work with!");
            System.exit(65);
        }
    }

    /*
     * Exception decompiling
     */
    protected void writeIndexToCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void readIndexFromCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected EquallySpacedTimeSeries readTrace(GatherEntry gatherInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

