/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.seis.miniseed.MiniseedTraceWriter;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.miniseed.CroppingMode;

public class Request {
    private final CroppingMode mode;
    private final TimeMoment start;
    private final TimeMoment stop;
    private final TimeSpan length;
    private MiniseedTraceWriter writer;

    public static Request newStartStopRequest(TimeMoment start, TimeMoment stop) {
        return new Request(CroppingMode.START_STOP, start, stop, null);
    }

    public static Request newStartLengthRequest(TimeMoment start, TimeSpan length) {
        return new Request(CroppingMode.START_LENGTH, start, null, length);
    }

    public static Request newLengthStopRequest(TimeSpan length, TimeMoment stop) {
        return new Request(CroppingMode.LENGTH_STOP, null, stop, length);
    }

    public static Request newFullDataRequest() {
        return new Request(CroppingMode.NONE, null, null, null);
    }

    private Request(CroppingMode mode, TimeMoment start, TimeMoment stop, TimeSpan length) {
        assert (mode != null) : "Undefined cropping 'mode'!";
        this.mode = mode;
        this.start = start;
        this.stop = stop;
        this.length = length;
        this.writer = null;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        switch (this.mode) {
            case NONE: {
                text.append("all data");
                break;
            }
            case START_STOP: {
                text.append("from ").append(this.start).append(" to ").append(this.stop);
                break;
            }
            case START_LENGTH: {
                text.append(this.length).append(" beginning at ").append(this.start);
                break;
            }
            case LENGTH_STOP: {
                text.append(this.length).append(" ending at ").append(this.stop);
                break;
            }
            default: {
                text.append("UNKNOWN CROPPING MODE");
            }
        }
        return text.toString();
    }

    public CroppingMode getCropMode() {
        return this.mode;
    }

    public TimeMoment getStart() {
        return this.start;
    }

    public TimeMoment getStop() {
        return this.stop;
    }

    public TimeSpan getLength() {
        return this.length;
    }

    public MiniseedTraceWriter getWriter() {
        return this.writer;
    }

    public void setWriter(MiniseedTraceWriter writer) {
        this.writer = writer;
    }

    public void closeWriter() {
        if (this.writer == null) {
            return;
        }
        FileUtils.flushClose(this.writer);
        this.writer = null;
    }
}

