/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortByExtension;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.regex.RegexUtils;
import de.gfz_potsdam.gipp.common.seis.miniseed.ArithmeticOverflowException;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MseedToPdas
extends GippToolsApplication {
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private final CmdLineBoolean forceConcatenateOption = new CmdLineBoolean("force-concat", "Concatenate the PDAS output creating as few new files as possible. This means that a new PDAS output file is only started when there is a (data) discontinuity in the miniSEED input. Without discontinuity the converted data is simply appended to the PDAS file\nBy default however, a new PDAS output file is created for every single miniSEED input file.");
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newMiniseedInputFilterOption();
    private final CmdLineString selectStationOption = GippToolsCommonOptions.newSelectStationOption();
    private final CmdLineString selectChannelOption = GippToolsCommonOptions.newSelectChannelOption();
    private final List<Pattern> selectedChannels;
    private final List<Pattern> selectedStations = new ArrayList<Pattern>();
    private File outputDir = null;
    private boolean forceOverwrite = false;
    private boolean forceConcatenate = false;
    private RegexFilenameFilter inputFilter = null;

    public MseedToPdas(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.selectedChannels = new ArrayList<Pattern>();
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.selectStationOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.selectChannelOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.registerOption(this.forceConcatenateOption);
        this.cmdLineParser.setProgramName("mseed2pdas");
        this.cmdLineParser.setProgramDescription("convert miniSEED input to PDAS format");
        this.cmdLineParser.setProgramArguments("[miniSEED-FILE|DIRECTORY]...");
    }

    private static String getPdasChannel(Record record) {
        assert (record != null) : "Argument 'record' must not be null.";
        if (record.getChannelId().contains("p0")) {
            return "P1";
        }
        if (record.getChannelId().contains("p1")) {
            return "P2";
        }
        if (record.getChannelId().contains("p2")) {
            return "P3";
        }
        if (record.getChannelId().contains("p3")) {
            return "P4";
        }
        if (record.getChannelId().contains("p4")) {
            return "P5";
        }
        if (record.getChannelId().contains("p5")) {
            return "P6";
        }
        if (record.getChannelId().contains("s1")) {
            return "S1";
        }
        if (record.getChannelId().contains("s2")) {
            return "S2";
        }
        if (record.getChannelId().contains("s3")) {
            return "S3";
        }
        if (record.getChannelId().contains("s4")) {
            return "S4";
        }
        if (record.getChannelId().contains("s5")) {
            return "S5";
        }
        if (record.getChannelId().contains("s6")) {
            return "S6";
        }
        if (record.getChannelId().contains("1C1")) {
            return "P1";
        }
        if (record.getChannelId().contains("1C2")) {
            return "P2";
        }
        if (record.getChannelId().contains("1C3")) {
            return "P3";
        }
        if (record.getChannelId().contains("1C4")) {
            return "P4";
        }
        if (record.getChannelId().contains("1C5")) {
            return "P5";
        }
        if (record.getChannelId().contains("1C6")) {
            return "P6";
        }
        if (record.getChannelId().contains("Z")) {
            return "P1";
        }
        if (record.getChannelId().contains("N")) {
            return "P2";
        }
        if (record.getChannelId().contains("E")) {
            return "P3";
        }
        return "P0";
    }

    private static int getPdasSerial(Record record) {
        assert (record != null) : "Argument 'record' must not be null.";
        if (record.getStationId().matches("^[er]\\d\\d\\d\\d$")) {
            int serial = Integer.parseInt(record.getStationId().substring(1));
            if (serial >= 3000 && serial <= 3999) {
                return serial % 1000;
            }
            if (serial >= 6000 && serial <= 6999) {
                return serial % 1000 + 500;
            }
            return 999;
        }
        if (record.getStationId().matches("^c\\d\\d\\d\\d$")) {
            return Integer.parseInt(record.getStationId().substring(1)) % 1000;
        }
        if (record.getStationId().matches("^\\d+$")) {
            return Integer.parseInt(record.getStationId()) % 1000;
        }
        return 999;
    }

    private static int getPdasTimeOfDay(Record record) {
        return (record.getStartTime().getHour() * 60 + record.getStartTime().getMinute()) / 2;
    }

    private static void writePdasHeader(OutputStream outStream, Record record) {
        PrintStream prtStream = new PrintStream(outStream);
        prtStream.print("DATASET " + MseedToPdas.getPdasChannel(record) + StringUtils.THREE_DIGITS.format(MseedToPdas.getPdasSerial(record)) + StringUtils.THREE_DIGITS.format(MseedToPdas.getPdasTimeOfDay(record)) + StringUtils.THREE_DIGITS.format(record.getStartTime().getDayOfYear()) + "\r\n");
        prtStream.print("FILE_TYPE LONG\r\n");
        prtStream.print("VERSION next\r\n");
        prtStream.print("SIGNAL " + record.getChannelId() + "\r\n");
        prtStream.print("DATE " + StringUtils.TWO_DIGITS.format(record.getStartTime().getMonth()) + "-" + StringUtils.TWO_DIGITS.format(record.getStartTime().getDay()) + "-" + StringUtils.TWO_DIGITS.format(record.getStartTime().getYear() % 100) + "\r\n");
        prtStream.print("TIME " + StringUtils.TWO_DIGITS.format(record.getStartTime().getHour()) + ":" + StringUtils.TWO_DIGITS.format(record.getStartTime().getMinute()) + ":" + StringUtils.TWO_DIGITS.format(record.getStartTime().getSecond()) + "." + StringUtils.THREE_DIGITS.format(record.getStartTime().getNanoSecond() / 1000000L) + "  (" + StringUtils.THREE_DIGITS.format(record.getStartTime().getNanoSecond() / 1000000L) + ")\r\n");
        prtStream.print("INTERVAL " + record.getSamplePeriod() + "\r\n");
        prtStream.print("VERT_UNITS Counts\r\n");
        prtStream.print("HORZ_UNITS Sec\r\n");
        prtStream.print("COMMENT MINISEED " + record.getNetworkId() + ", " + record.getLocationId() + ", " + record.getStationId() + ", " + record.getChannelId() + "\r\n");
        prtStream.print("DATA\r\n");
    }

    private static void writePdasData(OutputStream outStream, Record record) throws IOException {
        for (double sample : record.getSampleData()) {
            if (sample > 2.147483647E9 || sample < -2.147483648E9) {
                throw new ArithmeticOverflowException("The sample value '" + sample + "' is to large to be represented by a 32 bit integer. Cannot encode data!");
            }
            int value = (int)Math.round(sample);
            outStream.write(value & 0xFF);
            outStream.write(value >>> 8 & 0xFF);
            outStream.write(value >>> 16 & 0xFF);
            outStream.write(value >>> 24 & 0xFF);
        }
    }

    public static void main(String[] args) {
        MseedToPdas mseed2pdas = new MseedToPdas(args);
        try {
            mseed2pdas.handleCommonOptions();
            mseed2pdas.handleGippToolOptions();
            mseed2pdas.handleInputOptions();
            mseed2pdas.handleSelectionOptions();
            mseed2pdas.handleOutputOptions();
            mseed2pdas.run();
        }
        catch (CmdLineException e) {
            mseed2pdas.logThrowable(e);
            System.exit(64);
        }
        catch (IntegrityException e) {
            mseed2pdas.logThrowable(e);
            System.exit(65);
        }
        catch (IOException e) {
            mseed2pdas.logThrowable(e);
            System.exit(74);
        }
        catch (OutOfMemoryError e) {
            mseed2pdas.log.severe("Ran out of memory! Please reduce the amount of miniSEED input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            mseed2pdas.logThrowable(e);
            System.exit(99);
        }
    }

    private File pdasFilename(Record record) {
        String basename = MseedToPdas.getPdasChannel(record).toLowerCase() + StringUtils.THREE_DIGITS.format(MseedToPdas.getPdasSerial(record)) + StringUtils.THREE_DIGITS.format(MseedToPdas.getPdasTimeOfDay(record));
        String extension = StringUtils.THREE_DIGITS.format(record.getStartTime().getDayOfYear());
        return this.getOutputFile(this.outputDir, basename, extension, this.forceOverwrite);
    }

    private void handleInputOptions() {
        if (this.cmdLineParser.getArgumentList().isEmpty() && this.inputFilterOption.isMatched()) {
            throw new CmdLineException("Cannot apply the '--include-pattern' option when reading from standard input! Please give at least one miniSEED file or directory as argument to read from or drop the '--include-pattern' option altogether.");
        }
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addMseedFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP miniSEED filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    void handleSelectionOptions() {
        if (this.selectStationOption.isMatched()) {
            for (String pattern : this.selectStationOption.getValues()) {
                if (pattern.isEmpty()) {
                    this.log.warning("The \"--select-station\" option is missing the STATION expression.");
                }
                if (pattern.length() > Record.FixedHeader.STATION_ID.length()) {
                    this.log.warning("The STATION given in the \"--select-station\" option is longer than the permitted station id length (up to " + Record.FixedHeader.STATION_ID.length() + " characters). Most likely, there will be no matching station in the miniSEED input!");
                }
                this.selectedStations.add(Pattern.compile(RegexUtils.convertWildcards(pattern)));
                this.log.info("Processing stations that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.selectedStations.clear();
            this.log.fine("No stations selection is applied.");
        }
        if (this.selectChannelOption.isMatched()) {
            for (String pattern : this.selectChannelOption.getValues()) {
                if (pattern.isEmpty()) {
                    this.log.warning("The \"--select-channel\" option is missing a CHANNEL expression.");
                }
                if (pattern.length() > Record.FixedHeader.CHANNEL_ID.length()) {
                    this.log.warning("The CHANNEL given in the \"--select-channel\" option is longer than the permitted channel id length (up to " + Record.FixedHeader.CHANNEL_ID.length() + " characters). Most likely, there will be no matching channel in the miniSEED input!");
                }
                this.selectedChannels.add(Pattern.compile(RegexUtils.convertWildcards(pattern)));
                this.log.info("Processing channels that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.selectedChannels.clear();
            this.log.fine("No channel selection is applied.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        if (!this.outputDirOption.isMatched()) {
            if (this.forceOverwriteOption.isMatched()) {
                throw new CmdLineException("The '--force-overwrite' option is only allowed in conjunction with the '--output-dir=DIR' option.");
            }
            if (this.forceConcatenateOption.isMatched()) {
                throw new CmdLineException("The '--force-concat' option is only allowed in conjunction with the '--output-dir=DIR' option.");
            }
        }
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing PDAS files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing PDAS files will NOT be overwritten.");
        }
        if (this.forceConcatenateOption.isMatched()) {
            this.forceConcatenate = true;
            this.log.info("Concatenate the PDAS output in as few files as possible.");
        } else {
            this.forceConcatenate = false;
            this.log.fine("Create a new PDAS output file for every miniSEED input file.");
        }
        if (!this.outputDirOption.isMatched()) {
            this.outputDir = null;
            this.log.fine("All PDAS data will be written to \"standard output\" (console).");
            return;
        }
        this.outputDir = new File(this.outputDirOption.getValue());
        if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
            this.log.info("All PDAS files will be created in the '" + this.outputDir.getPath() + "' directory.");
            return;
        }
        this.outputDir = null;
        throw new CmdLineException("Cannot write PDAS files to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
    }

    private SortedFileSet handleFileArguments() {
        SortedFileSet inputList = new SortedFileSet(new SortByExtension(), this.inputFilter);
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            this.log.info("Reading miniSEED data from \"standard input\".");
            inputList.add(SortedFileSet.STANDARD_INPUT_TOKEN);
        } else {
            this.log.info("Building list of input files..");
            for (String name : this.cmdLineParser.getArgumentList()) {
                File file = new File(name);
                if (file.exists()) {
                    inputList.add(file);
                    continue;
                }
                this.log.warning("File or directory '" + name + "' given at the command line does not exist! Maybe a typing error?");
            }
        }
        if (inputList.isEmpty()) {
            this.log.severe("No suitable input files found.");
        } else {
            this.log.info("Found " + inputList.size() + " file(s) to process.");
        }
        return inputList;
    }

    /*
     * Exception decompiling
     */
    protected void run() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

