/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortByExtension;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.miniseed.EncodingFormat;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.time.InvalidDateException;
import de.gfz_potsdam.gipp.common.time.ParserException;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import de.gfz_potsdam.gipp.tool.miniseed.Action;
import de.gfz_potsdam.gipp.tool.miniseed.Condition;
import de.gfz_potsdam.gipp.tool.miniseed.EditingRule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class MseedToMseed
extends GippToolsApplication {
    private static final String WILDCARD_CONDITION = "*";
    private static final String NOP_ACTION = "*";
    private static final String RESET_ACTION = "RESET";
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private final CmdLineBoolean forceConcatenateOption = new CmdLineBoolean("force-concat", "Concatenate the miniSEED output creating as few new files as possible. This means that a new miniSEED output file is only started when there is a (data) discontinuity in the miniSEED input. Without discontinuity the converted data is simply appended to the current file.\nBy default however, a new miniSEED output file is created for every single input file as well as in the case of a discontinuity.");
    private final CmdLineString outputByteOrderOption = new CmdLineString("byte-order", "Set the byte order of the miniSEED output. Use the values BIG-ENDIAN or LITTLE-ENDIAN to use the respective byte order. The argument NATIVE automatically changes the byte order to the byte order of the currently used platform (e.g. little endian on Intel PCs and big endian on Sun SPARC machines).\nNote: This command line option always applies to all records at the same time!", new String[]{"BIG-ENDIAN", "LITTLE-ENDIAN", "NATIVE"});
    private final CmdLineString outputRecordSizeOption = new CmdLineString("record-size", "Set the record size of the miniSEED output. The record size is given in bytes and must be a power of two value (e.g. 512, 1024, 2048, ...)\nNote: This command line option always applies to all records at the same time!");
    private final CmdLineString outputEncodingOption = new CmdLineString("encoding", "Set the encoding scheme of the miniSEED output.\nNote: This command line option always applies to all records at the same time!", new String[]{"STEIM-1", "STEIM-2", "INT-32", "FLOAT-32", "FLOAT-64"});
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newMiniseedInputFilterOption();
    private final CmdLineBoolean dryRunOption = new CmdLineBoolean("dry-run", "Perform a trial run with no changes and modifications made to the file system whatsoever (and, of course, no miniSEED output).\nHint: This command line option is used best in conjunction with the '--verbose' option, so you can see what would happen if it were not a trial run.");
    private final CmdLineString ruleFileOption = new CmdLineString("rules", "Use the table contained in the given file to define additional editing rules. Please see the manual for a description of the table layout.");
    private final CmdLineString matchStationOption = new CmdLineString("match-station", "Condition. Only modify miniSEED records with matching \"station id\".");
    private final CmdLineString matchChannelOption = new CmdLineString("match-channel", "Condition. Only modify miniSEED records with matching \"channel id\".");
    private final CmdLineString matchLocationOption = new CmdLineString("match-location", "Condition. Only modify miniSEED records with matching \"location id\".");
    private final CmdLineString matchNetworkOption = new CmdLineString("match-network", "Condition. Only modify miniSEED records with matching \"network id\".");
    private final CmdLineString equalsSampleRateOption = new CmdLineString("equals-sample-rate", "Condition. Only modify miniSEED records of the given \"sampling rate\" (given in samples per second).\n(Hint: Use '--equals-sample-period' for cases where the sample rate is smaller than one sample per second.)");
    private final CmdLineString equalsSamplePeriodOption = new CmdLineString("equals-sample-period", "Condition. Only modify miniSEED records of the given \"sampling period\" (given in seconds between samples).\n(Hint: Use '--equals-sample-rate' in cases where the time between samples is smaller than one second.)");
    private final CmdLineString equalsTimingQualityOption = new CmdLineString("equals-timing-quality", "Condition. Only modify miniSEED records with \"timing quality\" equaling the given value (range 0 to 100).");
    private final CmdLineString lessThanTimingQualityOptions = new CmdLineString("less-than-timing-quality", "Condition. Only modify miniSEED records with \"timing quality\" less than the given value (range 0 to 100).");
    private final CmdLineString moreThanTimingQualityOptions = new CmdLineString("more-than-timing-quality", "Condition. Only modify miniSEED records with \"timing quality\" more than the given value (range 0 to 100).");
    private final CmdLineString beforeTimeOption = new CmdLineString("before-time", "Condition. Only modify miniSEED records with a \"start time\" before or at precisely the given value.");
    private final CmdLineString afterTimeOption = new CmdLineString("after-time", "Condition. Only modify miniSEED records with a \"start time\" after the given value.");
    private final CmdLineString setStationOption = new CmdLineString("set-station", "Action. Set the \"station id\". (Up to five characters long!)");
    private final CmdLineString setChannelOption = new CmdLineString("set-channel", "Action. Set the \"channel id\". (Up to three characters long!)");
    private final CmdLineString setLocationOption = new CmdLineString("set-location", "Action. Set the \"location id\". (Up to two characters long!)");
    private final CmdLineString setNetworkOption = new CmdLineString("set-network", "Action. Set the \"network id\". (Up to two characters long!)");
    private final CmdLineString setTimingQualityOption = new CmdLineString("set-timing-quality", "Action. Set the \"timing quality\" value. (Range 0..100)");
    private final CmdLineString shiftStartTimeOption = new CmdLineString("shift-time", "Action. Shift the \"start time\" of the miniSEED record by the given time span. The time shift is given in seconds. Negative numbers will shift the start time towards earlier times.)");
    private final CmdLineBoolean bugfixStartTimeOption = new CmdLineBoolean("bugfix-edr-start-time", "Action. Correct possibly erroneous \"start times\" of miniSEED records that were recorded by EDRs running a buggy firmware. See program documentation for more details!\nWARNING !!! It is not save at all to apply this \"BugFix Action\" to data that is not affected by the (historic) EDR firmware bug! It probably will irreversible screw up your start times!");
    private final CmdLineBoolean bugfixWeekNumberRolloverOption = new CmdLineBoolean("bugfix-gps-epoch", "Action. Correct possibly erroneous \"start times\" of miniSEED records that were caused by an unhandled GPS week number rollover. See documentation for more details!\nWARNING !!! It is not save at all to apply this \"BugFix Action\" to data that is not affected by the GPS week number rollover problem! It possibly will screw up your start times!");
    List<EditingRule> jobList = new ArrayList<EditingRule>();
    private File outputDir = null;
    private boolean forceOverwrite = false;
    private boolean forceConcatenate = false;
    private ByteOrder outputByteOrder = null;
    private int outputRecordSize = -1;
    private EncodingFormat outputEncoding = null;
    private RegexFilenameFilter inputFilter = null;
    private boolean dryRun = false;

    public MseedToMseed(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.registerOption(this.dryRunOption);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.registerOption(this.forceConcatenateOption);
        this.cmdLineParser.registerOption(this.outputByteOrderOption);
        this.cmdLineParser.registerOption(this.outputRecordSizeOption);
        this.cmdLineParser.registerOption(this.outputEncodingOption);
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.ruleFileOption);
        this.cmdLineParser.registerOption(this.matchChannelOption);
        this.cmdLineParser.registerOption(this.matchStationOption);
        this.cmdLineParser.registerOption(this.matchNetworkOption);
        this.cmdLineParser.registerOption(this.matchLocationOption);
        this.cmdLineParser.registerOption(this.equalsSampleRateOption);
        this.cmdLineParser.registerOption(this.equalsSamplePeriodOption);
        this.cmdLineParser.registerOption(this.lessThanTimingQualityOptions);
        this.cmdLineParser.registerOption(this.equalsTimingQualityOption);
        this.cmdLineParser.registerOption(this.moreThanTimingQualityOptions);
        this.cmdLineParser.registerOption(this.afterTimeOption);
        this.cmdLineParser.registerOption(this.beforeTimeOption);
        this.cmdLineParser.registerOption(this.setStationOption);
        this.cmdLineParser.registerOption(this.setChannelOption);
        this.cmdLineParser.registerOption(this.setNetworkOption);
        this.cmdLineParser.registerOption(this.setLocationOption);
        this.cmdLineParser.registerOption(this.setTimingQualityOption);
        this.cmdLineParser.registerOption(this.shiftStartTimeOption);
        this.cmdLineParser.registerOption(this.bugfixStartTimeOption).set(CmdLineOption.Visibility.HIDDEN);
        this.cmdLineParser.registerOption(this.bugfixWeekNumberRolloverOption).set(CmdLineOption.Visibility.HIDDEN);
        this.cmdLineParser.setProgramName("mseed2mseed");
        this.cmdLineParser.setProgramDescription("modify miniSEED header fields");
        this.cmdLineParser.setProgramArguments("[miniSEED-FILE|DIRECTORY]...");
    }

    public static void main(String[] args) {
        MseedToMseed mseed2mseed = new MseedToMseed(args);
        try {
            mseed2mseed.handleCommonOptions();
            mseed2mseed.handleGippToolOptions();
            mseed2mseed.parseRuleFile();
            mseed2mseed.handleRuleOptions();
            mseed2mseed.handleOutputOptions();
            mseed2mseed.handleInputOptions();
            mseed2mseed.run();
        }
        catch (CmdLineException e) {
            mseed2mseed.logThrowable(e);
            System.exit(64);
        }
        catch (IntegrityException | TimeException e) {
            mseed2mseed.logThrowable(e);
            System.exit(65);
        }
        catch (IOException e) {
            mseed2mseed.logThrowable(e);
            System.exit(74);
        }
        catch (OutOfMemoryError e) {
            mseed2mseed.log.severe("Ran out of memory! Please reduce the amount of miniSEED input to process or (better) increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            mseed2mseed.logThrowable(e);
            System.exit(99);
        }
    }

    private boolean addTextMatchCondition(List<Condition> conditions, CmdLineString option, Key headerField) {
        if (option.isMatched()) {
            String regex = option.getValue();
            Condition.MatchText condition = new Condition.MatchText(headerField, regex);
            this.log.fine("Found condition: '" + condition + "'");
            return conditions.add(condition);
        }
        return false;
    }

    private boolean addNumericCondition(List<Condition> conditions, CmdLineString option, Key headerField, Operator comparison) {
        if (option.isMatched()) {
            try {
                Condition condition;
                int value = Integer.parseInt(option.getValue());
                switch (comparison) {
                    case EQUALS: {
                        condition = new Condition.EqualNumber(headerField, value);
                        break;
                    }
                    case SMALLER: {
                        condition = new Condition.SmallerNumber(headerField, value);
                        break;
                    }
                    case GREATER: {
                        condition = new Condition.LargerNumber(headerField, value);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Comparison operator " + (Object)((Object)comparison) + " was not implemented yet!");
                    }
                }
                this.log.fine("Found condition: '" + condition + "'");
                return conditions.add(condition);
            }
            catch (NumberFormatException e) {
                throw new CmdLineException("The argument ('" + option.getValue() + "') that was given in option '" + option.getLongSyntax() + "' must be an integer number!", e);
            }
        }
        return false;
    }

    private boolean addTimingCondition(List<Condition> conditions, CmdLineString option, Key headerField, Operator comparison) {
        if (option.isMatched()) {
            try {
                Condition condition;
                TimeMoment time = TimeMoment.parse(option.getValue());
                if (time.before(new TimeMoment.Builder().date(1950, 1, 1).build())) {
                    this.log.warning("The given time is before 1 Jan 1950, which is probably not what you want! Typing error? Anyway, your wish is my command...");
                }
                switch (comparison) {
                    case BEFORE: {
                        condition = new Condition.BeforeTime(headerField, time);
                        break;
                    }
                    case BEFORE_OR_AT: {
                        condition = new Condition.BeforeOrAtTime(headerField, time);
                        break;
                    }
                    case AFTER: {
                        condition = new Condition.AfterTime(headerField, time);
                        break;
                    }
                    case AFTER_OR_AT: {
                        condition = new Condition.AfterOrAtTime(headerField, time);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Comparison operator " + (Object)((Object)comparison) + " was not implemented yet!");
                    }
                }
                this.log.fine("Found condition: '" + condition + "'");
                return conditions.add(condition);
            }
            catch (TimeException e) {
                throw new CmdLineException("Invalid time argument ('" + option.getValue() + "'). Please use a correctly formatted and existing date/time string (e.g. \"2007-03-27T13:00:00\").", e);
            }
        }
        return false;
    }

    private boolean addSetTextAction(List<Action> actions, CmdLineString option, Key headerField) {
        if (option.isMatched()) {
            String value = option.getValue();
            Action action = value.equalsIgnoreCase(RESET_ACTION) ? new Action.Reset(headerField) : new Action.SetText(headerField, value);
            this.log.fine("Found    action: '" + action + "'");
            return actions.add(action);
        }
        return false;
    }

    private boolean addSetTimingQualityAction(List<Action> actions) {
        if (this.setTimingQualityOption.isMatched()) {
            Action action;
            if (this.setTimingQualityOption.getValue().equalsIgnoreCase(RESET_ACTION)) {
                action = new Action.Reset(Key.TIMING_QUALITY);
            } else if (this.setTimingQualityOption.getValue().equalsIgnoreCase("BAD")) {
                action = new Action.SetTimingQuality(1);
            } else if (this.setTimingQualityOption.getValue().equalsIgnoreCase("GOOD")) {
                action = new Action.SetTimingQuality(100);
            } else {
                byte value;
                try {
                    value = Byte.parseByte(this.setTimingQualityOption.getValue());
                }
                catch (NumberFormatException e) {
                    throw new CmdLineException("Invalid timing quality value ('" + this.setTimingQualityOption.getValue() + "'). Timing quality must be in the range from 0 (bad) to 100 (maximum accuracy).", e);
                }
                if (value < 0 || value > 100) {
                    throw new CmdLineException("Invalid timing quality value ('" + this.setTimingQualityOption.getValue() + "'). Timing quality must be in the range from 0 (bad) to 100 (maximum accuracy).");
                }
                action = new Action.SetTimingQuality(value);
            }
            this.log.fine("Found    action: '" + action + "'");
            return actions.add(action);
        }
        return false;
    }

    private boolean addTimeActions(List<Action> actions) {
        if (this.shiftStartTimeOption.isMatched()) {
            try {
                Action.ShiftTime action;
                String value = this.shiftStartTimeOption.getValue();
                switch (value.charAt(0)) {
                    case '-': {
                        action = new Action.ShiftTime(-1, TimeSpan.parse(value.substring(1)));
                        break;
                    }
                    case '+': {
                        action = new Action.ShiftTime(1, TimeSpan.parse(value.substring(1)));
                        break;
                    }
                    default: {
                        action = new Action.ShiftTime(1, TimeSpan.parse(value));
                    }
                }
                this.log.fine("Found    action: '" + action + "'");
                return actions.add(action);
            }
            catch (TimeException e) {
                throw new CmdLineException("Invalid '--shift-time' argument. " + e.getMessage(), e);
            }
        }
        return false;
    }

    private boolean addBugFixActions(List<Action> actionList, CmdLineOption cmdLineOption, Action bugfixAction) {
        if (cmdLineOption.isMatched()) {
            this.log.fine("Found    action: '" + bugfixAction + "'");
            return actionList.add(bugfixAction);
        }
        return false;
    }

    private void handleInputOptions() {
        if (this.cmdLineParser.getArgumentList().isEmpty() && this.inputFilterOption.isMatched()) {
            throw new CmdLineException("Cannot apply the '--include-pattern' option when reading from standard input! Please give at least one miniSEED file or directory as argument to read from or drop the '--include-pattern' option altogether.");
        }
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addMseedFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP miniSEED filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        String codec;
        block40: {
            if (!this.outputDirOption.isMatched()) {
                if (this.forceOverwriteOption.isMatched()) {
                    throw new CmdLineException("The '--force-overwrite' option is only allowed in conjunction with the '--output-dir=DIR' option.");
                }
                if (this.forceConcatenateOption.isMatched()) {
                    throw new CmdLineException("The '--force-concat' option is only allowed in conjunction with the '--output-dir=DIR' option.");
                }
            }
            if (this.dryRunOption.isMatched()) {
                this.dryRun = true;
                this.log.info("Running in \"trial mode\". No changes or modifications will be made whatsoever!");
            }
            if (this.forceOverwriteOption.isMatched()) {
                this.forceOverwrite = true;
                this.log.info("Already existing files will be overwritten!");
            } else {
                this.forceOverwrite = false;
                this.log.fine("Already existing files will NOT be overwritten.");
            }
            if (this.forceConcatenateOption.isMatched()) {
                this.forceConcatenate = true;
                this.log.info("Concatenate the miniSEED output in as few files as possible.");
            } else {
                this.forceConcatenate = false;
                this.log.fine("Create a new miniSEED output file for every single input file.");
            }
            if (this.outputDirOption.isMatched()) {
                this.outputDir = new File(this.outputDirOption.getValue());
                if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
                    this.log.info("All resulting miniSEED files will be written to the '" + this.outputDir.getPath() + "' directory.");
                    break block40;
                } else {
                    this.outputDir = null;
                    throw new CmdLineException("Cannot write miniSEED files to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
                }
            }
            this.outputDir = null;
            this.log.fine("All results will be written to \"standard output\" (console).");
        }
        if (this.outputByteOrderOption.isMatched()) {
            String order = this.outputByteOrderOption.getValue().toUpperCase();
            if (order.startsWith("BIG")) {
                this.outputByteOrder = ByteOrder.BIG_ENDIAN;
            } else if (order.startsWith("LITTLE")) {
                this.outputByteOrder = ByteOrder.LITTLE_ENDIAN;
            } else if (order.startsWith("NATIVE")) {
                this.outputByteOrder = ByteOrder.nativeOrder();
            } else {
                this.log.severe("Unknown byte order format '" + order + "'. Please use one of \"BIG-ENDIAN\", \"LITTLE-ENDIAN\" or \"NATIVE\" instead.");
                System.exit(64);
            }
            this.log.info("The miniSEED output will be in " + this.outputByteOrder.toString() + " byte order.");
        } else {
            this.outputByteOrder = null;
            this.log.fine("MiniSEED byte order will not be changed.");
        }
        if (this.outputRecordSizeOption.isMatched()) {
            long size = Long.parseLong(this.outputRecordSizeOption.getValue());
            byte exponent = (byte)Math.round(Math.ceil(Math.log(size) / Math.log(2.0)));
            this.outputRecordSize = 1 << exponent;
            if (size <= 64L) {
                this.log.severe("A MiniSEED record must be at least 64 bytes long.");
                System.exit(64);
            }
            if (size >= Integer.MAX_VALUE) {
                this.log.severe("Cannot allocate memory for a MiniSEED record of this size. Please use a smaller record size.");
                System.exit(64);
            }
            if ((long)this.outputRecordSize != size) {
                this.log.warning("The miniSEED record size must be a power of two. Increasing record size to " + this.outputRecordSize + " bytes for all output!");
            } else {
                this.log.info("The miniSEED output will use " + this.outputRecordSize + " byte long records.");
            }
        } else {
            this.outputRecordSize = -1;
            this.log.fine("MiniSEED record size will not be changed.");
        }
        if (!this.outputEncodingOption.isMatched()) {
            this.outputEncoding = null;
            this.log.fine("MiniSEED data encoding will not be changed.");
            return;
        }
        switch (codec = this.outputEncodingOption.getValue().toUpperCase()) {
            case "STEIM-1": {
                this.outputEncoding = EncodingFormat.STEIM_1;
                break;
            }
            case "STEIM-2": {
                this.outputEncoding = EncodingFormat.STEIM_2;
                break;
            }
            case "INT-32": {
                this.outputEncoding = EncodingFormat.INT_32;
                break;
            }
            case "FLOAT-32": {
                this.outputEncoding = EncodingFormat.IEEE_FLOAT;
                break;
            }
            case "FLOAT-64": {
                this.outputEncoding = EncodingFormat.IEEE_DOUBLE;
                break;
            }
            default: {
                this.log.severe("Unknown encoding format '" + codec + "'. Please use one of \"STEIM-1\", \"STEIM-2\", \"INT-32\", \"FLOAT-32\" or \"FLOAT-64\" instead.");
                System.exit(64);
            }
        }
        this.log.info("The miniSEED output will use " + (Object)((Object)this.outputEncoding) + ".");
    }

    private void handleRuleOptions() throws CmdLineException {
        this.log.fine("Searching command line for additional miniSEED editing rule.");
        ArrayList<Action> actionList = new ArrayList<Action>();
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        this.addTextMatchCondition(conditionList, this.matchStationOption, Key.STATION);
        this.addTextMatchCondition(conditionList, this.matchChannelOption, Key.CHANNEL);
        this.addTextMatchCondition(conditionList, this.matchNetworkOption, Key.NETWORK);
        this.addTextMatchCondition(conditionList, this.matchLocationOption, Key.LOCATION);
        this.addNumericCondition(conditionList, this.equalsSampleRateOption, Key.SAMPLE_RATE, Operator.EQUALS);
        this.addNumericCondition(conditionList, this.equalsSamplePeriodOption, Key.SAMPLE_PERIOD, Operator.EQUALS);
        this.addNumericCondition(conditionList, this.equalsTimingQualityOption, Key.TIMING_QUALITY, Operator.EQUALS);
        this.addNumericCondition(conditionList, this.lessThanTimingQualityOptions, Key.TIMING_QUALITY, Operator.SMALLER);
        this.addNumericCondition(conditionList, this.moreThanTimingQualityOptions, Key.TIMING_QUALITY, Operator.GREATER);
        this.addTimingCondition(conditionList, this.afterTimeOption, Key.START_TIME, Operator.AFTER_OR_AT);
        this.addTimingCondition(conditionList, this.beforeTimeOption, Key.START_TIME, Operator.BEFORE);
        this.addSetTextAction(actionList, this.setStationOption, Key.STATION);
        this.addSetTextAction(actionList, this.setChannelOption, Key.CHANNEL);
        this.addSetTextAction(actionList, this.setNetworkOption, Key.NETWORK);
        this.addSetTextAction(actionList, this.setLocationOption, Key.LOCATION);
        this.addSetTimingQualityAction(actionList);
        this.addTimeActions(actionList);
        this.addBugFixActions(actionList, this.bugfixStartTimeOption, new Action.FixEdrStartTime());
        this.addBugFixActions(actionList, this.bugfixWeekNumberRolloverOption, new Action.FixGpsEpoch());
        if (conditionList.isEmpty() && actionList.isEmpty()) {
            this.log.fine("No miniSEED header modification was defined at the command line.");
        } else {
            EditingRule job = new EditingRule(conditionList, actionList);
            this.log.info("Prepending editing rule '" + job + "' to the to-do list.");
            this.jobList.add(0, new EditingRule(conditionList, actionList));
        }
    }

    private void parseRuleFile() throws IOException, CmdLineException, ParserException, InvalidDateException {
        if (!this.ruleFileOption.isMatched()) {
            this.log.fine("No rule file is used.");
            return;
        }
        BufferedReader ruleReader = null;
        try {
            String line;
            File ruleFile = new File(this.ruleFileOption.getValue());
            ruleReader = new BufferedReader(new FileReader(ruleFile));
            this.log.fine("Rule file is '" + ruleFile.getAbsolutePath() + "'.");
            int lineNumber = 0;
            while ((line = ruleReader.readLine()) != null) {
                String[] column;
                int commentPos;
                this.log.fine("Line #" + ++lineNumber + "  Analyzing '" + line + "'");
                if ((line = line.trim()).isEmpty() || (commentPos = line.indexOf(35)) == 0) continue;
                if (commentPos > 0) {
                    line = line.substring(0, commentPos);
                }
                if ((column = line.split("\\s+")).length != 10) {
                    this.log.warning("Line #" + lineNumber + "  Unknown format! Ten columns are expected. This line will be ignored and skipped!");
                    continue;
                }
                ArrayList<Condition> conditionList = new ArrayList<Condition>();
                ArrayList<Action> actionList = new ArrayList<Action>();
                if (!column[0].equalsIgnoreCase("*")) {
                    conditionList.add(new Condition.MatchText(Key.STATION, column[0]));
                }
                if (!column[1].equalsIgnoreCase("*")) {
                    conditionList.add(new Condition.MatchText(Key.CHANNEL, column[1]));
                }
                if (!column[2].equalsIgnoreCase("*")) {
                    conditionList.add(new Condition.MatchText(Key.NETWORK, column[2]));
                }
                if (!column[3].equalsIgnoreCase("*")) {
                    conditionList.add(new Condition.MatchText(Key.LOCATION, column[3]));
                }
                if (!column[4].equalsIgnoreCase("*")) {
                    conditionList.add(new Condition.AfterTime(Key.START_TIME, TimeMoment.parse(column[4])));
                }
                if (!column[5].equalsIgnoreCase("*")) {
                    conditionList.add(new Condition.BeforeTime(Key.START_TIME, TimeMoment.parse(column[5])));
                }
                if (column[6].equalsIgnoreCase(RESET_ACTION)) {
                    actionList.add(new Action.Reset(Key.STATION));
                } else if (!column[6].equalsIgnoreCase("*")) {
                    actionList.add(new Action.SetText(Key.STATION, column[6]));
                }
                if (column[7].equalsIgnoreCase(RESET_ACTION)) {
                    actionList.add(new Action.Reset(Key.CHANNEL));
                } else if (!column[7].equalsIgnoreCase("*")) {
                    actionList.add(new Action.SetText(Key.CHANNEL, column[7]));
                }
                if (column[8].equalsIgnoreCase(RESET_ACTION)) {
                    actionList.add(new Action.Reset(Key.NETWORK));
                } else if (!column[8].equalsIgnoreCase("*")) {
                    actionList.add(new Action.SetText(Key.NETWORK, column[8]));
                }
                if (column[9].equalsIgnoreCase(RESET_ACTION)) {
                    actionList.add(new Action.Reset(Key.LOCATION));
                } else if (!column[9].equalsIgnoreCase("*")) {
                    actionList.add(new Action.SetText(Key.LOCATION, column[9]));
                }
                EditingRule rule = new EditingRule(conditionList, actionList);
                this.log.fine("Line #" + lineNumber + "  Adding rule '" + rule + "'.");
                this.jobList.add(new EditingRule(conditionList, actionList));
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new CmdLineException("Cannot find the file '" + this.ruleFileOption.getValue() + "'. Please verify that the file exist and is it readable?", e);
            }
            catch (Throwable throwable) {
                FileUtils.flushClose(ruleReader);
                throw throwable;
            }
        }
        FileUtils.flushClose(ruleReader);
        this.log.info("Finished reading the rule file. Found " + this.jobList.size() + " editing rules.");
    }

    private SortedFileSet handleFileArguments() {
        SortedFileSet inputList = new SortedFileSet(new SortByExtension(), this.inputFilter);
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            this.log.info("Reading miniSEED data from \"standard input\".");
            inputList.add(SortedFileSet.STANDARD_INPUT_TOKEN);
        } else {
            this.log.info("Building list of input files..");
            for (String name : this.cmdLineParser.getArgumentList()) {
                File file = new File(name);
                if (file.exists()) {
                    inputList.add(file);
                    continue;
                }
                this.log.warning("File or directory '" + name + "' given at the command line does not exist! Maybe a typing error?");
            }
        }
        if (inputList.isEmpty()) {
            this.log.severe("No suitable input files found.");
        } else {
            this.log.info("Found " + inputList.size() + " file(s) to process.");
        }
        return inputList;
    }

    /*
     * Exception decompiling
     */
    protected void run() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static enum Operator {
        MATCH,
        EQUALS,
        GREATER,
        SMALLER,
        BEFORE,
        BEFORE_OR_AT,
        AFTER,
        AFTER_OR_AT;

    }

    protected static enum Key {
        RECORD_NUMBER,
        STATION,
        CHANNEL,
        NETWORK,
        LOCATION,
        SAMPLE_RATE,
        SAMPLE_PERIOD,
        TIMING_QUALITY,
        START_TIME,
        STOP_TIME;

    }
}

