/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortByExtension;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.regex.RegexUtils;
import de.gfz_potsdam.gipp.common.seis.miniseed.EncodingFormat;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class MseedToAscii
extends GippToolsApplication {
    private static final Locale OUTPUT_LOCALE = Locale.ENGLISH;
    private static final char REPLACEMENT_CHARACTER = (char)65533;
    private final CmdLineString outputFormatOption = new CmdLineString("format", "Change the output format. Pick one of the following:\n" + (Object)((Object)OutputFormat.ALL) + " ....... Combination of HEADER and DATA. (Default)\n" + (Object)((Object)OutputFormat.HEADER) + " .... Only miniSEED header information.\n" + (Object)((Object)OutputFormat.DATA) + " ...... Only sample values.\n" + (Object)((Object)OutputFormat.GMT) + " ....... Sample values in a 'psxy' compatible format.\n", new String[]{OutputFormat.ALL.toString(), OutputFormat.HEADER.toString(), OutputFormat.DATA.toString(), OutputFormat.GMT.toString()});
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private final CmdLineBoolean forceConcatenateOption = new CmdLineBoolean("force-concat", "Concatenate the ASCII output creating as few new files as possible. This means that a new ASCII output file is only started when there is a (data) discontinuity in the miniSEED input. Without discontinuity the converted data is simply appended to the ASCII file.\nBy default however, a new ASCII output file is created for every single miniSEED input file.");
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newMiniseedInputFilterOption();
    private final CmdLineString selectStationOption = GippToolsCommonOptions.newSelectStationOption();
    private final CmdLineString selectChannelOption = GippToolsCommonOptions.newSelectChannelOption();
    private final List<Pattern> selectedChannels;
    private final List<Pattern> selectedStations;
    private OutputFormat outputFormat = OutputFormat.ALL;
    private File outputDir = null;
    private boolean forceOverwrite = false;
    private boolean forceConcatenate = false;
    private RegexFilenameFilter inputFilter = null;

    public MseedToAscii(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.selectedStations = new ArrayList<Pattern>();
        this.selectedChannels = new ArrayList<Pattern>();
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.selectStationOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.selectChannelOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.registerOption(this.forceConcatenateOption);
        this.cmdLineParser.registerOption(this.outputFormatOption);
        this.cmdLineParser.setProgramName("mseed2ascii");
        this.cmdLineParser.setProgramDescription("convert miniSEED data to various ASCII formats");
        this.cmdLineParser.setProgramArguments("[miniSEED-FILE|DIRECTORY]...");
    }

    private static String sanitizeText(String dirty) {
        assert (dirty != null) : "Cannot sanitize a 'null' string!";
        char[] result = new char[dirty.length()];
        int count = 0;
        for (char code : dirty.toCharArray()) {
            if (Character.isIdentifierIgnorable(code) || code == REPLACEMENT_CHARACTER || !Character.isDefined(code)) continue;
            result[count++] = code;
        }
        return new String(result, 0, count);
    }

    private static void printRecordHeader(PrintWriter out, Record record) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (record != null) : "Argument 'record' must not be null.";
        out.format(OUTPUT_LOCALE, "# --- sequence number : %6s --------------------%n", record.getSequenceString());
        out.format(OUTPUT_LOCALE, "#            station: %s%n", record.getStationId());
        out.format(OUTPUT_LOCALE, "#            network: %s%n", record.getNetworkId());
        out.format(OUTPUT_LOCALE, "#            channel: %s%n", record.getChannelId());
        out.format(OUTPUT_LOCALE, "#           location: %s%n", record.getLocationId());
        out.format(OUTPUT_LOCALE, "#        record size: %d bytes%n", record.size());
        out.format(OUTPUT_LOCALE, "#         byte order: %s%n", record.getByteOrderString());
        out.format(OUTPUT_LOCALE, "#    sample encoding: %s%n", new Object[]{record.getCodec()});
        out.format(OUTPUT_LOCALE, "#      activity flag: %s%n", record.getActivityInfo());
        out.format(OUTPUT_LOCALE, "# i/o and clock flag: %s%n", record.getIoAndClockInfo());
        out.format(OUTPUT_LOCALE, "#  data quality flag: %s%n", record.getDataQualityInfo());
        out.format(OUTPUT_LOCALE, "#     timing quality: %s%n", record.getTimingQualityInfo());
        if (record.getCodec() == EncodingFormat.ASCII) {
            out.format(OUTPUT_LOCALE, "#       approx. time: %s%n", record.getStartTime().toLogString());
        } else {
            out.format(OUTPUT_LOCALE, "#       first sample: %s%n", record.getStartTime().toDateTimeString());
            out.format(OUTPUT_LOCALE, "#        last sample: %s%n", record.getStopTime().toDateTimeString());
            out.format(OUTPUT_LOCALE, "#  number of samples: %d%n", record.getSampleCount());
            out.format(OUTPUT_LOCALE, "#      sampling rate: %s samples per second%n", StringUtils.roundedNumber(record.getSampleRate(), 0, 9));
            out.format(OUTPUT_LOCALE, "#    sampling period: %s seconds per sample%n", StringUtils.roundedNumber(record.getSamplePeriod(), 0, 9));
        }
    }

    private static void printDataGmt(PrintWriter out, Record record) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (record != null) : "Argument 'record' must not be null.";
        assert (record.getCodec() != EncodingFormat.ASCII) : "Argument 'record' must not contain ASCII (meta-)data.";
        double[] samples = record.getSampleData();
        out.format(OUTPUT_LOCALE, ">   miniSEED Record #%6s (%5s, %3s)%n", record.getSequenceString(), record.getStationId(), record.getChannelId());
        block4: for (int i = 0; i < samples.length; ++i) {
            TimeMoment time = record.getTimeAt(i);
            switch (record.getCodec()) {
                case IEEE_FLOAT: {
                    out.format(OUTPUT_LOCALE, "%s  %.7g%n", time.toIsoString(), samples[i]);
                    continue block4;
                }
                case IEEE_DOUBLE: {
                    out.format(OUTPUT_LOCALE, "%s  %.15g%n", time.toIsoString(), samples[i]);
                    continue block4;
                }
                default: {
                    out.format(OUTPUT_LOCALE, "%s  %s%n", time.toIsoString(), StringUtils.roundedNumber(samples[i], 0, 15));
                }
            }
        }
    }

    public static void main(String[] args) {
        MseedToAscii mseed2ascii = new MseedToAscii(args);
        try {
            mseed2ascii.handleCommonOptions();
            mseed2ascii.handleGippToolOptions();
            mseed2ascii.handleInputOptions();
            mseed2ascii.handleSelectionOptions();
            mseed2ascii.handleOutputOptions();
            mseed2ascii.handleConversionOptions();
            mseed2ascii.run();
        }
        catch (CmdLineException e) {
            mseed2ascii.logThrowable(e);
            System.exit(64);
        }
        catch (IntegrityException e) {
            mseed2ascii.logThrowable(e);
            System.exit(65);
        }
        catch (OutOfMemoryError e) {
            mseed2ascii.log.severe("Ran out of memory! Please reduce the amount of miniSEED input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            mseed2ascii.logThrowable(e);
            System.exit(99);
        }
    }

    private void printDataColumns(PrintWriter out, Record record) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (record != null) : "Argument 'record' must not be null.";
        if (record.getCodec() == EncodingFormat.ASCII) {
            String dirty = new String(record.getRawData(), StandardCharsets.UTF_8);
            if (dirty.contains(String.valueOf(REPLACEMENT_CHARACTER))) {
                this.log.warning("ASCII encoded data in 'record #" + record.getSequenceString() + ": " + record.getStationId() + ", " + record.getChannelId() + ", " + record.getStartTime().toLogString() + "' contains non-ASCII characters!");
            }
            out.print(MseedToAscii.sanitizeText(dirty));
        } else {
            double[] samples = record.getSampleData();
            block4: for (int i = 0; i < samples.length; ++i) {
                TimeMoment time = record.getTimeAt(i);
                switch (record.getCodec()) {
                    case IEEE_FLOAT: {
                        out.format(OUTPUT_LOCALE, "%s  %s  %.7g%n", time.toDateString(), time.toTimeString(), samples[i]);
                        continue block4;
                    }
                    case IEEE_DOUBLE: {
                        out.format(OUTPUT_LOCALE, "%s  %s  %.15g%n", time.toDateString(), time.toTimeString(), samples[i]);
                        continue block4;
                    }
                    default: {
                        out.format(OUTPUT_LOCALE, "%s  %s  %s%n", time.toDateString(), time.toTimeString(), StringUtils.roundedNumber(samples[i], 0, 15));
                    }
                }
            }
        }
    }

    private File asciiFilename(Record record) {
        assert (record != null) : "Argument 'record' must not be null.";
        String temp = record.getStationId();
        String stationId = temp == null || temp.isEmpty() ? "xyz" : temp.toLowerCase();
        temp = record.getChannelId();
        String channelId = temp == null || temp.isEmpty() ? "xyz" : (temp.matches("^p\\d$") ? "pri" + temp.charAt(1) : (temp.matches("^s\\d$") ? "sec" + temp.charAt(1) : temp.toLowerCase()));
        TimeMoment startTime = record.getStartTime();
        String basename = stationId + startTime.toMinimalString() + "." + channelId;
        return this.getOutputFile(this.outputDir, basename, "txt", this.forceOverwrite);
    }

    private void handleInputOptions() {
        if (this.cmdLineParser.getArgumentList().isEmpty() && this.inputFilterOption.isMatched()) {
            throw new CmdLineException("Cannot apply the '--include-pattern' option when reading from standard input! Please give at least one miniSEED file or directory as argument to read from or drop the '--include-pattern' option altogether.");
        }
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addMseedFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP miniSEED filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    void handleSelectionOptions() {
        if (this.selectStationOption.isMatched()) {
            for (String pattern : this.selectStationOption.getValues()) {
                if (pattern.isEmpty()) {
                    this.log.warning("The \"--select-station\" option is missing the STATION expression.");
                }
                if (pattern.length() > Record.FixedHeader.STATION_ID.length()) {
                    this.log.warning("The STATION given in the \"--select-station\" option is longer than the permitted station id length (up to " + Record.FixedHeader.STATION_ID.length() + " characters). Most likely, there will be no matching station in the miniSEED input!");
                }
                this.selectedStations.add(Pattern.compile(RegexUtils.convertWildcards(pattern)));
                this.log.info("Processing stations that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.selectedStations.clear();
            this.log.fine("No stations selection is applied.");
        }
        if (this.selectChannelOption.isMatched()) {
            for (String pattern : this.selectChannelOption.getValues()) {
                if (pattern.isEmpty()) {
                    this.log.warning("The \"--select-channel\" option is missing a CHANNEL expression.");
                }
                if (pattern.length() > Record.FixedHeader.CHANNEL_ID.length()) {
                    this.log.warning("The CHANNEL given in the \"--select-channel\" option is longer than the permitted channel id length (up to " + Record.FixedHeader.CHANNEL_ID.length() + " characters). Most likely, there will be no matching channel in the miniSEED input!");
                }
                this.selectedChannels.add(Pattern.compile(RegexUtils.convertWildcards(pattern)));
                this.log.info("Processing channels that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.selectedChannels.clear();
            this.log.fine("No channel selection is applied.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        if (!this.outputDirOption.isMatched()) {
            if (this.forceOverwriteOption.isMatched()) {
                throw new CmdLineException("The '--force-overwrite' option is only allowed in conjunction with the '--output-dir=DIR' option.");
            }
            if (this.forceConcatenateOption.isMatched()) {
                throw new CmdLineException("The '--force-concat' option is only allowed in conjunction with the '--output-dir=DIR' option.");
            }
        }
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing ASCII files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing ASCII files will NOT be overwritten.");
        }
        if (this.forceConcatenateOption.isMatched()) {
            this.forceConcatenate = true;
            this.log.info("Concatenate the ASCII output in as few files as possible.");
        } else {
            this.forceConcatenate = false;
            this.log.fine("Create a new ASCII output file for every miniSEED input file.");
        }
        if (!this.outputDirOption.isMatched()) {
            this.outputDir = null;
            this.log.fine("All results will be written to \"standard output\" (console).");
            return;
        }
        this.outputDir = new File(this.outputDirOption.getValue());
        if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
            this.log.info("All ASCII text files will be written to the '" + this.outputDir.getPath() + "' directory.");
            return;
        }
        this.outputDir = null;
        throw new CmdLineException("Cannot write ASCII files to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
    }

    private void handleConversionOptions() {
        if (this.outputFormatOption.isMatched()) {
            String format = this.outputFormatOption.getValue().toUpperCase();
            if (format.startsWith("HEA")) {
                this.outputFormat = OutputFormat.HEADER;
            } else if (format.startsWith("DAT")) {
                this.outputFormat = OutputFormat.DATA;
            } else if (format.startsWith("ALL")) {
                this.outputFormat = OutputFormat.ALL;
            } else if (format.startsWith("GMT")) {
                this.outputFormat = OutputFormat.GMT;
            } else {
                this.log.severe("Unknown output format '" + format + "'. Please use one of " + Arrays.toString((Object[])OutputFormat.values()) + " instead.");
                System.exit(64);
            }
            this.log.info("Switching to '" + (Object)((Object)this.outputFormat) + "' output format.");
        } else {
            this.log.fine("Using the default output mode ('" + this.outputFormat.toString() + "').");
        }
    }

    private SortedFileSet handleFileArguments() {
        SortedFileSet inputList = new SortedFileSet(new SortByExtension(), this.inputFilter);
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            this.log.info("Reading miniSEED data from \"standard input\".");
            inputList.add(SortedFileSet.STANDARD_INPUT_TOKEN);
        } else {
            this.log.info("Building list of input files..");
            for (String name : this.cmdLineParser.getArgumentList()) {
                File file = new File(name);
                if (file.exists()) {
                    inputList.add(file);
                    continue;
                }
                this.log.warning("File or directory '" + name + "' given at the command line does not exist! Maybe a typing error?");
            }
        }
        if (inputList.isEmpty()) {
            this.log.severe("No suitable input files found.");
        } else {
            this.log.info("Found " + inputList.size() + " file(s) to process.");
        }
        return inputList;
    }

    /*
     * Exception decompiling
     */
    protected void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum OutputFormat {
        ALL,
        HEADER,
        DATA,
        GMT;

    }
}

