/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortByExtension;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.Stopwatch;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MseedRename
extends GippToolsApplication {
    private static final char KEYWORD_FLAG = '%';
    private static final Pattern GIPP_FILENAME_PATTERN = Pattern.compile("\\b([eErRcCnN]\\d{4})(\\d{2})(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])([01][0-9]|2[0-3])([0-5][0-9])([0-5][0-9]|60)\\b");
    private final CmdLineString transferModeOption = new CmdLineString("transfer-mode", "Select the file transfer mode. Pick one of the following:\n  COPY .. Copy files, not touching the source\n  MOVE .. Move files, deleting transferred source files.\nThe default is to COPY files. It is recommended to use the MOVE mode only if you are very sure that there will be no problems (e.g. by testing the parameters using the \"--dry-run\" option first).", new String[]{"COPY", "MOVE"});
    private final CmdLineBoolean dryRunOption = new CmdLineBoolean("dry-run", "Perform a trial run with no changes and modifications made to the file system whatsoever.\nHint: This command line option is used best in conjunction with the '--verbose' option, so you can see what will happen.");
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newMiniseedInputFilterOption();
    CmdLineString filenameTemplateOption = new CmdLineString("template", "The given VALUE controls the automatic generation of the new filename. Here, every character of VALUE is used for the new filename with the exception of the following variables. They are interpreted and replaced with their corresponding value (taken from the currently processed input file).\n\n  %% .. a single literal '%' character\n  %f .. filename (without directory but including suffix)\n  %b .. basename (filename without suffix)\n  %e .. extension (suffix of the filename without the dot)\n  %Y .. year (including century, i.e. 4 digits)\n  %y .. year (without century, i.e. 2 digits)\n  %m .. month (2 digits)\n  %d .. day (of month, 2 digits)\n  %j .. day of year (3 digits)\n  %H .. hour (2 digits)\n  %M .. minute (2 digits)\n  %s .. second (2 digits)\n  %T .. time (equivalent to \"%H:%M:%S\")\n  %F .. date (equivalent to \"%Y-%m-%d\")\n  %G .. GEOFON (equivalent to \"%Y/%S/%j/%f\")\n  %S .. miniSEED station id (up to 5 characters)\n  %L .. miniSEED location id (up to 2 characters)\n  %C .. miniSEED recording channel (up to 3 characters)\n  %N .. miniSEED network id (up to 2 characters)\n  %r .. miniSEED sample rate (rounded)\n\nPlease note that usage of '" + File.separator + "' characters is explicitly allowed in the filename template indicating additional subdirectory levels. The respective directories will automatically be created as needed.\n\nIf no filename template is given at the command line \"%f\" is used as default. (This will collapse any complex directory tree used as input into a single flat output directory.)\n\nWarning! You will run into trouble when you try to rename a non-miniSEED file using e.g. a miniSEED recording channel id (\"%C\"). Since a non-miniSEED source file cannot provide the recording channel information required to replace the \"%C\" keyword in the template string the operation must fail!");
    private FileTransferMode transferMode;
    private boolean dryRun = false;
    private File outputDir = null;
    private char[] filenameTemplate = "%f".toCharArray();
    private boolean forceOverwrite;
    private RegexFilenameFilter inputFilter = null;

    public MseedRename(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.transferMode = FileTransferMode.COPY;
        this.cmdLineParser.registerOption(this.dryRunOption);
        this.cmdLineParser.registerOption(this.filenameTemplateOption);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.registerOption(this.transferModeOption);
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.setProgramName("mseedrename");
        this.cmdLineParser.setProgramDescription("systematically rename miniSEED files using a template");
        this.cmdLineParser.setProgramArguments("miniSEED-FILE|DIRECTORY...");
    }

    public static void main(String[] args) {
        MseedRename mseedrename = new MseedRename(args);
        try {
            mseedrename.handleCommonOptions();
            mseedrename.handleGippToolOptions();
            mseedrename.handleInputOptions();
            mseedrename.handleOutputOptions();
            mseedrename.run();
        }
        catch (CmdLineException e) {
            mseedrename.logThrowable(e);
            System.exit(64);
        }
        catch (IntegrityException e) {
            mseedrename.logThrowable(e);
            System.exit(65);
        }
        catch (OutOfMemoryError e) {
            mseedrename.log.severe("Ran out of memory! Please reduce the amount of miniSEED input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            mseedrename.logThrowable(e);
            System.exit(99);
        }
    }

    private String stationFromGippFile(File file) {
        String text = FileUtils.getBasename(file);
        if (text == null) {
            return null;
        }
        Matcher m = GIPP_FILENAME_PATTERN.matcher(text);
        if (!m.find()) {
            return null;
        }
        return m.group(1);
    }

    private TimeMoment timeFromGippFile(File file) {
        String text = FileUtils.getBasename(file);
        if (text == null) {
            return null;
        }
        Matcher m = GIPP_FILENAME_PATTERN.matcher(text);
        if (!m.find()) {
            return null;
        }
        try {
            int year = Integer.parseInt(m.group(2));
            int month = Integer.parseInt(m.group(3));
            int day = Integer.parseInt(m.group(4));
            int hour = Integer.parseInt(m.group(5));
            int minute = Integer.parseInt(m.group(6));
            int second = Integer.parseInt(m.group(7));
            year = year < 70 ? (year += 2000) : (year += 1900);
            return new TimeMoment.Builder().date(year, month, day).time(hour, minute, second).build();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void handleInputOptions() {
        if (this.cmdLineParser.getArgumentList().isEmpty() && this.inputFilterOption.isMatched()) {
            throw new CmdLineException("Cannot apply the '--include-pattern' option when reading from standard input! Please give at least one file or directory as argument to read from or drop the '--include-pattern' option altogether.");
        }
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addMseedFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP miniSEED filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        block16: {
            block17: {
                block15: {
                    if (!this.outputDirOption.isMatched() && this.forceOverwriteOption.isMatched()) {
                        throw new CmdLineException("The '--force-overwrite' option is only allowed in conjunction with the '--output-dir=DIR' option.");
                    }
                    if (this.dryRunOption.isMatched()) {
                        this.dryRun = true;
                        this.log.info("Running in \"trial mode\". No changes or modifications will be made to the file system whatsoever!");
                    }
                    if (this.forceOverwriteOption.isMatched()) {
                        this.forceOverwrite = true;
                        this.log.info("Already existing files will be overwritten!");
                    } else {
                        this.forceOverwrite = false;
                        this.log.fine("Already existing files will NOT be overwritten.");
                    }
                    if (this.outputDirOption.isMatched()) {
                        this.outputDir = new File(this.outputDirOption.getValue());
                        if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
                            this.log.info("All files will be created relative to the '" + this.outputDir.getPath() + "' directory.");
                            break block15;
                        } else {
                            this.outputDir = null;
                            throw new CmdLineException("Cannot write files to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
                        }
                    }
                    this.outputDir = null;
                    this.log.fine("All files will be created relative to the current working directory.");
                }
                if (!this.transferModeOption.isMatched()) break block17;
                String mode = this.transferModeOption.getValue();
                if (mode.equalsIgnoreCase("MOVE")) {
                    this.transferMode = FileTransferMode.MOVE;
                    break block16;
                } else if (mode.equalsIgnoreCase("COPY")) {
                    this.transferMode = FileTransferMode.COPY;
                    break block16;
                } else {
                    this.log.severe("Unknown file transfer mode '" + mode + "'. Please use one of \"COPY\" or \"MOVE\" instead.");
                    System.exit(64);
                }
                break block16;
            }
            this.log.fine("No file transfer mode was given. Using the default " + this.transferMode.name() + " mode.");
        }
        if (!this.filenameTemplateOption.isMatched()) {
            this.log.fine("No filename template was given. Using the default '" + String.valueOf(this.filenameTemplate) + "' as template.");
            return;
        }
        char[] cArray = this.filenameTemplate = this.filenameTemplateOption.getValue().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.log.info("Using '" + String.valueOf(this.filenameTemplate) + "' as filename template.");
                return;
            }
            char c = cArray[n2];
            if (Character.isISOControl(c)) {
                this.log.severe("Invalid character in the filename template. The character '" + c + "' (Unicode U+" + StringUtils.toHexString((short)c) + ") is not allowed!");
                System.exit(64);
            }
            ++n2;
        }
    }

    private String targetFilename(File file, TimeMoment time, String station, String channel, String location, String network, Double rate) {
        StringBuilder target = new StringBuilder();
        int i = 0;
        while (i < this.filenameTemplate.length) {
            char letter;
            if ((letter = this.filenameTemplate[i++]) == '%') {
                char key = this.filenameTemplate[i++];
                switch (key) {
                    case '%': {
                        target.append('%');
                        break;
                    }
                    case 'f': {
                        if (file == null) {
                            return null;
                        }
                        target.append(file.getName());
                        break;
                    }
                    case 'b': {
                        if (file == null) {
                            return null;
                        }
                        target.append(FileUtils.getBasename(file));
                        break;
                    }
                    case 'e': {
                        if (file == null) {
                            return null;
                        }
                        target.append(FileUtils.getSuffix(file));
                        break;
                    }
                    case 'Y': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.FOUR_DIGITS.format(time.getYear()));
                        break;
                    }
                    case 'y': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.TWO_DIGITS.format(time.getYear() % 100));
                        break;
                    }
                    case 'm': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.TWO_DIGITS.format(time.getMonth()));
                        break;
                    }
                    case 'd': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.TWO_DIGITS.format(time.getDay()));
                        break;
                    }
                    case 'j': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.THREE_DIGITS.format(time.getDayOfYear()));
                        break;
                    }
                    case 'H': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.TWO_DIGITS.format(time.getHour()));
                        break;
                    }
                    case 'M': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.TWO_DIGITS.format(time.getMinute()));
                        break;
                    }
                    case 's': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.TWO_DIGITS.format(time.getSecond()));
                        break;
                    }
                    case 'T': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.TWO_DIGITS.format(time.getHour())).append(":").append(StringUtils.TWO_DIGITS.format(time.getMinute())).append(":").append(StringUtils.TWO_DIGITS.format(time.getSecond()));
                        break;
                    }
                    case 'F': {
                        if (time == null) {
                            return null;
                        }
                        target.append(StringUtils.FOUR_DIGITS.format(time.getYear())).append("-").append(StringUtils.TWO_DIGITS.format(time.getMonth())).append("-").append(StringUtils.TWO_DIGITS.format(time.getDay()));
                        break;
                    }
                    case 'G': {
                        if (time == null || station == null) {
                            return null;
                        }
                        target.append(StringUtils.FOUR_DIGITS.format(time.getYear())).append(File.separator).append(station).append(File.separator).append(StringUtils.THREE_DIGITS.format(time.getDayOfYear())).append(File.separator).append(file.getName());
                        break;
                    }
                    case 'S': {
                        if (station == null) {
                            return null;
                        }
                        target.append(station);
                        break;
                    }
                    case 'L': {
                        if (location == null) {
                            return null;
                        }
                        target.append(location);
                        break;
                    }
                    case 'C': {
                        if (channel == null) {
                            return null;
                        }
                        target.append(channel);
                        break;
                    }
                    case 'N': {
                        if (network == null) {
                            return null;
                        }
                        target.append(network);
                        break;
                    }
                    case 'r': {
                        if (rate == null) {
                            return null;
                        }
                        target.append(Math.round(rate));
                        break;
                    }
                    default: {
                        throw new CmdLineException("Cannot correctly parse filename specifier string '" + String.valueOf(this.filenameTemplate) + "'! The key '" + '%' + key + "' is not supported.");
                    }
                }
                continue;
            }
            target.append(letter);
        }
        return target.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transferFile(File source) {
        try {
            Double rate;
            TimeMoment start;
            String network;
            String location;
            String channel;
            String station;
            this.log.fine("Begin processing file: '" + source.getAbsolutePath() + "'");
            if (!source.isFile()) {
                this.log.warning("Will not work with '" + source.getAbsolutePath() + "' because it is not a plain file!");
                return false;
            }
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(source);
                Record record = new Record();
                record.read(inStream);
                station = record.getStationId();
                channel = record.getChannelId();
                location = record.getLocationId();
                network = record.getNetworkId();
                start = record.getStartTime();
                rate = record.getSampleRate();
                this.log.fine("Will generated target name based on miniSEED header info.");
            }
            catch (Exception ignored) {
                try {
                    station = this.stationFromGippFile(source);
                    channel = null;
                    location = null;
                    network = null;
                    start = this.timeFromGippFile(source);
                    rate = null;
                    this.log.fine("Will generated target name based on source filename info.");
                }
                catch (Throwable throwable) {
                    FileUtils.flushClose(inStream);
                    throw throwable;
                }
                FileUtils.flushClose(inStream);
            }
            FileUtils.flushClose(inStream);
            String newName = this.targetFilename(source, start, station, channel, location, network, rate);
            if (newName == null) {
                this.log.warning("Could not generate a target filename for '" + source.getAbsolutePath() + "'! Skipping file.");
                return false;
            }
            this.log.fine("Template generated filename: '" + newName + "'");
            while (newName.charAt(0) == File.separatorChar) {
                newName = newName.substring(1);
            }
            File target = this.outputDir != null ? new File(this.outputDir, newName) : new File(System.getProperty("user.dir"), newName);
            this.log.fine("      Final target filename: '" + target.getAbsolutePath() + "'");
            if (target.exists()) {
                if (this.forceOverwrite) {
                    this.log.warning("File '" + source.getPath() + "' will overwrite file '" + target.getPath() + "'!");
                } else {
                    File unique = target.getAbsoluteFile();
                    int count = 0;
                    while (unique.exists()) {
                        unique = new File(target.getParent(), FileUtils.getBasename(target) + "." + ++count + "." + FileUtils.getSuffix(target));
                    }
                    target = unique;
                    this.log.warning("File already exists! Writing '" + source.getPath() + "' to '" + target.getPath() + "' instead.");
                }
            }
            this.log.fine("Create target directory '" + target.getParent() + "' (if necessary)..");
            if (!this.dryRun) {
                FileUtils.makeDirectory(target.getParentFile());
            }
            switch (this.transferMode) {
                case COPY: {
                    this.log.info("Copy '" + source.getPath() + "' to '" + target.getPath() + "'.");
                    if (!this.dryRun) {
                        FileUtils.copyFile(source, target, this.forceOverwrite, true);
                    }
                    return true;
                }
                case MOVE: {
                    this.log.info("Moving '" + source.getPath() + "' to '" + target.getPath() + "'.");
                    if (!this.dryRun) {
                        FileUtils.moveFile(source, target, this.forceOverwrite, true);
                    }
                    return true;
                }
            }
            this.log.severe("File transfer mode '" + this.transferMode.name() + "' is not implemented yet. ");
            System.exit(69);
        }
        catch (IOException e) {
            this.log.warning("File i/o error! " + e.getMessage());
            return false;
        }
        return false;
    }

    protected void run() {
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            this.log.severe("No file or directory was given at the command line. Please enter something that possibly can be renamed!");
            System.exit(66);
        }
        Stopwatch totalRunTime = new Stopwatch();
        SortedFileSet inputList = new SortedFileSet(new SortByExtension(), this.inputFilter);
        this.log.info("Building list of input files..");
        for (String name : this.cmdLineParser.getArgumentList()) {
            File file = new File(name);
            if (file.exists()) {
                inputList.add(file);
                continue;
            }
            this.log.warning("File or directory '" + name + "' given at the command line does not exist! Maybe a typing error?");
        }
        if (inputList.isEmpty()) {
            this.log.severe("No suitable input files found!");
            System.exit(66);
        } else {
            this.log.info("Found " + inputList.size() + " file(s) to process.");
        }
        long successCount = 0L;
        long failedCount = 0L;
        for (File file : inputList) {
            if (this.transferFile(file)) {
                ++successCount;
                continue;
            }
            ++failedCount;
        }
        if (failedCount > 0L) {
            this.log.warning(failedCount + " file(s) could not be processed! (Of " + inputList.size() + " total.)");
        } else {
            this.log.info(successCount + " files were successfully processed.");
        }
        this.log.info("Finished in " + totalRunTime);
    }

    private static enum FileTransferMode {
        COPY,
        MOVE;

    }
}

