/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.array.ByteArray;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.crypto.GippSecurityProvider;
import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.SortByExtension;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.miniseed.EncodingFormat;
import de.gfz_potsdam.gipp.common.seis.miniseed.MiniseedException;
import de.gfz_potsdam.gipp.common.seis.miniseed.MiniseedTraceWriter;
import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.Stopwatch;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MseedRecover
extends GippToolsApplication {
    private static final List<String> PREFERRED_FINGERPRINTS = new ArrayList<String>();
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private final CmdLineBoolean forceConcatenateOption = new CmdLineBoolean("force-concat", "Concatenate the miniSEED output creating as few new files as possible. This means that a new output file is only started when there is a (data) discontinuity in the miniSEED input. Without discontinuity the recovered data is simply appended to the miniSEED file.\nBy default however, a new miniSEED output file is created for every single input file.");
    private final CmdLineBoolean forceSortOption = new CmdLineBoolean("force-sort", "Sort the recovered miniSEED fragments. If this flag is set, an additional (sub-)directory level (consisting of the 'year' and 'day-of-year' of the fragment) will be created inside the output directory. All \"recovered\" miniSEED data is placed in the respective subdirectory");
    private final CmdLineBoolean dryRunOption = new CmdLineBoolean("dry-run", "Perform a trial run with no changes and modifications made to the file system whatsoever (and, of course, no miniSEED output).\nHint: This command line option is used best in conjunction with the '--verbose' option, so you can see what would happen if it were not a trial run.");
    private final CmdLineString startOffsetOption = new CmdLineString("start-offset", "Before any data is analyzed, this many bytes are skipped and ignored from the input. Use this option to \"fast forward\" through the input to a position where you suspect recoverable miniSEED data.");
    private final CmdLineString stopOffsetOption = new CmdLineString("stop-offset", "The search for intact miniSEED data will be aborted after the stop offset was passed. The offset is given in bytes and is calculated from the beginning of the input (and NOT relative to the start offset parameter).\n Note: This offset is not used as an absolute, hard stop criteria! If the limit is reached while currently extracting valid miniSEED data from the stream, the program will rather finish extracting the current (intact) data than to stop abruptly in the middle of some miniSEED record.");
    private final CmdLineString searchIntervalOption = new CmdLineString("search-interval", "Search interval in bytes. When searching for miniSEED data in the input, the program will look every VALUE bytes if a valid miniSEED record starts at that offset.\nAlthough in principal, any interval is possible, it probably does not make sense to use anything other than a power of two (i.e. 1, 2, 4, 8, 16, etc.).\nNote: The default value of 512 bytes seems to work fine in about any situation. So usually you don't need to use this option at all.");
    private final CmdLineBoolean disableDedupeOption = new CmdLineBoolean("no-dedupe", "Disable the detection of duplicate miniSEED records.\nHowever, the default behavior (without this option) is to automatically detect multiples of miniSEED records and to only recover one copy.");
    private File outputDir = null;
    private boolean forceOverwrite = false;
    private boolean forceConcatenate = false;
    private boolean forceSort = false;
    private boolean dryRun = false;
    private long startOffset = 0L;
    private long stopOffset = Long.MAX_VALUE;
    private int searchInterval = 512;
    private boolean dedupeRecords = true;

    public MseedRecover(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.registerOption(this.dryRunOption);
        this.cmdLineParser.registerOption(this.startOffsetOption);
        this.cmdLineParser.registerOption(this.stopOffsetOption);
        this.cmdLineParser.registerOption(this.searchIntervalOption);
        this.cmdLineParser.registerOption(this.disableDedupeOption);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.registerOption(this.forceConcatenateOption);
        this.cmdLineParser.registerOption(this.forceSortOption);
        this.cmdLineParser.setProgramName("mseedrecover");
        this.cmdLineParser.setProgramDescription("recover miniSEED records from damaged files");
        this.cmdLineParser.setProgramArguments("[FILE]...");
    }

    public static void main(String[] args) {
        MseedRecover mseedrecover = new MseedRecover(args);
        try {
            mseedrecover.handleCommonOptions();
            mseedrecover.handleGippToolOptions();
            mseedrecover.handleSearchOptions();
            mseedrecover.handleSelectionOptions();
            mseedrecover.handleOutputOptions();
            mseedrecover.run();
        }
        catch (CmdLineException e) {
            mseedrecover.logThrowable(e);
            System.exit(64);
        }
        catch (IOException e) {
            mseedrecover.logThrowable(e);
            System.exit(74);
        }
        catch (OutOfMemoryError e) {
            mseedrecover.log.severe("Ran out of memory! Please reduce the amount of miniSEED input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            mseedrecover.logThrowable(e);
            System.exit(99);
        }
    }

    private MessageDigest initFingerprintAlgorithm() {
        for (String algorithm : PREFERRED_FINGERPRINTS) {
            try {
                this.log.info("Using '" + algorithm + "' hash algorithm to detect duplicate miniSEED records.");
                return MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException exp) {
                this.log.info("'" + algorithm + "' algorithm is not available!");
            }
        }
        return null;
    }

    private File getTargetDir(Record record) {
        File targetDir;
        assert (record != null) : "MiniSEED 'record' argument must not be 'null'!";
        TimeMoment startTime = record.getStartTime();
        if (this.forceSort) {
            targetDir = new File(this.outputDir, StringUtils.FOUR_DIGITS.format(startTime.getYear()) + "-" + StringUtils.THREE_DIGITS.format(startTime.getDayOfYear()));
            if (targetDir.exists()) {
                this.log.fine("Writing to already existing output directory '" + targetDir.getPath() + "'.");
            } else if (targetDir.mkdir()) {
                this.log.info("Created new output directory '" + targetDir.getPath() + "'.");
            } else {
                this.log.warning("Could not create output directory '" + targetDir.getAbsolutePath() + "'. Will use '" + this.outputDir + "' directory instead.");
                targetDir = this.outputDir;
            }
        } else {
            targetDir = this.outputDir;
        }
        return targetDir;
    }

    private void handleSearchOptions() {
        if (this.searchIntervalOption.isMatched()) {
            try {
                this.searchInterval = Integer.parseInt(this.searchIntervalOption.getValue());
            }
            catch (NumberFormatException e) {
                throw new CmdLineException("The string '" + this.searchIntervalOption.getValue() + "' is not a valid number. Please use a positive integer value as argument for the '" + this.searchIntervalOption.getLongSyntax() + "' command line option.");
            }
            if (this.searchInterval <= 0) {
                throw new CmdLineException("The search interval '" + this.searchInterval + "' is zero or even a negative number. Please use a positive (!) integer value as argument for the '" + this.searchIntervalOption.getLongSyntax() + "' command line option.");
            }
            if ((this.searchInterval & this.searchInterval - 1) != 0) {
                this.log.warning("The selected search interval is not a power of two! Usually, it does not make sense to use a value of '" + this.searchInterval + "'. However, your wish is my command...");
            }
            if (this.searchInterval > 4096) {
                this.log.warning("The selected search interval is most likely to large! EDL miniSEED records are typically 4096 bytes long and by using a larger search interval ('" + this.searchInterval + "') you risk jumping over complete EDL miniSEED records in the input. You have been warned...");
            }
            this.log.info("Using a search interval of " + this.searchInterval + " bytes.");
        } else {
            this.log.fine("Using the default search interval of " + this.searchInterval + " bytes.");
        }
        if (this.startOffsetOption.isMatched()) {
            try {
                this.startOffset = Integer.parseInt(this.startOffsetOption.getValue());
            }
            catch (NumberFormatException e) {
                throw new CmdLineException("The string '" + this.startOffsetOption.getValue() + "' is not a valid number. Please use a positive integer value as argument for the '" + this.startOffsetOption.getLongSyntax() + "' command line option.");
            }
            if (this.startOffset <= 0L) {
                throw new CmdLineException("The start offset '" + this.startOffset + "' is  a negative number. Please use a positive (!) integer value as argument for the '" + this.startOffsetOption.getLongSyntax() + "' command line option.");
            }
            if (this.startOffset % (long)this.searchInterval != 0L) {
                this.log.warning("The start offset ('" + this.startOffset + "') is not a multiple of the search interval ('" + this.searchInterval + "'). Although this is a valid combination, it is a rather unusual one! Maybe a spelling mistake? Anyway, I will do as you wish.");
            }
            this.log.info("Using a start offset of " + this.startOffset + " bytes.");
        } else {
            this.log.fine("Using the default start offset of " + this.startOffset + " bytes.");
        }
        if (this.stopOffsetOption.isMatched()) {
            try {
                this.stopOffset = Integer.parseInt(this.stopOffsetOption.getValue());
            }
            catch (NumberFormatException e) {
                throw new CmdLineException("The string '" + this.stopOffsetOption.getValue() + "' is not a valid number. Please use a positive integer value as argument for the '" + this.stopOffsetOption.getLongSyntax() + "' command line option.");
            }
            if (this.stopOffset < 0L) {
                throw new CmdLineException("The stop offset '" + this.stopOffset + "' is a negative number. Please use a positive (!) integer value as argument for the '" + this.stopOffsetOption.getLongSyntax() + "' command line option.");
            }
            if (this.stopOffset <= this.startOffset) {
                throw new CmdLineException("The stop offset ('" + this.stopOffset + "') must be larger than the start offset ('" + this.startOffset + "'). Everything else does not make sense!");
            }
            this.log.info("Using a stop offset of " + this.stopOffset + " bytes.");
        } else {
            this.log.fine("Using the default stop offset of " + this.stopOffset + " bytes.");
        }
    }

    private void handleSelectionOptions() {
        if (this.disableDedupeOption.isMatched()) {
            this.dedupeRecords = false;
            this.log.info("Disabling detection of duplicate miniSEED records!");
        } else {
            this.log.fine("Using the default dedupe setting of '" + this.dedupeRecords + "'.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        block13: {
            if (!this.outputDirOption.isMatched()) {
                if (this.forceOverwriteOption.isMatched()) {
                    throw new CmdLineException("The '--force-overwrite' option is only allowed in conjunction with the '--output-dir=DIR' option.");
                }
                if (this.forceConcatenateOption.isMatched()) {
                    throw new CmdLineException("The '--force-concat' option is only allowed in conjunction with the '--output-dir=DIR' option.");
                }
                if (this.forceSortOption.isMatched()) {
                    throw new CmdLineException("The '--force-sort' option is only allowed in conjunction with the '--output-dir=DIR' option.");
                }
            }
            if (this.dryRunOption.isMatched()) {
                this.dryRun = true;
                this.log.info("Running in \"trial mode\". No changes or modifications will be made to the file system whatsoever!");
            }
            if (this.outputDirOption.isMatched()) {
                this.outputDir = new File(this.outputDirOption.getValue());
                if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
                    this.log.info("All recoverable miniSEED data will be written to the '" + this.outputDir.getPath() + "' directory.");
                    break block13;
                } else {
                    this.outputDir = null;
                    throw new CmdLineException("Cannot write miniSEED files to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
                }
            }
            this.outputDir = null;
            this.log.fine("All results will be written to \"standard output\" (console).");
        }
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing miniSEED files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing miniSEED files will NOT be overwritten.");
        }
        if (this.forceConcatenateOption.isMatched()) {
            this.forceConcatenate = true;
            this.log.info("Concatenate the miniSEED output in as few files as possible.");
        } else {
            this.forceConcatenate = false;
            this.log.fine("Create a new miniSEED output file for every input file.");
        }
        if (this.forceSortOption.isMatched()) {
            this.forceSort = true;
            this.log.info("In addition, the recovered miniSEED data will be sorted into \"year\"-\"day-of-year\" subdirectories.");
            return;
        }
        this.forceSort = false;
        this.log.fine("The recovered miniSEED data will not be sorted.");
    }

    private SortedFileSet handleFileArguments() {
        SortedFileSet inputList = new SortedFileSet(new SortByExtension());
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            this.log.info("Searching for miniSEED data in \"standard input\".");
            inputList.add(SortedFileSet.STANDARD_INPUT_TOKEN);
        } else {
            this.log.info("Building list of input files..");
            for (String name : this.cmdLineParser.getArgumentList()) {
                File file = new File(name);
                if (file.exists()) {
                    inputList.add(file);
                    continue;
                }
                this.log.warning("File or directory '" + name + "' given at the command line does not exist! Maybe a typing error?");
            }
        }
        if (inputList.isEmpty()) {
            this.log.severe("No suitable input files found.");
        } else {
            this.log.info("Found " + inputList.size() + " file(s) to process.");
        }
        return inputList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() throws IOException {
        totalRunTime = new Stopwatch();
        recordCount = 0L;
        fragmentCount = 0L;
        totalData = 0L;
        digestAlgorithm = this.initFingerprintAlgorithm();
        if (digestAlgorithm == null && this.dedupeRecords) {
            this.log.warning("Could not find/load required hash algorithm. Detection of duplicate miniSEED records was disabled.");
            this.dedupeRecords = false;
        }
        inStream = null;
        fileOffset = 0L;
        outWriter = null;
        inputList = this.handleFileArguments();
        for (File inFile : inputList) {
            block30: {
                block31: {
                    digestSet = new HashSet<ByteArray>();
                    if (!inFile.equals(SortedFileSet.STANDARD_INPUT_TOKEN)) break block31;
                    inStream = System.in;
                    ** GOTO lbl29
                }
                if (inFile.canRead()) {
                    this.log.info("Start reading from " + inFile.getPath());
                    break block30;
                }
                this.log.severe("Input file '" + inFile.getAbsolutePath() + "' is not readable!");
                FileUtils.flushClose(inStream);
                continue;
            }
            try {
                inStream = new BufferedInputStream(new FileInputStream(inFile));
lbl29:
                // 2 sources

                if (!MseedRecover.$assertionsDisabled && !inStream.markSupported()) {
                    throw new AssertionError((Object)"Support for method 'mark()' method is required!");
                }
                if (!this.forceConcatenate) {
                    FileUtils.flushClose(outWriter);
                    outWriter = null;
                }
                if (this.startOffset > 0L) {
                    inStream.skip(this.startOffset);
                    fileOffset += this.startOffset;
                }
                this.log.fine("Offset #" + fileOffset + ", begin reading ..");
                block11: while (true) {
                    try {
                        while (true) {
                            inStream.mark(this.searchInterval);
                            record = new Record();
                            count = record.read(inStream);
                            if (count == -1) {
                                this.log.info("Finished reading data! (Reason: End of file)");
                                break block11;
                            }
                            this.log.fine("Found record " + record);
                            if (record.getCodec() != EncodingFormat.ASCII) {
                                if (record.getSampleCount() == 0) {
                                    this.log.warning("Ignoring empty record " + record);
                                    continue;
                                }
                                samples = record.getSampleData();
                                if (samples.length != record.getSampleCount()) {
                                    this.log.warning("Could not read the expected number of samples!");
                                    continue;
                                }
                            }
                            if (this.dedupeRecords) {
                                digest = new ByteArray(record.digest(digestAlgorithm));
                                if (digestSet.contains(digest)) {
                                    this.log.fine("Record was already recovered previously. Skipping this copy.");
                                    continue;
                                }
                                digestSet.add(digest);
                            }
                            fileOffset += (long)count;
                            totalData += (long)count;
                            ++recordCount;
                            if (this.dryRun) continue;
                            if (outWriter == null || !outWriter.append(record)) {
                                ++fragmentCount;
                                FileUtils.flushClose(outWriter);
                                outWriter = MiniseedTraceWriter.newFromMiniseed(record, this.getTargetDir(record), this.forceOverwrite);
                                outWriter.append(record);
                            }
                            this.log.fine("Offset #" + fileOffset + " recovered record '" + record + "'.");
                        }
                    }
                    catch (MiniseedException e) {
                        if (fileOffset > this.stopOffset) {
                            this.log.info("Offset #" + fileOffset + ", finished reading data! Reason: stop offset limit of #" + this.stopOffset + " was reached.");
                            break;
                        }
                        this.log.fine("Offset #" + fileOffset + ", skipping " + this.searchInterval + " bytes.");
                        inStream.reset();
                        inStream.skip(this.searchInterval);
                        fileOffset += (long)this.searchInterval;
                        continue;
                    }
                    catch (EOFException e) {
                        // empty catch block
                    }
                    break;
                }
                this.log.fine("Recovered " + recordCount + " records so far.");
            }
            catch (FileNotFoundException e) {
                if (outWriter != null) {
                    outWriter.flush();
                }
                this.log.severe("File '" + inFile.getPath() + "' has disappeared from the filesystem!");
                FileUtils.flushClose(inStream);
                continue;
            }
            catch (IOException e) {
                if (outWriter != null) {
                    outWriter.flush();
                }
                this.log.severe("Filesystem input/output error while reading from file '" + inFile.getAbsolutePath() + "'! " + e.getMessage());
                {
                    catch (Throwable var20_20) {
                        FileUtils.flushClose(inStream);
                        throw var20_20;
                    }
                }
                FileUtils.flushClose(inStream);
                continue;
            }
            FileUtils.flushClose(inStream);
        }
        FileUtils.flushClose(outWriter);
        if (this.dryRun) {
            this.log.info("Can recover " + recordCount + " miniSEED records (about " + StringUtils.TWO_DECIMAL_PLACES.format((double)totalData / 1024.0 / 1024.0) + " mebibytes).");
        } else {
            this.log.info("Recovered " + fragmentCount + " continuous miniSEED data fragment(s) (total: " + recordCount + " records, " + StringUtils.TWO_DECIMAL_PLACES.format((double)totalData / 1024.0 / 1024.0) + " mebibytes).");
        }
        this.log.info("Finished in " + totalRunTime);
    }

    static {
        Security.addProvider(new GippSecurityProvider());
        PREFERRED_FINGERPRINTS.add("MD5");
        PREFERRED_FINGERPRINTS.add("SHA-1");
        PREFERRED_FINGERPRINTS.add("CRC-64");
    }
}

