/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.crypto.GippSecurityProvider;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortByExtension;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.regex.RegexUtils;
import de.gfz_potsdam.gipp.common.seis.miniseed.EncodingFormat;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import java.io.File;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class MseedInfo
extends GippToolsApplication {
    private static final List<String> PREFERRED_FINGERPRINTS = new ArrayList<String>();
    private static final Locale OUTPUT_LOCALE;
    private static final NumberFormat FLOAT_FORMATTER;
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newMiniseedInputFilterOption();
    private final CmdLineString selectStationOption = GippToolsCommonOptions.newSelectStationOption();
    private final CmdLineString selectChannelOption = GippToolsCommonOptions.newSelectChannelOption();
    private final CmdLineString outputFormatOption = new CmdLineString("format", "Change the output format. Pick one of the following:\n" + (Object)((Object)OutputFormat.FILE) + "....... Detailed summary of each miniSEED file. (Default)\n" + (Object)((Object)OutputFormat.INDEX) + " ..... One-line summary for each single miniSEED record.\n" + (Object)((Object)OutputFormat.QUALITY) + ".... One-line data quality report for each miniSEED record\n" + (Object)((Object)OutputFormat.OVERVIEW) + " .. Quick overview about continuous miniSEED streams.\n" + (Object)((Object)OutputFormat.SUMMARY) + " ... Detailed summary of continuous miniSEED stream.\n" + (Object)((Object)OutputFormat.CHECKSUM) + " .. Checksum of each continuous miniSEED input stream.\n");
    private final List<Pattern> selectedChannels;
    private final List<Pattern> selectedStations;
    private RegexFilenameFilter inputFilter = null;
    private OutputFormat outputFormat = OutputFormat.FILE;

    public MseedInfo(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.selectedStations = new ArrayList<Pattern>();
        this.selectedChannels = new ArrayList<Pattern>();
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.selectStationOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.selectChannelOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.outputFormatOption);
        this.cmdLineParser.setProgramName("mseedinfo");
        this.cmdLineParser.setProgramDescription("summarize the content of a miniSEED files");
        this.cmdLineParser.setProgramArguments("[miniSEED-FILE|DIRECTORY]...");
    }

    private static void printFileBegin(PrintWriter out, File file) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (file != null) : "Argument 'file' must not be null.";
        out.format(OUTPUT_LOCALE, "# ------------------------------------------------------------------------%n", new Object[0]);
        out.format(OUTPUT_LOCALE, "#         file name: %s%n", file.getName());
    }

    private static void printFileEnd(PrintWriter out) {
        assert (out != null) : "Argument 'out' must not be null.";
        out.format(OUTPUT_LOCALE, "# ------------------------------------------------------------------------%n", new Object[0]);
        out.format(OUTPUT_LOCALE, "%n", new Object[0]);
    }

    private static void printRecordSummaryLine(PrintWriter out, Record record) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (record != null) : "Argument 'record' must not be null.";
        if (record.getCodec() != EncodingFormat.ASCII) {
            out.format(OUTPUT_LOCALE, "#%6s: %5s, %3s, %26s to %26s, %.2f Hz, %4d samples%n", record.getSequenceString(), record.getStationId(), record.getChannelId(), record.getStartTime().toDateTimeString(), record.getStopTime().toDateTimeString(), record.getSampleRate(), record.getSampleCount());
        } else {
            out.format(OUTPUT_LOCALE, "#%6s: %5s, %3s, %s%n", record.getSequenceString(), record.getStationId(), record.getChannelId(), record.getStartTime().toLogString());
        }
    }

    private static void printRecordDataQualityLine(PrintWriter out, Record record) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (record != null) : "Argument 'record' must not be null.";
        if (record.getCodec() != EncodingFormat.ASCII) {
            out.format(OUTPUT_LOCALE, "#%6s: %5s, %3s, %26s to %26s, time: %3s, data: %s%n", record.getSequenceString(), record.getStationId(), record.getChannelId(), record.getStartTime().toDateTimeString(), record.getStopTime().toDateTimeString(), record.getTimingQualityInfo(), record.getDataQualityInfo());
        } else {
            out.format(OUTPUT_LOCALE, "#%6s: %5s, %3s, %s%n", record.getSequenceString(), record.getStationId(), record.getChannelId(), record.getStartTime().toLogString());
        }
    }

    private static void printStreamOverviewLine(PrintWriter out, Record first, Record last, long numOfRecords) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (first != null) : "Argument 'first' must not be null.";
        assert (last != null) : "Argument 'last' must not be null.";
        if (first.size() != last.size()) {
            out.format(OUTPUT_LOCALE, "WARNING: Suspicious change of miniSEED record size! First record %d bytes and last record %d bytes!%n", first.size(), last.size());
        }
        if (!first.getByteOrder().equals(last.getByteOrder())) {
            out.format(OUTPUT_LOCALE, "WARNING: Suspicious byte order change! First record uses %s and last record uses %s!%n", first.getByteOrder(), last.getByteOrder());
        }
        if (!first.getCodec().equals((Object)last.getCodec())) {
            out.format(OUTPUT_LOCALE, "WARNING: Suspicious encoding change! First record is in %s encoded and last record in %s!%n", new Object[]{first.getCodec(), last.getCodec()});
        }
        if (first.getCodec() != EncodingFormat.ASCII) {
            TimeSpan length = TimeSpan.diff(last.getStopTime(), first.getStartTime());
            out.format(OUTPUT_LOCALE, "%5s, %3s, %17s to %17s, %.2f Hz, %s%n", first.getStationId(), first.getChannelId(), first.getStartTime().toDoyString(), last.getStopTime().toDoyString(), first.getSampleRate(), length.getApproximateString());
        } else {
            out.format(OUTPUT_LOCALE, "%5s, %3s, %17s, %d records%n", first.getStationId(), first.getChannelId(), first.getStartTime().toDoyString(), numOfRecords);
        }
    }

    private static void printStreamSummaryTable(PrintWriter out, Record first, Record last, long numOfRecords, long numOfSamples) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (first != null) : "Argument 'first' must not be null.";
        assert (last != null) : "Argument 'last' must not be null.";
        if (first.size() != last.size()) {
            out.format(OUTPUT_LOCALE, "WARNING: Suspicious change of miniSEED record size! First record %d bytes and last record %d bytes!%n", first.size(), last.size());
        }
        if (!first.getByteOrder().equals(last.getByteOrder())) {
            out.format(OUTPUT_LOCALE, "WARNING: Suspicious byte order change! First record uses %s and last record uses %s!%n", first.getByteOrder(), last.getByteOrder());
        }
        if (!first.getCodec().equals((Object)last.getCodec())) {
            out.format(OUTPUT_LOCALE, "WARNING: Suspicious encoding change! First record is in %s encoded and last record in %s!%n", new Object[]{first.getCodec(), last.getCodec()});
        }
        out.format(OUTPUT_LOCALE, "# ------------------------------------------------------------------------%n", new Object[0]);
        out.format(OUTPUT_LOCALE, "#           station: %s%n", first.getStationId());
        out.format(OUTPUT_LOCALE, "#           network: %s%n", first.getNetworkId());
        out.format(OUTPUT_LOCALE, "#           channel: %s%n", first.getChannelId());
        out.format(OUTPUT_LOCALE, "#          location: %s%n", first.getLocationId());
        out.format(OUTPUT_LOCALE, "# -------------------------------------------------------------------------%n", new Object[0]);
        out.format(OUTPUT_LOCALE, "#       record size: %d bytes%n", first.size());
        out.format(OUTPUT_LOCALE, "#        byte order: %s%n", first.getByteOrderString());
        out.format(OUTPUT_LOCALE, "#   sample encoding: %s%n", new Object[]{first.getCodec()});
        out.format(OUTPUT_LOCALE, "# ------------------------------------------------------------------------%n", new Object[0]);
        if (first.getCodec() == EncodingFormat.ASCII) {
            out.format(OUTPUT_LOCALE, "#      approx. time: %s%n", first.getStartTime().toLogString());
            out.format(OUTPUT_LOCALE, "# number of records: %d%n", numOfRecords);
        } else {
            out.format(OUTPUT_LOCALE, "#      first sample: %s%n", first.getStartTime().toDateTimeString());
            out.format(OUTPUT_LOCALE, "#       last sample: %s%n", last.getStopTime().toDateTimeString());
            out.format(OUTPUT_LOCALE, "# number of samples: %d     (in %d records)%n", numOfSamples, numOfRecords);
            out.format(OUTPUT_LOCALE, "#     sampling rate: %s samples per second%n", FLOAT_FORMATTER.format(first.getSampleRate()));
            out.format(OUTPUT_LOCALE, "#   sampling period: %s seconds per sample%n", FLOAT_FORMATTER.format(first.getSamplePeriod()));
        }
    }

    private static void printStreamSummaryLine(PrintWriter out, Record first, Record last, long numOfRecords, long numOfSamples) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (first != null) : "Argument 'first' must not be null.";
        assert (last != null) : "Argument 'last' must not be null.";
        if (first.size() != last.size()) {
            out.format(OUTPUT_LOCALE, "WARNING: Suspicious change of miniSEED record size! First record %d bytes and last record %d bytes!%n", first.size(), last.size());
        }
        if (!first.getByteOrder().equals(last.getByteOrder())) {
            out.format(OUTPUT_LOCALE, "WARNING: Suspicious byte order change! First record uses %s and last record uses %s!%n", first.getByteOrder(), last.getByteOrder());
        }
        if (!first.getCodec().equals((Object)last.getCodec())) {
            out.format(OUTPUT_LOCALE, "WARNING: Suspicious encoding change! First record is in %s encoded and last record in %s!%n", new Object[]{first.getCodec(), last.getCodec()});
        }
        if (first.getCodec() == EncodingFormat.ASCII) {
            out.format(OUTPUT_LOCALE, "%2s, %2s, %5s, %3s, %19s, %d records%n", first.getNetworkId(), first.getLocationId(), first.getStationId(), first.getChannelId(), first.getStartTime().toLogString(), numOfRecords);
        } else {
            out.format(OUTPUT_LOCALE, "%2s, %2s, %5s, %3s, %26s to %26s, %6d records, %.2f Hz, %10d samples%n", first.getNetworkId(), first.getLocationId(), first.getStationId(), first.getChannelId(), first.getStartTime().toDateTimeString(), last.getStopTime().toDateTimeString(), numOfRecords, first.getSampleRate(), numOfSamples);
        }
    }

    private static void printStreamFingerprintLine(PrintWriter out, Record first, Record last, MessageDigest digest) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (first != null) : "Argument 'first' must not be null.";
        assert (last != null) : "Argument 'last' must not be null.";
        assert (digest != null) : "Argument 'digest' must not be null.";
        StringBuilder fingerprint = new StringBuilder();
        fingerprint.append(digest.getAlgorithm());
        fingerprint.append(':');
        for (byte b : digest.digest()) {
            fingerprint.append(StringUtils.toHexString(b));
        }
        if (first.getCodec() != EncodingFormat.ASCII) {
            out.format(OUTPUT_LOCALE, "%5s, %3s, %26s to %26s, %s%n", first.getStationId(), first.getChannelId(), first.getStartTime().toDateTimeString(), last.getStopTime().toDateTimeString(), fingerprint);
        } else {
            out.format(OUTPUT_LOCALE, "%5s, %3s, %19s, %s%n", first.getStationId(), first.getChannelId(), first.getStartTime().toLogString(), fingerprint);
        }
    }

    private static void updateFingerprint(MessageDigest digest, Record record) {
        assert (digest != null) : "Argument 'digest' must not be null.";
        assert (record != null) : "Argument 'record' must not be null.";
        if (record.getCodec() != EncodingFormat.ASCII) {
            double[] samples = record.getSampleData();
            for (int i = 0; i < samples.length; ++i) {
                digest.update(record.getTimeAt(i).toByteArray());
                long value = Double.doubleToRawLongBits(samples[i]);
                digest.update(new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value});
            }
        } else {
            digest.update(record.getStartTime().toByteArray());
            digest.update(record.getRawData());
        }
    }

    public static void main(String[] args) {
        MseedInfo mseedInfo = new MseedInfo(args);
        try {
            mseedInfo.handleCommonOptions();
            mseedInfo.handleGippToolOptions();
            mseedInfo.handleInputOptions();
            mseedInfo.handleSelectionOptions();
            mseedInfo.handleReportOptions();
            mseedInfo.run();
        }
        catch (CmdLineException e) {
            mseedInfo.logThrowable(e);
            System.exit(64);
        }
        catch (IntegrityException e) {
            mseedInfo.logThrowable(e);
            System.exit(65);
        }
        catch (OutOfMemoryError e) {
            mseedInfo.log.severe("Ran out of memory! Please reduce the amount of miniSEED input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            mseedInfo.logThrowable(e);
            System.exit(99);
        }
    }

    private MessageDigest initFingerprint() {
        for (String algorithm : PREFERRED_FINGERPRINTS) {
            try {
                return MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException exp) {
                this.log.warning("Hash algorithm '" + algorithm + "' is not available!");
            }
        }
        return null;
    }

    private void handleInputOptions() {
        if (this.cmdLineParser.getArgumentList().isEmpty() && this.inputFilterOption.isMatched()) {
            throw new CmdLineException("Cannot apply the '--include-pattern' option when reading from standard input! Please give at least one miniSEED file or directory as argument to read from or drop the '--include-pattern' option altogether.");
        }
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addMseedFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP miniSEED filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    void handleSelectionOptions() {
        if (this.selectStationOption.isMatched()) {
            for (String pattern : this.selectStationOption.getValues()) {
                if (pattern.isEmpty()) {
                    this.log.warning("The \"--select-station\" option is missing the STATION expression.");
                }
                if (pattern.length() > Record.FixedHeader.STATION_ID.length()) {
                    this.log.warning("The STATION given in the \"--select-station\" option is longer than the permitted station id length (up to " + Record.FixedHeader.STATION_ID.length() + " characters). Most likely, there will be no matching station in the miniSEED input!");
                }
                this.selectedStations.add(Pattern.compile(RegexUtils.convertWildcards(pattern)));
                this.log.info("Processing stations that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.selectedStations.clear();
            this.log.fine("No stations selection is applied.");
        }
        if (this.selectChannelOption.isMatched()) {
            for (String pattern : this.selectChannelOption.getValues()) {
                if (pattern.isEmpty()) {
                    this.log.warning("The \"--select-channel\" option is missing a CHANNEL expression.");
                }
                if (pattern.length() > Record.FixedHeader.CHANNEL_ID.length()) {
                    this.log.warning("The CHANNEL given in the \"--select-channel\" option is longer than the permitted channel id length (up to " + Record.FixedHeader.CHANNEL_ID.length() + " characters). Most likely, there will be no matching channel in the miniSEED input!");
                }
                this.selectedChannels.add(Pattern.compile(RegexUtils.convertWildcards(pattern)));
                this.log.info("Processing channels that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.selectedChannels.clear();
            this.log.fine("No channel selection is applied.");
        }
    }

    private void handleReportOptions() {
        if (this.outputFormatOption.isMatched()) {
            String format = this.outputFormatOption.getValue().toUpperCase();
            if (format.startsWith("IND")) {
                this.outputFormat = OutputFormat.INDEX;
            } else if (format.startsWith("CHE")) {
                this.outputFormat = OutputFormat.CHECKSUM;
            } else if (format.startsWith("FIN")) {
                this.outputFormat = OutputFormat.CHECKSUM;
            } else if (format.startsWith("DIG")) {
                this.outputFormat = OutputFormat.CHECKSUM;
            } else if (format.startsWith("SUM")) {
                this.outputFormat = OutputFormat.SUMMARY;
            } else if (format.startsWith("OVE")) {
                this.outputFormat = OutputFormat.OVERVIEW;
            } else if (format.startsWith("FIL")) {
                this.outputFormat = OutputFormat.FILE;
            } else if (format.startsWith("QUA")) {
                this.outputFormat = OutputFormat.QUALITY;
            } else {
                this.log.severe("Unknown output format '" + format + "'. Please use one of " + Arrays.toString((Object[])OutputFormat.values()) + " instead.");
                System.exit(64);
            }
            this.log.info("Switching to '" + (Object)((Object)this.outputFormat) + "' output format.");
        } else {
            this.log.fine("Using the default output mode ('" + this.outputFormat.toString() + "').");
        }
    }

    private SortedFileSet handleFileArguments() {
        SortedFileSet inputList = new SortedFileSet(new SortByExtension(), this.inputFilter);
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            this.log.info("Reading miniSEED data from \"standard input\".");
            inputList.add(SortedFileSet.STANDARD_INPUT_TOKEN);
        } else {
            this.log.info("Building list of input files..");
            for (String name : this.cmdLineParser.getArgumentList()) {
                File file = new File(name);
                if (file.exists()) {
                    inputList.add(file);
                    continue;
                }
                this.log.warning("File or directory '" + name + "' given at the command line does not exist! Maybe a typing error?");
            }
        }
        if (inputList.isEmpty()) {
            this.log.severe("No suitable input files found.");
        } else {
            this.log.info("Found " + inputList.size() + " file(s) to process.");
        }
        return inputList;
    }

    /*
     * Exception decompiling
     */
    protected void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        Security.addProvider(new GippSecurityProvider());
        PREFERRED_FINGERPRINTS.add("MD5");
        PREFERRED_FINGERPRINTS.add("SHA-1");
        PREFERRED_FINGERPRINTS.add("CRC-64");
        OUTPUT_LOCALE = Locale.ENGLISH;
        FLOAT_FORMATTER = DecimalFormat.getInstance(OUTPUT_LOCALE);
        FLOAT_FORMATTER.setGroupingUsed(false);
        FLOAT_FORMATTER.setMaximumFractionDigits(9);
    }

    public static enum OutputFormat {
        FILE,
        INDEX,
        QUALITY,
        OVERVIEW,
        SUMMARY,
        CHECKSUM;

    }
}

