/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortByExtension;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.regex.RegexUtils;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import de.gfz_potsdam.gipp.tool.GippToolsConfig;
import de.gfz_potsdam.gipp.tool.miniseed.CroppingMode;
import de.gfz_potsdam.gipp.tool.miniseed.Request;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MseedCut
extends GippToolsApplication {
    private static final TimeSpan DEFAULT_TRACE_LENGTH = GippToolsConfig.getDefaultTraceLength();
    private static final double DEFAULT_TRACE_OFFSET = GippToolsConfig.getDefaultTraceOffset();
    private final List<Request> requestList = new ArrayList<Request>();
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private final CmdLineBoolean forceConcatenateOption = new CmdLineBoolean("force-concat", "Concatenate the miniSEED output creating as few new files as possible. This means that a new miniSEED output file is only started when there is a (data) discontinuity in the miniSEED input. Without discontinuity the converted data is simply appended to the current output file.\nBy default (i.e. without this option) however, a new miniSEED output file is created for every single input file.");
    private final CmdLineString fileLengthOption = new CmdLineString("file-length", "Write miniSEED files of (at most) the given length. Valid values are \"MINUTE\", \"HOUR\", \"DAY\" or \"WEEK\". Alternatively, the segment length can also be given as number (in seconds).\nUsing this option automatically implies the option \"--force-concat\" as well!\nExample: To return files of one minute length use either \"--file-length=60\" or \"--file-length=MINUTE\".");
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newMiniseedInputFilterOption();
    private final CmdLineString selectStationOption = GippToolsCommonOptions.newSelectStationOption();
    private final CmdLineString selectChannelOption = GippToolsCommonOptions.newSelectChannelOption();
    private final CmdLineString eventFileOption = new CmdLineString("events", "Use an event file to cut out more than one time window per program run. Each line in the event file contains the start (optionally also length and offset) of a time window that should be read from the miniSEED input.\nPlease see the manual for a more detailed description of the table layout.");
    private final CmdLineString traceStartOption = GippToolsCommonOptions.newTraceStartOption();
    private final CmdLineString traceStopOption = new CmdLineString("trace-stop", "Stop extracting samples at this time. The format for the time string is the same as for the \"--trace-start\" option (\"YYYY-MM-DD'T'HH:MM:SS.SSSS\").");
    private final CmdLineString traceLengthOption = new CmdLineString("trace-length", "Stop extracting samples after this time span. The input format is \"SS.ssss\" and is given in seconds.\nExample: To extract 2 minutes of data use \"--trace-length=120\".");
    private final CmdLineString traceOffsetOption = new CmdLineString("trace-offset", "Use this option to shift the beginning of the resulting miniSEED output relative to the start/stop time of the requested time window. The input format is \"SS.ssss\" and is given in seconds. The length of the time window is not changed.\nExample: To extract data beginning 2 seconds before a given trace start time use \"--trace-offset=-2\". (Note the minus sign!)");
    private final CmdLineBoolean dryRunOption = new CmdLineBoolean("dry-run", "Perform a trial run with no changes and modifications made to the file system whatsoever (and, of course, no miniSEED output).\nHint: This command line option is used best in conjunction with the '--verbose' option, so you can see what would happen if it were not a trial run.");
    private final List<Pattern> selectedChannels;
    private final List<Pattern> selectedStations = new ArrayList<Pattern>();
    private File outputDir = null;
    private boolean forceOverwrite = false;
    private boolean forceConcatenate = false;
    private TimeSpan fileLength = null;
    private RegexFilenameFilter inputFilter = null;
    private boolean dryRun = false;

    public MseedCut(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.selectedChannels = new ArrayList<Pattern>();
        this.cmdLineParser.registerOption(this.dryRunOption);
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.selectStationOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.selectChannelOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.registerOption(this.forceConcatenateOption);
        this.cmdLineParser.registerOption(this.fileLengthOption);
        this.cmdLineParser.registerOption(this.traceStartOption);
        this.cmdLineParser.registerOption(this.traceStopOption);
        this.cmdLineParser.registerOption(this.traceLengthOption);
        this.cmdLineParser.registerOption(this.traceOffsetOption);
        this.cmdLineParser.registerOption(this.eventFileOption);
        this.cmdLineParser.setProgramName("mseedcut");
        this.cmdLineParser.setProgramDescription("cut out data segments from miniSEED input");
        this.cmdLineParser.setProgramArguments("[miniSEED-FILE|DIRECTORY]...");
    }

    public static void main(String[] args) {
        MseedCut mseedcut = new MseedCut(args);
        try {
            mseedcut.handleCommonOptions();
            mseedcut.handleGippToolOptions();
            mseedcut.handleInputOptions();
            mseedcut.handleSelectionOptions();
            mseedcut.handleOutputOptions();
            mseedcut.handleCroppingOptions();
            mseedcut.parseEventFile();
            mseedcut.run();
        }
        catch (CmdLineException e) {
            mseedcut.logThrowable(e);
            System.exit(64);
        }
        catch (IntegrityException e) {
            mseedcut.logThrowable(e);
            System.exit(65);
        }
        catch (IOException e) {
            mseedcut.logThrowable(e);
            System.exit(74);
        }
        catch (OutOfMemoryError e) {
            mseedcut.log.severe("Ran out of memory! Please reduce the amount of miniSEED input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            mseedcut.logThrowable(e);
            System.exit(99);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEventFile() throws IOException {
        if (!this.eventFileOption.isMatched()) {
            this.log.fine("No event file is used.");
            return;
        }
        BufferedReader eventReader = null;
        try {
            String textLine;
            File eventFile = new File(this.eventFileOption.getValue());
            eventReader = new BufferedReader(new FileReader(eventFile));
            this.log.fine("The event file is '" + eventFile.getAbsolutePath() + "'.");
            int lineNumber = 0;
            while ((textLine = eventReader.readLine()) != null) {
                int commentPos;
                this.log.fine("Line #" + ++lineNumber + "  Parsing '" + textLine + "'");
                if ((textLine = textLine.trim()).isEmpty() || (commentPos = textLine.indexOf(35)) == 0) continue;
                if (commentPos > 0) {
                    textLine = textLine.substring(0, commentPos);
                }
                String[] column = textLine.split("\\s+");
                TimeMoment start = null;
                TimeSpan length = null;
                double offset = 0.0;
                if (column.length > 0) {
                    try {
                        start = TimeMoment.parse(column[0]);
                    }
                    catch (TimeException e) {
                        this.log.warning("Line #" + lineNumber + "  " + e.getMessage() + " The line will be ignored and skipped!");
                        continue;
                    }
                }
                if (column.length > 1) {
                    try {
                        length = TimeSpan.parse(column[1]);
                    }
                    catch (TimeException e) {
                        this.log.warning("Line #" + lineNumber + "  " + e.getMessage() + " The line will be ignored and skipped!");
                        continue;
                    }
                }
                if (column.length > 2) {
                    try {
                        offset = Double.parseDouble(column[2]);
                    }
                    catch (NumberFormatException e) {
                        this.log.warning("Line #" + lineNumber + "  Problem parsing '" + column[2] + "' as valid time offset. The line will be ignored and skipped!");
                        continue;
                    }
                }
                if (column.length > 3) {
                    this.log.warning("Line #" + lineNumber + "  Unknown format! Expected one to three columns but detected " + column.length + " columns instead! The line will be ignored and skipped!");
                    continue;
                }
                if (offset > 0.0) {
                    start = TimeSpan.add(start, new TimeSpan.Builder().addSeconds(offset).build());
                } else if (offset < 0.0) {
                    start = TimeSpan.subtract(start, new TimeSpan.Builder().addSeconds(offset).build());
                }
                if (length == null) {
                    this.log.fine("Line #" + lineNumber + "  Adding time window of " + DEFAULT_TRACE_LENGTH + " beginning at " + start);
                    this.requestList.add(Request.newStartLengthRequest(start, DEFAULT_TRACE_LENGTH));
                    continue;
                }
                this.log.fine("Line #" + lineNumber + "  Adding time window of " + length + " beginning at " + start);
                this.requestList.add(Request.newStartLengthRequest(start, length));
            }
        }
        catch (FileNotFoundException e) {
            try {
                this.log.severe("Cannot find the file '" + this.eventFileOption.getValue() + "'. Please verify that the file exist and is it readable?");
                System.exit(66);
            }
            catch (Throwable throwable) {
                FileUtils.flushClose(eventReader);
                throw throwable;
            }
            FileUtils.flushClose(eventReader);
        }
        FileUtils.flushClose(eventReader);
        this.log.info("Finished reading the event file. Marked " + this.requestList.size() + " time windows for processing.");
    }

    private void handleInputOptions() {
        if (this.cmdLineParser.getArgumentList().isEmpty() && this.inputFilterOption.isMatched()) {
            throw new CmdLineException("Cannot apply the '--include-pattern' option when reading from standard input! Please give at least one miniSEED file or directory as argument to read from or drop the '--include-pattern' option altogether.");
        }
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addMseedFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined 'GIPP miniSEED filename' pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    void handleSelectionOptions() {
        if (this.selectStationOption.isMatched()) {
            for (String pattern : this.selectStationOption.getValues()) {
                if (pattern.isEmpty()) {
                    this.log.warning("The \"--select-station\" option is missing the STATION expression.");
                }
                if (pattern.length() > Record.FixedHeader.STATION_ID.length()) {
                    this.log.warning("The STATION given in the \"--select-station\" option is longer than the permitted station id length (up to " + Record.FixedHeader.STATION_ID.length() + " characters). Most likely, there will be no matching station in the miniSEED input!");
                }
                this.selectedStations.add(Pattern.compile(RegexUtils.convertWildcards(pattern)));
                this.log.info("Processing stations that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.selectedStations.clear();
            this.log.fine("No stations selection is applied.");
        }
        if (this.selectChannelOption.isMatched()) {
            for (String pattern : this.selectChannelOption.getValues()) {
                if (pattern.isEmpty()) {
                    this.log.warning("The \"--select-channel\" option is missing a CHANNEL expression.");
                }
                if (pattern.length() > Record.FixedHeader.CHANNEL_ID.length()) {
                    this.log.warning("The CHANNEL given in the \"--select-channel\" option is longer than the permitted channel id length (up to " + Record.FixedHeader.CHANNEL_ID.length() + " characters). Most likely, there will be no matching channel in the miniSEED input!");
                }
                this.selectedChannels.add(Pattern.compile(RegexUtils.convertWildcards(pattern)));
                this.log.info("Processing channels that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.selectedChannels.clear();
            this.log.fine("No channel selection is applied.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleOutputOptions() {
        if (this.dryRunOption.isMatched()) {
            this.dryRun = true;
            this.log.info("Running in \"trial mode\". No changes or modifications will be made whatsoever!");
        }
        if (!this.outputDirOption.isMatched()) {
            if (this.forceOverwriteOption.isMatched()) {
                throw new CmdLineException("The '--force-overwrite' option is only allowed in conjunction with the '--output-dir=DIR' option.");
            }
            if (this.forceConcatenateOption.isMatched()) {
                throw new CmdLineException("The '--force-concat' option is only allowed in conjunction with the '--output-dir=DIR' option.");
            }
            if (this.fileLengthOption.isMatched()) {
                throw new CmdLineException("The '--file-length' option is only allowed in conjunction with the '--output-dir=DIR' option.");
            }
        }
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing files will NOT be overwritten.");
        }
        if (this.forceConcatenateOption.isMatched()) {
            this.forceConcatenate = true;
            this.log.info("Concatenate the miniSEED output in as few files as possible.");
        } else {
            this.forceConcatenate = false;
            this.log.fine("Create a new miniSEED output file for every single input file.");
        }
        if (this.fileLengthOption.isMatched()) {
            String value = this.fileLengthOption.getValue().toUpperCase();
            if (value.startsWith("MIN")) {
                this.fileLength = new TimeSpan.Builder().addMinutes(1L).build();
                this.log.info("Writing miniSEED output in segments of at most one minute length.");
            } else if (value.startsWith("HOUR")) {
                this.fileLength = new TimeSpan.Builder().addHours(1L).build();
                this.log.info("Writing miniSEED output in segments of at most one hour length.");
            } else if (value.startsWith("DAY")) {
                this.fileLength = new TimeSpan.Builder().addDays(1L).build();
                this.log.info("Writing miniSEED output in segments of at most one day length.");
            } else if (value.startsWith("WEEK")) {
                this.fileLength = new TimeSpan.Builder().addDays(7L).build();
                this.log.info("Writing miniSEED output in segments of at most one week length.");
            } else {
                try {
                    this.fileLength = TimeSpan.parse(value);
                }
                catch (TimeException e) {
                    this.log.severe(e.getMessage() + " Please use a correctly formatted value (e.g. \"120\" for segments of two minutes length). Alternatively, use one of the keywords \"MINUTE\", \"HOUR\", \"DAY\" or \"WEEK\" for segments of corresponding length.");
                    System.exit(64);
                }
                this.log.info("Writing miniSEED output in segments of " + this.fileLength + " length.");
            }
            this.forceConcatenate = true;
            this.log.fine("Use of '--file-length' implies option '--force-concat'. Enabling concatenation.");
        } else {
            this.fileLength = null;
            this.log.fine("No segment length for splitting the input was given.");
        }
        if (!this.outputDirOption.isMatched()) {
            this.outputDir = null;
            this.log.fine("All results will be written to \"standard output\" (console).");
            return;
        }
        this.outputDir = new File(this.outputDirOption.getValue());
        if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
            this.log.info("All resulting miniSEED files will be written to the '" + this.outputDir.getPath() + "' directory.");
            return;
        }
        this.outputDir = null;
        throw new CmdLineException("Cannot write miniSEED files to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
    }

    private void handleCroppingOptions() {
        CroppingMode cropMode = null;
        try {
            if (this.traceLengthOption.isMatched() && this.traceStartOption.isMatched() && this.traceStopOption.isMatched()) {
                this.log.severe("At most two of the command line options \"--trace-start\", \"--trace-stop\" or \"--trace-length\" may be used at the same time.");
                System.exit(64);
            } else if (this.traceLengthOption.isMatched() && !this.traceStartOption.isMatched() && !this.traceStopOption.isMatched()) {
                this.log.severe("Using the \"--trace-length\" command line option makes only sense if one of the \"--trace-start\" or \"--trace-stop\" options is used as well!");
                System.exit(64);
            } else if (this.traceStartOption.isMatched() && this.traceStopOption.isMatched()) {
                this.log.fine("Using a time window base on a start and a stop time definition.");
                cropMode = CroppingMode.START_STOP;
            } else if (this.traceStartOption.isMatched()) {
                this.log.fine("Using a time window based on a start time and a time span definition.");
                cropMode = CroppingMode.START_LENGTH;
            } else if (this.traceStopOption.isMatched()) {
                this.log.fine("Using a time window base on a time span and a stop time definition.");
                cropMode = CroppingMode.LENGTH_STOP;
            } else {
                cropMode = CroppingMode.NONE;
                this.log.fine("No time window was defined at the command line.");
            }
            double traceOffset = DEFAULT_TRACE_OFFSET;
            if (this.traceOffsetOption.isMatched()) {
                try {
                    traceOffset = Double.parseDouble(this.traceOffsetOption.getValue());
                    this.log.info("The time window will be shifted by " + traceOffset + " seconds relative to the start/stop time.");
                }
                catch (NumberFormatException exp) {
                    traceOffset = 0.0;
                    this.log.severe("Cannot understand '" + this.traceOffsetOption.getValue() + "'. Please use a correctly formatted trace length value (e.g. \"-10\" to shift by ten seconds towards earlier times).");
                    System.exit(64);
                }
            } else {
                this.log.fine("Using the default trace offset of " + traceOffset + " seconds.");
            }
            TimeMoment traceStart = null;
            if (this.traceStartOption.isMatched()) {
                traceStart = TimeMoment.parse(this.traceStartOption.getValue());
                if (traceStart.before(new TimeMoment.Builder().date(1950, 1, 1).build())) {
                    this.log.warning("Your start time is before 1-Jan-1950, which is probably not what you want! Typing error? Forgot the century? Anyway, your wish is my command...");
                }
                if (traceOffset > 0.0) {
                    traceStart = TimeSpan.add(traceStart, new TimeSpan.Builder().addSeconds(traceOffset).build());
                } else if (traceOffset < 0.0) {
                    traceStart = TimeSpan.subtract(traceStart, new TimeSpan.Builder().addSeconds(traceOffset).build());
                }
                this.log.info("Will begin extracting at: " + traceStart);
            } else {
                this.log.fine("No start time for clipping was given.");
            }
            TimeMoment traceStop = null;
            if (this.traceStopOption.isMatched()) {
                traceStop = TimeMoment.parse(this.traceStopOption.getValue());
                if (traceStop.before(new TimeMoment.Builder().date(1950, 1, 1).build())) {
                    this.log.warning("Your stop time is before 1-Jan-1950, which is probably not what you want! Typing error? Forgot the century? Anyway, your wish is my command...");
                }
                if (traceOffset > 0.0) {
                    traceStop = TimeSpan.add(traceStop, new TimeSpan.Builder().addSeconds(traceOffset).build());
                } else if (traceOffset < 0.0) {
                    traceStop = TimeSpan.subtract(traceStop, new TimeSpan.Builder().addSeconds(traceOffset).build());
                }
                this.log.info("Will stop  extracting at: " + traceStop);
            } else {
                this.log.fine("No stop  time for clipping was given.");
            }
            TimeSpan traceLength = DEFAULT_TRACE_LENGTH;
            if (this.traceLengthOption.isMatched()) {
                traceLength = TimeSpan.parse(this.traceLengthOption.getValue());
                if (traceLength == null) {
                    this.log.severe("Cannot understand '" + this.traceLengthOption.getValue() + "'. Please use a correctly formatted trace length value (e.g. \"120\" to extract two minutes of data).");
                    System.exit(64);
                }
                if (traceLength.equals(new TimeSpan.Builder().build())) {
                    this.log.warning("A trace length of 0 seconds will never return any data!");
                    this.log.info("Done.");
                    System.exit(0);
                }
                this.log.info("The trace length will be: " + traceLength);
            } else if (cropMode == CroppingMode.START_LENGTH || cropMode == CroppingMode.LENGTH_STOP) {
                this.log.info("The trace length will be: " + traceLength + " (default)");
            } else {
                traceLength = null;
                this.log.fine("No trace length for clipping was given.");
            }
            if (cropMode == CroppingMode.START_STOP) {
                assert (traceStart != null);
                assert (traceStop != null);
                if (traceStart.afterOrAt(traceStop)) {
                    this.log.severe("Invalid time window! The given trace start time must always come before the trace stop time.");
                    System.exit(64);
                }
            }
            switch (cropMode) {
                case START_STOP: {
                    this.log.info("Adding time window from " + traceStart + " to " + traceStop);
                    this.requestList.add(Request.newStartStopRequest(traceStart, traceStop));
                    break;
                }
                case START_LENGTH: {
                    this.log.info("Adding time window of " + traceLength + " beginning at " + traceStart);
                    this.requestList.add(Request.newStartLengthRequest(traceStart, traceLength));
                    break;
                }
                case LENGTH_STOP: {
                    this.log.info("Adding time window of " + traceLength + " ending at " + traceStop);
                    this.requestList.add(Request.newLengthStopRequest(traceLength, traceStop));
                    break;
                }
                default: {
                    this.log.fine("No time window was given at the command line.");
                    break;
                }
            }
        }
        catch (TimeException e) {
            this.log.severe(e.getMessage());
            System.exit(64);
        }
    }

    private SortedFileSet handleFileArguments() {
        SortedFileSet inputList = new SortedFileSet(new SortByExtension(), this.inputFilter);
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            this.log.info("Reading miniSEED data from \"standard input\".");
            inputList.add(SortedFileSet.STANDARD_INPUT_TOKEN);
        } else {
            this.log.info("Building list of input files..");
            for (String name : this.cmdLineParser.getArgumentList()) {
                File file = new File(name);
                if (file.exists()) {
                    inputList.add(file);
                    continue;
                }
                this.log.warning("File or directory '" + name + "' given at the command line does not exist! Maybe a typing error?");
            }
        }
        if (inputList.isEmpty()) {
            this.log.severe("No suitable input files found.");
        } else {
            this.log.info("Found " + inputList.size() + " file(s) to process.");
        }
        return inputList;
    }

    /*
     * Exception decompiling
     */
    private void run() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

