/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.tool.miniseed.Action;
import de.gfz_potsdam.gipp.tool.miniseed.Condition;
import java.util.ArrayList;
import java.util.List;

public class EditingRule {
    private final List<Condition> conditionList = new ArrayList<Condition>();
    private final List<Action> actionList = new ArrayList<Action>();

    public EditingRule(List<Condition> conditions, List<Action> actions) {
        if (conditions != null) {
            this.conditionList.addAll(conditions);
        }
        if (actions != null) {
            this.actionList.addAll(actions);
        }
    }

    public EditingRule() {
        this(null, null);
    }

    public boolean addCondition(Condition condition) {
        if (condition == null) {
            return false;
        }
        return this.conditionList.add(condition);
    }

    public boolean addAction(Action action) {
        if (action == null) {
            return false;
        }
        return this.actionList.add(action);
    }

    public boolean execute(Record record) {
        for (Condition condition : this.conditionList) {
            if (condition == null || condition.comply(record)) continue;
            return false;
        }
        for (Action task : this.actionList) {
            if (task == null || task.execute(record)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.actionList.size() == 0) {
            buffer.append("NO OPERATION");
        } else {
            buffer.append(this.actionList);
        }
        if (this.conditionList.size() == 0) {
            buffer.insert(0, "ALWAYS DO ");
        } else {
            buffer.append(" IF ").append(this.conditionList);
        }
        return buffer.toString();
    }
}

