/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.tool.miniseed.MseedToMseed;
import java.util.regex.Pattern;

abstract class Condition {
    protected MseedToMseed.Key keyword;

    Condition() {
    }

    protected abstract boolean comply(Record var1);

    protected static class AfterOrAtTime
    extends Condition {
        private final TimeMoment time;

        protected AfterOrAtTime(MseedToMseed.Key headerField, TimeMoment time) {
            this.keyword = headerField;
            this.time = time;
        }

        @Override
        protected boolean comply(Record record) {
            switch (this.keyword) {
                case START_TIME: {
                    return record.getStartTime().after(this.time) || record.getStartTime().after(this.time);
                }
                case STOP_TIME: {
                    return record.getStopTime().after(this.time) || record.getStopTime().after(this.time);
                }
            }
            throw new AssertionError((Object)("Time comparison \"after or at time\" is not implemented for miniSEED header " + (Object)((Object)this.keyword) + "!"));
        }

        public String toString() {
            return (Object)((Object)this.keyword) + " after or at " + this.time;
        }
    }

    protected static class AfterTime
    extends Condition {
        private final TimeMoment time;

        protected AfterTime(MseedToMseed.Key headerField, TimeMoment time) {
            this.keyword = headerField;
            this.time = time;
        }

        @Override
        protected boolean comply(Record record) {
            switch (this.keyword) {
                case START_TIME: {
                    return record.getStartTime().after(this.time);
                }
                case STOP_TIME: {
                    return record.getStopTime().after(this.time);
                }
            }
            throw new AssertionError((Object)("Time comparison \"after time\" is not implemented for miniSEED header " + (Object)((Object)this.keyword) + "!"));
        }

        public String toString() {
            return (Object)((Object)this.keyword) + " after " + this.time;
        }
    }

    protected static class BeforeOrAtTime
    extends Condition {
        private final TimeMoment time;

        protected BeforeOrAtTime(MseedToMseed.Key headerField, TimeMoment time) {
            this.keyword = headerField;
            this.time = time;
        }

        @Override
        protected boolean comply(Record record) {
            switch (this.keyword) {
                case START_TIME: {
                    return record.getStartTime().before(this.time) || record.getStartTime().equals(this.time);
                }
                case STOP_TIME: {
                    return record.getStopTime().before(this.time) || record.getStopTime().equals(this.time);
                }
            }
            throw new AssertionError((Object)("Comparison \"before or at time\" is not implemented for miniSEED header " + (Object)((Object)this.keyword) + "!"));
        }

        public String toString() {
            return (Object)((Object)this.keyword) + " before or at " + this.time;
        }
    }

    protected static class BeforeTime
    extends Condition {
        private final TimeMoment time;

        protected BeforeTime(MseedToMseed.Key headerField, TimeMoment time) {
            this.keyword = headerField;
            this.time = time;
        }

        @Override
        protected boolean comply(Record record) {
            switch (this.keyword) {
                case START_TIME: {
                    return record.getStartTime().before(this.time);
                }
                case STOP_TIME: {
                    return record.getStopTime().before(this.time);
                }
            }
            throw new AssertionError((Object)("Comparison \"before time\" is not implemented for miniSEED header " + (Object)((Object)this.keyword) + "!"));
        }

        public String toString() {
            return (Object)((Object)this.keyword) + " before " + this.time;
        }
    }

    protected static class LargerNumber
    extends Condition {
        private final long value;

        protected LargerNumber(MseedToMseed.Key headerField, long testValue) {
            this.keyword = headerField;
            this.value = testValue;
        }

        @Override
        protected boolean comply(Record record) {
            switch (this.keyword) {
                case RECORD_NUMBER: {
                    return (long)record.getSequenceNumber() > this.value;
                }
                case SAMPLE_RATE: {
                    return Math.round(record.getSampleRate()) > this.value;
                }
                case SAMPLE_PERIOD: {
                    return Math.round(record.getSamplePeriod()) > this.value;
                }
                case TIMING_QUALITY: {
                    if (record.hasBlockette(1001)) {
                        return (long)record.getTimingQualityValue() > this.value;
                    }
                    return false;
                }
            }
            throw new AssertionError((Object)("Larger than comparison is not implemented for miniSEED header " + (Object)((Object)this.keyword) + "!"));
        }

        public String toString() {
            return (Object)((Object)this.keyword) + " > '" + this.value + "'";
        }
    }

    protected static class SmallerNumber
    extends Condition {
        private final long value;

        protected SmallerNumber(MseedToMseed.Key headerField, long testValue) {
            this.keyword = headerField;
            this.value = testValue;
        }

        @Override
        protected boolean comply(Record record) {
            switch (this.keyword) {
                case RECORD_NUMBER: {
                    return (long)record.getSequenceNumber() < this.value;
                }
                case SAMPLE_RATE: {
                    return Math.round(record.getSampleRate()) < this.value;
                }
                case SAMPLE_PERIOD: {
                    return Math.round(record.getSamplePeriod()) < this.value;
                }
                case TIMING_QUALITY: {
                    if (record.hasBlockette(1001)) {
                        return (long)record.getTimingQualityValue() < this.value;
                    }
                    return false;
                }
            }
            throw new AssertionError((Object)("Less than comparison is not implemented for miniSEED header " + (Object)((Object)this.keyword) + "!"));
        }

        public String toString() {
            return (Object)((Object)this.keyword) + " < '" + this.value + "'";
        }
    }

    protected static class EqualNumber
    extends Condition {
        private final long value;

        protected EqualNumber(MseedToMseed.Key headerField, long testValue) {
            this.keyword = headerField;
            this.value = testValue;
        }

        @Override
        protected boolean comply(Record record) {
            switch (this.keyword) {
                case RECORD_NUMBER: {
                    return (long)record.getSequenceNumber() == this.value;
                }
                case SAMPLE_RATE: {
                    return Math.round(record.getSampleRate()) == this.value;
                }
                case SAMPLE_PERIOD: {
                    return Math.round(record.getSamplePeriod()) == this.value;
                }
                case TIMING_QUALITY: {
                    if (record.hasBlockette(1001)) {
                        return (long)record.getTimingQualityValue() == this.value;
                    }
                    return false;
                }
            }
            throw new AssertionError((Object)("Equal comparison is not implemented for miniSEED header " + (Object)((Object)this.keyword) + "!"));
        }

        public String toString() {
            return (Object)((Object)this.keyword) + " == '" + this.value + "'";
        }
    }

    protected static class MatchText
    extends Condition {
        private final Pattern pattern;

        protected MatchText(MseedToMseed.Key headerField, String simpleRegEx) {
            StringBuilder buffer = new StringBuilder();
            block5: for (char c : simpleRegEx.toCharArray()) {
                switch (c) {
                    case '*': {
                        buffer.append(".*");
                        continue block5;
                    }
                    case '?': {
                        buffer.append(".");
                        continue block5;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '}': {
                        buffer.append('\\').append(c);
                        continue block5;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            this.keyword = headerField;
            this.pattern = Pattern.compile(buffer.toString());
        }

        @Override
        protected boolean comply(Record record) {
            switch (this.keyword) {
                case STATION: {
                    return this.pattern.matcher(record.getStationId()).matches();
                }
                case CHANNEL: {
                    return this.pattern.matcher(record.getChannelId()).matches();
                }
                case NETWORK: {
                    return this.pattern.matcher(record.getNetworkId()).matches();
                }
                case LOCATION: {
                    return this.pattern.matcher(record.getLocationId()).matches();
                }
            }
            throw new AssertionError((Object)("Text matching is not implemented for the miniSEED header " + (Object)((Object)this.keyword) + "!"));
        }

        public String toString() {
            return (Object)((Object)this.keyword) + " matches '" + this.pattern.toString() + "'";
        }
    }
}

