/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.miniseed;

import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.miniseed.MseedToMseed;

abstract class Action {
    Action() {
    }

    protected abstract boolean execute(Record var1);

    protected static class SetTimingQuality
    extends Action {
        private final byte quality;

        protected SetTimingQuality(byte quality) {
            this.quality = quality;
        }

        @Override
        protected boolean execute(Record record) {
            record.setTimingQualityValue(this.quality);
            return true;
        }

        public String toString() {
            return "timing quality := " + this.quality;
        }
    }

    protected static class FixGpsEpoch
    extends Action {
        static final TimeMoment EDL_INT_OVERFLOW_START_TIME = new TimeMoment.Builder().year(2031).month(1).day(1).build();
        static final TimeSpan EDL_INT_OVERFLOW_CORRECTION = TimeSpan.SECOND.multiply(3.88961152E8);
        static final TimeMoment HALF_GPS_EPOCH_BEFORE_PRESENT = TimeMoment.now().subtract(TimeSpan.WEEK.multiply(512.0));

        protected FixGpsEpoch() {
        }

        static TimeMoment correctTime(TimeMoment buggyTime) {
            TimeMoment fixedTime = buggyTime.after(EDL_INT_OVERFLOW_START_TIME) ? buggyTime.subtract(EDL_INT_OVERFLOW_CORRECTION) : (buggyTime.before(HALF_GPS_EPOCH_BEFORE_PRESENT) ? buggyTime.add(TimeSpan.GPS_EPOCH) : buggyTime);
            return fixedTime;
        }

        @Override
        protected boolean execute(Record record) {
            TimeMoment buggyTime = record.getStartTime();
            assert (buggyTime != null) : "Could not read the start time of record " + record;
            TimeMoment fixedTime = FixGpsEpoch.correctTime(buggyTime);
            assert (fixedTime != null) : "Could not determine the new start time.";
            record.setStartTime(fixedTime);
            return true;
        }

        public String toString() {
            return "Correcting for wrong GPS epoch caused by week number rollover error.";
        }
    }

    protected static class FixEdrStartTime
    extends Action {
        protected FixEdrStartTime() {
        }

        static TimeMoment fixEdrFirmwareBug(TimeMoment time) {
            String MICROSECOND_ERROR_PATTERN = "900";
            if (time.toIsoString().endsWith("900")) {
                return time.add(TimeSpan.TICK);
            }
            return time;
        }

        @Override
        protected boolean execute(Record record) {
            TimeMoment buggyTime = record.getStartTime();
            assert (buggyTime != null) : "Could not read the start time of record " + record;
            TimeMoment fixedTime = FixEdrStartTime.fixEdrFirmwareBug(buggyTime);
            assert (fixedTime != null) : "Could not determine the new start time.";
            record.setStartTime(fixedTime);
            return true;
        }

        public String toString() {
            return "Correcting erroneous start time of some EDRs due to firmware bug.";
        }
    }

    protected static class ShiftTime
    extends Action {
        private final TimeSpan offset;
        private final int scalar;

        protected ShiftTime(int direction, TimeSpan shift) {
            this.scalar = direction;
            this.offset = shift;
        }

        @Override
        protected boolean execute(Record record) {
            TimeMoment oldTime = record.getStartTime();
            TimeMoment newTime = this.scalar < 0 ? TimeSpan.subtract(oldTime, this.offset.multiply(Math.abs(this.scalar))) : TimeSpan.add(oldTime, this.offset.multiply(Math.abs(this.scalar)));
            record.setStartTime(newTime);
            return true;
        }

        public String toString() {
            if (this.scalar < 0) {
                return "Subtracting " + this.offset.multiply(Math.abs(this.scalar)).getApproximateString() + " from the start time";
            }
            return "Adding " + this.offset.multiply(Math.abs(this.scalar)).getApproximateString() + " to the start time";
        }
    }

    protected static class SetText
    extends Action {
        private final MseedToMseed.Key headerField;
        private final String value;

        protected SetText(MseedToMseed.Key headerField, String newValue) {
            this.headerField = headerField;
            this.value = newValue;
        }

        @Override
        protected boolean execute(Record record) throws IllegalArgumentException, UnsupportedOperationException {
            switch (this.headerField) {
                case STATION: {
                    record.setStationId(this.value);
                    return true;
                }
                case CHANNEL: {
                    record.setChannelId(this.value);
                    return true;
                }
                case NETWORK: {
                    record.setNetworkId(this.value);
                    return true;
                }
                case LOCATION: {
                    record.setLocationId(this.value);
                    return true;
                }
            }
            throw new UnsupportedOperationException("Resetting the miniSEED header " + (Object)((Object)this.headerField) + " is not implemented!");
        }

        public String toString() {
            return (Object)((Object)this.headerField) + " := '" + this.value + "'";
        }
    }

    protected static class Reset
    extends Action {
        private final MseedToMseed.Key headerField;

        protected Reset(MseedToMseed.Key header) {
            this.headerField = header;
        }

        @Override
        protected boolean execute(Record record) throws UnsupportedOperationException {
            switch (this.headerField) {
                case STATION: {
                    record.setStationId("");
                    return true;
                }
                case CHANNEL: {
                    record.setChannelId("");
                    return true;
                }
                case NETWORK: {
                    record.setNetworkId("");
                    return true;
                }
                case LOCATION: {
                    record.setLocationId("");
                    return true;
                }
                case TIMING_QUALITY: {
                    if (record.hasBlockette(1001)) {
                        record.setTimingQualityValue((byte)0);
                    }
                    return true;
                }
            }
            throw new UnsupportedOperationException("Resetting the miniSEED header '" + (Object)((Object)this.headerField) + "' is not implemented!");
        }

        public String toString() {
            return (Object)((Object)this.headerField) + " := <empty string>";
        }
    }
}

