/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.cube;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.TraceReader;
import de.gfz_potsdam.gipp.common.seis.TraceWriter;
import de.gfz_potsdam.gipp.common.seis.cube.CubeException;
import de.gfz_potsdam.gipp.common.seis.cube.CubeTraceReader;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.FringeSampleUtils;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.TimingQualityUtils;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.seis.cube.WnroUtil;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.Stopwatch;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.common.time.TimeWindow;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import de.gfz_potsdam.gipp.tool.GippToolsConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CubeToOther
extends GippToolsApplication {
    private static final TimeSpan DEFAULT_TRACE_LENGTH = GippToolsConfig.getDefaultTraceLength();
    private static final double DEFAULT_TRACE_OFFSET = GippToolsConfig.getDefaultTraceOffset();
    private static final int DEFAULT_SINC_FILTER_LENGTH = 25;
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newCubeInputFilterOption();
    private final List<TimeWindow> windowList;
    private final CmdLineString wnroCorrectionOption = GippToolsCommonOptions.newWnroCorrectionOption();
    private final CmdLineString timingControlOption = new CmdLineString("timing-control", "Select an algorithm to quality control the timing information contained in the Cube input data.\n LLS .... Use a \"local least squares\" (LLS) approximation to\n          detect outliers and other suspicious time information.\n          (Default)\n RULE ... Do a rule-based evaluation. The rules are predefined\n          and were determined by trial and error.\n NONE ... Skip quality control altogether! This will use any\n          available (GPS) timing information without further\n          qualification.\nPlease see the documentation for more details about the quality control of the timing information recorded by the Cube.", null);
    private final CmdLineString fringeSampleOption = new CmdLineString("fringe-samples", "Decide how to treat samples that were recorded before the first GPS time fix or after the last GPS time fix taken by the Cube unit. Determining the precise recording time of these \"fringe samples\" is problematic because without a second time tag on the other side of the sample the precise sampling rate cannot be computed. However, sometimes it might be beneficial to use fringe samples for further processing anyhow. Valid options are:\n SKIP ....... Exclude all samples without good time control\n              from the conversion. (Default)\n NOMINAL .... Include samples assuming a perfect nominal (as\n              configured) sample rate.\n CONSTANT ... Include samples assuming a constant clock drift\n              over the whole recording.\nPlease see the documentation for more details about fringe sample treatment.", null);
    private final CmdLineString resamplerOption = new CmdLineString("resample", "Change the used resample algorithm. Pick one of the following:\n SINC ..... Resample using a windowed 'sinc' function. (Default)\n LINEAR ... Linear interpolation.\n NONE ..... No resampling at all.\nPlease see the documentation for more details.", null);
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private final CmdLineString eventFileOption = new CmdLineString("events", "Use an event file to convert more than one time window per program run. Each line in the event file contains the start (optionally also length and offset) of a time window that should be converted.\nPlease see the manual for a more detailed description of the table layout.");
    private final CmdLineString traceStartOption = GippToolsCommonOptions.newTraceStartOption();
    private final CmdLineString traceStopOption = GippToolsCommonOptions.newTraceStopOption();
    private final CmdLineString traceLengthOption = GippToolsCommonOptions.newTraceLengthOption(DEFAULT_TRACE_LENGTH);
    private final CmdLineString traceOffsetOption = GippToolsCommonOptions.newTraceOffsetOption(DEFAULT_TRACE_OFFSET);
    protected File outputDir = null;
    protected boolean forceOverwrite = false;
    private RegexFilenameFilter inputFilter;
    private TimeSpan wnroCorrection = null;
    private TimingQualityUtils.QualityControlAlgorithm timingControl;
    private FringeSampleUtils.FringeSampleTreatment fringeSamples;
    private Resampler resampleAlgorithmTyp;
    private int resampleWindowLength = 25;

    protected CubeToOther(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.windowList = new ArrayList<TimeWindow>();
        this.resampleAlgorithmTyp = Resampler.SINC;
        this.timingControl = TimingQualityUtils.QualityControlAlgorithm.LOCAL_LEAST_SQUARES;
        this.fringeSamples = FringeSampleUtils.FringeSampleTreatment.SKIP;
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.traceStartOption);
        this.cmdLineParser.registerOption(this.traceStopOption);
        this.cmdLineParser.registerOption(this.traceLengthOption);
        this.cmdLineParser.registerOption(this.traceOffsetOption);
        this.cmdLineParser.registerOption(this.eventFileOption);
        this.cmdLineParser.registerOption(this.wnroCorrectionOption).set(CmdLineOption.Visibility.HIDDEN);
        this.cmdLineParser.registerOption(this.timingControlOption);
        this.cmdLineParser.registerOption(this.fringeSampleOption);
        this.cmdLineParser.registerOption(this.resamplerOption);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
    }

    protected TraceReader getReader(TraceInfo traceInfo, TimeWindow requestWindow) {
        assert (traceInfo != null) : "Variable 'traceInfo' must not be 'null'!";
        assert (requestWindow != null) : "Variable 'requestWindow' must not be 'null'!";
        assert (this.resampleWindowLength >= 0) : "The window length of the resampler must not be negative!";
        TimeSpan extraWidth = traceInfo.getSamplePeriod().multiply(this.resampleWindowLength + 1);
        TimeWindow largerWindow = new TimeWindow(TimeSpan.subtract(requestWindow.getStart(), extraWidth), TimeSpan.add(requestWindow.getStop(), extraWidth));
        CubeTraceReader reader = CubeTraceReader.newFromTrace(traceInfo, largerWindow);
        if (reader == null) {
            this.log.warning("Cannot read from Cube trace for the time window " + requestWindow + "!");
        } else {
            this.log.fine("Successfully initialized a new Cube trace reader.");
        }
        return reader;
    }

    protected abstract TraceWriter getWriter(TraceInfo var1, TimeWindow var2);

    protected void handleInputOptions() {
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addCubeFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP Cube filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleOutputOptions() {
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing output files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing output files will NOT be overwritten.");
        }
        if (!this.outputDirOption.isMatched()) {
            this.outputDir = null;
            this.log.fine("The resulting output files will be written to \"standard output\" (console).");
            return;
        }
        this.outputDir = new File(this.outputDirOption.getValue());
        if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
            this.log.info("All output files will be written to the '" + this.outputDir.getPath() + "' directory.");
            return;
        }
        this.outputDir = null;
        throw new CmdLineException("Cannot write resulting files to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
    }

    protected void handleDataQualityOptions() {
        this.wnroCorrection = GippToolsCommonOptions.evalWnroCorrectionOption(this.log, this.wnroCorrectionOption);
    }

    protected void handleConversionOptions() {
        if (this.resamplerOption.isMatched()) {
            String format = this.resamplerOption.getValue().toUpperCase();
            if (format.startsWith(Resampler.SINC.toString().substring(0, 3))) {
                this.resampleAlgorithmTyp = Resampler.SINC;
                String[] params = format.split(",");
                this.resampleWindowLength = params.length == 1 ? 25 : Integer.parseInt(params[1]);
                if (this.resampleWindowLength <= 0) {
                    this.log.severe("Resampler window length must be a positive integer!");
                    System.exit(64);
                }
                this.log.info("Switching to '" + (Object)((Object)this.resampleAlgorithmTyp) + "' resample algorithm (window length " + this.resampleWindowLength + ").");
            } else if (format.startsWith(Resampler.LINEAR.toString().substring(0, 3))) {
                this.resampleAlgorithmTyp = Resampler.LINEAR;
                this.resampleWindowLength = 1;
                this.log.info("Switching to '" + (Object)((Object)this.resampleAlgorithmTyp) + "' resample algorithm.");
            } else if (format.startsWith(Resampler.NONE.toString().substring(0, 3))) {
                this.resampleAlgorithmTyp = Resampler.NONE;
                this.resampleWindowLength = 0;
                this.log.info("Switching to '" + (Object)((Object)this.resampleAlgorithmTyp) + "' resample algorithm.");
            } else {
                this.log.severe("Unknown resample algorithm '" + format + "'. Please use one of " + Arrays.toString((Object[])Resampler.values()) + " instead.");
                System.exit(64);
            }
        } else {
            this.log.fine("Using the default resample algorithm ('" + this.resampleAlgorithmTyp.toString() + "').");
        }
        if (this.fringeSampleOption.isMatched()) {
            String temp = this.fringeSampleOption.getValue().toUpperCase();
            if (temp.startsWith(FringeSampleUtils.FringeSampleTreatment.SKIP.toString().substring(0, 3))) {
                this.fringeSamples = FringeSampleUtils.FringeSampleTreatment.SKIP;
                this.log.info("All samples before the first and after the last GPS time fix will be ignored.");
            } else if (temp.startsWith(FringeSampleUtils.FringeSampleTreatment.NOMINAL.toString().substring(0, 3))) {
                this.fringeSamples = FringeSampleUtils.FringeSampleTreatment.NOMINAL;
                this.log.info("Sample before the first and after the last GPS time fix will be processed assuming the nominal sampling rate.");
            } else if (temp.startsWith(FringeSampleUtils.FringeSampleTreatment.CONSTANT.toString().substring(0, 3))) {
                this.fringeSamples = FringeSampleUtils.FringeSampleTreatment.CONSTANT;
                this.log.info("Samples before the first and after the last GPS time fix will be processed assuming a constant clock drift over the whole recording.");
            } else {
                this.log.severe("Unknown fringe sample treatment method '" + temp + "'. Please use one of " + Arrays.toString((Object[])FringeSampleUtils.FringeSampleTreatment.values()) + " instead.");
                System.exit(64);
            }
        } else {
            this.log.fine("Using the default fringe sample treatment method ('" + this.fringeSamples.toString() + "').");
        }
        if (this.timingControlOption.isMatched()) {
            String qc = this.timingControlOption.getValue().toUpperCase();
            if (qc.startsWith("RUL")) {
                this.timingControl = TimingQualityUtils.QualityControlAlgorithm.RULE_BASED;
                this.log.info("Switching to 'rule based' timing quality control.");
            } else if (qc.startsWith("LLS")) {
                this.timingControl = TimingQualityUtils.QualityControlAlgorithm.LOCAL_LEAST_SQUARES;
                this.log.info("Switching to 'local least squares' fitting for timing quality control.");
            } else if (qc.startsWith("NO")) {
                this.timingControl = TimingQualityUtils.QualityControlAlgorithm.NONE;
                this.log.info("Disabling any timing quality control! Every time tag will be used no matter the quality.");
            } else if (qc.startsWith("FAKE")) {
                this.timingControl = TimingQualityUtils.QualityControlAlgorithm.FAKE_TIME;
                this.log.info("Replacing all (recorded) time information by a new, made-up \"fake\" time!");
                if (this.fringeSamples != FringeSampleUtils.FringeSampleTreatment.NOMINAL) {
                    this.log.severe("Selecting the \"fake\" time algorithm requires the '--fringe-samples=" + (Object)((Object)FringeSampleUtils.FringeSampleTreatment.NOMINAL) + "' command line option to be given as well.");
                    System.exit(64);
                }
            } else {
                this.log.severe("Unknown timing quality control method '" + qc + "'. Please use one of \"LLS\" (Local Least Squares fitting), \"RULE\", \"NONE\" or \"FAKE\" instead.");
                System.exit(64);
            }
        } else {
            this.log.fine("Using the default timing quality control method ('" + this.timingControl.toString() + "').");
        }
    }

    protected void handleCroppingOptions() {
        CroppingMode cropMode = null;
        try {
            TimeMoment traceStop;
            TimeMoment traceStart;
            if (this.traceLengthOption.isMatched() && this.traceStartOption.isMatched() && this.traceStopOption.isMatched()) {
                this.log.severe("At most two of the command line options \"--trace-start\", \"--trace-stop\" or \"--trace-length\" may be used at the same time.");
                System.exit(64);
            } else if (this.traceLengthOption.isMatched() && !this.traceStartOption.isMatched() && !this.traceStopOption.isMatched()) {
                this.log.severe("Using the \"--trace-length\" command line option makes only sense if one of the \"--trace-start\" or \"--trace-stop\" options is used as well!");
                System.exit(64);
            } else if (this.traceStartOption.isMatched() && this.traceStopOption.isMatched()) {
                this.log.fine("Using a time window base on a start and a stop time definition.");
                cropMode = CroppingMode.START_STOP;
            } else if (this.traceStartOption.isMatched()) {
                this.log.fine("Using a time window based on a start time and a time span definition.");
                cropMode = CroppingMode.START_LENGTH;
            } else if (this.traceStopOption.isMatched()) {
                this.log.fine("Using a time window base on a time span and a stop time definition.");
                cropMode = CroppingMode.LENGTH_STOP;
            } else {
                this.log.fine("No time window was defined at the command line.");
                return;
            }
            double traceOffset = DEFAULT_TRACE_OFFSET;
            if (this.traceOffsetOption.isMatched()) {
                try {
                    traceOffset = Double.parseDouble(this.traceOffsetOption.getValue());
                    this.log.info("The time window will be shifted by " + traceOffset + " seconds relative to the given start/stop time.");
                }
                catch (NumberFormatException exp) {
                    this.log.severe("Cannot understand '" + this.traceOffsetOption.getValue() + "'. Please use a correctly formatted trace length value (e.g. \"-10.0\" to shift by ten seconds towards earlier times).");
                }
            } else {
                this.log.fine("Using the default trace offset of " + traceOffset + " seconds.");
            }
            if (this.traceStartOption.isMatched()) {
                traceStart = TimeMoment.parse(this.traceStartOption.getValue());
                if (traceStart.before(new TimeMoment.Builder().date(1950, 1, 0).build())) {
                    this.log.warning("Your start time is before 1-Jan-1950, which is probably not what you want! Typing error? Forgot the century? Anyway, your wish is my command...");
                }
                if (traceOffset > 0.0) {
                    traceStart = TimeSpan.add(traceStart, new TimeSpan.Builder().addSeconds(traceOffset).build());
                } else if (traceOffset < 0.0) {
                    traceStart = TimeSpan.subtract(traceStart, new TimeSpan.Builder().addSeconds(traceOffset).build());
                }
                this.log.fine("Begin of time window: " + traceStart + " (including trace offset)");
            } else {
                traceStart = null;
                this.log.fine("No start time for the time window was given.");
            }
            if (this.traceStopOption.isMatched()) {
                traceStop = TimeMoment.parse(this.traceStopOption.getValue());
                if (traceStop.before(new TimeMoment.Builder().date(1950, 1, 0).build())) {
                    this.log.warning("Your stop time is before 1-Jan-1950, which is probably not what you want! Typing error? Forgot the century? Anyway, your wish is my command...");
                }
                if (traceOffset > 0.0) {
                    traceStop = TimeSpan.add(traceStop, new TimeSpan.Builder().addSeconds(traceOffset).build());
                } else if (traceOffset < 0.0) {
                    traceStop = TimeSpan.subtract(traceStop, new TimeSpan.Builder().addSeconds(traceOffset).build());
                }
                this.log.fine(" End  of time window: " + traceStop + " (including trace offset)");
            } else {
                traceStop = null;
                this.log.fine("No stop  time for the time window was given.");
            }
            TimeSpan traceLength = DEFAULT_TRACE_LENGTH;
            if (this.traceLengthOption.isMatched()) {
                traceLength = TimeSpan.parse(this.traceLengthOption.getValue());
                if (traceLength == null) {
                    this.log.severe("Cannot understand '" + this.traceLengthOption.getValue() + "'. Please use a correctly formatted trace length value (e.g. \"120\" to extract two minutes of data).");
                    System.exit(64);
                }
                if (traceLength.isZeroLength()) {
                    this.log.severe("A trace length of 0 seconds will never return any data!");
                    System.exit(64);
                }
                this.log.fine("Length of time window: " + traceLength);
            } else if (cropMode == CroppingMode.START_LENGTH || cropMode == CroppingMode.LENGTH_STOP) {
                this.log.info("The trace length will be: " + traceLength + " (default)");
            } else {
                this.log.fine("No trace length for clipping was given.");
            }
            if (cropMode == CroppingMode.START_STOP && !traceStart.before(traceStop)) {
                this.log.severe("Invalid time window! The given trace start time must always come before the trace stop time.");
                System.exit(64);
            }
            switch (cropMode) {
                case START_STOP: {
                    this.log.info("Adding time window from " + traceStart + " to " + traceStop);
                    this.windowList.add(new TimeWindow(traceStart, traceStop));
                    break;
                }
                case START_LENGTH: {
                    this.log.info("Adding time window of " + traceLength + " beginning at " + traceStart);
                    this.windowList.add(new TimeWindow(traceStart, traceLength));
                    break;
                }
                case LENGTH_STOP: {
                    this.log.info("Adding time window of " + traceLength + " ending at " + traceStop);
                    this.windowList.add(new TimeWindow(traceLength, traceStop));
                    break;
                }
                default: {
                    this.log.fine("No time window was given at the command line.");
                    break;
                }
            }
        }
        catch (TimeException e) {
            this.log.severe(e.getMessage());
            System.exit(64);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseEventFile() throws IOException {
        if (!this.eventFileOption.isMatched()) {
            this.log.fine("No event file is used.");
            return;
        }
        BufferedReader eventReader = null;
        try {
            String textLine;
            File eventFile = new File(this.eventFileOption.getValue());
            eventReader = new BufferedReader(new FileReader(eventFile));
            this.log.fine("The event file is '" + eventFile.getAbsolutePath() + "'.");
            int lineNumber = 0;
            while ((textLine = eventReader.readLine()) != null) {
                int commentPos;
                this.log.fine("Line #" + ++lineNumber + "  Parsing '" + textLine + "'");
                if ((textLine = textLine.trim()).isEmpty() || (commentPos = textLine.indexOf(35)) == 0) continue;
                if (commentPos > 0) {
                    textLine = textLine.substring(0, commentPos);
                }
                String[] column = textLine.split("\\s+");
                TimeMoment start = null;
                TimeSpan length = null;
                double offset = 0.0;
                if (column.length > 0) {
                    try {
                        start = TimeMoment.parse(column[0]);
                    }
                    catch (TimeException e) {
                        this.log.warning("Line #" + lineNumber + "  " + e.getMessage() + " The line will be ignored and skipped!");
                        continue;
                    }
                }
                if (column.length > 1) {
                    try {
                        length = TimeSpan.parse(column[1]);
                    }
                    catch (TimeException e) {
                        this.log.warning("Line #" + lineNumber + "  " + e.getMessage() + " The line will be ignored and skipped!");
                        continue;
                    }
                }
                if (column.length > 2) {
                    try {
                        offset = Double.parseDouble(column[2]);
                    }
                    catch (NumberFormatException e) {
                        this.log.warning("Line #" + lineNumber + "  Problem parsing '" + column[2] + "' as valid time offset. The line will be ignored and skipped!");
                        continue;
                    }
                }
                if (column.length > 3) {
                    this.log.warning("Line #" + lineNumber + "  Unknown format! Expected one to three columns but detected " + column.length + " columns instead! The line will be ignored and skipped!");
                    continue;
                }
                if (offset > 0.0) {
                    start = TimeSpan.add(start, new TimeSpan.Builder().addSeconds(offset).build());
                } else if (offset < 0.0) {
                    start = TimeSpan.subtract(start, new TimeSpan.Builder().addSeconds(offset).build());
                }
                if (length == null) {
                    length = new TimeSpan.Builder().addMinutes(2L).build();
                }
                TimeWindow window = new TimeWindow(start, length);
                this.log.fine("Line #" + lineNumber + "  Adding time window starting at " + window.getStart() + " (" + window.getLength() + " long).");
                this.windowList.add(window);
            }
        }
        catch (FileNotFoundException e) {
            try {
                this.log.severe("Cannot find the file '" + this.eventFileOption.getValue() + "'. Please verify that the file exist and is it readable?");
                System.exit(66);
            }
            catch (Throwable throwable) {
                FileUtils.flushClose(eventReader);
                throw throwable;
            }
            FileUtils.flushClose(eventReader);
        }
        FileUtils.flushClose(eventReader);
        this.log.info("Finished reading the event file. Marked " + this.windowList.size() + " time windows for processing.");
    }

    /*
     * Exception decompiling
     */
    private void convertTrace(TraceInfo traceInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        Stopwatch totalRunTime = new Stopwatch();
        Stopwatch traceRunTime = new Stopwatch();
        long traceSize = 0L;
        long totalSize = 0L;
        SortedFileSet fileList = null;
        if (!this.cmdLineParser.getArgumentList().isEmpty()) {
            fileList = CubeUtils.buildCubeFileList(this.cmdLineParser.getArgumentList(), this.inputFilter);
            if (fileList.isEmpty()) {
                return;
            }
        } else {
            this.log.severe("No input file was given. At least one Cube input file or directory containing one is required!");
            System.exit(64);
        }
        TraceInfo traceInfo = new TraceInfo();
        for (File cubeFile : fileList) {
            try {
                if (!traceInfo.isContinuous(cubeFile)) {
                    this.log.info("End of trace detected");
                    try {
                        if (traceInfo.getNumberOfSamples() == 0L) {
                            throw new IntegrityException("No Cube samples could be read!");
                        }
                        WnroUtil.wnroCorrection(traceInfo, this.wnroCorrection);
                        TimingQualityUtils.qualityControl(traceInfo, this.timingControl);
                        FringeSampleUtils.includeFringeSamples(traceInfo, this.fringeSamples);
                        this.convertTrace(traceInfo);
                        this.log.info("Converted " + StringUtils.toShortIecByteCount(traceSize) + " in " + traceRunTime);
                    }
                    catch (CubeException | TimeException e) {
                        this.log.severe("Conversion of trace failed! Reason: " + e.getMessage());
                    }
                    finally {
                        traceInfo = new TraceInfo();
                        traceRunTime.restart();
                    }
                }
                this.log.info("Scanning file '" + cubeFile.getName() + "'  (" + StringUtils.toShortIecByteCount(cubeFile.length()) + ")");
                if (CubeUtils.isLeapSecondListOutdated(cubeFile)) {
                    this.log.severe("The available leap second table is too old to process the file '" + cubeFile.getAbsolutePath() + "'! You need an update!!!");
                    continue;
                }
                traceInfo.append(cubeFile);
                traceSize = cubeFile.length();
                totalSize += cubeFile.length();
            }
            catch (FileNotFoundException e) {
                this.log.severe("File '" + cubeFile.getAbsolutePath() + "' disappeared!");
            }
            catch (IOException e) {
                this.log.severe("Couldn't read from file '" + cubeFile.getAbsolutePath() + "'! Permissions?");
            }
            catch (CubeException e) {
                this.log.warning("Cube file format problem! Reason: " + e.getMessage());
                this.log.severe("Cube file '" + cubeFile.getName() + "' is corrupt! Trying to rescue/process data up to the corrupt file position but conversion will be incomplete!");
                break;
            }
        }
        this.log.info("End of (last) trace detected");
        try {
            if (traceInfo.getNumberOfSamples() == 0L) {
                throw new IntegrityException("No Cube samples could be read!");
            }
            WnroUtil.wnroCorrection(traceInfo, this.wnroCorrection);
            TimingQualityUtils.qualityControl(traceInfo, this.timingControl);
            FringeSampleUtils.includeFringeSamples(traceInfo, this.fringeSamples);
            this.convertTrace(traceInfo);
            this.log.info("Converted " + StringUtils.toShortIecByteCount(traceSize) + " in " + traceRunTime);
        }
        catch (CubeException | TimeException e) {
            this.log.severe("Conversion of trace failed! Reason: " + e.getMessage());
        }
        this.log.info("Finished in " + totalRunTime + "  (processed " + StringUtils.toShortIecByteCount(totalSize) + " total)");
    }

    private static enum Resampler {
        SINC,
        LINEAR,
        NONE;

    }

    private static enum CroppingMode {
        NONE,
        START_LENGTH,
        LENGTH_STOP,
        START_STOP;

    }
}

