/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.cube;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.seis.TraceWriter;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.seis.miniseed.EncodingFormat;
import de.gfz_potsdam.gipp.common.seis.miniseed.MiniseedTraceWriter;
import de.gfz_potsdam.gipp.common.time.TimeWindow;
import de.gfz_potsdam.gipp.tool.cube.CubeToOther;
import java.io.IOException;
import java.nio.ByteOrder;

public class CubeToMseed
extends CubeToOther {
    private final CmdLineString outputByteOrderOption = new CmdLineString("byte-order", "Set the byte order of the miniSEED output. Use the values BIG-ENDIAN or LITTLE-ENDIAN to use the respective byte order. The argument NATIVE automatically changes the byte order to the byte order of the currently used platform (e.g. little endian on Intel PCs and big endian on Sun SPARC machines).\nIf this option is not used the program will default to NATIVE format.", new String[]{"BIG-ENDIAN", "LITTLE-ENDIAN", "NATIVE"});
    private final CmdLineString outputRecordSizeOption = new CmdLineString("record-size", "Set the record size of the miniSEED output. The record size is given in bytes and must be a power of two value (e.g. 512, 1024, 2048, ...)\nIf this option is not used the program will default to 4096 byte long records.");
    private final CmdLineString outputEncodingOption = new CmdLineString("encoding", "Set the encoding scheme of the miniSEED output.\nThe program will default to STEIM-1 encoding if this option is not used.", new String[]{"STEIM-1", "STEIM-2", "INT-32", "FLOAT-32", "FLOAT-64"});
    private ByteOrder outputByteOrder = ByteOrder.nativeOrder();
    private int outputRecordSize = 4096;
    private EncodingFormat outputEncoding = EncodingFormat.STEIM_1;

    public CubeToMseed(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.registerOption(this.outputByteOrderOption);
        this.cmdLineParser.registerOption(this.outputRecordSizeOption);
        this.cmdLineParser.registerOption(this.outputEncodingOption);
        this.cmdLineParser.setProgramName("cube2mseed");
        this.cmdLineParser.setProgramDescription("convert Cube data to miniSEED format");
        this.cmdLineParser.setProgramArguments("Cube-FILE|DIRECTORY ...");
    }

    public static void main(String[] args) {
        CubeToMseed cube2mseed = new CubeToMseed(args);
        try {
            cube2mseed.handleCommonOptions();
            cube2mseed.handleGippToolOptions();
            cube2mseed.handleInputOptions();
            cube2mseed.parseEventFile();
            cube2mseed.handleDataQualityOptions();
            cube2mseed.handleConversionOptions();
            cube2mseed.handleCroppingOptions();
            cube2mseed.handleMseedFormatOptions();
            cube2mseed.handleOutputOptions();
            cube2mseed.run();
        }
        catch (CmdLineException e) {
            cube2mseed.logThrowable(e);
            System.exit(64);
        }
        catch (IntegrityException e) {
            cube2mseed.logThrowable(e);
            System.exit(65);
        }
        catch (IOException e) {
            cube2mseed.logThrowable(e);
            System.exit(74);
        }
        catch (OutOfMemoryError e) {
            cube2mseed.log.severe("Ran out of memory! Please reduce the amount of Cube input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            cube2mseed.logThrowable(e);
            System.exit(99);
        }
    }

    private void handleMseedFormatOptions() {
        if (this.outputByteOrderOption.isMatched()) {
            String order = this.outputByteOrderOption.getValue().toUpperCase();
            if (order.startsWith("BIG")) {
                this.outputByteOrder = ByteOrder.BIG_ENDIAN;
            } else if (order.startsWith("LIT")) {
                this.outputByteOrder = ByteOrder.LITTLE_ENDIAN;
            } else if (order.startsWith("NAT")) {
                this.outputByteOrder = ByteOrder.nativeOrder();
            } else {
                this.log.severe("Unknown byte order format '" + order + "'. Please use one of 'BIG-ENDIAN', 'LITTLE-ENDIAN' or 'NATIVE' instead.");
                System.exit(64);
            }
            this.log.info("The miniSEED output will be in " + this.outputByteOrder.toString() + " byte order.");
        } else {
            this.log.fine("Using the " + this.outputByteOrder.toString() + " byte order for writing.");
        }
        if (this.outputRecordSizeOption.isMatched()) {
            long size = Long.parseLong(this.outputRecordSizeOption.getValue());
            byte exponent = (byte)Math.round(Math.ceil(Math.log(size) / Math.log(2.0)));
            this.outputRecordSize = 1 << exponent;
            if (size < 64L) {
                this.log.severe("A MiniSEED record must be at least 64 bytes long.");
                System.exit(64);
            }
            if (size >= Integer.MAX_VALUE) {
                this.log.severe("Cannot allocate memory for a MiniSEED record of this size. Please use a smaller record size. A typical record size is 4096 bytes!");
                System.exit(64);
            }
            if ((long)this.outputRecordSize != size) {
                this.log.warning("The miniSEED record size must be a power of two. Increasing record size to " + this.outputRecordSize + " bytes for all output!");
            } else {
                this.log.info("The miniSEED output will use " + this.outputRecordSize + " byte long records.");
            }
        } else {
            this.log.fine("Using " + this.outputRecordSize + " byte long miniSEED records for writing.");
        }
        if (this.outputEncodingOption.isMatched()) {
            String codec;
            switch (codec = this.outputEncodingOption.getValue().toUpperCase()) {
                case "STEIM-1": {
                    this.outputEncoding = EncodingFormat.STEIM_1;
                    break;
                }
                case "STEIM-2": {
                    this.outputEncoding = EncodingFormat.STEIM_2;
                    break;
                }
                case "INT-32": {
                    this.outputEncoding = EncodingFormat.INT_32;
                    break;
                }
                case "FLOAT-32": {
                    this.outputEncoding = EncodingFormat.IEEE_FLOAT;
                    break;
                }
                case "FLOAT-64": {
                    this.outputEncoding = EncodingFormat.IEEE_DOUBLE;
                    break;
                }
                default: {
                    this.log.severe("Unknown encoding format '" + codec + "'. Please use one of 'STEIM-1', 'STEIM-2', 'INT-32', 'FLOAT-32' or 'FLOAT-64' instead.");
                    System.exit(64);
                }
            }
            this.log.info("The miniSEED output will use " + (Object)((Object)this.outputEncoding) + ".");
        } else {
            this.log.fine("Using " + this.outputEncoding.toString() + " encoding for writing.");
        }
    }

    @Override
    protected TraceWriter getWriter(TraceInfo traceInfo, TimeWindow requestWindow) {
        assert (traceInfo != null) : "Variable 'traceInfo' must not be 'null'!";
        assert (requestWindow != null) : "Variable 'requestWindow' must not be 'null'!";
        MiniseedTraceWriter outWriter = MiniseedTraceWriter.newFromCube(traceInfo, this.outputDir, this.forceOverwrite, requestWindow);
        if (this.outputRecordSize > 0) {
            outWriter.setRecordSize(this.outputRecordSize);
        }
        if (this.outputByteOrder != null) {
            outWriter.setByteOrder(this.outputByteOrder);
        }
        if (this.outputEncoding != null) {
            outWriter.setEncoding(this.outputEncoding);
        }
        this.log.fine("Successfully initialized a new miniSEED trace writer.");
        return outWriter;
    }
}

