/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.cube;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.seis.TraceWriter;
import de.gfz_potsdam.gipp.common.seis.ascii.AsciiTraceWriter;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.time.TimeWindow;
import de.gfz_potsdam.gipp.tool.cube.CubeToOther;
import java.io.IOException;
import java.util.Arrays;

public class CubeToAscii
extends CubeToOther {
    private final CmdLineString outputFormatOption = new CmdLineString("format", "Change the output format. Pick one of the following:\n ALL ........ Combination of HEADER and DATA. (Default)\n HEADER ..... Only Cube (trace) header information. No samples!\n DATA ....... Sample values and recording time but no header.\n CHANNELn ... Sample values of recording channel #n only.\n              (Channels are numbered starting with '0'. If \n              the number is missing all channels are written.)", null);
    private OutputFormat outputFormat = OutputFormat.ALL;

    public CubeToAscii(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.registerOption(this.outputFormatOption);
        this.cmdLineParser.setProgramName("cube2ascii");
        this.cmdLineParser.setProgramDescription("convert Cube data to ASCII format");
        this.cmdLineParser.setProgramArguments("Cube-FILE|DIRECTORY ...");
    }

    public static void main(String[] args) {
        CubeToAscii cube2ascii = new CubeToAscii(args);
        try {
            cube2ascii.handleCommonOptions();
            cube2ascii.handleGippToolOptions();
            cube2ascii.handleInputOptions();
            cube2ascii.parseEventFile();
            cube2ascii.handleDataQualityOptions();
            cube2ascii.handleCroppingOptions();
            cube2ascii.handleConversionOptions();
            cube2ascii.handleFormattingOptions();
            cube2ascii.handleOutputOptions();
            cube2ascii.run();
        }
        catch (CmdLineException e) {
            cube2ascii.logThrowable(e);
            System.exit(64);
        }
        catch (IntegrityException e) {
            cube2ascii.logThrowable(e);
            System.exit(65);
        }
        catch (IOException e) {
            cube2ascii.logThrowable(e);
            System.exit(74);
        }
        catch (OutOfMemoryError e) {
            cube2ascii.log.severe("Ran out of memory! Please reduce the amount of Cube input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            cube2ascii.logThrowable(e);
            System.exit(99);
        }
    }

    private void handleFormattingOptions() {
        if (this.outputFormatOption.isMatched()) {
            String format = this.outputFormatOption.getValue().toUpperCase();
            if (format.startsWith(OutputFormat.ALL.toString().substring(0, 3))) {
                this.outputFormat = OutputFormat.ALL;
                this.log.info("Switching to '" + (Object)((Object)this.outputFormat) + "' output format.");
            } else if (format.startsWith(OutputFormat.HEADER.toString().substring(0, 3))) {
                this.outputFormat = OutputFormat.HEADER;
                this.log.info("Switching to '" + (Object)((Object)this.outputFormat) + "' output format.");
            } else if (format.startsWith(OutputFormat.DATA.toString().substring(0, 3))) {
                this.outputFormat = OutputFormat.DATA;
                this.log.info("Switching to '" + (Object)((Object)this.outputFormat) + "' output format.");
            } else if (format.startsWith(OutputFormat.CHANNELS_ALL.toString().substring(0, 3))) {
                switch (format.charAt(format.length() - 1)) {
                    case '0': {
                        this.outputFormat = OutputFormat.CHANNEL_0;
                        break;
                    }
                    case '1': {
                        this.outputFormat = OutputFormat.CHANNEL_1;
                        break;
                    }
                    case '2': {
                        this.outputFormat = OutputFormat.CHANNEL_2;
                        break;
                    }
                    case '3': {
                        this.outputFormat = OutputFormat.CHANNEL_3;
                        break;
                    }
                    case '4': {
                        this.outputFormat = OutputFormat.CHANNEL_4;
                        break;
                    }
                    case '5': {
                        this.outputFormat = OutputFormat.CHANNEL_5;
                        break;
                    }
                    case '6': {
                        this.outputFormat = OutputFormat.CHANNEL_6;
                        break;
                    }
                    case '7': {
                        this.outputFormat = OutputFormat.CHANNEL_7;
                        break;
                    }
                    default: {
                        this.outputFormat = OutputFormat.CHANNELS_ALL;
                    }
                }
                this.log.info("Switching to '" + (Object)((Object)this.outputFormat) + "' output format.");
            } else {
                this.log.severe("Unknown output format '" + format + "'. Please use one of " + Arrays.toString((Object[])OutputFormat.values()) + " instead.");
                System.exit(64);
            }
        } else {
            this.log.fine("Using the default output mode ('" + this.outputFormat.toString() + "').");
        }
    }

    @Override
    protected TraceWriter getWriter(TraceInfo traceInfo, TimeWindow requestWindow) {
        assert (traceInfo != null) : "Variable 'traceInfo' must not be 'null'!";
        assert (requestWindow != null) : "Variable 'requestWindow' must not be 'null'!";
        AsciiTraceWriter writer = AsciiTraceWriter.newFromCube(traceInfo, this.outputDir, this.forceOverwrite, requestWindow);
        switch (this.outputFormat) {
            case ALL: {
                writer.addFullCubeHeader(traceInfo);
                writer.enableAllColumns();
                break;
            }
            case HEADER: {
                writer.addFullCubeHeader(traceInfo);
                writer.addOutputChannels(new int[0]);
                break;
            }
            case DATA: {
                writer.clearStaticHeader();
                writer.enableAllColumns();
                break;
            }
            case CHANNELS_ALL: {
                writer.enableDefaultHeader();
                int channel = 0;
                while (channel < traceInfo.getNumberOfChannels()) {
                    writer.addOutputChannels(channel++);
                }
                break;
            }
            case CHANNEL_0: {
                writer.enableDefaultHeader();
                writer.addOutputChannels(0);
                break;
            }
            case CHANNEL_1: {
                writer.enableDefaultHeader();
                writer.addOutputChannels(1);
                break;
            }
            case CHANNEL_2: {
                writer.enableDefaultHeader();
                writer.addOutputChannels(2);
                break;
            }
            case CHANNEL_3: {
                writer.enableDefaultHeader();
                writer.addOutputChannels(3);
                break;
            }
            case CHANNEL_4: {
                writer.enableDefaultHeader();
                writer.addOutputChannels(4);
                break;
            }
            case CHANNEL_5: {
                writer.enableDefaultHeader();
                writer.addOutputChannels(5);
                break;
            }
            case CHANNEL_6: {
                writer.enableDefaultHeader();
                writer.addOutputChannels(6);
                break;
            }
            case CHANNEL_7: {
                writer.enableDefaultHeader();
                writer.addOutputChannels(7);
            }
        }
        this.log.fine("Successfully initialized a new ASCII trace writer.");
        return writer;
    }

    private static enum OutputFormat {
        ALL,
        HEADER,
        DATA,
        CHANNELS_ALL,
        CHANNEL_0,
        CHANNEL_1,
        CHANNEL_2,
        CHANNEL_3,
        CHANNEL_4,
        CHANNEL_5,
        CHANNEL_6,
        CHANNEL_7;

    }
}

