/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.cube;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.crypto.GippSecurityProvider;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.ChecksumBlock;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.Stopwatch;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.Locale;

public class CubeSum
extends GippToolsApplication {
    private static final Locale OUTPUT_LOCALE = Locale.ENGLISH;
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newCubeInputFilterOption();
    private final CmdLineBoolean verifyChecksumOption = new CmdLineBoolean("verify", "Verify checksums already contained in the Cube input.");
    private final CmdLineBoolean addChecksumOption = new CmdLineBoolean("add", "Add checksum information to the Cube input.");
    private final CmdLineBoolean removeChecksumOption = new CmdLineBoolean("remove", "Remove all checksums from the Cube input.");
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private RegexFilenameFilter inputFilter = null;
    private OperationMode mode = OperationMode.VERIFY;
    private File outputDir = null;
    private boolean forceOverwrite = false;

    public CubeSum(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.registerOption(this.verifyChecksumOption);
        this.cmdLineParser.registerOption(this.addChecksumOption);
        this.cmdLineParser.registerOption(this.removeChecksumOption);
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.setProgramName("cubesum");
        this.cmdLineParser.setProgramDescription("compute and verify checksums (CRCs) of a Cube recording");
        this.cmdLineParser.setProgramArguments("[Cube-FILE|DIRECTORY]...");
    }

    public static void main(String[] args) {
        CubeSum cubesum = new CubeSum(args);
        try {
            cubesum.handleCommonOptions();
            cubesum.handleGippToolOptions();
            cubesum.handleInputOptions();
            cubesum.handleChecksumOptions();
            cubesum.handleOutputOptions();
            cubesum.run();
        }
        catch (CmdLineException e) {
            cubesum.logThrowable(e);
            System.exit(64);
        }
        catch (IOException e) {
            cubesum.logThrowable(e);
            System.exit(74);
        }
        catch (OutOfMemoryError e) {
            cubesum.log.severe("Ran out of memory! Please reduce the amount of Cube input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            cubesum.logThrowable(e);
            System.exit(99);
        }
    }

    private void handleInputOptions() {
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addCubeFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP Cube filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing files will not be overwritten.");
        }
        if (!this.outputDirOption.isMatched()) {
            this.outputDir = null;
            this.log.fine("All results will be written to \"standard output\" (console).");
            return;
        }
        this.outputDir = new File(this.outputDirOption.getValue());
        if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
            this.log.info("Modified Cube files will be written to the '" + this.outputDir.getPath() + "' directory.");
            return;
        }
        this.outputDir = null;
        throw new CmdLineException("Cannot write to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
    }

    void handleChecksumOptions() {
        if (this.verifyChecksumOption.isMatched() && this.addChecksumOption.isMatched() || this.verifyChecksumOption.isMatched() && this.removeChecksumOption.isMatched() || this.removeChecksumOption.isMatched() && this.addChecksumOption.isMatched()) {
            throw new CmdLineException("Only one of " + this.verifyChecksumOption.getLongSyntax() + ", " + this.addChecksumOption.getLongSyntax() + " or " + this.removeChecksumOption.getLongSyntax() + " is allowed at a time!");
        }
        if (this.addChecksumOption.isMatched()) {
            this.mode = OperationMode.INJECT;
            this.log.info("Checksum information will be added to the Cube input.");
        } else if (this.removeChecksumOption.isMatched()) {
            this.mode = OperationMode.REMOVE;
            this.log.info("All checksum information will be removed from the Cube input.");
        } else {
            this.mode = OperationMode.VERIFY;
            this.log.info("Checksums contained in the Cube input will be verified.");
        }
    }

    private void verifyChecksum(MessageDigest crc, File cubeFile) throws IntegrityException, IOException {
        String id;
        ChecksumBlock checksum = new ChecksumBlock();
        BinaryBlock block = new BinaryBlock();
        long blockCount = 0L;
        boolean crcDetected = false;
        boolean crcMismatch = false;
        boolean eof = false;
        BufferedInputStream inStream = cubeFile == null ? new BufferedInputStream(System.in) : new BufferedInputStream(Files.newInputStream(cubeFile.toPath(), new OpenOption[0]));
        int blockType = inStream.read();
        if (blockType < 128) {
            throw new IntegrityException("Data stream does not start with Cube block 'header'.");
        }
        block5: while (!eof) {
            ++blockCount;
            switch (blockType) {
                case 236: {
                    crcDetected = true;
                    blockType = checksum.read(inStream);
                    if (checksum.verify(crc)) {
                        this.log.info("Checksum (block #" + StringUtils.TEN_DIGITS.format(blockCount) + "): Okay");
                        continue block5;
                    }
                    crcMismatch = true;
                    this.log.info("Checksum (block #" + StringUtils.TEN_DIGITS.format(blockCount) + "): Mismatch");
                    continue block5;
                }
                case -1: {
                    eof = true;
                    continue block5;
                }
                case 240: {
                    crc.reset();
                }
            }
            crc.update((byte)blockType);
            blockType = block.read(inStream);
            block.updateDigest(crc);
        }
        PrintWriter out = new PrintWriter(System.out);
        String string = id = cubeFile == null ? "" : cubeFile.getName() + " : ";
        if (crcDetected) {
            if (crcMismatch) {
                out.format(OUTPUT_LOCALE, "%sFAIL  (Checksum mismatch!)%n", id);
            } else {
                out.format(OUTPUT_LOCALE, "%sokay%n", id);
            }
        } else {
            out.format(OUTPUT_LOCALE, "%sn/a  (Cube data does not contain checksum information.)%n", id);
        }
        out.flush();
    }

    private void injectChecksum(MessageDigest crc, File cubeFile) throws IntegrityException, IllegalArgumentException, IOException {
        BinaryBlock block = new BinaryBlock();
        boolean eof = false;
        boolean crcDetected = false;
        int crcAdded = 0;
        BufferedInputStream inStream = cubeFile == null ? new BufferedInputStream(System.in) : new BufferedInputStream(Files.newInputStream(cubeFile.toPath(), new OpenOption[0]));
        int nextBlockType = inStream.read();
        if (nextBlockType < 128) {
            throw new IntegrityException("Data stream does not start with Cube block 'header'.");
        }
        try (OutputStream outStream = CubeUtils.newCubeOutputStream(this.outputDir, cubeFile, this.forceOverwrite);){
            block15: while (!eof) {
                int currentBlockType;
                switch (nextBlockType) {
                    case 239: {
                        currentBlockType = nextBlockType;
                        nextBlockType = block.read(inStream);
                        if (crcDetected) {
                            crc.reset();
                        } else {
                            String crcText = crc.getAlgorithm() + "=" + StringUtils.toHexString(crc.digest());
                            outStream.write(236);
                            outStream.write(crcText.getBytes(StandardCharsets.US_ASCII));
                            ++crcAdded;
                        }
                        outStream.write(currentBlockType);
                        outStream.write(block.getContent());
                        crc.update((byte)currentBlockType);
                        block.updateDigest(crc);
                        continue block15;
                    }
                    case -1: {
                        eof = true;
                        continue block15;
                    }
                    case 236: {
                        crcDetected = true;
                        currentBlockType = nextBlockType;
                        nextBlockType = block.read(inStream);
                        outStream.write(currentBlockType);
                        outStream.write(block.getContent());
                        crc.reset();
                        continue block15;
                    }
                    case 240: {
                        crc.reset();
                    }
                }
                currentBlockType = nextBlockType;
                nextBlockType = block.read(inStream);
                outStream.write(currentBlockType);
                outStream.write(block.getContent());
                crc.update((byte)currentBlockType);
                block.updateDigest(crc);
            }
        }
        if (crcDetected) {
            this.log.warning("Cube input already contained checksum information!");
        }
        if (crcAdded == 0) {
            this.log.info("No checksum blocks were added to the Cube input.");
        } else if (crcAdded == 1) {
            this.log.info("Added " + crcAdded + " checksum block.");
        } else {
            this.log.info("Added " + crcAdded + " checksum blocks.");
        }
    }

    private void removeChecksum(File cubeFile) throws IllegalArgumentException, IOException, IntegrityException {
        BinaryBlock block = new BinaryBlock();
        boolean crcDetected = false;
        boolean eof = false;
        BufferedInputStream inStream = cubeFile == null ? new BufferedInputStream(System.in) : new BufferedInputStream(Files.newInputStream(cubeFile.toPath(), new OpenOption[0]));
        int nextType = ((InputStream)inStream).read();
        if (nextType < 128) {
            throw new IntegrityException("Data stream does not start with Cube block 'header'.");
        }
        try (OutputStream outStream = CubeUtils.newCubeOutputStream(this.outputDir, cubeFile, this.forceOverwrite);){
            block13: while (!eof) {
                switch (nextType) {
                    case 236: {
                        crcDetected = true;
                        nextType = Block.skip(inStream);
                        continue block13;
                    }
                    case -1: {
                        eof = true;
                        continue block13;
                    }
                }
                outStream.write(nextType);
                nextType = block.read(inStream);
                outStream.write(block.getContent());
            }
        }
        if (crcDetected) {
            this.log.info("Removed checksum information.");
        } else {
            this.log.warning("Cube data did not contain checksum information.");
        }
    }

    private void run() throws IOException, FileNotFoundException, NoSuchAlgorithmException, NoSuchProviderException {
        Stopwatch totalRunTime = new Stopwatch();
        Security.addProvider(new GippSecurityProvider());
        MessageDigest crc = MessageDigest.getInstance("CRC-32", "GIPP");
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            this.log.info("Reading Cube data from \"standard input\".");
            switch (this.mode) {
                case VERIFY: {
                    this.verifyChecksum(crc, null);
                    break;
                }
                case INJECT: {
                    this.injectChecksum(crc, null);
                    break;
                }
                case REMOVE: {
                    this.removeChecksum(null);
                }
            }
        } else {
            this.log.info("Building list of input files..");
            SortedFileSet fileSet = CubeUtils.buildCubeFileList(this.cmdLineParser.getArgumentList(), this.inputFilter);
            if (fileSet.isEmpty()) {
                this.log.severe("Not a single input file was found!");
            }
            for (File cubeFile : fileSet) {
                this.log.info("Processing file '" + cubeFile.getCanonicalPath() + "' ..");
                switch (this.mode) {
                    case VERIFY: {
                        this.verifyChecksum(crc, cubeFile);
                        break;
                    }
                    case INJECT: {
                        this.injectChecksum(crc, cubeFile);
                        break;
                    }
                    case REMOVE: {
                        this.removeChecksum(cubeFile);
                    }
                }
            }
            this.log.info("finished in " + totalRunTime);
        }
    }

    private static enum OperationMode {
        VERIFY,
        INJECT,
        REMOVE;

    }
}

