/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.cube;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortByCubeStream;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.DataRecorderSampleBlock;
import de.gfz_potsdam.gipp.common.seis.cube.EventRecorderSampleBlock;
import de.gfz_potsdam.gipp.common.seis.cube.HeaderBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.LostSamplesBlock;
import de.gfz_potsdam.gipp.common.seis.cube.SampleBlock;
import de.gfz_potsdam.gipp.common.seis.cube.SystemEventBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TaipBlock;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.LeapSecondInfo;
import de.gfz_potsdam.gipp.common.time.Stopwatch;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CubeInspect
extends GippToolsApplication {
    private static final Locale OUTPUT_LOCALE = Locale.ENGLISH;
    private static final int DEFAULT_DUMMY_VALUE = 0;
    private static final String CONSOLE_INPUT = "STD_IN";
    private static final String MODIFIED_FILE = ".modified.";
    private final List<CubeStatistics> cubeStatistics;
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newCubeInputFilterOption();
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private final CmdLineBoolean inspectionModeOption = new CmdLineBoolean("inspect", "Inspect files and diagnose problems");
    private final CmdLineBoolean repairBufferOverrunOption = new CmdLineBoolean("repair-buffer-overrun", "Repair buffer overrun system errors.");
    private OperationalMode operationalMode = OperationalMode.INSPECTION;
    private RegexFilenameFilter inputFilter = null;
    private File outputDir = null;
    private boolean forceOverwrite = false;

    public CubeInspect(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cubeStatistics = new ArrayList<CubeStatistics>();
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.inspectionModeOption);
        this.cmdLineParser.registerOption(this.repairBufferOverrunOption);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.setProgramName("cubeinspect");
        this.cmdLineParser.setProgramDescription("inspect Cube files searching for problems");
        this.cmdLineParser.setProgramArguments("Cube-FILE|DIRECTORY...");
    }

    public static void main(String[] args) {
        CubeInspect cubeInspect = new CubeInspect(args);
        try {
            cubeInspect.handleCommonOptions();
            cubeInspect.handleGippToolOptions();
            cubeInspect.handleInputOptions();
            cubeInspect.handleInspectionOptions();
            cubeInspect.handleOutputOptions();
            cubeInspect.run();
        }
        catch (CmdLineException e) {
            cubeInspect.logThrowable(e);
            System.exit(64);
        }
        catch (IOException e) {
            cubeInspect.logThrowable(e);
            System.exit(74);
        }
        catch (OutOfMemoryError e) {
            cubeInspect.log.severe("Ran out of memory! Please reduce the amount of Cube input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            cubeInspect.logThrowable(e);
            System.exit(99);
        }
    }

    private void handleInputOptions() {
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addCubeFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP Cube filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing files will not be overwritten.");
        }
        if (!this.outputDirOption.isMatched()) {
            this.outputDir = null;
            this.log.fine("All results will be written to \"standard output\" (console).");
            return;
        }
        this.outputDir = new File(this.outputDirOption.getValue());
        if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
            this.log.info("Modified Cube files will be written to the '" + this.outputDir.getPath() + "' directory.");
            return;
        }
        this.outputDir = null;
        throw new CmdLineException("Cannot write to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
    }

    private void handleInspectionOptions() {
        if (this.inspectionModeOption.isMatched() && this.repairBufferOverrunOption.isMatched()) {
            throw new CmdLineException("Only one of the '" + this.inspectionModeOption.getLongSyntax() + "' or '" + this.repairBufferOverrunOption.getLongSyntax() + "' options is allowed at a time.");
        }
        if (this.inspectionModeOption.isMatched()) {
            this.operationalMode = OperationalMode.INSPECTION;
            this.log.info("Running in \"inspection/diagnostic\" mode.");
        } else if (this.repairBufferOverrunOption.isMatched()) {
            this.operationalMode = OperationalMode.REPAIR_BUFFER_OVERRUN;
            this.log.info("Switching to \"repair-buffer-overrun-errors\" mode.");
        } else {
            this.operationalMode = OperationalMode.INSPECTION;
            this.log.fine("No operational mode selected. Default to inspecting files.");
        }
    }

    private void reportStatistics(PrintWriter writer, List<CubeStatistics> statistics) {
        if (statistics == null || statistics.isEmpty()) {
            this.log.severe("No statistics were collected! There is nothing to report.");
            return;
        }
        for (CubeStatistics stat : statistics) {
            StringBuilder channelNames = new StringBuilder();
            StringBuilder channelGains = new StringBuilder();
            StringBuilder channelMinima = new StringBuilder();
            StringBuilder channelMaxima = new StringBuilder();
            StringBuilder channelClippedValues = new StringBuilder();
            for (int i = 0; i < stat.enabledChannels; ++i) {
                if (i == 0) {
                    channelNames.append(String.format("%8s", CubeUtils.channelNumberToGippName(i)));
                    channelGains.append(String.format("%8d", stat.gainSettings[i]));
                    channelMinima.append(String.format("%+8d", stat.minValues[i]));
                    channelMaxima.append(String.format("%+8d", stat.maxValues[i]));
                    channelClippedValues.append(String.format("%8d", stat.clippedValues[i]));
                    continue;
                }
                channelNames.append("  ").append(String.format("%8s", CubeUtils.channelNumberToGippName(i)));
                channelGains.append("  ").append(String.format("%8d", stat.gainSettings[i]));
                channelMinima.append("  ").append(String.format("%+8d", stat.minValues[i]));
                channelMaxima.append("  ").append(String.format("%+8d", stat.maxValues[i]));
                channelClippedValues.append("  ").append(String.format("%8d", stat.clippedValues[i]));
            }
            String overrunInfo = stat.bufferOverrun_Count == 0L ? "0" : (stat.bufferOverrun_LostSamples == 0L ? String.format("%d  (unknown number of lost samples)", stat.bufferOverrun_Count) : String.format("%d  (%d lost samples)", stat.bufferOverrun_Count, stat.bufferOverrun_LostSamples));
            String wnroInfo = stat.wnroEvent_Detected ? "1  (automatic correction used)" : "0";
            assert (stat.dataSource != null);
            if (!stat.dataSource.equals(CONSOLE_INPUT)) {
                writer.format(OUTPUT_LOCALE, "# --- FILE -------------------------------------------------------------%n", new Object[0]);
                if (StringUtils.containsWhitespace(stat.dataSource)) {
                    writer.format(OUTPUT_LOCALE, "#                file name:  '%s'%n", stat.dataSource);
                } else {
                    writer.format(OUTPUT_LOCALE, "#                file name:  %s%n", stat.dataSource);
                }
            }
            writer.format(OUTPUT_LOCALE, "# --- SYSTEM -----------------------------------------------------------%n", new Object[0]);
            writer.format(OUTPUT_LOCALE, "#              recorder ID:  %s%n", stat.recorderID);
            writer.format(OUTPUT_LOCALE, "#                 firmware:  %s%n", stat.firmwareRelease);
            writer.format(OUTPUT_LOCALE, "# --- DATA -------------------------------------------------------------%n", new Object[0]);
            writer.format(OUTPUT_LOCALE, "#         enabled channels:  %d%n", stat.enabledChannels);
            writer.format(OUTPUT_LOCALE, "#              sample rate:  %d%n", stat.sampleRate);
            writer.format(OUTPUT_LOCALE, "#        number of samples:  %d%n", stat.numberOfSamples);
            writer.format(OUTPUT_LOCALE, "#         primary channels:  %s%n", channelNames);
            writer.format(OUTPUT_LOCALE, "#             channel gain:  %s%n", channelGains);
            writer.format(OUTPUT_LOCALE, "#           channel minima:  %s%n", channelMinima);
            writer.format(OUTPUT_LOCALE, "#           channel maxima:  %s%n", channelMaxima);
            writer.format(OUTPUT_LOCALE, "#     clipped values count:  %s%n", channelClippedValues);
            writer.format(OUTPUT_LOCALE, "# --- PROBLEMS ---------------------------------------------------------%n", new Object[0]);
            writer.format(OUTPUT_LOCALE, "#          buffer overruns:  %s%n", overrunInfo);
            writer.format(OUTPUT_LOCALE, "#               WNRO event:  %s%n", wnroInfo);
            writer.format(OUTPUT_LOCALE, "#          clipped samples:  %d%n", stat.clippedSamples);
            writer.format(OUTPUT_LOCALE, "# ----------------------------------------------------------------------%n", new Object[0]);
            writer.format(OUTPUT_LOCALE, "%n", new Object[0]);
        }
    }

    private void checkHeaderBlock(long blockCount, CubeStatistics stats, HeaderBlock header) {
        this.log.fine("Block " + String.format("#%010d", blockCount) + " - Checking 'header block' .. ");
        stats.recorderID = header.cubeName();
        stats.firmwareRelease = header.firmwareVersionInfo();
        stats.enabledChannels = header.enabledChannels();
        stats.sampleRate = header.sampleRate();
        assert (stats.enabledChannels < 8);
        for (int i = 0; i < header.channelGains().size(); ++i) {
            ((CubeStatistics)stats).gainSettings[i] = header.channelGains().get(i);
        }
        if (header.wnroCorrection() != null && header.wnroCorrection().moreThan(TimeSpan.ZERO)) {
            stats.wnroEvent_Detected = true;
        }
    }

    private void checkSampleBlock(long blockCount, CubeStatistics stats, SampleBlock dataSample, int minClipValue, int maxClipValue) {
        this.log.fine("Block " + String.format("#%010d", blockCount) + " - Checking 'sample block' .. ");
        stats.numberOfSamples = stats.numberOfSamples + 1L;
        boolean clipped = false;
        int[] samples = dataSample.getAllValues();
        for (int i = 0; i < samples.length; ++i) {
            ((CubeStatistics)stats).minValues[i] = Math.min(stats.minValues[i], samples[i]);
            ((CubeStatistics)stats).maxValues[i] = Math.max(stats.maxValues[i], samples[i]);
            if (samples[i] != maxClipValue && samples[i] != minClipValue) continue;
            int[] nArray = stats.clippedValues;
            int n = i;
            nArray[n] = nArray[n] + 1;
            clipped = true;
        }
        if (clipped) {
            stats.clippedSamples = stats.clippedSamples + 1L;
        }
    }

    private void checkTaipBlock(long blockCount, CubeStatistics stats, TaipBlock taip) {
        this.log.fine("Block " + String.format("#%010d", blockCount) + " - Checking 'TAIP block' .. ");
        if (!stats.wnroEvent_Detected) {
            try {
                String gpsTime = taip.getGpsDateTimeInfo();
                if (gpsTime != null) {
                    int sourceOffset = taip.getSourceOffset();
                    int iersOffset = LeapSecondInfo.getGpsUtcOffset(gpsTime);
                    if (sourceOffset != 0 && Math.abs(sourceOffset - iersOffset) > 1) {
                        stats.wnroEvent_Detected = true;
                    }
                }
            }
            catch (IntegrityException | TimeException exp) {
                this.log.info("Exception caught while handling 'TAIP block'. (" + exp.getMessage() + ")");
            }
        }
    }

    private void checkSystemEventBlock(long blockCount, CubeStatistics stats, SystemEventBlock systemEvent) {
        this.log.fine("Block " + String.format("#%010d", blockCount) + " - Checking 'system event block' .. ");
        if (systemEvent.ringBufferOverrunIsOn()) {
            this.log.info("Block " + String.format("#%010d", blockCount) + " - 'Buffer Overrun Error' detected!");
            stats.bufferOverrun_Count = stats.bufferOverrun_Count + 1L;
            stats.bufferOverrun_LostSamples = stats.bufferOverrun_LostSamples + (long)systemEvent.numberOfMissingSamples();
        }
    }

    private void checkLostSamplesBlock(long blockCount, CubeStatistics stats, LostSamplesBlock lostSamples) {
        this.log.info("Block " + String.format("#%010d", blockCount) + " - 'Lost Samples' information detected.");
        stats.bufferOverrun_LostSamples = stats.bufferOverrun_LostSamples + (long)lostSamples.getSamplesLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CubeStatistics inspectRecording(File inFile) {
        DataInputStream inputStream = null;
        CubeStatistics inputStats = null;
        try {
            this.log.info("-- Inspecting '" + inFile.getName() + "' --");
            inputStream = new DataInputStream(new BufferedInputStream(Files.newInputStream(inFile.toPath(), new OpenOption[0])));
            inputStats = this.inspectRecording(inputStream, inFile.getName());
            if (inputStats.bufferOverrun_Count > 0L || inputStats.clippedSamples > 0L) {
                this.log.info("Found one or more issues. Please see report for details.");
            } else {
                this.log.info("No problems found.");
            }
            FileUtils.flushClose(inputStream);
        }
        catch (IOException | SecurityException exp) {
            this.log.severe("Could not read file '" + inFile.getName() + "' (" + exp.getMessage() + ").");
        }
        finally {
            FileUtils.flushClose(inputStream);
        }
        return inputStats;
    }

    private CubeStatistics inspectRecording(DataInput cubeIn, String streamID) {
        CubeStatistics result = new CubeStatistics(streamID);
        int blockCount = 0;
        try {
            HeaderBlock header = new HeaderBlock();
            DataRecorderSampleBlock dataSample = new DataRecorderSampleBlock();
            EventRecorderSampleBlock eventSample = new EventRecorderSampleBlock();
            TaipBlock taip = new TaipBlock();
            SystemEventBlock systemEvent = new SystemEventBlock();
            LostSamplesBlock lostSamples = new LostSamplesBlock();
            boolean eof = false;
            int blockFlag = cubeIn.readUnsignedByte();
            block11: while (!eof) {
                ++blockCount;
                switch (blockFlag) {
                    case 240: {
                        blockFlag = header.read(cubeIn);
                        this.checkHeaderBlock(blockCount, result, header);
                        continue block11;
                    }
                    case 128: 
                    case 144: {
                        blockFlag = dataSample.read(cubeIn);
                        this.checkSampleBlock(blockCount, result, dataSample, DataRecorderSampleBlock.MIN_VALUE, DataRecorderSampleBlock.MAX_VALUE);
                        continue block11;
                    }
                    case 136: 
                    case 152: {
                        blockFlag = eventSample.read(cubeIn);
                        this.checkSampleBlock(blockCount, result, eventSample, EventRecorderSampleBlock.MIN_VALUE, EventRecorderSampleBlock.MAX_VALUE);
                        continue block11;
                    }
                    case 160: {
                        blockFlag = taip.read(cubeIn);
                        this.checkTaipBlock(blockCount, result, taip);
                        continue block11;
                    }
                    case 192: {
                        blockFlag = systemEvent.read(cubeIn);
                        this.checkSystemEventBlock(blockCount, result, systemEvent);
                        continue block11;
                    }
                    case 194: {
                        blockFlag = lostSamples.read(cubeIn);
                        this.checkLostSamplesBlock(blockCount, result, lostSamples);
                        continue block11;
                    }
                    case -1: {
                        this.log.fine("End of input stream was reached (read()/skip() returned '-1').");
                        eof = true;
                        continue block11;
                    }
                }
                blockFlag = Block.skip(cubeIn);
            }
        }
        catch (IOException exp) {
            this.log.severe("Input/output error. (" + exp.getMessage() + ")");
        }
        return result;
    }

    private DataRecorderSampleBlock getDummyBlock(HeaderBlock header, int value) throws IntegrityException {
        assert (header != null) : "The header block must not be 'null'.";
        if (!header.isCube() && !header.isNube()) {
            throw new IntegrityException("Cannot identify the logger type used to record the data.");
        }
        DataRecorderSampleBlock dummySample = new DataRecorderSampleBlock();
        for (int i = 0; i < header.enabledChannels(); ++i) {
            dummySample.setValue(i, value);
        }
        return dummySample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixBufferOverrun(File inFile, int dummyValue) throws IOException {
        block11: {
            DataInputStream inputStream;
            block10: {
                File outFile = new File(FileUtils.getBasename(inFile) + MODIFIED_FILE + FileUtils.getSuffix(inFile));
                inputStream = null;
                DataOutputStream outputStream = null;
                try {
                    this.log.info("-- Repairing '" + inFile.getName() + "' --");
                    inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile)));
                    outputStream = new DataOutputStream(CubeUtils.newCubeOutputStream(this.outputDir, outFile, this.forceOverwrite));
                    int samples = this.fixBufferOverrun(inputStream, outputStream, dummyValue);
                    if (samples > 0) {
                        this.log.info("Success!  (A total of " + samples + " dummy samples were inserted.)");
                    } else {
                        this.log.warning("No repairable \"buffer overrun\" gaps were found. Data was not modified!");
                    }
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                    if (this.outputDir == null) break block10;
                }
                catch (FileNotFoundException exp) {
                    this.log.severe(exp.getMessage());
                    break block11;
                }
                finally {
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                    if (this.outputDir != null) {
                        FileUtils.flushClose(outputStream);
                    }
                    FileUtils.flushClose(inputStream);
                }
                FileUtils.flushClose(outputStream);
            }
            FileUtils.flushClose(inputStream);
        }
    }

    private int fixBufferOverrun(DataInput cubeIn, DataOutput cubeOut, int dummyValue) {
        int insertedSamplesTotal = 0;
        try {
            HeaderBlock header = new HeaderBlock();
            DataRecorderSampleBlock dummyBlock = null;
            SystemEventBlock systemEvent = new SystemEventBlock();
            LostSamplesBlock lostSamples = new LostSamplesBlock();
            BinaryBlock someBlock = new BinaryBlock();
            boolean eof = false;
            int blockFlag = cubeIn.readUnsignedByte();
            int blockCount = 0;
            block8: while (!eof) {
                int nextFlag;
                ++blockCount;
                switch (blockFlag) {
                    case 240: {
                        nextFlag = header.read(cubeIn);
                        dummyBlock = this.getDummyBlock(header, dummyValue);
                        header.write(cubeOut);
                        blockFlag = nextFlag;
                        continue block8;
                    }
                    case 194: {
                        this.log.warning("A 'lost samples' block was encountered at an unexpected file position! The mandatory preceding 'system event' block is missing. Continuing anyway...");
                        nextFlag = lostSamples.read(cubeIn);
                        lostSamples.write(cubeOut);
                        blockFlag = nextFlag;
                        continue block8;
                    }
                    case 192: {
                        nextFlag = systemEvent.read(cubeIn);
                        if (systemEvent.ringBufferOverrunIsOn()) {
                            int missingSamples;
                            if (nextFlag == 194) {
                                nextFlag = lostSamples.read(cubeIn);
                                missingSamples = lostSamples.getSamplesLost();
                            } else {
                                missingSamples = systemEvent.numberOfMissingSamples();
                            }
                            if (missingSamples > 0) {
                                if (dummyBlock == null) {
                                    throw new IntegrityException("Could not detect a valid Cube header block. Cannot repair file!");
                                }
                                this.log.info("Block " + String.format("#%010d", blockCount) + " - Filling 'buffer overrun gap' with " + String.format("%2d", missingSamples) + " dummy samples.");
                                for (int i = 0; i < missingSamples; ++i) {
                                    dummyBlock.write(cubeOut);
                                }
                                insertedSamplesTotal += missingSamples;
                            } else {
                                systemEvent.write(cubeOut);
                                this.log.warning("Block " + String.format("#%010d", blockCount) + " - The number of 'samples lost' during the 'buffer overrun error' is not available. Unable to repair!");
                            }
                        } else {
                            systemEvent.write(cubeOut);
                        }
                        blockFlag = nextFlag;
                        continue block8;
                    }
                    case -1: {
                        this.log.fine("End of input stream was reached (read()/skip() returned '-1').");
                        eof = true;
                        continue block8;
                    }
                }
                nextFlag = someBlock.read(cubeIn);
                someBlock.write(cubeOut, blockFlag);
                blockFlag = nextFlag;
            }
        }
        catch (IOException exp) {
            this.log.severe("Input/output error. (" + exp.getMessage() + ")");
        }
        return insertedSamplesTotal;
    }

    private void run() throws IOException {
        Stopwatch totalRunTime = new Stopwatch();
        PrintWriter writer = new PrintWriter(System.out, true);
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            switch (this.operationalMode) {
                case INSPECTION: {
                    this.log.info("Reading from standard input.");
                    this.cubeStatistics.add(this.inspectRecording(new DataInputStream(System.in), CONSOLE_INPUT));
                    break;
                }
                case REPAIR_BUFFER_OVERRUN: {
                    this.log.info("Reading from standard input and writing to standard output.");
                    this.fixBufferOverrun(new DataInputStream(System.in), new DataOutputStream(System.out), DEFAULT_DUMMY_VALUE);
                }
            }
        } else {
            this.log.info("Building list of input files...");
            SortedFileSet inputList = new SortedFileSet(new SortByCubeStream(), this.inputFilter);
            for (String fileName : this.cmdLineParser.getArgumentList()) {
                File file = new File(fileName);
                if (file.exists()) {
                    inputList.add(file);
                    continue;
                }
                this.log.warning("File or directory '" + fileName + "' given at the command line does not exist! Maybe a typing error?");
            }
            if (inputList.isEmpty()) {
                this.log.severe("Not a single Cube input file was found!");
            } else {
                this.log.info("Found " + inputList.size() + " files to process.");
            }
            for (File inFile : inputList) {
                if (!inFile.canRead()) {
                    this.log.warning("File '" + inFile.getName() + "' is not readable! File permissions?");
                    continue;
                }
                if (inFile.length() == 0L) {
                    this.log.warning("File '" + inFile.getName() + "' is zero bytes long!");
                    continue;
                }
                switch (this.operationalMode) {
                    case INSPECTION: {
                        this.cubeStatistics.add(this.inspectRecording(inFile));
                        break;
                    }
                    case REPAIR_BUFFER_OVERRUN: {
                        this.fixBufferOverrun(inFile, DEFAULT_DUMMY_VALUE);
                    }
                }
            }
        }
        if (this.operationalMode == OperationalMode.INSPECTION) {
            this.reportStatistics(writer, this.cubeStatistics);
        }
        this.log.info("finished in " + totalRunTime);
    }

    private static class CubeStatistics {
        private final String dataSource;
        private final int[] gainSettings;
        private final int[] minValues;
        private final int[] maxValues;
        private final int[] clippedValues;
        private String recorderID;
        private String firmwareRelease;
        private int enabledChannels;
        private int sampleRate;
        private long numberOfSamples;
        private long clippedSamples;
        private boolean wnroEvent_Detected;
        private long bufferOverrun_Count;
        private long bufferOverrun_LostSamples;

        public CubeStatistics(String dataSource) {
            this.dataSource = dataSource;
            this.recorderID = null;
            this.firmwareRelease = null;
            this.enabledChannels = 0;
            this.sampleRate = 0;
            this.numberOfSamples = 0L;
            this.clippedSamples = 0L;
            this.gainSettings = new int[8];
            this.minValues = new int[8];
            this.maxValues = new int[8];
            this.clippedValues = new int[8];
            for (int i = 0; i < 8; ++i) {
                this.gainSettings[i] = 0;
                this.minValues[i] = Integer.MAX_VALUE;
                this.maxValues[i] = Integer.MIN_VALUE;
                this.clippedValues[i] = 0;
            }
            this.wnroEvent_Detected = false;
            this.bufferOverrun_Count = 0L;
            this.bufferOverrun_LostSamples = 0L;
        }
    }

    private static enum OperationalMode {
        INSPECTION,
        REPAIR_BUFFER_OVERRUN;

    }
}

