/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.cube;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortByExtension;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.cube.AuxiliaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.ChecksumBlock;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.DataRecorderSampleBlock;
import de.gfz_potsdam.gipp.common.seis.cube.DelayBlock;
import de.gfz_potsdam.gipp.common.seis.cube.EventRecorderSampleBlock;
import de.gfz_potsdam.gipp.common.seis.cube.HeaderBlock;
import de.gfz_potsdam.gipp.common.seis.cube.InfoBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.LostSamplesBlock;
import de.gfz_potsdam.gipp.common.seis.cube.SampleBlock;
import de.gfz_potsdam.gipp.common.seis.cube.SystemEventBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TaipBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TemperatureBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TrailerBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TriggerEventBlock;
import de.gfz_potsdam.gipp.common.seis.cube.VoltageBlock;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.ExpiredLeapSecondInfoException;
import de.gfz_potsdam.gipp.common.time.InvalidLeapSecondInfoException;
import de.gfz_potsdam.gipp.common.time.LeapSecondInfo;
import de.gfz_potsdam.gipp.common.time.Stopwatch;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class CubeInfo
extends GippToolsApplication {
    private static final Locale OUTPUT_LOCALE = Locale.ENGLISH;
    protected final CmdLineString inputFilterOption = GippToolsCommonOptions.newCubeInputFilterOption();
    private final CmdLineString outputFormatOption = new CmdLineString("format", "Changes the output format. (The default is INFO):\nINFO ..... Short, minimal description of the Cube/Nube file.\nSUMMARY .. A slightly more verbose file description.\nGPS ...... Parsed content of all GPS blocks (i.e. time, position).\nDEBUG  .... A (very) large raw dump of all blocks in the Cube/Nube file.", null);
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    protected RegexFilenameFilter inputFilter = null;
    private OutputFormat outFormat = OutputFormat.INFO;
    private File outputDir = null;
    private boolean forceOverwrite = false;
    private boolean expiredLeapSecondList = false;

    public CubeInfo(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.outputFormatOption);
        this.cmdLineParser.setProgramName("cubeinfo");
        this.cmdLineParser.setProgramDescription("summarize the content of a Cube recording");
        this.cmdLineParser.setProgramArguments("[Cube-FILE|DIRECTORY]...");
    }

    private static void printFileBegin(PrintWriter out, File file) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (file == null || file.getName().isEmpty()) {
            out.format(OUTPUT_LOCALE, "# --- FILE ---------------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#            The file name is empty or completely missing!%n", new Object[0]);
        } else if (StringUtils.containsWhitespace(file.getName())) {
            out.format(OUTPUT_LOCALE, "# --- FILE ---------------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#                file name:  '%s'%n", file.getName());
        } else {
            out.format(OUTPUT_LOCALE, "# --- FILE ---------------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#                file name:  %s%n", file.getName());
        }
    }

    private static void printFileEnd(PrintWriter out) {
        assert (out != null) : "Argument 'out' must not be null.";
        out.format(OUTPUT_LOCALE, "# ------------------------------------------------------------------------%n", new Object[0]);
        out.format(OUTPUT_LOCALE, "%n", new Object[0]);
    }

    private static void printBoot(PrintWriter out, InfoBlock boot, boolean printHeader) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (printHeader) {
            out.format(OUTPUT_LOCALE, "# --- BOOT ---------------------------------------------------------------%n", new Object[0]);
        }
        out.format(OUTPUT_LOCALE, "# %s%n", StringUtils.replaceControlCodes(boot.toString()));
    }

    private static void printHeader(PrintWriter out, HeaderBlock header) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (header != null) : "Argument 'header' must not be null";
        if (header.length() > 0) {
            String approxStart = header.approxRecorderStartup() == null ? "N/A" : header.approxRecorderStartup().toLogString();
            String gpsVolts = Double.isNaN(header.gpsBackupVoltage()) ? "N/A" : StringUtils.roundedNumber(header.gpsBackupVoltage(), 2, 2) + " V";
            String batteryVolts = Double.isNaN(header.dcellVoltage()) ? "N/A" : StringUtils.roundedNumber(header.dcellVoltage(), 2, 2) + " V";
            String externVolts = Double.isNaN(header.externVoltage()) ? "N/A" : StringUtils.roundedNumber(header.externVoltage(), 2, 2) + " V";
            List<Integer> gainList = header.channelGains();
            StringBuilder gainInfo = new StringBuilder();
            StringBuilder channelInfo = new StringBuilder();
            for (int i = 0; i < header.enabledChannels(); ++i) {
                channelInfo.append(String.format("%3s ", CubeUtils.channelNumberToGippName(i)));
                gainInfo.append(String.format("%3d ", gainList.get(i)));
            }
            out.format(OUTPUT_LOCALE, "# --- SYSTEM -------------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#         firmware version:  %s%n", header.firmwareVersionInfo());
            out.format(OUTPUT_LOCALE, "#           recording unit:  %s%n", header.cubeName());
            out.format(OUTPUT_LOCALE, "#          experiment name:  %s%n", StringUtils.replaceControlCodes(header.experimentName()));
            out.format(OUTPUT_LOCALE, "#             file segment:  %s%n", header.fileNumberInfo());
            out.format(OUTPUT_LOCALE, "# --- DIGITIZER ----------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#        recorded channels: %s%n", StringUtils.trimTrailing(channelInfo.toString()));
            out.format(OUTPUT_LOCALE, "#     amplification factor: %s%n", StringUtils.trimTrailing(gainInfo.toString()));
            out.format(OUTPUT_LOCALE, "#              sample rate:  %d samples per second%n", header.sampleRate());
            out.format(OUTPUT_LOCALE, "#       power optimization:  %s%n", header.adcPowerModeInfo());
            out.format(OUTPUT_LOCALE, "#       chopping amplifier:  %s%n", header.choppingAmplifierMode());
            out.format(OUTPUT_LOCALE, "#          FIR filter mode:  %s%n", header.firFilterInfo());
            out.format(OUTPUT_LOCALE, "#         high-pass filter:  %s%n", header.highpassFilterInfo());
            out.format(OUTPUT_LOCALE, "#             filter delay:  %s%n", header.firFilterDelay());
            out.format(OUTPUT_LOCALE, "# --- CLOCK --------------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#             clock source:  %s%n", header.clockSourceInfo());
            out.format(OUTPUT_LOCALE, "#               power mode:  %s%n", header.clockPowerModeInfo());
            out.format(OUTPUT_LOCALE, "#    initial GNSS position:  %s%n", StringUtils.replaceControlCodes(header.initialGnssPositionInfo()));
            out.format(OUTPUT_LOCALE, "#  clock static correction:  %s%n", header.clockStaticCorrectionInfo());
            out.format(OUTPUT_LOCALE, "#   clock drift correction:  %s%n", header.clockDriftCorrectionInfo());
            out.format(OUTPUT_LOCALE, "#          begin recording:  %s%n", header.startRecordingInfo());
            out.format(OUTPUT_LOCALE, "#      GNSS backup battery:  %s%n", gpsVolts);
            out.format(OUTPUT_LOCALE, "# --- POWER ON -----------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#   approx. recorder start:  %s%n", approxStart);
            out.format(OUTPUT_LOCALE, "#           D-cell battery:  %s%n", batteryVolts);
            out.format(OUTPUT_LOCALE, "#         external battery:  %s%n", externVolts);
        } else {
            out.format(OUTPUT_LOCALE, "# --- SYSTEM -------------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#            The Cube >HEADER< block is empty or missing!%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "# --- DIGITIZER ----------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#            The Cube >HEADER< block is empty or missing!%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "# --- CLOCK --------------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#            The Cube >HEADER< block is empty or missing!%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "# --- POWER ON -----------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#            The Cube >HEADER< block is empty or missing!%n", new Object[0]);
        }
    }

    private static void printInfo(PrintWriter out, List<InfoBlock> infos) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (infos != null && !infos.isEmpty()) {
            out.format(OUTPUT_LOCALE, "# --- INFO ---------------------------------------------------------------%n", new Object[0]);
            for (InfoBlock info : infos) {
                out.format(OUTPUT_LOCALE, "# %s%n", StringUtils.replaceControlCodes(info.toString()));
            }
        }
    }

    private static void printInfo(PrintWriter out, InfoBlock info, boolean printHeader) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (printHeader) {
            out.format(OUTPUT_LOCALE, "# --- INFO ---------------------------------------------------------------%n", new Object[0]);
        }
        out.format(OUTPUT_LOCALE, "# %s%n", StringUtils.replaceControlCodes(info.toString()));
    }

    private static void printTrailer(PrintWriter out, TrailerBlock trailer) {
        String externVolts;
        if (trailer == null) {
            return;
        }
        assert (out != null) : "Argument 'out' must not be null.";
        String approxStop = trailer.approxRecorderStop() == null ? "N/A" : trailer.approxRecorderStop().toLogString();
        String batteryVolts = Double.isNaN(trailer.dcellVoltage()) ? "N/A" : StringUtils.roundedNumber(trailer.dcellVoltage(), 2, 2) + " V";
        String string = externVolts = Double.isNaN(trailer.externVoltage()) ? "N/A" : StringUtils.roundedNumber(trailer.externVoltage(), 2, 2) + " V";
        if (trailer.approxRecorderStop() == null || Double.isNaN(trailer.dcellVoltage()) || Double.isNaN(trailer.externVoltage())) {
            out.format(OUTPUT_LOCALE, "# --- POWER OFF ----------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#            The Cube >TRAILER< block is damaged or incomplete!%n", new Object[0]);
        } else if (trailer.length() == 0) {
            out.format(OUTPUT_LOCALE, "# --- POWER OFF ----------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#            The Cube >TRAILER< block is empty or missing!%n", new Object[0]);
        } else {
            out.format(OUTPUT_LOCALE, "# --- POWER OFF ----------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "#    approx. recorder stop:  %s%n", approxStop);
            out.format(OUTPUT_LOCALE, "#           D-cell battery:  %s%n", batteryVolts);
            out.format(OUTPUT_LOCALE, "#         external battery:  %s%n", externVolts);
        }
    }

    private static void printSummary(PrintWriter out, long bootMessageCount, long headerCount, long infoCount, long trailerCount, long recorderSampleCount, long recorderSamplePpsCount, long eventSampleCount, long eventSamplePpsCount, long taipCount, long delayCount, long systemEventCount, long lostSamplesCount, long triggerEventCount, long auxOneCount, long auxTwoCount, long voltageCount, long temperatureCount, long checksumCount, long eofCount, long debugCount, long unknownCount) {
        assert (out != null) : "Argument 'out' must not be null.";
        long numOfSamples = recorderSampleCount + recorderSamplePpsCount + eventSampleCount + eventSamplePpsCount;
        long totalCount = bootMessageCount + headerCount + infoCount + trailerCount + recorderSampleCount + recorderSamplePpsCount + eventSampleCount + eventSamplePpsCount + taipCount + delayCount + systemEventCount + lostSamplesCount + triggerEventCount + auxOneCount + auxTwoCount + voltageCount + temperatureCount + checksumCount + eofCount + debugCount + unknownCount;
        String plainSampleInfo = recorderSampleCount == 0L && eventSampleCount == 0L ? String.format(OUTPUT_LOCALE, "0", new Object[0]) : (recorderSampleCount > 0L && eventSampleCount == 0L ? String.format(OUTPUT_LOCALE, "%d  (24-bit, data recorder)", recorderSampleCount) : (recorderSampleCount == 0L && eventSampleCount > 0L ? String.format(OUTPUT_LOCALE, "%d  (16-bit, event recorder)", eventSampleCount) : String.format(OUTPUT_LOCALE, "%d (24-bit, data recorder) and %d (16-bit, event recorder)", recorderSampleCount, eventSampleCount)));
        String ppsSampleInfo = recorderSamplePpsCount == 0L && eventSamplePpsCount == 0L ? String.format(OUTPUT_LOCALE, "0", new Object[0]) : (recorderSamplePpsCount > 0L && eventSamplePpsCount == 0L ? String.format(OUTPUT_LOCALE, "%d  (24-bit, data recorder)", recorderSamplePpsCount) : (recorderSamplePpsCount == 0L && eventSamplePpsCount > 0L ? String.format(OUTPUT_LOCALE, "%d  (16-bit, event recorder)", eventSamplePpsCount) : String.format(OUTPUT_LOCALE, "%d (24-bit, data recorder) and %d (16-bit, event recorder)", recorderSamplePpsCount, eventSamplePpsCount)));
        String auxiliaryPortInfo = auxOneCount == 0L && auxTwoCount == 0L ? String.format(OUTPUT_LOCALE, "0", new Object[0]) : (auxOneCount > 0L && auxTwoCount == 0L ? String.format(OUTPUT_LOCALE, "%d  (port #1)", auxOneCount) : (auxOneCount == 0L && auxTwoCount > 0L ? String.format(OUTPUT_LOCALE, "%d  (port #2)", auxTwoCount) : String.format(OUTPUT_LOCALE, "%d (port #1) and %d (port #2)", auxOneCount, auxTwoCount)));
        out.format(OUTPUT_LOCALE, "# --- STATISTICS ---------------------------------------------------------%n", new Object[0]);
        out.format(OUTPUT_LOCALE, "#      boot message blocks:  %d%n", bootMessageCount);
        out.format(OUTPUT_LOCALE, "#            header blocks:  %d%n", headerCount);
        out.format(OUTPUT_LOCALE, "#           trailer blocks:  %d%n", trailerCount);
        out.format(OUTPUT_LOCALE, "#      plain sample blocks:  %s%n", plainSampleInfo);
        out.format(OUTPUT_LOCALE, "# PPS tagged sample blocks:  %s%n", ppsSampleInfo);
        out.format(OUTPUT_LOCALE, "#        TAIP (GPS) blocks:  %d%n", taipCount);
        out.format(OUTPUT_LOCALE, "#             delay blocks:  %d%n", delayCount);
        out.format(OUTPUT_LOCALE, "#    (textual) info blocks:  %d%n", infoCount);
        out.format(OUTPUT_LOCALE, "#         auxiliary blocks:  %s%n", auxiliaryPortInfo);
        out.format(OUTPUT_LOCALE, "#     trigger event blocks:  %d%n", triggerEventCount);
        out.format(OUTPUT_LOCALE, "#      system event blocks:  %d%n", systemEventCount);
        out.format(OUTPUT_LOCALE, "#       lost sample blocks:  %d%n", lostSamplesCount);
        out.format(OUTPUT_LOCALE, "#           voltage blocks:  %d%n", voltageCount);
        out.format(OUTPUT_LOCALE, "#       temperature blocks:  %d%n", temperatureCount);
        out.format(OUTPUT_LOCALE, "#         debugging blocks:  %d%n", debugCount);
        out.format(OUTPUT_LOCALE, "#          checksum blocks:  %d%n", checksumCount);
        out.format(OUTPUT_LOCALE, "#       end-of-file blocks:  %d%n", eofCount);
        out.format(OUTPUT_LOCALE, "#           unknown blocks:  %d%n", unknownCount);
        out.format(OUTPUT_LOCALE, "#   total number of blocks:  %d  (%d samples)%n", totalCount, numOfSamples);
    }

    private static void dumpHeader(PrintWriter out, HeaderBlock header, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (header == null || header.length() == 0) {
            out.format(OUTPUT_LOCALE, "#%010d    HEADER    Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d    HEADER    %s%n", count, StringUtils.replaceControlCodes(header.toString()));
        }
    }

    private static void dumpBoot(PrintWriter out, InfoBlock boot, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (boot == null || boot.length() == 0) {
            out.format(OUTPUT_LOCALE, "#%010d     BOOT     Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d     BOOT     %s%n", count, StringUtils.replaceControlCodes(boot.toString()));
        }
    }

    private static void dumpInfo(PrintWriter out, InfoBlock info, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (info == null || info.length() == 0) {
            out.format(OUTPUT_LOCALE, "#%010d     INFO     Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d     INFO     %s%n", count, StringUtils.replaceControlCodes(info.toString()));
        }
    }

    private static void dumpDataRecorderSample(PrintWriter out, boolean isPPS, SampleBlock data, long count) {
        String blockType;
        assert (out != null) : "Argument 'out' must not be null.";
        String string = blockType = isPPS ? "PPS-SAMPLE" : "  SAMPLE  ";
        if (data == null) {
            out.format(OUTPUT_LOCALE, "#%010d  %s  Block information is missing or damaged!%n", count, blockType);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d  %s  %s%n", count, blockType, data);
        }
    }

    private static void dumpEventRecorderSample(PrintWriter out, boolean isPPS, EventRecorderSampleBlock data, long count) {
        String blockId;
        assert (out != null) : "Argument 'out' must not be null.";
        String string = blockId = isPPS ? "PPS-SAMPLE" : "  SAMPLE  ";
        if (data == null) {
            out.format(OUTPUT_LOCALE, "#%010d  %s  Block information is missing or damaged!%n", count, blockId);
        } else {
            String buttonPressed = data.isRecordButtonPressed() ? "[1]" : "[0]";
            String triggerEvent = data.isTriggerSample() ? "[1]" : "[0]";
            out.format(OUTPUT_LOCALE, "#%010d  %s  %s aux:%s%s%n", count, blockId, data, buttonPressed, triggerEvent);
        }
    }

    private static void dumpTaip(PrintWriter out, TaipBlock taip, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (taip == null || taip.length() == 0) {
            out.format(OUTPUT_LOCALE, "#%010d     GPS      Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d     GPS      %s%n", count, StringUtils.replaceControlCodes(taip.toString()));
        }
    }

    private static void dumpVoltage(PrintWriter out, VoltageBlock voltage, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (voltage == null) {
            out.format(OUTPUT_LOCALE, "#%010d   VOLTAGE    Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d   VOLTAGE    %s%n", count, voltage);
        }
    }

    private static void dumpTemperature(PrintWriter out, TemperatureBlock temperature, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (temperature == null) {
            out.format(OUTPUT_LOCALE, "#%010d     TEMP     Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d     TEMP     %s%n", count, temperature);
        }
    }

    private static void dumpDelay(PrintWriter out, DelayBlock delay, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (delay == null) {
            out.format(OUTPUT_LOCALE, "#%010d    DELAY     Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d    DELAY     %s%n", count, delay);
        }
    }

    private static void dumpTriggerEvent(PrintWriter out, TriggerEventBlock trigger, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (trigger == null) {
            out.format(OUTPUT_LOCALE, "#%010d   TRIGGER    Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d   TRIGGER    %s%n", count, trigger);
        }
    }

    private static void dumpSystemEvent(PrintWriter out, SystemEventBlock event, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (event == null) {
            out.format(OUTPUT_LOCALE, "#%010d    SYSTEM    Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d    SYSTEM    %s%n", count, event);
        }
    }

    private static void dumpLostSamples(PrintWriter out, LostSamplesBlock lostSamples, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (lostSamples == null) {
            out.format(OUTPUT_LOCALE, "#%010d  SAMPLE-GAP  Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d  SAMPLE-GAP  %s missing samples%n", count, lostSamples);
        }
    }

    private static void dumpAuxiliary(PrintWriter out, AuxiliaryBlock auxiliary, int port, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (auxiliary == null) {
            out.format(OUTPUT_LOCALE, "#%010d     AUX%d     Block information is missing or damaged!%n", count, port);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d     AUX%d     %s%n", count, port, StringUtils.replaceControlCodes(auxiliary.toString()));
        }
    }

    private static void dumpChecksum(PrintWriter out, ChecksumBlock checksum, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (checksum == null) {
            out.format(OUTPUT_LOCALE, "#%010d   CHECKSUM   Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d   CHECKSUM   %s%n", count, checksum);
        }
    }

    private static void dumpDebug(PrintWriter out, BinaryBlock debug, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (debug == null) {
            out.format(OUTPUT_LOCALE, "#%010d     DEBUG    Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d     DEBUG    %s%n", count, debug);
        }
    }

    private static void dumpUnknown(PrintWriter out, byte id, BinaryBlock unknown, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (unknown == null) {
            out.format(OUTPUT_LOCALE, "#%010d   ID: 0x%s   Block information is missing or damaged!%n", count, StringUtils.toHexString(id));
        } else {
            out.format(OUTPUT_LOCALE, "#%010d   ID: 0x%s   %s%n", count, StringUtils.toHexString(id), unknown);
        }
    }

    private static void dumpTrailer(PrintWriter out, TrailerBlock trailer, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (trailer == null || trailer.length() == 0) {
            out.format(OUTPUT_LOCALE, "#%010d   TRAILER    Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d   TRAILER    %s%n", count, StringUtils.replaceControlCodes(trailer.toString()));
        }
    }

    private static void dumpEndOfFile(PrintWriter out, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        out.format("#%010d  END-OF-FILE%n", count);
    }

    public static void main(String[] args) {
        CubeInfo cubeinfo = new CubeInfo(args);
        try {
            cubeinfo.handleCommonOptions();
            cubeinfo.handleGippToolOptions();
            cubeinfo.handleInputOptions();
            cubeinfo.handleOutputOptions();
            cubeinfo.run();
        }
        catch (CmdLineException e) {
            cubeinfo.logThrowable(e);
            System.exit(64);
        }
        catch (IOException e) {
            cubeinfo.logThrowable(e);
            System.exit(74);
        }
        catch (OutOfMemoryError e) {
            cubeinfo.log.severe("Ran out of memory! Please reduce the input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            cubeinfo.logThrowable(e);
            System.exit(99);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTaip(PrintWriter out, TaipBlock taip, long count) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (taip == null || taip.length() == 0) {
            out.format(OUTPUT_LOCALE, "#%010d  GPS  Block information is missing or damaged!%n", count);
        } else {
            out.format(OUTPUT_LOCALE, "#%010d  GPS  ", count);
            try {
                if (taip.getTime() != null) {
                    out.format(OUTPUT_LOCALE, "utc-time=%s ", taip.getTime().toIsoShortString());
                } else {
                    out.format(OUTPUT_LOCALE, "utc-time=MISSING ", new Object[0]);
                }
                if (taip.getSourceOffset() != null && taip.getSourceOffset() != 0) {
                    out.format(OUTPUT_LOCALE, "src-leap=%+2ds ", taip.getSourceOffset());
                }
                if (taip.getGpsDateTimeInfo() != null && !taip.getGpsDateTimeInfo().isEmpty()) {
                    out.format(OUTPUT_LOCALE, "iers-leap=%+2ds ", LeapSecondInfo.getGpsUtcOffset(taip.getGpsDateTimeInfo()));
                    out.format(OUTPUT_LOCALE, "gps-time=%s ", taip.getGpsDateTimeInfo());
                }
                if (taip.getPosition() != null) {
                    out.format(OUTPUT_LOCALE, "lat=%+.5f lon=%+.5f ", taip.getPosition().getLatitude(), taip.getPosition().getLongitude());
                }
                if (taip.getElevation() != null) {
                    out.format(OUTPUT_LOCALE, "elev=%s ", taip.getElevation().toString());
                }
                if (taip.getClockSource() != null && !taip.getClockSource().isEmpty()) {
                    out.format(OUTPUT_LOCALE, "source=%s ", taip.getClockSource());
                }
                if (taip.isUpToDate() != null) {
                    out.format(OUTPUT_LOCALE, "age=%s ", taip.isUpToDate() != false ? "<10s" : "old");
                }
                if (taip.getNumOfSatellites() != null) {
                    out.format(OUTPUT_LOCALE, "sats=%d ", taip.getNumOfSatellites());
                }
                if (taip.getTemperature() != null) {
                    out.format(OUTPUT_LOCALE, "temp=%s ", taip.getTemperature().toString());
                }
                if (taip.getUbloxStatus() != null) {
                    out.format(OUTPUT_LOCALE, "status=%s ", taip.getUbloxStatus());
                }
                if (taip.getCsacUseTime() != null) {
                    out.format(OUTPUT_LOCALE, "uptime=%d ", taip.getCsacUseTime());
                }
                if (taip.getCsacMode() != null) {
                    out.format(OUTPUT_LOCALE, "mode=0x%s ", StringUtils.toHexString(taip.getCsacMode()));
                }
                if (taip.getCsacStatus() != null) {
                    out.format(OUTPUT_LOCALE, "status=0x%s ", StringUtils.toHexString(taip.getCsacStatus()));
                }
                if (taip.getCsacAlarm() != null) {
                    out.format(OUTPUT_LOCALE, "alarm=0x%s ", StringUtils.toHexString(taip.getCsacAlarm()));
                }
                if (taip.getCsacPpsShift() != null) {
                    out.format(OUTPUT_LOCALE, "shift=%f ", taip.getCsacPpsShift().getSeconds());
                }
            }
            catch (IntegrityException e) {
                out.format(OUTPUT_LOCALE, "ERROR while parsing TAIP message (" + StringUtils.replaceControlCodes(taip.toString()) + ").", new Object[0]);
            }
            catch (ExpiredLeapSecondInfoException | InvalidLeapSecondInfoException e) {
                this.expiredLeapSecondList = true;
            }
            catch (TimeException e) {
                out.format(OUTPUT_LOCALE, "Error while converting between GPS and UTC time scale (" + e.getMessage() + ").", new Object[0]);
            }
            finally {
                out.println();
            }
        }
    }

    private void handleInputOptions() {
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addCubeFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined \"GIPP Cube/Nube filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        block20: {
            if (this.forceOverwriteOption.isMatched()) {
                this.forceOverwrite = true;
                this.log.info("Already existing files will be overwritten!");
            } else {
                this.forceOverwrite = false;
                this.log.fine("Already existing files will NOT be overwritten.");
            }
            if (this.outputDirOption.isMatched()) {
                this.outputDir = new File(this.outputDirOption.getValue());
                if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
                    this.log.info("The requested information will be written to the '" + this.outputDir.getPath() + "' directory.");
                    break block20;
                } else {
                    this.outputDir = null;
                    throw new CmdLineException("Cannot write to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
                }
            }
            this.outputDir = null;
            this.log.fine("All results will be written to \"standard output\" (console).");
        }
        if (!this.outputFormatOption.isMatched()) {
            this.log.fine("Using the default output mode ('" + this.outFormat.toString() + "').");
            return;
        }
        String format = this.outputFormatOption.getValue().toUpperCase();
        if (format.startsWith("INF")) {
            this.outFormat = OutputFormat.INFO;
        } else if (format.startsWith("SUM")) {
            this.outFormat = OutputFormat.SUMMARY;
        } else if (format.startsWith("TAI")) {
            this.outFormat = OutputFormat.TAIP;
        } else if (format.startsWith("GNN")) {
            this.outFormat = OutputFormat.TAIP;
        } else if (format.startsWith("GPS")) {
            this.outFormat = OutputFormat.TAIP;
        } else if (format.startsWith("DEB")) {
            this.outFormat = OutputFormat.DEBUG;
        } else if (format.startsWith("DUM")) {
            this.outFormat = OutputFormat.DEBUG;
        } else {
            this.log.severe("Unknown output format '" + format + "'. Please use one of " + Arrays.toString((Object[])OutputFormat.values()) + " instead.");
            System.exit(64);
        }
        this.log.info("Switching to '" + (Object)((Object)this.outFormat) + "' output format.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeInfo(File inFile, PrintWriter outWriter) throws FileNotFoundException, IOException {
        block7: {
            block6: {
                raf = null;
                this.log.fine("Begin processing file '" + inFile.getName() + "'");
                try {
                    raf = new RandomAccessFile(inFile, "r");
                    if (CubeUtils.isCubeFile(raf)) break block6;
                    this.log.warning("The file '" + inFile.getName() + "' is not a Cube/Nube data file!");
                }
                catch (Throwable var8_8) {
                    FileUtils.flushClose(raf);
                    throw var8_8;
                }
                FileUtils.flushClose(raf);
                return;
            }
            if (this.outFormat == OutputFormat.INFO || this.outFormat == OutputFormat.SUMMARY) {
                CubeInfo.printFileBegin(outWriter, inFile);
            }
            if (this.outFormat != OutputFormat.INFO) ** GOTO lbl34
            header = CubeUtils.getHeader(raf);
            description = CubeUtils.getInfos(raf, 0L, 1024L);
            trailer = CubeUtils.getTrailer(raf);
            hasEOF = CubeUtils.hasEofBlock(raf);
            if (header == null || trailer == null && !hasEOF) break block7;
            if (header.isPartiallyRead()) {
                throw new IntegrityException("The Cube header block is corrupt or incomplete! At least one mandatory header field is missing! Did you by any chance use non-ASCII characters in the 'Config.txt' file? Maybe for the experiment name?");
            }
            CubeInfo.printHeader(outWriter, header);
            CubeInfo.printInfo(outWriter, description);
            CubeInfo.printTrailer(outWriter, trailer);
            CubeInfo.printFileEnd(outWriter);
            FileUtils.flushClose(raf);
            return;
        }
        this.log.fine("Failed to extract header and/or trailer block directly. Starting exhaustive scan.");
        raf.seek(0L);
lbl34:
        // 2 sources

        this.writeInfo(raf, outWriter);
        FileUtils.flushClose(raf);
        this.log.fine("Done processing file '" + inFile.getName() + "'");
    }

    private void writeInfo(DataInput inStream, PrintWriter outStream) {
        DataRecorderSampleBlock recorderData = new DataRecorderSampleBlock();
        EventRecorderSampleBlock eventData = new EventRecorderSampleBlock();
        TaipBlock taip = new TaipBlock();
        TriggerEventBlock eventTrigger = new TriggerEventBlock();
        SystemEventBlock systemEvent = new SystemEventBlock();
        LostSamplesBlock lostSamples = new LostSamplesBlock();
        VoltageBlock voltage = new VoltageBlock();
        TemperatureBlock temperature = new TemperatureBlock();
        InfoBlock info = new InfoBlock();
        AuxiliaryBlock auxiliary = new AuxiliaryBlock();
        TrailerBlock trailer = new TrailerBlock();
        ChecksumBlock checksum = new ChecksumBlock();
        HeaderBlock header = new HeaderBlock();
        BinaryBlock unknown = new BinaryBlock();
        long blockCount = 1L;
        long recorderSampleCount = 0L;
        long eventSampleCount = 0L;
        long recorderSamplePpsCount = 0L;
        long eventSamplePpsCount = 0L;
        long taipCount = 0L;
        long delayCount = 0L;
        long triggerEventCount = 0L;
        long systemEventCount = 0L;
        long lostSamplesCount = 0L;
        long voltageCount = 0L;
        long temperatureCount = 0L;
        long debugCount = 0L;
        long infoCount = 0L;
        long auxiliaryOneCount = 0L;
        long auxiliaryTwoCount = 0L;
        long trailerCount = 0L;
        long checksumCount = 0L;
        long eofCount = 0L;
        long headerCount = 0L;
        long bootMessageCount = 0L;
        long unknownCount = 0L;
        try {
            int blockFlag = inStream.readUnsignedByte();
            boolean eof = false;
            while (!eof) {
                switch (blockFlag) {
                    case 128: {
                        ++recorderSampleCount;
                        blockFlag = recorderData.read(inStream);
                        if (recorderData.getNumberOfChannels() != header.enabledChannels()) {
                            this.log.warning("Bad sample block! Expected " + header.enabledChannels() + " channel(s) of data but got " + recorderData.getNumberOfChannels() + " channel(s) instead at block #" + StringUtils.TEN_DIGITS.format(blockCount));
                        }
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpDataRecorderSample(outStream, false, recorderData, blockCount);
                        break;
                    }
                    case 136: {
                        ++eventSampleCount;
                        blockFlag = eventData.read(inStream);
                        if (eventData.getNumberOfChannels() != header.enabledChannels()) {
                            this.log.warning("Bad sample block! Expected " + header.enabledChannels() + " channel(s) of data but got " + eventData.getNumberOfChannels() + " channel(s) instead at block #" + StringUtils.TEN_DIGITS.format(blockCount));
                        }
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpEventRecorderSample(outStream, false, eventData, blockCount);
                        break;
                    }
                    case 144: {
                        ++recorderSamplePpsCount;
                        blockFlag = recorderData.read(inStream);
                        if (recorderData.getNumberOfChannels() != header.enabledChannels()) {
                            this.log.warning("Bad sample block! Expected " + header.enabledChannels() + " channel(s) of data but got " + recorderData.getNumberOfChannels() + " channel(s) instead at block #" + StringUtils.TEN_DIGITS.format(blockCount));
                        }
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpDataRecorderSample(outStream, true, recorderData, blockCount);
                        break;
                    }
                    case 152: {
                        ++eventSamplePpsCount;
                        blockFlag = eventData.read(inStream);
                        if (eventData.getNumberOfChannels() != header.enabledChannels()) {
                            this.log.warning("Bad sample block! Expected " + header.enabledChannels() + " channel(s) of data but got " + eventData.getNumberOfChannels() + " channel(s) instead at block #" + StringUtils.TEN_DIGITS.format(blockCount));
                        }
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpEventRecorderSample(outStream, true, eventData, blockCount);
                        break;
                    }
                    case 160: {
                        ++taipCount;
                        blockFlag = taip.read(inStream);
                        if (this.outFormat == OutputFormat.DEBUG) {
                            CubeInfo.dumpTaip(outStream, taip, blockCount);
                            break;
                        }
                        if (this.outFormat != OutputFormat.TAIP) break;
                        this.printTaip(outStream, taip, blockCount);
                        break;
                    }
                    case 176: 
                    case 177: {
                        ++delayCount;
                        DelayBlock delay = new DelayBlock(blockFlag);
                        blockFlag = delay.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpDelay(outStream, delay, blockCount);
                        break;
                    }
                    case 184: {
                        ++triggerEventCount;
                        blockFlag = eventTrigger.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpTriggerEvent(outStream, eventTrigger, blockCount);
                        break;
                    }
                    case 192: {
                        ++systemEventCount;
                        blockFlag = systemEvent.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpSystemEvent(outStream, systemEvent, blockCount);
                        break;
                    }
                    case 194: {
                        ++lostSamplesCount;
                        blockFlag = lostSamples.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpLostSamples(outStream, lostSamples, blockCount);
                        break;
                    }
                    case 200: {
                        ++voltageCount;
                        blockFlag = voltage.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpVoltage(outStream, voltage, blockCount);
                        break;
                    }
                    case 206: {
                        ++temperatureCount;
                        blockFlag = temperature.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpTemperature(outStream, temperature, blockCount);
                        break;
                    }
                    case 207: {
                        ++debugCount;
                        blockFlag = unknown.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpDebug(outStream, unknown, blockCount);
                        break;
                    }
                    case 208: {
                        ++infoCount;
                        blockFlag = info.read(inStream);
                        if (this.outFormat == OutputFormat.INFO || this.outFormat == OutputFormat.SUMMARY) {
                            CubeInfo.printInfo(outStream, info, infoCount == 1L);
                            break;
                        }
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpInfo(outStream, info, blockCount);
                        break;
                    }
                    case 209: {
                        ++auxiliaryOneCount;
                        blockFlag = auxiliary.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpAuxiliary(outStream, auxiliary, 1, blockCount);
                        break;
                    }
                    case 210: {
                        ++auxiliaryTwoCount;
                        blockFlag = auxiliary.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpAuxiliary(outStream, auxiliary, 2, blockCount);
                        break;
                    }
                    case 224: {
                        ++trailerCount;
                        blockFlag = trailer.read(inStream);
                        if (this.outFormat == OutputFormat.INFO || this.outFormat == OutputFormat.SUMMARY) {
                            CubeInfo.printTrailer(outStream, trailer);
                            break;
                        }
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpTrailer(outStream, trailer, blockCount);
                        break;
                    }
                    case 236: {
                        ++checksumCount;
                        blockFlag = checksum.read(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpChecksum(outStream, checksum, blockCount);
                        break;
                    }
                    case 239: {
                        ++eofCount;
                        blockFlag = Block.skip(inStream);
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpEndOfFile(outStream, blockCount);
                        break;
                    }
                    case 240: {
                        ++headerCount;
                        blockFlag = header.read(inStream);
                        if (header.isPartiallyRead()) {
                            throw new IntegrityException("The Cube/Nube header block is corrupt or incomplete! At least one mandatory header field is missing! Did you by any chance use non-ASCII characters in the 'Config.txt' file? Maybe for the experiment name?");
                        }
                        if (this.outFormat == OutputFormat.INFO || this.outFormat == OutputFormat.SUMMARY) {
                            CubeInfo.printHeader(outStream, header);
                            break;
                        }
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpHeader(outStream, header, blockCount);
                        break;
                    }
                    case 248: {
                        ++bootMessageCount;
                        blockFlag = info.read(inStream);
                        if (this.outFormat == OutputFormat.INFO || this.outFormat == OutputFormat.SUMMARY) {
                            CubeInfo.printBoot(outStream, info, bootMessageCount == 1L);
                            break;
                        }
                        if (this.outFormat != OutputFormat.DEBUG) break;
                        CubeInfo.dumpBoot(outStream, info, blockCount);
                        break;
                    }
                    case -1: {
                        this.log.fine("End of input stream was reached (read()/skip() returned '-1').");
                        eof = true;
                        break;
                    }
                    default: {
                        ++unknownCount;
                        if (this.outFormat == OutputFormat.DEBUG) {
                            byte savedFlag = (byte)blockFlag;
                            blockFlag = unknown.read(inStream);
                            CubeInfo.dumpUnknown(outStream, savedFlag, unknown, blockCount);
                            break;
                        }
                        this.log.warning("Unknown flag 0x" + StringUtils.toHexString((byte)blockFlag) + " at block #" + blockCount);
                        blockFlag = Block.skip(inStream);
                    }
                }
                ++blockCount;
            }
        }
        catch (IOException exp) {
            this.log.fine("IOException caught! Most likely end of stream reached!");
        }
        if (this.outFormat == OutputFormat.INFO) {
            CubeInfo.printFileEnd(outStream);
        } else if (this.outFormat == OutputFormat.SUMMARY) {
            CubeInfo.printSummary(outStream, bootMessageCount, headerCount, infoCount, trailerCount, recorderSampleCount, recorderSamplePpsCount, eventSampleCount, eventSamplePpsCount, taipCount, delayCount, systemEventCount, lostSamplesCount, triggerEventCount, auxiliaryOneCount, auxiliaryTwoCount, voltageCount, temperatureCount, checksumCount, eofCount, debugCount, unknownCount);
            CubeInfo.printFileEnd(outStream);
        }
    }

    private PrintWriter getWriter() throws IOException {
        if (this.outputDir != null) {
            String basename = "console." + this.outFormat.toString().toLowerCase();
            File outFile = this.getOutputFile(this.outputDir, basename, "txt", this.forceOverwrite);
            this.log.info("Creating a new file at '" + outFile.getPath() + "'.");
            return new PrintWriter(Files.newOutputStream(outFile.toPath(), new OpenOption[0]), true);
        }
        return new PrintWriter(System.out, true);
    }

    private PrintWriter getWriter(File cubeFile) throws IOException {
        assert (cubeFile != null) : "No file was given!";
        if (this.outputDir != null) {
            String basename = cubeFile.getName() + "." + this.outFormat.toString().toLowerCase();
            File outFile = this.getOutputFile(this.outputDir, basename, "txt", this.forceOverwrite);
            this.log.info("Creating a new output file at '" + outFile.getPath() + "'.");
            return new PrintWriter(Files.newOutputStream(outFile.toPath(), new OpenOption[0]), true);
        }
        return new PrintWriter(System.out, true);
    }

    void freeWriter(PrintWriter outWriter) {
        assert (outWriter != null) : "Cannot free an 'null' print writer!";
        if (this.outputDir != null) {
            FileUtils.flushClose(outWriter);
        } else {
            outWriter.flush();
        }
    }

    private void run() throws IOException, FileNotFoundException {
        Stopwatch totalRunTime = new Stopwatch();
        if (this.cmdLineParser.getArgumentList().isEmpty()) {
            PrintWriter writer = this.getWriter();
            this.log.info("Reading Cube/Nube data from \"standard input\".");
            this.writeInfo(new DataInputStream(System.in), writer);
            this.freeWriter(writer);
        } else {
            this.log.info("Building list of input files..");
            SortedFileSet inputList = new SortedFileSet(new SortByExtension(), this.inputFilter);
            for (String fileName : this.cmdLineParser.getArgumentList()) {
                File file = new File(fileName);
                if (file.exists()) {
                    inputList.add(file);
                    continue;
                }
                this.log.warning("File or directory '" + fileName + "' given at the command line does not exist! Maybe a typing error?");
            }
            if (inputList.isEmpty()) {
                this.log.severe("Not a single input file was found!");
            } else {
                this.log.info("Found " + inputList.size() + " files to process.");
            }
            for (File inFile : inputList) {
                if (!inFile.canRead()) {
                    this.log.warning("File '" + inFile.getName() + "' is not readable! File permissions?");
                    continue;
                }
                if (inFile.length() == 0L) {
                    this.log.warning("File '" + inFile.getName() + "' is zero bytes long!");
                    continue;
                }
                PrintWriter outWriter = this.getWriter(inFile);
                this.writeInfo(inFile, outWriter);
                this.freeWriter(outWriter);
            }
        }
        this.log.info("finished in " + totalRunTime);
        if (this.outFormat == OutputFormat.TAIP && this.expiredLeapSecondList) {
            this.log.warning("The used leap second table is too old! IERS leap second information ('iers-leap') may be wrong or not available! You need an update!!!");
        }
    }

    private static enum OutputFormat {
        INFO,
        SUMMARY,
        TAIP,
        DEBUG;

    }
}

