/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.cube;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.EventRecorderSampleBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TimeTag;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.seis.cube.TriggerEventBlock;
import de.gfz_potsdam.gipp.common.seis.cube.VoltageBlock;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import de.gfz_potsdam.gipp.tool.GippToolsConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Locale;

public class CubeEvent
extends GippToolsApplication {
    private static final int BUFFER_SIZE = 8192;
    private static final int MAXIMUM_GNSS_AGE_OK = 5;
    private static final Locale OUTPUT_LOCALE = Locale.ENGLISH;
    protected final CmdLineString inputFilterOption = new CmdLineString("include-pattern", "Only read data from \"event recorder\" files matching the given pattern. Files with names not matching the pattern will be ignored.\nExample: To process only files recorded by Recorder #Q12 you could use \"--include-pattern='*.Q12'\". (Don't forget the single quotes when using wildcard characters at the command line!)\nHint: There is a predefined pattern for your convenience (\"--include-pattern=GIPP\") that can be used to exclude everything but \"event recorder\" data files following the GIPP file naming convention for those recorders.");
    private final CmdLineString wnroCorrectionOption = GippToolsCommonOptions.newWnroCorrectionOption();
    private final CmdLineString outputFormatOption = new CmdLineString("format", "Changes the output format. (The default is \"EVENTS\"):\nEVENTS ... List recorded/triggered events.\nREC ...... Sample values recorded while \"REC\" button was pressed.ALL ...... All recorded sample values.\nBATTERY .. Battery voltage.\n", null);
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    protected RegexFilenameFilter inputFilter = null;
    private OutputFormat outFormat = OutputFormat.EVENTS;
    private File outputDir = null;
    private boolean forceOverwrite = false;
    private TimeSpan wnroCorrection = null;

    public CubeEvent(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.wnroCorrectionOption).set(CmdLineOption.Visibility.HIDDEN);
        this.cmdLineParser.registerOption(this.outputFormatOption);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.setProgramName("cubeevent");
        this.cmdLineParser.setProgramDescription("list events captured by the \"event recorder\" hardware");
        this.cmdLineParser.setProgramArguments("event-recorder-FILE|DIRECTORY ...");
        this.cmdLineParser.setCopyrightInfo(GippToolsConfig.getCopyright());
        this.cmdLineParser.setLicenseInfo(GippToolsConfig.getLicenseText());
    }

    private static void printFileHeader(PrintWriter out, File file, TraceInfo traceInfo) {
        assert (out != null) : "Argument 'out' must not be null.";
        if (file != null && file.length() > 0L) {
            out.format(OUTPUT_LOCALE, "# ------------------------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "# recording unit:  %s                          file name:  %s%n", traceInfo.getCubeName(), file.getName());
            out.format(OUTPUT_LOCALE, "# ------------------------------------------------------------------------%n", new Object[0]);
        } else {
            out.format(OUTPUT_LOCALE, "# ------------------------------------------------------------------------%n", new Object[0]);
            out.format(OUTPUT_LOCALE, "# recording unit:  %s %n", traceInfo.getCubeName());
            out.format(OUTPUT_LOCALE, "# ------------------------------------------------------------------------%n", new Object[0]);
        }
    }

    private static void printSample(PrintWriter out, TimeMoment time, EventRecorderSampleBlock data) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (time != null) : "Argument 'time' must not be null.";
        assert (data != null) : "Argument 'data' must not be null.";
        assert (data.getNumberOfChannels() == 2) : "Unexpected number of recording channels!";
        char buttonPressed = data.isRecordButtonPressed() ? (char)'1' : '0';
        char triggerEvent = data.isTriggerSample() ? (char)'1' : '0';
        out.format(OUTPUT_LOCALE, "%s  %6d  %6d  %c  %c%n", time.toIsoString(), data.getValue(0), data.getValue(1), Character.valueOf(buttonPressed), Character.valueOf(triggerEvent));
    }

    private static void printBatteryVoltage(PrintWriter out, TimeMoment time, VoltageBlock voltage) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (time != null) : "Argument 'time' must not be null.";
        assert (voltage != null) : "Argument 'voltage' must not be null.";
        out.format(OUTPUT_LOCALE, "%s  battery  %s%n", time.toLogString(), voltage);
    }

    private static void printEvent(PrintWriter out, TimeMoment eventTime, long eventIndex, int gpsAge) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (eventTime != null) : "Argument 'eventTime' must not be null.";
        assert (eventIndex > 0L) : "Argument 'eventIndex' must be greater then zero.";
        if (gpsAge < 5) {
            out.format(OUTPUT_LOCALE, "Event #%-3d  %s   (GPS ok)%n", eventIndex, eventTime.toIsoString());
        } else {
            String ageInfo = TimeSpan.SECOND.multiply(gpsAge).getApproximateString();
            out.format(OUTPUT_LOCALE, "Event #%-3d  %s   (GPS %s old)%n", eventIndex, eventTime.toIsoString(), ageInfo);
        }
    }

    public static void main(String[] args) {
        CubeEvent cubeevent = new CubeEvent(args);
        try {
            cubeevent.handleCommonOptions();
            cubeevent.handleGippToolOptions();
            cubeevent.handleInputOptions();
            cubeevent.handleDataQualityOptions();
            cubeevent.handleReportOptions();
            cubeevent.handleOutputOptions();
            cubeevent.run();
        }
        catch (CmdLineException e) {
            cubeevent.logThrowable(e);
            System.exit(64);
        }
        catch (OutOfMemoryError e) {
            cubeevent.log.severe("Ran out of memory! Please reduce the amount of \"event recorder\" input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            cubeevent.logThrowable(e);
            System.exit(99);
        }
    }

    private void handleInputOptions() {
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addEventRecorderFilenameFilter(this.inputFilter);
                    this.log.info("Processing files with a filename matched by the predefined (GIPP) \"event recorder\" filename pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    private void handleDataQualityOptions() {
        this.wnroCorrection = GippToolsCommonOptions.evalWnroCorrectionOption(this.log, this.wnroCorrectionOption);
    }

    private void handleReportOptions() {
        if (this.outputFormatOption.isMatched()) {
            String format = this.outputFormatOption.getValue().toUpperCase();
            if (format.startsWith("EVE")) {
                this.outFormat = OutputFormat.EVENTS;
            } else if (format.startsWith("ALL")) {
                this.outFormat = OutputFormat.ALL_SAMPLES;
            } else if (format.startsWith("REC")) {
                this.outFormat = OutputFormat.REC_SAMPLES;
            } else if (format.startsWith("BAT")) {
                this.outFormat = OutputFormat.BATTERY;
            } else if (format.equalsIgnoreCase("DEBUG")) {
                this.outFormat = OutputFormat.DEBUG;
            } else {
                this.log.severe("Unknown output format '" + format + "'. Please use one of EVENTS, ALL, REC, BATTERY instead.");
                System.exit(64);
            }
            this.log.info("Switching to '" + (Object)((Object)this.outFormat) + "' output format.");
        } else {
            this.log.fine("Using the default output mode ('" + this.outFormat.toString() + "').");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing output files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing files will NOT be overwritten.");
        }
        if (!this.outputDirOption.isMatched()) {
            this.outputDir = null;
            this.log.fine("All results will be written to \"standard output\" (console).");
            return;
        }
        this.outputDir = new File(this.outputDirOption.getValue());
        if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
            this.log.info("The requested information will be written to the '" + this.outputDir.getPath() + "' directory.");
            return;
        }
        this.outputDir = null;
        throw new CmdLineException("Cannot write to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
    }

    private PrintWriter getWriter(File eventLoggerFile) throws FileNotFoundException {
        assert (eventLoggerFile != null) : "No file was given!";
        if (this.outputDir != null) {
            String basename = eventLoggerFile.getName() + "." + this.outFormat.toString().toLowerCase();
            File outFile = this.getOutputFile(this.outputDir, basename, "txt", this.forceOverwrite);
            this.log.info("Creating a new file at '" + outFile.getPath() + "'.");
            return new PrintWriter(new FileOutputStream(outFile), true);
        }
        return new PrintWriter(System.out, true);
    }

    void freeWriter(PrintWriter outWriter) {
        assert (outWriter != null) : "Cannot free an 'null' print writer!";
        if (this.outputDir != null) {
            FileUtils.flushClose(outWriter);
        } else {
            outWriter.flush();
        }
    }

    private long writeTraceSegment(FileChannel inChannel, PrintWriter outWriter, TimeSpan samplePeriod, TimeTag startTag, TimeTag stopTag, long eventCountOffset) throws IOException {
        long sampleCount = 0L;
        long eventCount = 0L;
        EventRecorderSampleBlock sampleBlock = new EventRecorderSampleBlock();
        VoltageBlock voltageBlock = new VoltageBlock();
        TriggerEventBlock eventBlock = new TriggerEventBlock();
        TimeMoment currentTime = null;
        int taipCount = -1;
        ByteBuffer inBuffer = ByteBuffer.allocateDirect(8192);
        inChannel.position(startTag.offset());
        inChannel.read(inBuffer);
        inBuffer.flip();
        int blockFlag = 152;
        block8: while (true) {
            try {
                while (true) {
                    inBuffer.mark();
                    switch (blockFlag) {
                        case 136: 
                        case 152: {
                            if (startTag.number() + sampleCount >= stopTag.number()) break block8;
                            blockFlag = sampleBlock.read(inBuffer);
                            currentTime = TimeSpan.add(startTag.time(), samplePeriod.multiply(sampleCount));
                            ++sampleCount;
                            if (this.outFormat == OutputFormat.REC_SAMPLES && sampleBlock.isRecordButtonPressed()) {
                                CubeEvent.printSample(outWriter, currentTime, sampleBlock);
                                break;
                            }
                            if (this.outFormat != OutputFormat.ALL_SAMPLES && this.outFormat != OutputFormat.DEBUG) continue block8;
                            CubeEvent.printSample(outWriter, currentTime, sampleBlock);
                            break;
                        }
                        case 200: {
                            blockFlag = voltageBlock.read(inBuffer);
                            if (this.outFormat != OutputFormat.BATTERY && this.outFormat != OutputFormat.DEBUG) continue block8;
                            CubeEvent.printBatteryVoltage(outWriter, currentTime, voltageBlock);
                            break;
                        }
                        case 160: {
                            blockFlag = Block.skip(inBuffer);
                            ++taipCount;
                            break;
                        }
                        case 184: {
                            blockFlag = eventBlock.read(inBuffer);
                            ++eventCount;
                            if (this.outFormat != OutputFormat.EVENTS && this.outFormat != OutputFormat.DEBUG) continue block8;
                            TimeMoment triggerTime = startTag.time().subtract(eventBlock.timeOffset()).add(TimeSpan.SECOND.multiply(taipCount));
                            CubeEvent.printEvent(outWriter, triggerTime, eventCount + eventCountOffset, taipCount);
                            break;
                        }
                        default: {
                            blockFlag = Block.skip(inBuffer);
                            break;
                        }
                    }
                }
            }
            catch (BufferUnderflowException e) {
                inBuffer.reset();
                inBuffer.compact();
                if (inChannel.read(inBuffer) == -1) break;
                inBuffer.flip();
                continue;
            }
            break;
        }
        return eventCount;
    }

    /*
     * Exception decompiling
     */
    private void convertEventRecorderFile(File eventFile, TraceInfo traceInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static enum OutputFormat {
        EVENTS,
        ALL_SAMPLES,
        REC_SAMPLES,
        BATTERY,
        DEBUG;

    }
}

