/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool.cube;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.GippFilenameFilter;
import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.geo.LatLonPoint;
import de.gfz_potsdam.gipp.common.seis.cube.AuxiliaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.CubeException;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.FringeSampleUtils;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.TaipBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TemperatureBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.seis.cube.VoltageBlock;
import de.gfz_potsdam.gipp.common.seis.cube.WnroUtil;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.Stopwatch;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsCommonOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class CubeAux
extends GippToolsApplication {
    private static final Locale OUTPUT_LOCALE = Locale.ENGLISH;
    private static StringBuilder aux1MessageBuffer = new StringBuilder(14);
    private static StringBuilder aux2MessageBuffer;
    private static TimeMoment aux1MessageTime;
    private static TimeMoment aux2MessageTime;
    private final CmdLineString inputFilterOption = GippToolsCommonOptions.newCubeInputFilterOption();
    private final CmdLineString wnroCorrectionOption = GippToolsCommonOptions.newWnroCorrectionOption();
    private final CmdLineString channelOption = new CmdLineString("channel", "Select the secondary recording channel that should be read.\nAUXILIARY .... Data generated by custom-build hardware.\nGNSS ......... GNSS information (i.e. position).\nTEMPERATURE .. Temperature inside the Cube enclosure.\nVOLTAGE ...... Operational voltage of the Cube.\nIf no channel is selected, ALL available auxiliary data are returned.", null);
    private final CmdLineString outputDirOption = GippToolsCommonOptions.newOutputDirectoryOption();
    private final CmdLineBoolean forceOverwriteOption = GippToolsCommonOptions.newForceOverwriteOption();
    private final List<Integer> requestedBlocks = new ArrayList<Integer>(4);
    private RegexFilenameFilter inputFilter = null;
    private File outputDir = null;
    private boolean forceOverwrite = false;
    private TimeSpan wnroCorrection = null;

    public CubeAux(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.registerOption(this.inputFilterOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.wnroCorrectionOption).set(CmdLineOption.Visibility.HIDDEN);
        this.cmdLineParser.registerOption(this.channelOption).set(CmdLineOption.Occurrence.ZERO_OR_MORE);
        this.cmdLineParser.registerOption(this.outputDirOption);
        this.cmdLineParser.registerOption(this.forceOverwriteOption);
        this.cmdLineParser.setProgramName("cubeaux");
        this.cmdLineParser.setProgramDescription("read out auxiliary recording channels from Cube files");
        this.cmdLineParser.setProgramArguments("Cube-FILE|DIRECTORY...");
    }

    public static void main(String[] args) {
        CubeAux cubeaux = new CubeAux(args);
        try {
            cubeaux.handleCommonOptions();
            cubeaux.handleGippToolOptions();
            cubeaux.handleInputOptions();
            cubeaux.handleDataQualityOptions();
            cubeaux.handleAuxOptions();
            cubeaux.handleOutputOptions();
            cubeaux.run();
        }
        catch (CmdLineException e) {
            cubeaux.logThrowable(e);
            System.exit(64);
        }
        catch (OutOfMemoryError e) {
            cubeaux.log.severe("Ran out of memory! Please reduce the amount of Cube input to process or increase the JRE heap space.");
            System.exit(70);
        }
        catch (Exception e) {
            cubeaux.logThrowable(e);
            System.exit(99);
        }
    }

    protected void handleInputOptions() {
        if (this.inputFilterOption.isMatched()) {
            this.inputFilter = new RegexFilenameFilter();
            for (String pattern : this.inputFilterOption.getValues()) {
                if (pattern.equalsIgnoreCase("GIPP")) {
                    GippFilenameFilter.addCubeFilenameFilter(this.inputFilter);
                    this.log.info("Processing Cube files with a filename matched by the predefined \"GIPP Cube filename\" pattern.");
                    continue;
                }
                this.inputFilter.addGlobbing(pattern);
                this.log.info("Processing Cube files with a filename that matches the '" + pattern + "' pattern.");
            }
        } else {
            this.inputFilter = null;
            this.log.fine("No (include) filename pattern is applied.");
        }
    }

    private void handleDataQualityOptions() {
        this.wnroCorrection = GippToolsCommonOptions.evalWnroCorrectionOption(this.log, this.wnroCorrectionOption);
    }

    private void handleAuxOptions() {
        if (this.channelOption.isMatched()) {
            for (String channel : this.channelOption.getValues()) {
                if ((channel = channel.trim().toUpperCase()).startsWith("GNSS") || channel.startsWith("GPS") || channel.startsWith("TAIP")) {
                    this.requestedBlocks.add(160);
                    this.log.info("Selecting GNSS channel.");
                    continue;
                }
                if (channel.startsWith("TEMP")) {
                    this.requestedBlocks.add(206);
                    this.log.info("Selecting TEMPERATURE channel.");
                    continue;
                }
                if (channel.startsWith("VOLT") || channel.startsWith("BAT")) {
                    this.requestedBlocks.add(200);
                    this.log.info("Selecting operational VOLTAGE channel.");
                    continue;
                }
                if (channel.startsWith("AUX")) {
                    this.requestedBlocks.add(209);
                    this.requestedBlocks.add(210);
                    this.log.info("Selecting custom hardware AUXILIARY channel(s).");
                    continue;
                }
                if (channel.startsWith("ALL")) {
                    this.requestedBlocks.add(160);
                    this.requestedBlocks.add(206);
                    this.requestedBlocks.add(200);
                    this.requestedBlocks.add(209);
                    this.requestedBlocks.add(210);
                    this.log.info("Selecting GNSS, TEMPERATURE, VOLTAGE and AUXILIARY channels.");
                    continue;
                }
                try {
                    int blockType = channel.startsWith("0X") ? Integer.parseUnsignedInt(channel.substring(2), 16) : Integer.parseUnsignedInt(channel);
                    if (blockType <= 255) {
                        this.requestedBlocks.add(blockType);
                        this.log.info("Reporting block type " + StringUtils.toHexString(blockType) + ".");
                        continue;
                    }
                    this.log.severe("Impossible block type " + StringUtils.toHexString(blockType) + "!");
                    System.exit(64);
                }
                catch (NumberFormatException e) {
                    this.log.severe("Secondary recording channel '" + channel + "' is unknown! Please select one of GNSS, TEMPERATURE, VOLTAGE, AUXILIARY  instead.");
                    System.exit(64);
                }
            }
        } else {
            this.requestedBlocks.add(160);
            this.requestedBlocks.add(206);
            this.requestedBlocks.add(200);
            this.requestedBlocks.add(209);
            this.requestedBlocks.add(210);
            this.log.info("No auxiliary/secondary channel was explicitly specified! Selecting GNSS, TEMPERATURE, VOLTAGE and AUXILIARY channels.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOutputOptions() {
        if (this.forceOverwriteOption.isMatched()) {
            this.forceOverwrite = true;
            this.log.info("Already existing files will be overwritten!");
        } else {
            this.forceOverwrite = false;
            this.log.fine("Already existing files will NOT be overwritten.");
        }
        if (!this.outputDirOption.isMatched()) {
            this.outputDir = null;
            this.log.fine("All results will be written to \"standard output\" (console).");
            return;
        }
        this.outputDir = new File(this.outputDirOption.getValue());
        if (this.outputDir.isDirectory() && this.outputDir.canWrite()) {
            this.log.info("The requested auxiliary channel will be written to the '" + this.outputDir.getPath() + "' directory.");
            return;
        }
        this.outputDir = null;
        throw new CmdLineException("Cannot write to '" + this.outputDirOption.getValue() + "'. Does this directory exist and if yes, is it writable?");
    }

    private PrintWriter getWriter(TraceInfo traceInfo, File outputDir, boolean forceOverwrite) throws IOException {
        assert (traceInfo != null);
        if (outputDir != null) {
            String basename = traceInfo.getCubeName() + '.' + traceInfo.getFirstTimeTag().time().toFilesystemString();
            File outFile = this.getOutputFile(outputDir, basename, "txt", forceOverwrite);
            this.log.info("Creating a new file at '" + outFile.getPath() + "'.");
            return new PrintWriter(Files.newOutputStream(outFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
        }
        return new PrintWriter(System.out, true);
    }

    private void freeWriter(PrintWriter outWriter) {
        assert (outWriter != null) : "Cannot free an 'null' print writer!";
        if (this.outputDir != null) {
            FileUtils.flushClose(outWriter);
        } else {
            outWriter.flush();
        }
    }

    private void processSegment(RandomAccessFile cubeFile, PrintWriter outWriter, BlockTag start, BlockTag stop, TraceInfo traceInfo) throws IOException, IntegrityException, TimeException {
        AuxiliaryBlock auxiliary = new AuxiliaryBlock();
        BinaryBlock binary = new BinaryBlock();
        TaipBlock taip = new TaipBlock();
        TemperatureBlock temperature = new TemperatureBlock();
        VoltageBlock voltage = new VoltageBlock();
        assert (start.offset() - 1L >= 0L) : "Invalid (i.e. negative) file offset!";
        cubeFile.seek(start.offset() - 1L);
        long sampleNumber = start.number() - 1L;
        int blockFlag = cubeFile.read();
        boolean eof = false;
        block10: while (!eof && sampleNumber < stop.number()) {
            TimeMoment approxTime;
            switch (blockFlag) {
                case 128: 
                case 136: 
                case 144: 
                case 152: {
                    blockFlag = Block.skip(cubeFile);
                    ++sampleNumber;
                    continue block10;
                }
                case 209: {
                    if (this.requestedBlocks.contains(blockFlag)) {
                        blockFlag = auxiliary.read(cubeFile);
                        approxTime = traceInfo.getApproximateTimeAt(sampleNumber);
                        if (aux1MessageTime == null) {
                            aux1MessageTime = approxTime;
                        }
                        aux1MessageBuffer.append(auxiliary);
                        if (!auxiliary.isLast()) continue block10;
                        outWriter.format(OUTPUT_LOCALE, "%s  %s  %s%n", aux1MessageTime.toLogString(), traceInfo.getCubeName(), StringUtils.replaceControlCodes(aux1MessageBuffer.toString()));
                        aux1MessageBuffer = new StringBuilder(14);
                        aux1MessageTime = null;
                        continue block10;
                    }
                    blockFlag = Block.skip(cubeFile);
                    continue block10;
                }
                case 210: {
                    if (this.requestedBlocks.contains(blockFlag)) {
                        blockFlag = auxiliary.read(cubeFile);
                        approxTime = traceInfo.getApproximateTimeAt(sampleNumber);
                        if (aux2MessageTime == null) {
                            aux2MessageTime = approxTime;
                        }
                        aux2MessageBuffer.append(auxiliary);
                        if (!auxiliary.isLast()) continue block10;
                        outWriter.format(OUTPUT_LOCALE, "%s  %s  %s%n", aux2MessageTime.toLogString(), traceInfo.getCubeName(), StringUtils.replaceControlCodes(aux2MessageBuffer.toString()));
                        aux2MessageBuffer = new StringBuilder(14);
                        aux2MessageTime = null;
                        continue block10;
                    }
                    blockFlag = Block.skip(cubeFile);
                    continue block10;
                }
                case 160: {
                    if (this.requestedBlocks.contains(blockFlag)) {
                        blockFlag = taip.read(cubeFile);
                        approxTime = traceInfo.getApproximateTimeAt(sampleNumber);
                        if (!taip.isValid()) continue block10;
                        StringBuilder gnssInfo = new StringBuilder();
                        LatLonPoint pos = taip.getPosition();
                        if (pos != null) {
                            gnssInfo.append(pos);
                        } else {
                            gnssInfo.append("  no-data     no-data ");
                        }
                        Double elevation = taip.getElevation();
                        if (elevation != null) {
                            gnssInfo.append("  ").append(elevation);
                        } else {
                            gnssInfo.append("  no-data");
                        }
                        Integer satellites = taip.getNumOfSatellites();
                        if (satellites != null) {
                            gnssInfo.append("  ").append(String.format("%2d", satellites));
                        } else {
                            gnssInfo.append("  no-data");
                        }
                        gnssInfo.append("  ").append(taip.getClockSource());
                        outWriter.format(OUTPUT_LOCALE, "%s  %s  %s%n", approxTime.toLogString(), traceInfo.getCubeName(), gnssInfo);
                        continue block10;
                    }
                    blockFlag = Block.skip(cubeFile);
                    continue block10;
                }
                case 206: {
                    if (this.requestedBlocks.contains(blockFlag)) {
                        blockFlag = temperature.read(cubeFile);
                        approxTime = traceInfo.getApproximateTimeAt(sampleNumber);
                        outWriter.format(OUTPUT_LOCALE, "%s  %s  %6.2f Celsius%n", approxTime.toLogString(), traceInfo.getCubeName(), temperature.getTemperature());
                        continue block10;
                    }
                    blockFlag = Block.skip(cubeFile);
                    continue block10;
                }
                case 200: {
                    if (this.requestedBlocks.contains(blockFlag)) {
                        blockFlag = voltage.read(cubeFile);
                        approxTime = traceInfo.getApproximateTimeAt(sampleNumber);
                        outWriter.format(OUTPUT_LOCALE, "%s  %s  %6.2f Volt%n", approxTime.toLogString(), traceInfo.getCubeName(), voltage.getVoltage());
                        continue block10;
                    }
                    blockFlag = Block.skip(cubeFile);
                    continue block10;
                }
                case -1: {
                    eof = true;
                    continue block10;
                }
                case 239: {
                    if (this.requestedBlocks.contains(blockFlag)) {
                        blockFlag = binary.read(cubeFile);
                        approxTime = traceInfo.getApproximateTimeAt(sampleNumber);
                        outWriter.format(OUTPUT_LOCALE, "%s  %s  0xef%n", approxTime.toLogString(), traceInfo.getCubeName());
                        continue block10;
                    }
                    blockFlag = Block.skip(cubeFile);
                    continue block10;
                }
            }
            if (this.requestedBlocks.contains(blockFlag)) {
                String blockType = "0x" + StringUtils.toHexString((byte)blockFlag);
                blockFlag = binary.read(cubeFile);
                approxTime = traceInfo.getApproximateTimeAt(sampleNumber);
                outWriter.format(OUTPUT_LOCALE, "%s  %s  %s %s%n", approxTime.toLogString(), traceInfo.getCubeName(), blockType, binary);
                continue;
            }
            blockFlag = Block.skip(cubeFile);
        }
        outWriter.flush();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTrace(TraceInfo traceInfo) {
        assert (traceInfo != null);
        assert (traceInfo.getTimeTagCount() > 0);
        RandomAccessFile inStream = null;
        PrintWriter outWriter = null;
        try {
            outWriter = this.getWriter(traceInfo, this.outputDir, this.forceOverwrite);
            Iterator<BlockTag> iter = traceInfo.getIndex().iterator();
            BlockTag start = iter.next();
            while (iter.hasNext()) {
                BlockTag stop = iter.next();
                if (inStream == null) {
                    this.log.info("Processing file '" + start.file().getName() + "' .. ");
                    inStream = new RandomAccessFile(start.file(), "r");
                }
                this.log.fine("  '" + start.file().getName() + "' : #" + start.number() + " to #" + stop.number() + " ...");
                this.processSegment(inStream, outWriter, start, stop, traceInfo);
                if (start.offset() > stop.offset()) {
                    this.log.fine("Closing file '" + start.file().getName() + "'");
                    FileUtils.flushClose(inStream);
                    inStream = null;
                }
                start = stop;
            }
        }
        catch (FileNotFoundException e) {
            try {
                this.log.fine("FileNotFoundException caught!");
                throw new RuntimeException(e);
                catch (IOException e2) {
                    this.log.fine("IOException caught!");
                    throw new RuntimeException(e2);
                }
                catch (IntegrityException e3) {
                    this.log.fine("IntegrityException caught!");
                    throw new RuntimeException(e3);
                }
                catch (TimeException e4) {
                    this.log.fine("TimeException caught!");
                    throw new RuntimeException(e4);
                }
            }
            catch (Throwable throwable) {
                FileUtils.flushClose(inStream);
                this.freeWriter(outWriter);
                throw throwable;
            }
        }
        FileUtils.flushClose(inStream);
        this.freeWriter(outWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        Stopwatch totalRunTime = new Stopwatch();
        Stopwatch traceRunTime = new Stopwatch();
        long traceSize = 0L;
        long totalSize = 0L;
        SortedFileSet fileList = null;
        if (!this.cmdLineParser.getArgumentList().isEmpty()) {
            fileList = CubeUtils.buildCubeFileList(this.cmdLineParser.getArgumentList(), this.inputFilter);
            if (fileList.isEmpty()) {
                return;
            }
        } else {
            this.log.severe("No input file was given. At least one Cube input file or directory containing one is required!");
            System.exit(64);
        }
        TraceInfo traceInfo = new TraceInfo();
        for (File cubeFile : fileList) {
            try {
                if (!traceInfo.isContinuous(cubeFile)) {
                    this.log.info("End of trace detected");
                    try {
                        WnroUtil.wnroCorrection(traceInfo, this.wnroCorrection);
                        FringeSampleUtils.includeFringeSamples(traceInfo, FringeSampleUtils.FringeSampleTreatment.NOMINAL);
                        this.processTrace(traceInfo);
                        this.log.info("Processed " + StringUtils.toShortIecByteCount(traceSize) + " in " + traceRunTime);
                    }
                    catch (CubeException | TimeException e) {
                        this.log.severe("Processing of trace failed! Reason: " + e.getMessage());
                    }
                    finally {
                        traceInfo = new TraceInfo();
                        traceSize = 0L;
                        traceRunTime.restart();
                    }
                }
                this.log.info("Scanning file '" + cubeFile.getName() + "'  (" + StringUtils.toShortIecByteCount(cubeFile.length()) + ")");
                if (CubeUtils.isLeapSecondListOutdated(cubeFile)) {
                    this.log.severe("The available leap second table is too old to process the file '" + cubeFile.getAbsolutePath() + "'! You need a software update first!!!");
                    continue;
                }
                traceInfo.append(cubeFile);
                traceSize += cubeFile.length();
                totalSize += cubeFile.length();
            }
            catch (FileNotFoundException e) {
                this.log.severe("File '" + cubeFile.getAbsolutePath() + "' disappeared!");
            }
            catch (IOException e) {
                this.log.severe("Couldn't read from file '" + cubeFile.getAbsolutePath() + "'! Permissions?");
            }
            catch (CubeException e) {
                this.log.warning("Cube file format problem! Reason: " + e.getMessage());
                this.log.severe("Cube file '" + cubeFile.getName() + "' is corrupt! Trying to process data up to the corrupt file position but conversion will be incomplete!");
                break;
            }
        }
        this.log.info("End of (last) trace detected");
        try {
            WnroUtil.wnroCorrection(traceInfo, this.wnroCorrection);
            FringeSampleUtils.includeFringeSamples(traceInfo, FringeSampleUtils.FringeSampleTreatment.NOMINAL);
            this.processTrace(traceInfo);
            this.log.info("Processed " + StringUtils.toShortIecByteCount(traceSize) + " in " + traceRunTime);
        }
        catch (CubeException | TimeException e) {
            this.log.severe("Conversion of trace failed! Reason: " + e.getMessage());
        }
        this.log.info("Finished in " + totalRunTime + "  (processed " + StringUtils.toShortIecByteCount(totalSize) + " total)");
    }

    static {
        aux1MessageTime = null;
        aux2MessageBuffer = new StringBuilder(14);
        aux2MessageTime = null;
    }
}

