/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool;

import de.gfz_potsdam.gipp.tool.GippToolsApplication;
import de.gfz_potsdam.gipp.tool.GippToolsConfig;
import de.gfz_potsdam.gipp.tool.cube.CubeAux;
import de.gfz_potsdam.gipp.tool.cube.CubeEvent;
import de.gfz_potsdam.gipp.tool.cube.CubeInfo;
import de.gfz_potsdam.gipp.tool.cube.CubeInspect;
import de.gfz_potsdam.gipp.tool.cube.CubeSum;
import de.gfz_potsdam.gipp.tool.cube.CubeToAscii;
import de.gfz_potsdam.gipp.tool.cube.CubeToMseed;
import de.gfz_potsdam.gipp.tool.miniseed.MseedCut;
import de.gfz_potsdam.gipp.tool.miniseed.MseedInfo;
import de.gfz_potsdam.gipp.tool.miniseed.MseedRecover;
import de.gfz_potsdam.gipp.tool.miniseed.MseedRename;
import de.gfz_potsdam.gipp.tool.miniseed.MseedToAscii;
import de.gfz_potsdam.gipp.tool.miniseed.MseedToMseed;
import de.gfz_potsdam.gipp.tool.miniseed.MseedToPdas;
import de.gfz_potsdam.gipp.tool.segy.CubeToSegy;
import de.gfz_potsdam.gipp.tool.segy.MseedToSegy;
import java.io.PrintStream;
import java.util.Vector;

public class GippToolsStarter
extends GippToolsApplication {
    private static final String RUN_TOOL_OPT = "--run-tool";

    private GippToolsStarter(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.setProgramName(GippToolsConfig.getPackageName().toLowerCase());
    }

    private static void printOnlineHelp(PrintStream prt) {
        String scriptName = GippToolsConfig.getPackageName().toLowerCase();
        String packageName = GippToolsConfig.getPackageName();
        prt.println();
        prt.println("  The '" + scriptName + "' script is the common start script used to execute the ");
        prt.println("  utilities of the " + packageName + " software collection.");
        prt.println();
        prt.println("  Synopsis:  " + scriptName + " [" + RUN_TOOL_OPT + "=TOOL [TOOLPARAM]...]");
        prt.println();
        prt.println("  Here, TOOL is the " + packageName + " program you want to start. All following");
        prt.println("  TOOLPARAMs will be forwarded to the respective TOOL.");
        prt.println();
        prt.println("  Valid TOOL values are:");
        prt.println();
        prt.println("      cube2ascii    convert Cube files to various ASCII text formats");
        prt.println("      cube2mseed    convert Cube files to miniSEED format");
        prt.println("      cube2segy     convert Cube files to SEG-Y format");
        prt.println("      cubeaux       read out auxiliary recording channels from Cube files");
        prt.println("      cubeevent     list events captured by the \"event recorder\" hardware");
        prt.println("      cubeinfo      inspect and summarize the content of a Cube recording");
        prt.println("      cubeinspect   diagnose Cube problems from a recording");
        prt.println("      cubesum       compute and verify checksums (CRCs) of a Cube recording");
        if (!scriptName.equals("cubetools")) {
            prt.println("      mseed2ascii   convert miniSEED data to various ASCII text formats");
            prt.println("      mseed2mseed   modify miniSEED header fields");
            prt.println("      mseed2pdas    convert miniSEED data to PDAS format");
            prt.println("      mseed2segy    convert miniSEED files to SEG-Y format");
            prt.println("      mseedcut      cut out or split the miniSEED input into pieces");
            prt.println("      mseedinfo     inspect and summarize the content of a miniSEED files");
            prt.println("      mseedrecover  recover miniSEED records from damaged files and disks");
            prt.println("      mseedrename   batch rename miniSEED files using a template");
        }
        prt.println();
        prt.println("  The list of possible values for TOOLPARAMETER is different for every");
        prt.println("  TOOL. However, almost all TOOLs understand the '--help' argument, which");
        prt.println("  you might try for more information.");
        prt.println();
        prt.println("  Example:");
        prt.println();
        prt.println("    To display the online help of the 'cubeinfo' utility use:");
        prt.println();
        prt.println("          " + scriptName + " " + RUN_TOOL_OPT + "=cubeinfo --help");
        prt.println();
        prt.println("    However, there should also be another start script called 'cubeinfo'");
        prt.println("    that you can call directly:");
        prt.println();
        prt.println("          cubeinfo --help");
        prt.println();
        prt.println("    Start scripts for the other utilities of the " + packageName + " collection");
        prt.println("    are provided as well.");
        prt.println();
    }

    public static void main(String[] allArgs) {
        Vector<String> buffer = new Vector<String>(allArgs.length);
        String tool = null;
        for (String param : allArgs) {
            if (param.startsWith(RUN_TOOL_OPT)) {
                tool = param.substring(RUN_TOOL_OPT.length() + 1);
                continue;
            }
            buffer.add(param);
        }
        String[] strippedArgs = new String[buffer.size()];
        buffer.toArray(strippedArgs);
        if (tool != null) {
            if (tool.equalsIgnoreCase("cubeaux")) {
                CubeAux.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("cubeevent")) {
                CubeEvent.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("cubeinfo")) {
                CubeInfo.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("cubeinspect")) {
                CubeInspect.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("cubesum")) {
                CubeSum.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("cube2ascii") || tool.equalsIgnoreCase("cubetoascii")) {
                CubeToAscii.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("cube2mseed") || tool.equalsIgnoreCase("cubetomseed")) {
                CubeToMseed.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("cube2segy") || tool.equalsIgnoreCase("cubetosegy")) {
                CubeToSegy.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("mseedcut") || tool.equalsIgnoreCase("edlcut")) {
                MseedCut.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("mseedinfo")) {
                MseedInfo.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("mseedrecover") || tool.equalsIgnoreCase("edlrecover")) {
                MseedRecover.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("mseedrename") || tool.equalsIgnoreCase("edlrename")) {
                MseedRename.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("mseed2ascii") || tool.equalsIgnoreCase("mseedtoascii") || tool.equalsIgnoreCase("edl2ascii") || tool.equalsIgnoreCase("edltoascii")) {
                MseedToAscii.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("mseed2mseed") || tool.equalsIgnoreCase("mseedtomseed") || tool.equalsIgnoreCase("edl2edl") || tool.equalsIgnoreCase("edltoedl")) {
                MseedToMseed.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("mseed2pdas") || tool.equalsIgnoreCase("mseedtopdas") || tool.equalsIgnoreCase("edl2pdas") || tool.equalsIgnoreCase("edltopdas")) {
                MseedToPdas.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("mseed2segy") || tool.equalsIgnoreCase("mseedtosegy") || tool.equalsIgnoreCase("edl2segy") || tool.equalsIgnoreCase("edltosegy")) {
                MseedToSegy.main(strippedArgs);
            } else if (tool.equalsIgnoreCase("gipptools") || tool.equalsIgnoreCase("gipptool") || tool.equalsIgnoreCase("gipputilities") || tool.equalsIgnoreCase("cubetools") || tool.equalsIgnoreCase("cubetool") || tool.equalsIgnoreCase("cubeutilities") || tool.equalsIgnoreCase("toolstart")) {
                GippToolsStarter starterApp = new GippToolsStarter(strippedArgs);
                if (starterApp.versionOption.isMatched()) {
                    starterApp.cmdLineParser.printReleaseInfo(System.out);
                    System.exit(0);
                } else if (starterApp.sysinfoOption.isMatched()) {
                    starterApp.printSystemInfo(System.out);
                    System.exit(0);
                } else if (starterApp.helpOption.isMatched()) {
                    GippToolsStarter.printOnlineHelp(System.out);
                    System.exit(0);
                } else {
                    GippToolsStarter.printOnlineHelp(System.err);
                    System.exit(64);
                }
            } else {
                System.err.println();
                System.err.println("ERROR!  Unknown '--run-tool' argument! An utility called '" + tool + "' is not known!");
                GippToolsStarter.printOnlineHelp(System.err);
                System.exit(64);
            }
        } else {
            GippToolsStarter.printOnlineHelp(System.out);
            System.exit(64);
        }
    }
}

