/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.time.ParserException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.InputStream;
import java.util.Properties;

public final class GippToolsConfig {
    private static final String[] PROPERTY_FILES = new String[]{"/config/info.properties", "/config/config.properties"};
    private static final Properties gippConfig = new Properties();

    public static String getPackageName() {
        String keyword = "package.name";
        String fallback = "GIPPtools";
        return gippConfig.getProperty("package.name", "GIPPtools");
    }

    public static String getPackageReleaseInfo() {
        String keyword = "package.release.id";
        String fallback = "TESTING";
        return gippConfig.getProperty("package.release.id", "TESTING");
    }

    public static String getPackageReleaseDate() {
        String keyword = "package.release.date";
        String fallback = "recently";
        return gippConfig.getProperty("package.release.date", "recently");
    }

    public static String getPackageVendor() {
        String keyword = "package.vendor";
        String fallback = "GIPP";
        return gippConfig.getProperty("package.vendor", "GIPP");
    }

    public static String getCopyright() {
        String keyword = "package.copyright";
        String fallback = "Copyright (c) 2006-" + TimeMoment.now().getYear() + ", GFZ-Potsdam";
        return gippConfig.getProperty("package.copyright", fallback);
    }

    public static String getLicenseText() {
        String keyword = "package.license.text";
        String fallback = "This is free software, which is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.";
        return gippConfig.getProperty("package.license.text", "This is free software, which is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
    }

    public static TimeSpan getDefaultTraceLength() {
        String keyword = "default.trace.length";
        TimeSpan fallback = new TimeSpan.Builder().addMinutes(5L).build();
        try {
            return TimeSpan.parse(gippConfig.getProperty("default.trace.length", fallback.toString()));
        }
        catch (ParserException e) {
            return fallback;
        }
    }

    public static double getDefaultTraceOffset() {
        String keyword = "default.trace.offset";
        double fallback = 0.0;
        try {
            return Double.parseDouble(gippConfig.getProperty("default.trace.offset", Double.toString(0.0)));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        for (String file : PROPERTY_FILES) {
            InputStream stream = GippToolsConfig.class.getResourceAsStream(file);
            try {
                if (stream == null) continue;
                gippConfig.load(stream);
            }
            catch (Exception exception) {
            }
            finally {
                FileUtils.flushClose(stream);
            }
        }
    }
}

