/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineString;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.util.logging.Logger;

public class GippToolsCommonOptions {
    private GippToolsCommonOptions() {
    }

    public static CmdLineString newCubeInputFilterOption() {
        return new CmdLineString("include-pattern", "Only read data from files matching the given pattern. All files with names not matching the filename pattern will be ignored.\nExample: To process only files recorded by the Cube #123 you could use \"--include-pattern='*.123'\". (Don't forget the single quotes when using wildcard characters at the command line!)\nHint: There is a predefined pattern for your convenience (\"--include-pattern=GIPP\") that can be used to exclude everything but Cube data files following the GIPP file naming convention for Cubes.");
    }

    public static CmdLineString newMiniseedInputFilterOption() {
        return new CmdLineString("include-pattern", "Only read data from files matching the given pattern. All files with names not matching the filename pattern will be ignored.\nExample: To process only the first channel recorded by an EDL or EDR digitizer you could use \"--include-pattern='*.pri0'\". (Don't forget the single quotes when using wildcard characters at the command line!)\nHint: There is a predefined pattern (\"--include-pattern=GIPP\") that can be used exclude everything but EDR or EDL data files following the GIPP file naming convention for those recorders.");
    }

    public static CmdLineString newOutputDirectoryOption() {
        return new CmdLineString("output-dir", "Write the result to one or more files in this directory instead of the standard output (console). The directory must exist and be writable!");
    }

    public static CmdLineBoolean newForceOverwriteOption() {
        return new CmdLineBoolean("force-overwrite", "If this option is set, already existing files, will be overwritten without mercy!\nThe default behavior, however, is NOT to overwrite! Instead an additional copy with slightly modified filename will be created.");
    }

    public static CmdLineString newTraceStartOption() {
        return new CmdLineString("trace-start", "Begin the trace at this time. The format for the time string is \"YYYY-MM-DD'T'HH:MM:SS.ssssss\".\nExample: To begin reading samples at 1pm on March 27th, 2007 use \"--trace-start=2007-03-27T13:00:00\".");
    }

    public static CmdLineString newTraceStopOption() {
        return new CmdLineString("trace-stop", "Stop extracting samples at this time. The format for the time string is the same as for the \"--trace-start\" option.");
    }

    public static CmdLineString newTraceLengthOption(TimeSpan defaultLength) {
        assert (defaultLength != null) : "Default trace length must not be 'null' argument!";
        return new CmdLineString("trace-length", "End the trace after this time span. The input format is \"SS.ssssss\" and  is given in seconds. (The default is " + defaultLength + ".)\nExample: To extract 10 minutes of data use \"--trace-length=600\".");
    }

    public static CmdLineString newTraceOffsetOption(double defaultOffset) {
        return new CmdLineString("trace-offset", "Use this option to shift the beginning of the trace relative to the start/stop time of the requested time window. The input format is \"SS.ssssss\" and is given in seconds. (The default is " + defaultOffset + " seconds.) This option does not change the length of the time window itself!\nExample: To start a trace two and a half seconds before a given trace start time use \"--trace-offset=-2.5\".  (Note the minus sign!)");
    }

    public static CmdLineString newSelectStationOption() {
        return new CmdLineString("select-station", "Only process data from the selected station. Data from other stations is ignored/skipped.");
    }

    public static CmdLineString newSelectChannelOption() {
        return new CmdLineString("select-channel", "Only process data from the selected data channel. All other channels are ignored/skipped.");
    }

    public static CmdLineString newWnroCorrectionOption() {
        return new CmdLineString("wnro-correction", "Enable or disable week number rollover (WNRO) correction of the input data.\n\n  AUTO ... Try to automatically detect and correct WNRO\n           problems. (Default)\n  OFF .... Disable any (automatic) WNRO corrections for\n           the input data.\n  FORCE .. Force apply WNRO corrections to the input data.\n\nWarning!  Unless there is a good reason for it the \"WNRO correction\" should be left in the default automatic mode. Use 'OFF' or 'FORCE' arguments to overwrite in case the automatic WNRO detection fails.");
    }

    public static TimeSpan evalWnroCorrectionOption(Logger log, CmdLineString option) {
        if (option.isMatched()) {
            switch (option.getValue().toUpperCase()) {
                case "OFF": 
                case "FALSE": 
                case "NO": 
                case "0": {
                    log.info("Disabling any WNRO corrections for the input data.");
                    return TimeSpan.ZERO;
                }
                case "FORCE": 
                case "ON": 
                case "TRUE": 
                case "YES": 
                case "1": {
                    log.info("Forcing WNRO corrections for all input data.");
                    return TimeSpan.GPS_EPOCH;
                }
                case "AUTO": 
                case "": {
                    log.info("Applying WNRO corrections as needed (i.e. automatic detection and correction).");
                    return null;
                }
            }
            throw new CmdLineException("Unknown WNRO correction option: '" + option.getValue() + "'. Please use one of 'OFF', 'FORCE' or 'AUTO' instead.");
        }
        log.fine("Applying WNRO corrections as needed (i.e. automatic detection and correction).");
        return null;
    }
}

