/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.tool;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineApplication;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.platform.PlatformInfo;
import de.gfz_potsdam.gipp.common.string.PrintStreamFormatter;
import de.gfz_potsdam.gipp.common.time.LeapSecondInfo;
import de.gfz_potsdam.gipp.tool.GippToolsConfig;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class GippToolsApplication
extends CmdLineApplication {
    protected final CmdLineBoolean sysinfoOption = new CmdLineBoolean("sysinfo", "Output system information and exit.");

    protected void handleGippToolOptions() {
        if (this.sysinfoOption.isMatched()) {
            this.printSystemInfo(System.out);
            System.exit(0);
        }
    }

    protected void printSystemInfo(PrintStream prt) {
        try {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, "Operating System");
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Name     : " + System.getProperty("os.name", "n/a"));
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Platform : " + System.getProperty("os.arch", "n/a"));
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Version  : " + System.getProperty("os.version", "n/a"));
        }
        catch (SecurityException e) {
            this.log.severe("Caught security exception while reporting on the operating system.");
        }
        try {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, "Java Runtime Engine (JRE)");
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Home     : '" + System.getProperty("java.home", "n/a") + "'");
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Vendor   : " + System.getProperty("java.vendor", "n/a"));
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Release  : " + System.getProperty("java.version", "n/a"));
        }
        catch (SecurityException e) {
            this.log.severe("Caught security exception while reporting on the Java Runtime Engine (JRE).");
        }
        try {
            File gipptoolsDir;
            String gippToolsRelease = this.cmdLineParser.getReleaseInfo();
            String gipptoolsHome = null;
            File classDir = PlatformInfo.getJarDirectory(GippToolsApplication.class);
            if (classDir != null && classDir.isDirectory() && (gipptoolsDir = classDir.getParentFile()) != null) {
                try {
                    gipptoolsHome = gipptoolsDir.getCanonicalPath();
                }
                catch (IOException e) {
                    gipptoolsHome = gipptoolsDir.getAbsolutePath();
                }
                catch (SecurityException e) {
                    gipptoolsHome = "n/a";
                }
            }
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, "GIPPtools");
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Home     : " + (gipptoolsHome == null ? "n/a" : "'" + gipptoolsHome + "'"));
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Release  : " + (gippToolsRelease.length() == 0 ? "n/a" : gippToolsRelease));
        }
        catch (SecurityException e) {
            this.log.severe("Caught security exception while reporting on the GIPPtools package.");
        }
        PrintStreamFormatter.printWrapped(prt);
        PrintStreamFormatter.printWrapped(prt, 2, "Leap Second Table");
        PrintStreamFormatter.printWrapped(prt, 4, 15, "Source   : " + LeapSecondInfo.getListSourceInfo());
        PrintStreamFormatter.printWrapped(prt, 4, 15, "Updated  : " + LeapSecondInfo.getLastListUpdateInfo());
        PrintStreamFormatter.printWrapped(prt, 4, 15, "Expires  : " + LeapSecondInfo.getExpirationDateInfo());
        try {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, "Current User");
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Name     : " + System.getProperty("user.name", "n/a"));
            PrintStreamFormatter.printWrapped(prt, 4, 15, "Home     : '" + System.getProperty("user.home", "n/a") + "'");
        }
        catch (SecurityException e) {
            this.log.severe("Caught security exception while reporting on the current user details.");
        }
        try {
            String gtLeapSeconds = System.getenv("GIPPTOOLS_LEAP");
            String gtOptions = System.getenv("GIPPTOOLS_OPTS");
            String gtHome = System.getenv("GIPPTOOLS_HOME");
            String gtJava = System.getenv("GIPPTOOLS_JAVA");
            String commandShell = System.getenv("SHELL");
            String searchPath = System.getenv("PATH");
            String manPath = System.getenv("MANPATH");
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, "Environment Variables");
            PrintStreamFormatter.printWrapped(prt, 4, 21, "         SHELL : " + (commandShell == null ? "n/a" : "'" + commandShell + "'"));
            PrintStreamFormatter.printWrapped(prt, 4, 21, "          PATH : " + (searchPath == null ? "n/a" : "'" + searchPath + "'"));
            PrintStreamFormatter.printWrapped(prt, 4, 21, "       MANPATH : " + (manPath == null ? "n/a" : "'" + manPath + "'"));
            PrintStreamFormatter.printWrapped(prt, 4, 21, "GIPPTOOLS_HOME : " + (gtHome == null ? "n/a" : "'" + gtHome + "'"));
            PrintStreamFormatter.printWrapped(prt, 4, 21, "GIPPTOOLS_LEAP : " + (gtLeapSeconds == null ? "n/a" : "'" + gtLeapSeconds + "'"));
            PrintStreamFormatter.printWrapped(prt, 4, 21, "GIPPTOOLS_JAVA : " + (gtJava == null ? "n/a" : "'" + gtJava + "'"));
            PrintStreamFormatter.printWrapped(prt, 4, 21, "GIPPTOOLS_OPTS : " + (gtOptions == null ? "n/a" : "'" + gtOptions + "'"));
        }
        catch (SecurityException e) {
            this.log.severe("Caught security exception while reporting on the environment variables.");
        }
        PrintStreamFormatter.printWrapped(prt);
    }

    protected File getOutputFile(File directory, String basename, String extension, boolean overwrite) {
        File filePath = new File(directory, basename + "." + extension);
        int copyCount = 0;
        if (overwrite) {
            if (filePath.exists()) {
                this.log.warning("The file \"" + filePath.getPath() + "\" already exists and will be overwritten!");
            } else {
                this.log.fine("Using file \"" + filePath.getPath() + "\".");
            }
        } else {
            while (filePath.exists()) {
                this.log.warning("The file \"" + filePath.getName() + "\" already exists!");
                filePath = new File(directory, basename + "." + ++copyCount + "." + extension);
            }
            this.log.fine("Using file \"" + filePath.getPath() + "\". ");
        }
        return filePath;
    }

    protected GippToolsApplication(String[] cmdLineArgs) {
        super(cmdLineArgs);
        this.cmdLineParser.registerOption(this.sysinfoOption, 40);
        this.cmdLineParser.setReleaseInfo(GippToolsConfig.getPackageName(), GippToolsConfig.getPackageReleaseInfo());
        this.cmdLineParser.setCopyrightInfo(GippToolsConfig.getCopyright());
        this.cmdLineParser.setLicenseInfo(GippToolsConfig.getLicenseText());
    }
}

