/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.time;

import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.Serializable;

public class TimeWindow
implements Serializable,
Comparable<TimeWindow> {
    private static final long serialVersionUID = 2L;
    private final TimeWindowType type;
    private final TimeMoment start;
    private final TimeMoment stop;

    public TimeWindow(TimeMoment start, TimeMoment stop) {
        this(TimeWindowType.START_STOP, start, stop);
    }

    public TimeWindow(TimeMoment start, TimeSpan length) {
        this(TimeWindowType.START_LENGTH, start, TimeSpan.add(start, length));
    }

    public TimeWindow(TimeSpan length, TimeMoment stop) {
        this(TimeWindowType.LENGTH_STOP, TimeSpan.subtract(stop, length), stop);
    }

    private TimeWindow(TimeWindowType windowType, TimeMoment windowStart, TimeMoment windowStop) {
        this.type = windowType;
        this.start = windowStart;
        this.stop = windowStop;
    }

    public String toString() {
        return "from " + this.start.toDateTimeString() + " to " + this.stop.toDateTimeString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeWindow other = (TimeWindow)obj;
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        return !(this.stop == null ? other.stop != null : !this.stop.equals(other.stop));
    }

    @Override
    public int compareTo(TimeWindow other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (!this.start.equals(other.start)) {
            return this.start.compareTo(other.start);
        }
        return this.stop.compareTo(other.stop);
    }

    public TimeWindowType getType() {
        return this.type;
    }

    public TimeMoment getStart() {
        return this.start;
    }

    public TimeMoment getStop() {
        return this.stop;
    }

    public TimeSpan getLength() throws ArithmeticException {
        return TimeSpan.diff(this.stop, this.start);
    }

    public boolean contains(TimeMoment time) {
        switch (this.type) {
            case START_STOP: {
                return !time.before(this.start) && !time.after(this.stop);
            }
            case START_LENGTH: {
                return !time.before(this.start) && !time.afterOrAt(this.stop);
            }
            case LENGTH_STOP: {
                return !time.after(this.stop) && !time.beforeOrAt(this.start);
            }
        }
        throw new UnsupportedOperationException("Unsupported time window type!");
    }

    public boolean before(TimeMoment time) {
        switch (this.type) {
            case START_STOP: {
                return this.stop.before(time);
            }
            case START_LENGTH: {
                return this.stop.beforeOrAt(time);
            }
            case LENGTH_STOP: {
                return this.stop.before(time);
            }
        }
        throw new UnsupportedOperationException("Unknown time window type!");
    }

    public boolean after(TimeMoment time) {
        switch (this.type) {
            case START_STOP: {
                return this.start.after(time);
            }
            case START_LENGTH: {
                return this.start.after(time);
            }
            case LENGTH_STOP: {
                return this.start.afterOrAt(time);
            }
        }
        throw new UnsupportedOperationException("Unknown time window type!");
    }

    public static enum TimeWindowType {
        START_STOP,
        START_LENGTH,
        LENGTH_STOP;

    }
}

