/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.time;

import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.ParserException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeSpan
implements Comparable<TimeSpan>,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final long NANOSEC_PER_SECOND = 1000000000L;
    public static final TimeSpan ZERO = new TimeSpan(0L, 0L);
    public static final TimeSpan MAX_VALUE = new TimeSpan(Long.MAX_VALUE, 999999999L);
    public static final TimeSpan NANOSECOND = new Builder().addNanoSeconds(1L).build();
    public static final TimeSpan MICROSECOND = new Builder().addMicroSeconds(1L).build();
    public static final TimeSpan TICK = new Builder().addMicroSeconds(100L).build();
    public static final TimeSpan MILLISECOND = new Builder().addMilliSeconds(1L).build();
    public static final TimeSpan SECOND = new Builder().addSeconds(1L).build();
    public static final TimeSpan MINUTE = new Builder().addMinutes(1L).build();
    public static final TimeSpan HOUR = new Builder().addHours(1L).build();
    public static final TimeSpan DAY = new Builder().addDays(1L).build();
    public static final TimeSpan WEEK = new Builder().addDays(7L).build();
    public static final TimeSpan GPS_EPOCH = new Builder().addDays(7168L).build();
    private static final Pattern TIMESPAN_PATTERN = Pattern.compile("(?:^|(?<=\\s))([-+]?\\d+([-:,\\.]\\d+)?([eE][+-]?\\d+)?)(?:$|(?=\\s))");
    private final long secondCount;
    private final long nanoCount;

    private static long modulus(long x, long y) {
        return x - y * Math.round(Math.floor((double)x / (double)y));
    }

    private static long quotient(long x, long y) {
        return Math.round(Math.floor((double)x / (double)y));
    }

    @Deprecated
    public long getCounts() {
        long micros = this.secondCount * 1000000L + Math.round((double)this.nanoCount / 1000.0);
        return micros;
    }

    public BigInteger getBigCount() {
        BigInteger bigIntCount = BigInteger.valueOf(this.secondCount).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(this.nanoCount));
        return bigIntCount;
    }

    public static TimeSpan diff(TimeSpan first, TimeSpan second) throws IllegalArgumentException {
        if (first == null) {
            throw new IllegalArgumentException("The 'first' time moment argument is null!");
        }
        if (second == null) {
            throw new IllegalArgumentException("The 'second' time moment argument is null!");
        }
        assert (first.nanoCount >= 0L && first.nanoCount < 1000000000L);
        assert (second.nanoCount >= 0L && second.nanoCount < 1000000000L);
        long deltaNanos = Math.abs(second.nanoCount - first.nanoCount);
        long deltaSeconds = Math.abs(second.secondCount - first.secondCount);
        return new TimeSpan(deltaSeconds, deltaNanos);
    }

    public static TimeSpan diff(TimeMoment first, TimeMoment second) throws IllegalArgumentException, ArithmeticException {
        long deltaSeconds;
        long deltaNanos;
        if (first == null) {
            throw new IllegalArgumentException("The 'first' time moment argument is null!");
        }
        if (second == null) {
            throw new IllegalArgumentException("The 'second' time moment argument is null!");
        }
        assert (first.getNanoCount() >= 0L && first.getNanoCount() < 1000000000L);
        assert (second.getNanoCount() >= 0L && second.getNanoCount() < 1000000000L);
        if (first.getSecondCount() == second.getSecondCount()) {
            deltaNanos = Math.abs(second.getNanoCount() - first.getNanoCount());
            deltaSeconds = 0L;
        } else if (first.getSecondCount() > second.getSecondCount()) {
            if (second.getSecondCount() > 0L ? first.getSecondCount() < Long.MIN_VALUE + second.getSecondCount() : first.getSecondCount() > Long.MAX_VALUE + second.getSecondCount()) {
                throw new ArithmeticException("Integer ('long') overflow while calculating time span between '" + first + "' and '" + second + "'!");
            }
            deltaNanos = first.getNanoCount() + 1000000000L - second.getNanoCount();
            deltaSeconds = Math.abs(first.getSecondCount() - second.getSecondCount()) - 1L;
        } else {
            if (second.getSecondCount() > 0L ? first.getSecondCount() < Long.MIN_VALUE + second.getSecondCount() : first.getSecondCount() > Long.MAX_VALUE + second.getSecondCount()) {
                throw new ArithmeticException("Integer ('long') overflow while calculating time span between '" + first + "' and '" + second + "'!");
            }
            deltaNanos = second.getNanoCount() + 1000000000L - first.getNanoCount();
            deltaSeconds = Math.abs(second.getSecondCount() - first.getSecondCount()) - 1L;
        }
        return new TimeSpan(deltaSeconds, deltaNanos);
    }

    public static double diffAsDoubleValue(TimeMoment first, TimeMoment second) {
        long deltaSeconds;
        long deltaNanos;
        assert (first != null);
        assert (second != null);
        assert (first.getNanoCount() >= 0L && first.getNanoCount() < 1000000000L);
        assert (second.getNanoCount() >= 0L && second.getNanoCount() < 1000000000L);
        if (first.getSecondCount() == second.getSecondCount()) {
            deltaNanos = Math.abs(second.getNanoCount() - first.getNanoCount());
            deltaSeconds = 0L;
        } else if (first.getSecondCount() > second.getSecondCount()) {
            deltaNanos = first.getNanoCount() + 1000000000L - second.getNanoCount();
            deltaSeconds = Math.abs(first.getSecondCount() - second.getSecondCount()) - 1L;
        } else {
            deltaNanos = second.getNanoCount() + 1000000000L - first.getNanoCount();
            deltaSeconds = Math.abs(second.getSecondCount() - first.getSecondCount()) - 1L;
        }
        return (double)deltaSeconds + (double)deltaNanos / 1.0E9;
    }

    public static TimeSpan sum(TimeSpan ... spans) {
        if (spans == null || spans.length == 0) {
            throw new NullPointerException("The time span array is 'null' or empty!");
        }
        TimeSpan total = ZERO;
        for (TimeSpan addend : spans) {
            if (addend == null) continue;
            total = new TimeSpan(total.secondCount + addend.secondCount, total.nanoCount + addend.nanoCount);
        }
        return total;
    }

    public static TimeMoment add(TimeMoment time, TimeSpan span) throws NullPointerException {
        if (time == null) {
            throw new NullPointerException("The TimeMoment argument is 'null'!");
        }
        if (span == null) {
            throw new NullPointerException("The TimeSpan argument is 'null'!");
        }
        return new TimeMoment(time.getSecondCount() + span.secondCount, time.getNanoCount() + span.nanoCount);
    }

    public static TimeMoment subtract(TimeMoment time, TimeSpan span) throws IllegalArgumentException {
        if (time == null) {
            throw new IllegalArgumentException("The TimeMoment argument is 'null'!");
        }
        if (span == null) {
            throw new IllegalArgumentException("The TimeSpan argument is 'null'!");
        }
        return new TimeMoment(time.getSecondCount() - span.secondCount, time.getNanoCount() - span.nanoCount);
    }

    public static TimeSpan multiply(TimeSpan span, double factor) throws NullPointerException, IllegalArgumentException {
        if (span == null) {
            throw new NullPointerException("The TimeSpan argument is 'null'!");
        }
        if (factor < 0.0) {
            throw new IllegalArgumentException("You cannot multiply a time span by a negative number!");
        }
        long seconds = Math.round(Math.floor((double)span.secondCount * factor));
        long nanos = (long)(((double)span.secondCount * factor - (double)seconds) * 1.0E9) + Math.round((double)span.nanoCount * factor);
        return new TimeSpan(seconds, nanos);
    }

    public TimeSpan multiply(double factor) {
        if (factor < 0.0) {
            throw new IllegalArgumentException("You cannot multiply a time span by a negative number!");
        }
        long seconds = Math.round(Math.floor((double)this.secondCount * factor));
        long nanos = (long)(((double)this.secondCount * factor - (double)seconds) * 1.0E9) + Math.round((double)this.nanoCount * factor);
        return new TimeSpan(seconds, nanos);
    }

    public static TimeSpan divide(TimeSpan span, double divisor) throws NullPointerException, IllegalArgumentException, ArithmeticException {
        if (span == null) {
            throw new NullPointerException("The TimeSpan argument is 'null'!");
        }
        if (divisor == 0.0) {
            throw new ArithmeticException("The divisor is 'zero'!");
        }
        if (divisor < 0.0) {
            throw new IllegalArgumentException("You cannot divide a time span by a negative number!");
        }
        if (divisor == 1.0) {
            return span;
        }
        long seconds = Math.round(Math.floor((double)span.secondCount / divisor));
        long nanos = (long)(((double)span.secondCount / divisor - (double)seconds) * 1.0E9) + Math.round((double)span.nanoCount / divisor);
        return new TimeSpan(seconds, nanos);
    }

    public TimeSpan divide(double divisor) throws ArithmeticException {
        if (divisor == 0.0) {
            throw new ArithmeticException("The divisor is 'zero'!");
        }
        if (divisor < 0.0) {
            throw new IllegalArgumentException("You cannot divide a time span by a negative number!");
        }
        if (divisor == 1.0) {
            return this;
        }
        long seconds = Math.round(Math.floor((double)this.secondCount / divisor));
        long nanos = (long)(((double)this.secondCount / divisor - (double)seconds) * 1.0E9) + Math.round((double)this.nanoCount / divisor);
        return new TimeSpan(seconds, nanos);
    }

    public static double divide(TimeSpan dividend, TimeSpan divisor) throws NullPointerException, ArithmeticException {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("a TimeSpan argument is 'null'!");
        }
        if (divisor.secondCount == 0L && divisor.nanoCount == 0L) {
            throw new ArithmeticException("The divisor is 'zero'!");
        }
        BigDecimal dividendCount = BigDecimal.valueOf(dividend.secondCount).add(BigDecimal.valueOf(dividend.nanoCount, 9));
        BigDecimal divisorCount = BigDecimal.valueOf(divisor.secondCount).add(BigDecimal.valueOf(divisor.nanoCount, 9));
        return dividendCount.divide(divisorCount, RoundingMode.HALF_UP).doubleValue();
    }

    public double divide(TimeSpan divisor) throws NullPointerException, ArithmeticException {
        if (divisor == null) {
            throw new NullPointerException("The divisor argument is 'null'!");
        }
        if (divisor.secondCount == 0L && divisor.nanoCount == 0L) {
            throw new ArithmeticException("The divisor is 'zero'!");
        }
        BigDecimal dividendCount = BigDecimal.valueOf(this.secondCount).add(BigDecimal.valueOf(this.nanoCount, 9));
        BigDecimal divisorCount = BigDecimal.valueOf(divisor.secondCount).add(BigDecimal.valueOf(divisor.nanoCount, 9));
        return dividendCount.divide(divisorCount, RoundingMode.HALF_UP).doubleValue();
    }

    public static TimeSpan modulo(TimeSpan dividend, TimeSpan divisor) throws NullPointerException, ArithmeticException {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("a TimeSpan argument is 'null'!");
        }
        if (divisor.secondCount == 0L && divisor.nanoCount == 0L) {
            throw new ArithmeticException("The divisor is 'zero'!");
        }
        BigDecimal dividendCount = BigDecimal.valueOf(dividend.secondCount).add(BigDecimal.valueOf(dividend.nanoCount, 9));
        BigDecimal divisorCount = BigDecimal.valueOf(divisor.secondCount).add(BigDecimal.valueOf(divisor.nanoCount, 9));
        return new TimeSpan(dividendCount.remainder(divisorCount).multiply(BigDecimal.valueOf(1000000000L)).toBigInteger());
    }

    public TimeSpan modulo(TimeSpan divisor) throws NullPointerException, ArithmeticException {
        if (divisor == null) {
            throw new NullPointerException("The divisor argument is 'null'!");
        }
        if (divisor.secondCount == 0L && divisor.nanoCount == 0L) {
            throw new ArithmeticException("The divisor is 'zero'!");
        }
        BigDecimal dividendCount = BigDecimal.valueOf(this.secondCount).add(BigDecimal.valueOf(this.nanoCount, 9));
        BigDecimal divisorCount = BigDecimal.valueOf(divisor.secondCount).add(BigDecimal.valueOf(divisor.nanoCount, 9));
        return new TimeSpan(dividendCount.remainder(divisorCount).multiply(BigDecimal.valueOf(1000000000L)).toBigInteger());
    }

    public static TimeSpan parse(String text) throws ParserException {
        if (text == null || text.length() == 0) {
            throw new ParserException("The time span string was 'null' or empty!");
        }
        String value = null;
        try {
            Matcher matcher = TIMESPAN_PATTERN.matcher(text);
            if (!matcher.find()) {
                throw new ParserException("The string '" + text + "' did not contain a time span!");
            }
            value = matcher.group(1);
            if (value != null) {
                int FRACTION_DIGITS = 9;
                BigDecimal big = new BigDecimal(value).setScale(9, RoundingMode.HALF_UP);
                if (big.compareTo(BigDecimal.ZERO) < 0) {
                    throw new ParserException("All time spans must be positive! (But input (sub-)string was '" + value + "'.)");
                }
                if (big.compareTo(new BigDecimal(Long.MAX_VALUE).add(BigDecimal.ONE)) >= 0) {
                    throw new ParserException("Time span too large! (" + value + " > " + MAX_VALUE.getFullString() + ")");
                }
                long secs = big.longValue();
                long nanos = big.remainder(BigDecimal.ONE).scaleByPowerOfTen(9).longValue();
                return new Builder().addSeconds(secs).addNanoSeconds(nanos).build();
            }
            throw new ParserException("The string '" + text + "' did not contain a parsable time span!");
        }
        catch (NumberFormatException exp) {
            if (value.contains(",")) {
                throw new ParserException("Unexpected character! The (sub-)string '" + value + "' contains a comma (','). Did you mean to use a decimal point?", exp);
            }
            if (value.contains(":")) {
                throw new ParserException("Unexpected character! The (sub-)string '" + value + "' contains a colon (':').", exp);
            }
            if (value.contains("-")) {
                throw new ParserException("Unexpected character! The (sub-)string '" + value + "' contains a minus ('-').", exp);
            }
            throw new ParserException("Unexpected character! Expected a floating point value but found (sub-)string '" + value + "' instead.", exp);
        }
    }

    public TimeSpan(BigInteger nanoCount) {
        BigInteger NANOSECONDS_PER_SECOND = BigInteger.valueOf(1000000000L);
        BigInteger[] result = nanoCount.divideAndRemainder(NANOSECONDS_PER_SECOND);
        this.secondCount = result[0].longValue();
        this.nanoCount = result[1].longValue();
    }

    protected TimeSpan(long seconds, long nanos) {
        if (nanos >= 1000000000L) {
            this.secondCount = Math.abs(seconds) + TimeSpan.quotient(nanos, 1000000000L);
            this.nanoCount = TimeSpan.modulus(nanos, 1000000000L);
        } else if (nanos < 0L) {
            this.secondCount = Math.abs(seconds - TimeSpan.quotient(nanos, 1000000000L));
            this.nanoCount = TimeSpan.modulus(nanos, 1000000000L);
        } else {
            this.secondCount = Math.abs(seconds);
            this.nanoCount = nanos;
        }
    }

    private TimeSpan(Builder builder) {
        if (builder.nanosecs >= 1000000000L) {
            this.secondCount = Math.abs(builder.seconds) + TimeSpan.quotient(builder.nanosecs, 1000000000L);
            this.nanoCount = TimeSpan.modulus(builder.nanosecs, 1000000000L);
        } else if (builder.nanosecs < 0L) {
            this.secondCount = Math.abs(builder.seconds - TimeSpan.quotient(builder.nanosecs, 1000000000L));
            this.nanoCount = TimeSpan.modulus(builder.nanosecs, 1000000000L);
        } else {
            this.secondCount = Math.abs(builder.seconds);
            this.nanoCount = builder.nanosecs;
        }
        assert (this.secondCount >= 0L);
        assert (this.nanoCount >= 0L);
        assert (this.nanoCount < 1000000000L);
    }

    protected long getSecondCount() {
        return this.secondCount;
    }

    protected long getNanoCount() {
        return this.nanoCount;
    }

    public int hashCode() {
        int result = (int)(this.secondCount ^ this.secondCount >>> 32);
        result = 31 * result + (int)(this.nanoCount ^ this.nanoCount >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeSpan)) {
            return false;
        }
        TimeSpan other = (TimeSpan)obj;
        if (this.secondCount != other.secondCount) {
            return false;
        }
        return this.nanoCount == other.nanoCount;
    }

    @Override
    public int compareTo(TimeSpan other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("The 'other' time span argument is 'null'!");
        }
        if (this.secondCount > other.secondCount) {
            return 1;
        }
        if (this.secondCount < other.secondCount) {
            return -1;
        }
        if (this.nanoCount > other.nanoCount) {
            return 1;
        }
        if (this.nanoCount < other.nanoCount) {
            return -1;
        }
        return 0;
    }

    public boolean isZeroLength() {
        return this.secondCount == 0L && this.nanoCount == 0L;
    }

    public boolean lessThan(TimeSpan other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("The 'other' time span argument is 'null'!");
        }
        if (this.secondCount < other.secondCount) {
            return true;
        }
        if (this.secondCount > other.secondCount) {
            return false;
        }
        return this.nanoCount < other.nanoCount;
    }

    public boolean moreThan(TimeSpan other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("The 'other' time span argument is 'null'!");
        }
        if (this.secondCount > other.secondCount) {
            return true;
        }
        if (this.secondCount < other.secondCount) {
            return false;
        }
        return this.nanoCount > other.nanoCount;
    }

    public double getSeconds() {
        return (double)this.secondCount + (double)this.nanoCount / 1.0E9;
    }

    public String toString() {
        return this.getSeconds() + " seconds";
    }

    public String getFullString() {
        StringBuilder span = new StringBuilder();
        span.append(this.getSecondCount());
        span.append('.');
        span.append(StringUtils.NINE_DIGITS.format(this.getNanoCount()));
        span.append(" seconds");
        return span.toString();
    }

    public String getApproximateString() {
        if (this.getBigCount().compareTo(BigInteger.ZERO) < 0) {
            return "invalid time span";
        }
        if (this.getBigCount().compareTo(BigInteger.ZERO) == 0) {
            return "zero";
        }
        if (this.lessThan(MICROSECOND)) {
            return "about " + this.getBigCount().toString() + " nanoseconds";
        }
        if (this.lessThan(MILLISECOND)) {
            return "about " + new BigDecimal(this.getBigCount()).divide(new BigDecimal(MICROSECOND.getBigCount())).setScale(1, RoundingMode.HALF_UP) + " microseconds";
        }
        if (this.lessThan(SECOND)) {
            return "about " + new BigDecimal(this.getBigCount()).divide(new BigDecimal(MILLISECOND.getBigCount()), 1, RoundingMode.HALF_UP) + " milliseconds";
        }
        if (this.lessThan(MINUTE)) {
            return "about " + new BigDecimal(this.getBigCount()).divide(new BigDecimal(SECOND.getBigCount()), 1, RoundingMode.HALF_UP) + " seconds";
        }
        if (this.lessThan(HOUR)) {
            return "about " + new BigDecimal(this.getBigCount()).divide(new BigDecimal(MINUTE.getBigCount()), 1, RoundingMode.HALF_UP) + " minutes";
        }
        if (this.lessThan(DAY)) {
            return "about " + new BigDecimal(this.getBigCount()).divide(new BigDecimal(HOUR.getBigCount()), 1, RoundingMode.HALF_UP) + " hours";
        }
        if (this.lessThan(TimeSpan.multiply(DAY, 30.0))) {
            return "about " + new BigDecimal(this.getBigCount()).divide(new BigDecimal(DAY.getBigCount()), 1, RoundingMode.HALF_UP) + " days";
        }
        if (this.lessThan(TimeSpan.multiply(DAY, 365.0))) {
            return "about " + new BigDecimal(this.getBigCount()).divide(new BigDecimal(DAY.multiply(30.0).getBigCount()), 1, RoundingMode.HALF_UP) + " months";
        }
        return "about " + new BigDecimal(this.getBigCount()).divide(new BigDecimal(DAY.multiply(365.0).getBigCount()), 1, RoundingMode.HALF_UP) + " years";
    }

    public static class Builder {
        private long seconds = 0L;
        private long nanosecs = 0L;

        public Builder addDays(long days) {
            this.seconds += Math.abs(days) * 60L * 60L * 24L;
            return this;
        }

        public Builder addHours(long hours) {
            this.seconds += Math.abs(hours) * 60L * 60L;
            return this;
        }

        public Builder addMinutes(long minutes) {
            this.seconds += Math.abs(minutes) * 60L;
            return this;
        }

        public Builder addSeconds(long seconds) {
            this.seconds += Math.abs(seconds);
            return this;
        }

        public Builder addSeconds(double seconds) {
            long fullSeconds = (long)Math.floor(Math.abs(seconds));
            long fracSeconds = Math.round((Math.abs(seconds) - (double)fullSeconds) * 1.0E9);
            this.seconds += fullSeconds;
            this.nanosecs += fracSeconds;
            return this;
        }

        public Builder addMilliSeconds(long millis) {
            this.nanosecs += Math.abs(millis) * 1000L * 1000L;
            return this;
        }

        public Builder addMicroSeconds(long micros) {
            this.nanosecs += Math.abs(micros) * 1000L;
            return this;
        }

        public Builder addNanoSeconds(long nanos) {
            this.nanosecs += Math.abs(nanos);
            return this;
        }

        public TimeSpan build() {
            TimeSpan span = new TimeSpan(this);
            return span;
        }
    }
}

