/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.time;

import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.InvalidDateException;
import de.gfz_potsdam.gipp.common.time.ParserException;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeMoment
implements Comparable<TimeMoment>,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long MILISEC_PER_SECOND = 1000L;
    private static final long MICROSEC_PER_SECOND = 1000000L;
    private static final long NANOSEC_PER_SECOND = 1000000000L;
    private static final Pattern ISO_PATTERN = Pattern.compile("^(\\d{4})([-/\\.])([1-9]|0[1-9]|1[012])\\2([1-9]|0[1-9]|[12][0-9]|3[01])(?:[ _;T]+([01]?[0-9]|2[0-3]):([0-5]?[0-9])(?::((?:[0-5]?[0-9]|60)(?:\\.\\d+)?)?)?)?$");
    private final long secondCount;
    private final long nanoCount;
    private transient boolean dirty;
    private transient int cachedYear;
    private transient int cachedMonth;
    private transient int cachedDay;
    private transient int cachedHour;
    private transient int cachedMinute;
    private transient int cachedSecond;
    public static final TimeMoment MAX_VALUE = new TimeMoment(Long.MAX_VALUE, 999999999L);
    public static final TimeMoment FAR_FUTURE = new Builder().date(9999, 9, 9).time(0, 0, 0).build();
    public static final TimeMoment EPOCH = new TimeMoment(0L, 0L);
    public static final TimeMoment LONG_AGO = new Builder().date(1000, 1, 1).time(0, 0, 0).build();
    public static final TimeMoment MIN_VALUE = new TimeMoment(Long.MIN_VALUE, 0L);
    public static final TimeMoment NTP_EPOCH = new Builder().date(1900, 1, 1).time(0, 0, 0).build();
    public static final TimeMoment UNIX_EPOCH = new Builder().date(1970, 1, 1).time(0, 0, 0).build();
    public static final TimeMoment GPS_EPOCH = new Builder().date(1980, 1, 6).time(0, 0, 0).build();
    public static final TimeMoment GALILEO_EPOCH = new Builder().date(1999, 8, 22).time(0, 0, 0).build();
    public static final TimeMoment BEIDOU_EPOCH = new Builder().date(2006, 1, 1).time(0, 0, 0).build();

    public static TimeMoment parse(String text) throws InvalidDateException, ParserException {
        if (text == null || text.length() == 0) {
            throw new ParserException("The date/time input string was 'null' or empty!");
        }
        Matcher m = ISO_PATTERN.matcher(text.trim());
        if (!m.find()) {
            throw new ParserException("The input '" + text + "' could not be parsed as date/time!");
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nano = 0;
        try {
            String value = m.group(1);
            if (value != null) {
                year = Integer.valueOf(value);
            }
            if ((value = m.group(3)) != null) {
                month = Integer.valueOf(value);
            }
            if ((value = m.group(4)) != null) {
                day = Integer.valueOf(value);
            }
            if ((value = m.group(5)) != null) {
                hour = Integer.valueOf(value);
            }
            if ((value = m.group(6)) != null) {
                minute = Integer.valueOf(value);
            }
            if ((value = m.group(7)) != null) {
                int FRACTION_DIGITS = 9;
                BigDecimal big = new BigDecimal(value).setScale(9, RoundingMode.HALF_UP);
                second = big.intValue();
                nano = big.remainder(BigDecimal.ONE).scaleByPowerOfTen(9).intValue();
            }
        }
        catch (NumberFormatException e) {
            throw new ParserException("One of the (sub-)fields in '" + text + "' could not be converted to a number!", e);
        }
        TimeMoment moment = new Builder().date(year, month, day).time(hour, minute, second).nanosec(nano).build();
        moment.updateGreg();
        if (moment.getYear() == year && moment.getMonth() == month && moment.getDay() == day) {
            return moment;
        }
        throw new InvalidDateException("The date '" + text + "' does not exist!");
    }

    private static long modulus(long x, long y) {
        return x - y * Math.round(Math.floor((double)x / (double)y));
    }

    private static long quotient(long x, long y) {
        return Math.round(Math.floor((double)x / (double)y));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.dirty = true;
    }

    public static TimeMoment now() {
        long secondsUntilJan1970 = 62135683200L;
        long millisSinceJan1970 = System.currentTimeMillis();
        return new TimeMoment(62135683200L + TimeMoment.quotient(millisSinceJan1970, 1000L), TimeMoment.modulus(millisSinceJan1970, 1000L));
    }

    public static boolean isLeapYear(long year) {
        return year % 400L == 0L || year % 4L == 0L && year % 100L != 0L;
    }

    public static int getNumberOfDaysInYear(long year) {
        if (TimeMoment.isLeapYear(year)) {
            return 366;
        }
        return 365;
    }

    public static int getNumberOfDaysInMonth(long year, int month) {
        int[] daysInNonLeapYears = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] daysInLeapYears = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        assert (month > 0 && month < 13) : "Month must be in range [1..12]!";
        if (TimeMoment.isLeapYear(year)) {
            return daysInLeapYears[month - 1];
        }
        return daysInNonLeapYears[month - 1];
    }

    public static boolean isValidDate(int year, int month, int day) {
        TimeMoment testDate = new Builder().date(year, month, day).build();
        testDate.updateGreg();
        return testDate.getYear() == year && testDate.getMonth() == month && testDate.getDay() == day;
    }

    private long calculateSecondCount(long year, long month, long day, long hour, long minute, long second) {
        long numOfDays = 365L * (year - 1L) + TimeMoment.quotient(year - 1L, 4L) - TimeMoment.quotient(year - 1L, 100L) + TimeMoment.quotient(year - 1L, 400L) + TimeMoment.quotient(367L * month - 362L, 12L) + (month <= 2L ? 0L : (TimeMoment.isLeapYear(year) ? -1L : -2L)) + day;
        long numOfSeconds = ((numOfDays * 24L + hour) * 60L + minute) * 60L + second;
        return numOfSeconds;
    }

    private void updateGreg() {
        long fullDays = TimeMoment.quotient(this.secondCount, 86400L);
        long fractDay = this.secondCount - fullDays * 86400L;
        long d0 = fullDays - 1L;
        long n400 = TimeMoment.quotient(d0, 146097L);
        long d1 = TimeMoment.modulus(d0, 146097L);
        long n100 = TimeMoment.quotient(d1, 36524L);
        long d2 = TimeMoment.modulus(d1, 36524L);
        long n4 = TimeMoment.quotient(d2, 1461L);
        long d3 = TimeMoment.modulus(d2, 1461L);
        long n1 = TimeMoment.quotient(d3, 365L);
        long tempYear = 400L * n400 + 100L * n100 + (4L * n4 + n1);
        this.cachedYear = n100 == 4L || n1 == 4L ? (int)tempYear : (int)(tempYear + 1L);
        long beginJanuary = this.calculateSecondCount(this.cachedYear, 1L, 1L, 0L, 0L, 0L);
        long beginMarch = this.calculateSecondCount(this.cachedYear, 3L, 1L, 0L, 0L, 0L);
        long priorDays = TimeMoment.quotient(this.secondCount - beginJanuary, 86400L);
        long Correction = this.secondCount < beginMarch ? 0L : (TimeMoment.isLeapYear(this.cachedYear) ? 1L : 2L);
        this.cachedMonth = (int)TimeMoment.quotient(12L * (priorDays + Correction) + 373L, 367L);
        long beginMonth = 0L;
        beginMonth = this.calculateSecondCount(this.cachedYear, this.cachedMonth, 1L, 0L, 0L, 0L);
        this.cachedDay = (int)(TimeMoment.quotient(this.secondCount - beginMonth, 86400L) + 1L);
        this.cachedHour = (int)(fractDay / 3600L);
        this.cachedMinute = (int)((fractDay -= (long)this.cachedHour * 60L * 60L) / 60L);
        this.cachedSecond = (int)(fractDay -= (long)(this.cachedMinute * 60));
        assert ((fractDay -= (long)this.cachedSecond) == 0L);
    }

    public TimeMoment() {
        this.secondCount = 0L;
        this.nanoCount = 0L;
        this.cachedYear = 0;
        this.cachedMonth = 12;
        this.cachedDay = 31;
        this.cachedHour = 0;
        this.cachedMinute = 0;
        this.cachedSecond = 0;
        this.dirty = false;
    }

    private TimeMoment(Builder builder) {
        if (builder.nanosec > 1000000000L || builder.nanosec < 0L) {
            long s = TimeMoment.quotient(builder.nanosec, 1000000000L);
            long n = TimeMoment.modulus(builder.nanosec, 1000000000L);
            this.secondCount = s + this.calculateSecondCount(builder.year, builder.month, builder.day, builder.hour, builder.minute, builder.second);
            this.nanoCount = n;
        } else {
            this.secondCount = this.calculateSecondCount(builder.year, builder.month, builder.day, builder.hour, builder.minute, builder.second);
            this.nanoCount = builder.nanosec;
        }
        this.dirty = true;
    }

    public TimeMoment(long seconds, long nanos) {
        if (nanos >= 1000000000L || nanos < 0L) {
            long s = TimeMoment.quotient(nanos, 1000000000L);
            long n = TimeMoment.modulus(nanos, 1000000000L);
            this.secondCount = seconds + s;
            this.nanoCount = n;
        } else {
            this.secondCount = seconds;
            this.nanoCount = nanos;
        }
        this.dirty = true;
    }

    public TimeMoment(BigInteger bigCount) {
        BigInteger NANOSECONDS_PER_SECOND = BigInteger.valueOf(1000000000L);
        BigInteger[] result = bigCount.divideAndRemainder(NANOSECONDS_PER_SECOND);
        this.secondCount = result[0].longValue();
        this.nanoCount = result[1].longValue();
        this.dirty = true;
    }

    public TimeMoment(byte[] byteArray) {
        int expectedLength = 16;
        if (byteArray.length != 16) {
            throw new IllegalArgumentException("Expected an array of length 16 but got " + byteArray.length + " bytes!");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray).order(ByteOrder.BIG_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.secondCount = longBuffer.get(0);
        this.nanoCount = longBuffer.get(1);
        this.dirty = true;
    }

    protected long getSecondCount() {
        return this.secondCount;
    }

    protected long getNanoCount() {
        return this.nanoCount;
    }

    @Deprecated
    public long getCounts() {
        long micros = this.secondCount * 1000000L + Math.round((double)this.nanoCount / 1000.0);
        return micros;
    }

    public BigInteger getBigCount() {
        BigInteger bigIntCount = BigInteger.valueOf(this.secondCount).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(this.nanoCount));
        return bigIntCount;
    }

    public byte[] toByteArray() {
        return new byte[]{(byte)(this.secondCount >> 56), (byte)(this.secondCount >> 48), (byte)(this.secondCount >> 40), (byte)(this.secondCount >> 32), (byte)(this.secondCount >> 24), (byte)(this.secondCount >> 16), (byte)(this.secondCount >> 8), (byte)this.secondCount, (byte)(this.nanoCount >> 56), (byte)(this.nanoCount >> 48), (byte)(this.nanoCount >> 40), (byte)(this.nanoCount >> 32), (byte)(this.nanoCount >> 24), (byte)(this.nanoCount >> 16), (byte)(this.nanoCount >> 8), (byte)this.nanoCount};
    }

    public int getYear() {
        if (this.dirty) {
            this.updateGreg();
            this.dirty = false;
        }
        return this.cachedYear;
    }

    public int getMonth() {
        if (this.dirty) {
            this.updateGreg();
            this.dirty = false;
        }
        return this.cachedMonth;
    }

    public int getDay() {
        if (this.dirty) {
            this.updateGreg();
            this.dirty = false;
        }
        return this.cachedDay;
    }

    public int getWeekday() {
        long fullDays = TimeMoment.quotient(this.secondCount, 86400L);
        long dayOfWeek = TimeMoment.modulus(fullDays, 7L);
        return (int)dayOfWeek;
    }

    public int getDayOfYear() {
        if (this.dirty) {
            this.updateGreg();
            this.dirty = false;
        }
        long dayOfYear = 1L + TimeMoment.quotient(this.secondCount - this.calculateSecondCount(this.cachedYear, 1L, 1L, 0L, 0L, 0L), 86400L);
        return (int)dayOfYear;
    }

    public int getHour() {
        if (this.dirty) {
            this.updateGreg();
            this.dirty = false;
        }
        return this.cachedHour;
    }

    public int getMinute() {
        if (this.dirty) {
            this.updateGreg();
            this.dirty = false;
        }
        return this.cachedMinute;
    }

    public int getSecond() {
        if (this.dirty) {
            this.updateGreg();
            this.dirty = false;
        }
        return this.cachedSecond;
    }

    public int getSecondOfDay() {
        if (this.dirty) {
            this.updateGreg();
            this.dirty = false;
        }
        long secondOfDay = this.secondCount - this.calculateSecondCount(this.cachedYear, this.cachedMonth, this.cachedDay, 0L, 0L, 0L);
        assert (secondOfDay >= 0L);
        assert (secondOfDay < 86400L);
        return (int)secondOfDay;
    }

    public long getNanoSecond() {
        if (this.dirty) {
            this.updateGreg();
            this.dirty = false;
        }
        return this.nanoCount;
    }

    public String toString() {
        return StringUtils.FOUR_DIGITS.format(this.getYear()) + '-' + StringUtils.TWO_DIGITS.format(this.getMonth()) + '-' + StringUtils.TWO_DIGITS.format(this.getDay()) + ' ' + StringUtils.TWO_DIGITS.format(this.getHour()) + ':' + StringUtils.TWO_DIGITS.format(this.getMinute()) + ':' + StringUtils.TWO_DIGITS.format(this.getSecond()) + '.' + StringUtils.NINE_DIGITS.format(this.getNanoSecond());
    }

    public String toDateTimeString() {
        long microsec = Math.round((double)this.getNanoCount() / 1000.0);
        assert (microsec >= 0L && microsec <= 1000000L);
        if (microsec < 1000000L) {
            return StringUtils.FOUR_DIGITS.format(this.getYear()) + '-' + StringUtils.TWO_DIGITS.format(this.getMonth()) + '-' + StringUtils.TWO_DIGITS.format(this.getDay()) + ' ' + StringUtils.TWO_DIGITS.format(this.getHour()) + ':' + StringUtils.TWO_DIGITS.format(this.getMinute()) + ':' + StringUtils.TWO_DIGITS.format(this.getSecond()) + '.' + StringUtils.SIX_DIGITS.format(microsec);
        }
        TimeMoment temp = new TimeMoment(this.secondCount, microsec * 1000L);
        return temp.toDateTimeString();
    }

    public String toIsoString() {
        long microsec = Math.round((double)this.getNanoCount() / 1000.0);
        assert (microsec >= 0L && microsec <= 1000000L);
        if (microsec < 1000000L) {
            return StringUtils.FOUR_DIGITS.format(this.getYear()) + '-' + StringUtils.TWO_DIGITS.format(this.getMonth()) + '-' + StringUtils.TWO_DIGITS.format(this.getDay()) + 'T' + StringUtils.TWO_DIGITS.format(this.getHour()) + ':' + StringUtils.TWO_DIGITS.format(this.getMinute()) + ':' + StringUtils.TWO_DIGITS.format(this.getSecond()) + '.' + StringUtils.SIX_DIGITS.format(microsec);
        }
        TimeMoment temp = new TimeMoment(this.secondCount, microsec * 1000L);
        return temp.toIsoString();
    }

    public String toIrisString() {
        long microsec = Math.round((double)this.getNanoCount() / 1000.0);
        assert (microsec >= 0L && microsec <= 1000000L);
        if (microsec < 1000000L) {
            return StringUtils.FOUR_DIGITS.format(this.getYear()) + ',' + StringUtils.THREE_DIGITS.format(this.getDayOfYear()) + ';' + StringUtils.TWO_DIGITS.format(this.getHour()) + ':' + StringUtils.TWO_DIGITS.format(this.getMinute()) + ':' + StringUtils.TWO_DIGITS.format(this.getSecond()) + '.' + StringUtils.SIX_DIGITS.format(microsec);
        }
        TimeMoment temp = new TimeMoment(this.secondCount, microsec * 1000L);
        return temp.toIrisString();
    }

    public String toDoyString() {
        return StringUtils.FOUR_DIGITS.format(this.getYear()) + '-' + StringUtils.THREE_DIGITS.format(this.getDayOfYear()) + ' ' + StringUtils.TWO_DIGITS.format(this.getHour()) + ':' + StringUtils.TWO_DIGITS.format(this.getMinute()) + ':' + StringUtils.TWO_DIGITS.format(this.getSecond());
    }

    public String toLogString() {
        return StringUtils.FOUR_DIGITS.format(this.getYear()) + '-' + StringUtils.TWO_DIGITS.format(this.getMonth()) + '-' + StringUtils.TWO_DIGITS.format(this.getDay()) + ' ' + StringUtils.TWO_DIGITS.format(this.getHour()) + ':' + StringUtils.TWO_DIGITS.format(this.getMinute()) + ':' + StringUtils.TWO_DIGITS.format(this.getSecond());
    }

    public String toIsoShortString() {
        return StringUtils.FOUR_DIGITS.format(this.getYear()) + '-' + StringUtils.TWO_DIGITS.format(this.getMonth()) + '-' + StringUtils.TWO_DIGITS.format(this.getDay()) + 'T' + StringUtils.TWO_DIGITS.format(this.getHour()) + ':' + StringUtils.TWO_DIGITS.format(this.getMinute()) + ':' + StringUtils.TWO_DIGITS.format(this.getSecond());
    }

    public String toFilesystemString() {
        return StringUtils.FOUR_DIGITS.format(this.getYear()) + '-' + StringUtils.TWO_DIGITS.format(this.getMonth()) + '-' + StringUtils.TWO_DIGITS.format(this.getDay()) + '_' + StringUtils.TWO_DIGITS.format(this.getHour()) + '-' + StringUtils.TWO_DIGITS.format(this.getMinute()) + '-' + StringUtils.TWO_DIGITS.format(this.getSecond());
    }

    public String toMinimalString() {
        return StringUtils.TWO_DIGITS.format(this.getYear() % 100) + StringUtils.TWO_DIGITS.format(this.getMonth()) + StringUtils.TWO_DIGITS.format(this.getDay()) + StringUtils.TWO_DIGITS.format(this.getHour()) + StringUtils.TWO_DIGITS.format(this.getMinute()) + StringUtils.TWO_DIGITS.format(this.getSecond());
    }

    public String toDateString() {
        return StringUtils.FOUR_DIGITS.format(this.getYear()) + '-' + StringUtils.TWO_DIGITS.format(this.getMonth()) + '-' + StringUtils.TWO_DIGITS.format(this.getDay());
    }

    public String toTimeString() {
        long microsec = Math.round((double)this.getNanoCount() / 1000.0);
        assert (microsec >= 0L && microsec <= 1000000L);
        if (microsec < 1000000L) {
            return StringUtils.TWO_DIGITS.format(this.getHour()) + ':' + StringUtils.TWO_DIGITS.format(this.getMinute()) + ':' + StringUtils.TWO_DIGITS.format(this.getSecond()) + '.' + StringUtils.SIX_DIGITS.format(microsec);
        }
        TimeMoment temp = new TimeMoment(this.secondCount, microsec * 1000L);
        return temp.toTimeString();
    }

    public int hashCode() {
        int result = (int)(this.secondCount ^ this.secondCount >>> 32);
        result = 31 * result + (int)(this.nanoCount ^ this.nanoCount >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeMoment)) {
            return false;
        }
        TimeMoment other = (TimeMoment)obj;
        if (this.secondCount != other.secondCount) {
            return false;
        }
        return this.nanoCount == other.nanoCount;
    }

    @Override
    public int compareTo(TimeMoment other) throws NullPointerException {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.secondCount < other.secondCount) {
            return -1;
        }
        if (this.secondCount > other.secondCount) {
            return 1;
        }
        if (this.nanoCount < other.nanoCount) {
            return -1;
        }
        if (this.nanoCount > other.nanoCount) {
            return 1;
        }
        return 0;
    }

    public boolean before(TimeMoment other) {
        return this.compareTo(other) == -1;
    }

    public boolean beforeOrAt(TimeMoment other) {
        return this.compareTo(other) <= 0;
    }

    public boolean after(TimeMoment other) {
        return this.compareTo(other) == 1;
    }

    public boolean afterOrAt(TimeMoment other) {
        return this.compareTo(other) >= 0;
    }

    public static TimeMoment first(TimeMoment left, TimeMoment right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        if (left.secondCount < right.secondCount) {
            return left;
        }
        if (left.secondCount > right.secondCount) {
            return right;
        }
        if (left.nanoCount < right.nanoCount) {
            return left;
        }
        return right;
    }

    public static TimeMoment last(TimeMoment left, TimeMoment right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        if (left.secondCount > right.secondCount) {
            return left;
        }
        if (left.secondCount < right.secondCount) {
            return right;
        }
        if (left.nanoCount > right.nanoCount) {
            return left;
        }
        return right;
    }

    public TimeMoment add(TimeSpan span) throws NullPointerException {
        if (span == null) {
            throw new NullPointerException("The TimeSpan argument is 'null'!");
        }
        return new TimeMoment(this.secondCount + span.getSecondCount(), this.nanoCount + span.getNanoCount());
    }

    public TimeMoment subtract(TimeSpan span) throws IllegalArgumentException {
        if (span == null) {
            throw new IllegalArgumentException("The TimeSpan argument is 'null'!");
        }
        return new TimeMoment(this.secondCount - span.getSecondCount(), this.nanoCount - span.getNanoCount());
    }

    public static class Builder {
        private long year = 1L;
        private long month = 1L;
        private long day = 0L;
        private long hour = 0L;
        private long minute = 0L;
        private long second = 0L;
        private long nanosec = 0L;

        public Builder date(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
            return this;
        }

        public Builder dayOfYear(int year, int doy) {
            this.year = year;
            this.month = 1L;
            this.day = doy;
            return this;
        }

        public Builder year(int year) {
            this.year = year;
            return this;
        }

        public Builder month(int month) {
            this.month = month;
            return this;
        }

        public Builder day(int day) {
            this.day = day;
            return this;
        }

        public Builder time(int hour, int minute, int second) {
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            return this;
        }

        public Builder hour(int hour) {
            this.hour = hour;
            return this;
        }

        public Builder minute(int minute) {
            this.minute = minute;
            return this;
        }

        public Builder second(int second) {
            this.second = second;
            return this;
        }

        public Builder millisec(long milli) {
            if (milli >= 1000L || milli < 0L) {
                long s = milli / 1000L;
                long n = milli % 1000L;
                this.second += s;
                this.nanosec = n * 1000L * 1000L;
            } else {
                this.nanosec = milli * 1000L * 1000L;
            }
            return this;
        }

        public Builder microsec(long micro) {
            if (micro >= 1000000L || micro < 0L) {
                long s = micro / 1000000L;
                long n = micro % 1000000L;
                this.second += s;
                this.nanosec = n * 1000L;
            } else {
                this.nanosec = micro * 1000L;
            }
            return this;
        }

        public Builder nanosec(long nano) {
            if (nano >= 1000000000L || nano < 0L) {
                long s = nano / 1000000000L;
                long n = nano % 1000000000L;
                this.second += s;
                this.nanosec = n;
            } else {
                this.nanosec = nano;
            }
            return this;
        }

        public TimeMoment build() {
            TimeMoment time = new TimeMoment(this);
            return time;
        }
    }
}

