/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.time;

public class Stopwatch {
    private long startNanos = System.nanoTime();

    public void restart() {
        this.startNanos = System.nanoTime();
    }

    public double elapsed() {
        long nanos = System.nanoTime() - this.startNanos;
        return (double)nanos / 1.0E9;
    }

    public String toString() {
        long nanos = System.nanoTime() - this.startNanos;
        StringBuilder result = new StringBuilder();
        long days = nanos / 1000L / 1000L / 1000L / 60L / 60L / 24L;
        long hours = (nanos -= days * 24L * 1000L * 1000L * 1000L * 60L * 60L) / 1000L / 1000L / 1000L / 60L / 60L;
        long minutes = (nanos -= hours * 1000L * 1000L * 1000L * 60L * 60L) / 1000L / 1000L / 1000L / 60L;
        long seconds = (nanos -= minutes * 1000L * 1000L * 1000L * 60L) / 1000L / 1000L / 1000L;
        long millis = (nanos -= seconds * 1000L * 1000L * 1000L) / 1000L / 1000L;
        long micros = (nanos -= millis * 1000L * 1000L) / 1000L;
        nanos -= micros * 1000L;
        if (days > 0L) {
            result.append(days).append("d ");
            if (hours < 10L) {
                result.append('0');
            }
            result.append(hours).append(':');
            if (minutes < 10L) {
                result.append('0');
            }
            result.append(minutes);
        } else if (minutes > 0L || hours > 0L) {
            if (hours < 10L) {
                result.append('0');
            }
            result.append(hours).append(':');
            if (minutes < 10L) {
                result.append('0');
            }
            result.append(minutes).append(':');
            if (seconds < 10L) {
                result.append('0');
            }
            result.append(seconds);
        } else if (seconds > 0L) {
            if (seconds < 10L) {
                result.append(' ');
            }
            result.append(seconds).append('.');
            if (millis < 100L) {
                result.append('0');
            }
            if (millis < 10L) {
                result.append('0');
            }
            result.append(millis).append(" s");
        } else if (millis > 0L) {
            if (millis < 100L) {
                result.append(' ');
            }
            if (millis < 10L) {
                result.append(' ');
            }
            result.append(millis).append('.');
            result.append(micros / 100L).append(" ms");
        } else if (micros > 0L) {
            if (micros < 100L) {
                result.append(' ');
            }
            if (micros < 10L) {
                result.append(' ');
            }
            result.append(micros).append('.');
            result.append(nanos / 100L).append(" us");
        } else {
            result.append("  ");
            if (nanos < 100L) {
                result.append(' ');
            }
            if (nanos < 10L) {
                result.append(' ');
            }
            result.append(nanos).append(" ns");
        }
        return result.toString();
    }
}

