/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.time;

import de.gfz_potsdam.gipp.common.platform.PlatformInfo;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.ExpiredLeapSecondInfoException;
import de.gfz_potsdam.gipp.common.time.InvalidLeapSecondInfoException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;

public class LeapSecondInfo {
    static final int INITIAL_UTC_TAI_OFFSET = 10;
    static final Logger log = Logger.getLogger(LeapSecondInfo.class.getName());
    private static final String LEAP_SECONDS_ENVIRONMENT = "GIPPTOOLS_LEAP";
    private static final String DEFAULT_LEAP_SECONDS_FILENAME = "leap-seconds.list";
    private static final List<File> LEAP_SECONDS_FILES = Arrays.asList(new File(System.getProperty("user.dir"), "leap-seconds.list"), new File(System.getProperty("user.home"), ".gipp" + File.separator + "leap-seconds.list"), new File(System.getProperty("user.home"), "gipp" + File.separator + "leap-seconds.list"), new File(System.getProperty("user.home"), "GIPP" + File.separator + "leap-seconds.list"), new File(System.getProperty("user.home"), "leap-seconds.list"), new File(PlatformInfo.getUserPrefsDirectory(), ".gipp" + File.separator + "leap-seconds.list"), new File(PlatformInfo.getUserPrefsDirectory(), "gipp" + File.separator + "leap-seconds.list"), new File(PlatformInfo.getUserPrefsDirectory(), "GIPP" + File.separator + "leap-seconds.list"), new File(PlatformInfo.getUserPrefsDirectory(), "leap-seconds.list"), new File(PlatformInfo.getUserPrefsDirectory(), "de.gfz_potsdam.gipp" + File.separator + "leap-seconds.list"), new File(PlatformInfo.getSharedPrefsDirectory(), "gipp" + File.separator + "leap-seconds.list"), new File(PlatformInfo.getSharedPrefsDirectory(), "GIPP" + File.separator + "leap-seconds.list"), new File(PlatformInfo.getSharedPrefsDirectory(), "leap-seconds.list"), new File(PlatformInfo.getJarDirectory(LeapSecondInfo.class).getParentFile(), "config" + File.separator + "leap-seconds.list"));
    private static final String[] LEAP_SECONDS_RESOURCES = new String[]{"/resources/leap-seconds.list", "/config/leap-seconds.list", "/etc/leap-seconds.list", "/de/gfz_potsdam/gipp/common/time/resources/leap-seconds.list", "resources/leap-seconds.list"};
    private static LeapSecondInfo leapSecondInfoInstance;
    private final SortedSet<LeapSecondEntry> leapSecondEvents = new TreeSet<LeapSecondEntry>(new NewestFirstComparator());
    private TimeMoment listExpiration = null;
    private TimeMoment lastListUpdate = null;
    private String listSource = null;

    private LeapSecondInfo() {
        try {
            this.initLeapSecondsList();
            assert (!this.leapSecondEvents.isEmpty()) : "Leap second list not initialized yet!";
        }
        catch (InvalidLeapSecondInfoException e) {
            log.warning(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LeapSecondInfo getInstance() {
        if (leapSecondInfoInstance != null) return leapSecondInfoInstance;
        Class<LeapSecondInfo> clazz = LeapSecondInfo.class;
        synchronized (LeapSecondInfo.class) {
            if (leapSecondInfoInstance != null) return leapSecondInfoInstance;
            leapSecondInfoInstance = new LeapSecondInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return leapSecondInfoInstance;
        }
    }

    public static boolean isListUpToDate() {
        return LeapSecondInfo.isListUpToDate(TimeMoment.now());
    }

    public static boolean isListUpToDate(TimeMoment date) {
        if (date == null) {
            throw new IllegalArgumentException("The time moment argument is missing (i.e. 'null').");
        }
        LeapSecondInfo instance = LeapSecondInfo.getInstance();
        assert (instance != null) : "Leap second info instance is 'null'!";
        return instance.listExpiration != null && instance.listExpiration.after(date);
    }

    public static String getExpirationDateInfo() {
        LeapSecondInfo instance = LeapSecondInfo.getInstance();
        assert (instance != null) : "Leap second info instance is 'null'!";
        if (instance.listExpiration != null) {
            return instance.listExpiration.toDateString();
        }
        return "n/a";
    }

    public static String getLastListUpdateInfo() {
        LeapSecondInfo instance = LeapSecondInfo.getInstance();
        assert (instance != null) : "Leap second info instance is 'null'!";
        if (instance.lastListUpdate != null) {
            return instance.lastListUpdate.toDateString();
        }
        return "n/a";
    }

    public static String getListSourceInfo() {
        LeapSecondInfo instance = LeapSecondInfo.getInstance();
        assert (instance != null) : "Leap second info instance is 'null'!";
        if (instance.listSource != null && !instance.listSource.isEmpty()) {
            return instance.listSource;
        }
        return "n/a";
    }

    public static int getGpsUtcOffset(String gpsTime) throws InvalidLeapSecondInfoException, ExpiredLeapSecondInfoException {
        LeapSecondInfo instance = LeapSecondInfo.getInstance();
        assert (instance != null) : "Leap second info instance is 'null'!";
        if (gpsTime.compareTo(instance.listExpiration.toDateString()) > 0) {
            throw new ExpiredLeapSecondInfoException("Used leap second list is not sufficiently up-to-date to provide information about time " + gpsTime + "!");
        }
        for (LeapSecondEntry event : instance.leapSecondEvents) {
            TimeMoment time = event.epochStart.subtract(TimeSpan.SECOND.multiply(19.0));
            String epoch = StringUtils.FOUR_DIGITS.format(time.getYear()) + '-' + StringUtils.TWO_DIGITS.format(time.getMonth()) + '-' + StringUtils.TWO_DIGITS.format(time.getDay()) + 'T' + StringUtils.TWO_DIGITS.format(time.getHour()) + ':' + StringUtils.TWO_DIGITS.format(time.getMinute()) + ':' + StringUtils.TWO_DIGITS.format(time.getSecond());
            if (gpsTime.compareTo(epoch) < 0) continue;
            return event.epochOffset - 19;
        }
        return 0;
    }

    static Iterator<LeapSecondEntry> getLeapSecondsIterator() {
        LeapSecondInfo instance = LeapSecondInfo.getInstance();
        assert (instance != null) : "Leap second info instance is 'null'!";
        assert (instance.leapSecondEvents != null) : "No leap seconds list available!";
        return instance.leapSecondEvents.iterator();
    }

    private void parseLeapSecondList(Reader leapSecondsReader) throws IOException, InvalidLeapSecondInfoException {
        String textLine;
        MessageDigest digest;
        assert (leapSecondsReader != null) : "No leap seconds reader provided!";
        try {
            digest = MessageDigest.getInstance("SHA-1");
            log.fine("Using \"SHA-1\" hash algorithm to verify leap seconds list.");
        }
        catch (NoSuchAlgorithmException e) {
            digest = null;
            log.warning("\"SHA-1\" hash algorithm is not available. Cannot check integrity of the leap seconds list. Will proceed anyhow.");
        }
        TreeMap<Long, Integer> parsedEvents = new TreeMap<Long, Integer>();
        BufferedReader in = new BufferedReader(leapSecondsReader);
        int lineNumber = 0;
        while ((textLine = in.readLine()) != null) {
            TimeSpan ntpSpan;
            log.fine("Line #" + ++lineNumber + "  Parsing \"" + textLine + "\"");
            if (textLine.startsWith("#$")) {
                textLine = textLine.substring(2).trim();
                if (digest != null) {
                    digest.update(textLine.getBytes());
                }
                long ntpSeconds = Long.parseLong(textLine);
                ntpSpan = new TimeSpan.Builder().addSeconds(ntpSeconds).build();
                this.lastListUpdate = TimeMoment.NTP_EPOCH.add(ntpSpan);
                continue;
            }
            if (textLine.startsWith("#@")) {
                textLine = textLine.substring(2).trim();
                if (digest != null) {
                    digest.update(textLine.getBytes());
                }
                long ntpSeconds = Long.parseLong(textLine);
                ntpSpan = new TimeSpan.Builder().addSeconds(ntpSeconds).build();
                this.listExpiration = TimeMoment.NTP_EPOCH.add(ntpSpan);
                continue;
            }
            if (textLine.startsWith("#h")) {
                if (digest == null) continue;
                StringBuilder hexString = new StringBuilder(digest.getDigestLength() * 2);
                for (String column : textLine.substring(2).trim().split("\\s+")) {
                    hexString.append(StringUtils.toHexString(Long.valueOf(column, 16), 8));
                }
                String expectedDigest = hexString.toString();
                String computedDigest = StringUtils.toHexString(digest.digest());
                if (computedDigest.equalsIgnoreCase(expectedDigest)) {
                    log.fine("Loaded leap seconds list passed checksum test.");
                    continue;
                }
                throw new InvalidLeapSecondInfoException("Checksum in leap seconds input does not verify!");
            }
            int commentPos = textLine.indexOf(35);
            if (commentPos <= 0) continue;
            String[] column = (textLine = textLine.substring(0, commentPos)).split("\\s+");
            if (column.length == 2) {
                try {
                    if (digest != null) {
                        digest.update(column[0].getBytes());
                    }
                    if (digest != null) {
                        digest.update(column[1].getBytes());
                    }
                    parsedEvents.put(Long.parseLong(column[0]), Integer.parseInt(column[1]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidLeapSecondInfoException("Could not parse number in line #" + lineNumber + "('" + textLine + "').", e);
                }
            }
            log.warning("Line #" + lineNumber + "  Expected two columns (event time and UTC/TAI offset) but got " + column.length + " columns. The line will be ignored and skipped!");
        }
        int previousOffset = 10;
        for (Map.Entry event : parsedEvents.entrySet()) {
            if ((Long)event.getKey() < 2287785600L) continue;
            if ((Integer)event.getValue() - previousOffset == 1) {
                this.leapSecondEvents.add(new LeapSecondEntry((Long)event.getKey(), (Integer)event.getValue(), true));
            } else if ((Integer)event.getValue() - previousOffset == -1) {
                this.leapSecondEvents.add(new LeapSecondEntry((Long)event.getKey(), (Integer)event.getValue(), false));
            } else {
                throw new InvalidLeapSecondInfoException("The UTC/TAI offset differs by more than one second between two consecutive leap second events!");
            }
            previousOffset = (Integer)event.getValue();
        }
    }

    /*
     * Exception decompiling
     */
    private void initLeapSecondsList() throws InvalidLeapSecondInfoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class LeapSecondEntry
    implements Comparable<LeapSecondEntry> {
        final TimeMoment epochStart;
        final int epochOffset;
        final boolean leapSecondAdded;

        private LeapSecondEntry(long ntpSecondCount, int taiToUtcOffset, boolean addedLeapSecond) {
            assert (ntpSecondCount >= 2287785600L) : "A time before the first leap second on 30 Jun 1972 was indicated";
            this.epochStart = TimeMoment.NTP_EPOCH.add(TimeSpan.SECOND.multiply(ntpSecondCount + (long)taiToUtcOffset));
            this.epochOffset = taiToUtcOffset;
            this.leapSecondAdded = addedLeapSecond;
        }

        public String toString() {
            return "time=" + this.epochStart.toLogString() + " (TAI), offset=" + this.epochOffset + " s between TAI and UTC,leap second was " + (this.leapSecondAdded ? "added" : "removed");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LeapSecondEntry other = (LeapSecondEntry)obj;
            if (this.epochStart == null ? other.epochStart != null : !this.epochStart.equals(other.epochStart)) {
                return false;
            }
            if (this.epochOffset != other.epochOffset) {
                return false;
            }
            return this.leapSecondAdded == other.leapSecondAdded;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.epochStart == null ? 0 : this.epochStart.hashCode());
            result = 31 * result + this.epochOffset;
            result = 31 * result + (this.leapSecondAdded ? 17 : 31);
            return result;
        }

        @Override
        public int compareTo(LeapSecondEntry other) {
            if (other == null) {
                throw new NullPointerException();
            }
            if (this == other) {
                return 0;
            }
            int result = this.epochStart.compareTo(other.epochStart);
            if (result != 0) {
                return result;
            }
            if (this.epochOffset < other.epochOffset) {
                return -1;
            }
            if (this.epochOffset > other.epochOffset) {
                return 1;
            }
            result = Boolean.compare(this.leapSecondAdded, other.leapSecondAdded);
            if (result != 0) {
                return result;
            }
            assert (this.equals(other)) : "Method 'compareTo()' inconsistent with 'equals()'!";
            return 0;
        }
    }

    private static class NewestFirstComparator
    implements Comparator<LeapSecondEntry> {
        private NewestFirstComparator() {
        }

        @Override
        public int compare(LeapSecondEntry left, LeapSecondEntry right) {
            if (left == null || right == null) {
                throw new NullPointerException();
            }
            if (left == right) {
                return 0;
            }
            if (left.epochStart.after(right.epochStart)) {
                return -1;
            }
            if (left.epochStart.before(right.epochStart)) {
                return 1;
            }
            assert (left.epochStart.equals(right.epochStart)) : "Expected same leap second event time!";
            assert (left.epochOffset == right.epochOffset) : "Expected the same UTC-TAI offset!";
            assert (left.equals(right)) : "Method 'NewestFirstComparator.compareTo()' is inconsistent with 'LeapSecondEntry.equals()'!";
            return 0;
        }
    }
}

