/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.swing;

import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class NiceNumbers {
    public static List<TimeMoment> getNiceNumbers(TimeMoment lower, TimeMoment upper, int maxNumber) {
        if (lower == null) {
            throw new NullPointerException("The given lower bound argument was 'null'!");
        }
        if (upper == null) {
            throw new NullPointerException("The given upper bound argument was 'null'!");
        }
        if (!lower.before(upper)) {
            throw new IllegalArgumentException("The lower bound (" + lower + ") must be before the upper bound (" + upper + ")!");
        }
        if (maxNumber < 1) {
            throw new IllegalArgumentException("The requested number of nice numbers ('" + maxNumber + "') must be at least '1'");
        }
        TimeSpan intervalLength = TimeSpan.diff(upper, lower);
        TimeSpan tickUnit = intervalLength.lessThan(new TimeSpan.Builder().addMicroSeconds(10L).build()) ? TimeSpan.MICROSECOND : (intervalLength.lessThan(new TimeSpan.Builder().addMicroSeconds(100L).build()) ? TimeSpan.multiply(TimeSpan.MICROSECOND, 10.0) : (intervalLength.lessThan(new TimeSpan.Builder().addMilliSeconds(1L).build()) ? TimeSpan.multiply(TimeSpan.MICROSECOND, 100.0) : (intervalLength.lessThan(new TimeSpan.Builder().addMilliSeconds(10L).build()) ? TimeSpan.MILLISECOND : (intervalLength.lessThan(new TimeSpan.Builder().addMilliSeconds(100L).build()) ? TimeSpan.multiply(TimeSpan.MILLISECOND, 10.0) : (intervalLength.lessThan(new TimeSpan.Builder().addSeconds(1L).build()) ? TimeSpan.multiply(TimeSpan.MILLISECOND, 100.0) : (intervalLength.lessThan(new TimeSpan.Builder().addSeconds(10L).build()) ? TimeSpan.SECOND : (intervalLength.lessThan(new TimeSpan.Builder().addSeconds(30L).build()) ? TimeSpan.multiply(TimeSpan.SECOND, 5.0) : (intervalLength.lessThan(new TimeSpan.Builder().addMinutes(1L).build()) ? TimeSpan.multiply(TimeSpan.SECOND, 10.0) : (intervalLength.lessThan(new TimeSpan.Builder().addMinutes(10L).build()) ? TimeSpan.MINUTE : (intervalLength.lessThan(new TimeSpan.Builder().addMinutes(30L).build()) ? TimeSpan.multiply(TimeSpan.MINUTE, 5.0) : (intervalLength.lessThan(new TimeSpan.Builder().addHours(1L).build()) ? TimeSpan.multiply(TimeSpan.MINUTE, 10.0) : (intervalLength.lessThan(new TimeSpan.Builder().addHours(5L).build()) ? TimeSpan.multiply(TimeSpan.MINUTE, 30.0) : (intervalLength.lessThan(new TimeSpan.Builder().addHours(12L).build()) ? TimeSpan.HOUR : (intervalLength.lessThan(new TimeSpan.Builder().addDays(1L).build()) ? TimeSpan.multiply(TimeSpan.HOUR, 6.0) : (intervalLength.lessThan(new TimeSpan.Builder().addDays(7L).build()) ? TimeSpan.DAY : (intervalLength.lessThan(new TimeSpan.Builder().addDays(14L).build()) ? TimeSpan.multiply(TimeSpan.DAY, 2.0) : (intervalLength.lessThan(new TimeSpan.Builder().addDays(35L).build()) ? TimeSpan.WEEK : TimeSpan.multiply(TimeSpan.WEEK, 4.0))))))))))))))))));
        BigDecimal first = new BigDecimal(lower.getBigCount()).divide(new BigDecimal(tickUnit.getBigCount()), 0, RoundingMode.CEILING).multiply(new BigDecimal(tickUnit.getBigCount())).setScale(0, RoundingMode.HALF_UP);
        BigDecimal last = new BigDecimal(upper.getBigCount()).divide(new BigDecimal(tickUnit.getBigCount()), 0, RoundingMode.FLOOR).multiply(new BigDecimal(tickUnit.getBigCount())).setScale(0, RoundingMode.HALF_UP);
        ArrayList<TimeMoment> result = new ArrayList<TimeMoment>(maxNumber);
        if (first.equals(last)) {
            result.add(new TimeMoment(first.setScale(0, RoundingMode.HALF_UP).toBigInteger()));
        } else if (maxNumber == 1) {
            BigDecimal middle = last.add(first).divide(new BigDecimal(2), MathContext.DECIMAL64).divide(new BigDecimal(tickUnit.getBigCount()), MathContext.DECIMAL64).setScale(0, RoundingMode.CEILING).multiply(new BigDecimal(tickUnit.getBigCount()));
            result.add(new TimeMoment(middle.setScale(0, RoundingMode.HALF_UP).toBigInteger()));
        } else {
            BigDecimal interval = last.subtract(first).divide(new BigDecimal(maxNumber - 1), MathContext.DECIMAL64).divide(new BigDecimal(tickUnit.getBigCount()), MathContext.DECIMAL64).setScale(0, RoundingMode.CEILING).multiply(new BigDecimal(tickUnit.getBigCount()));
            BigDecimal niceNumber = first;
            while (niceNumber.compareTo(last) <= 0) {
                result.add(new TimeMoment(niceNumber.setScale(0, RoundingMode.HALF_UP).toBigInteger()));
                niceNumber = niceNumber.add(interval);
            }
        }
        return result;
    }

    public static double[] getNiceNumbers(double lower, double upper, int maxNumber) {
        double[] buffer = new double[maxNumber];
        if (upper <= lower) {
            throw new IllegalArgumentException("The lower bound (" + lower + ") must be smaller than the upper bound (" + upper + ")!");
        }
        if (maxNumber < 2) {
            throw new IllegalArgumentException("The requested number of nice numbers ('" + maxNumber + "') must be at least '2'");
        }
        double delta = (upper - lower) / (double)(maxNumber - 1);
        double scale = 1.0;
        while (delta > 10.0) {
            delta /= 10.0;
            scale *= 10.0;
        }
        while (delta < 1.0) {
            delta *= 10.0;
            scale /= 10.0;
        }
        double unit = delta <= 2.0 ? 2.0 * scale : (delta <= 2.5 ? 2.5 * scale : (delta <= 5.0 ? 5.0 * scale : 10.0 * scale));
        double first = Math.ceil(lower / unit) * unit;
        double last = Math.floor(upper / unit) * unit;
        int count = 0;
        for (double niceNumber = first; niceNumber <= last; niceNumber += unit) {
            buffer[count] = niceNumber;
            ++count;
        }
        double[] result = new double[count];
        System.arraycopy(buffer, 0, result, 0, Math.min(buffer.length, count));
        return result;
    }
}

