/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class MissingIcon
implements Icon {
    private static final int DEFAULT_SIZE = 24;
    private final int size;

    public MissingIcon() {
        this(24);
    }

    public MissingIcon(int iconSize) {
        if (iconSize <= 0) {
            throw new IllegalArgumentException("Icon size must be greater than zero (was \"" + iconSize + "\")");
        }
        this.size = iconSize;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int xPos, int yPos) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(xPos, yPos, this.size - 1, this.size - 1);
        g2d.setPaint(Color.BLACK);
        g2d.drawRect(xPos, yPos, this.size - 1, this.size - 1);
        g2d.setPaint(Color.RED);
        g2d.setStroke(new BasicStroke(this.size / 10));
        int delta = this.size / 3;
        g2d.drawLine(xPos + delta, yPos + delta, xPos + this.size - delta, yPos + this.size - delta);
        g2d.drawLine(xPos + delta, yPos + this.size - delta, xPos + this.size - delta, yPos + delta);
        g2d.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

