/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

public class MemoryGauge
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final long updatePeriod;
    private final Color backgroundColor = SystemColor.control;
    private final Color foregroundColor = SystemColor.controlText;
    private final Color normalColor = new Color(0xF5F5B5);
    private final Color warnColor = new Color(16760445);
    private final Color panicColor = new Color(0xFF0000);
    private final double warnPercentage;
    private final double panicPercentage;

    public MemoryGauge() {
        this.updatePeriod = 3000L;
        this.warnPercentage = 1.01;
        this.panicPercentage = 1.01;
        int textHeight = this.getFontMetrics(this.getFont()).getAscent();
        this.setMinimumSize(new Dimension(20, textHeight + 2));
        this.setPreferredSize(new Dimension(100, textHeight + 2));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.setToolTipText("Displays current memory usage.");
        Timer timer = new Timer("Periodic update of MemoryGauge", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                MemoryGauge.this.repaint();
            }
        }, this.updatePeriod, this.updatePeriod);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Runtime r = Runtime.getRuntime();
        long usedMemory = r.totalMemory();
        long maxMemory = r.maxMemory();
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setColor(this.foregroundColor);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if ((double)(usedMemory / maxMemory) > this.panicPercentage) {
            g.setColor(this.panicColor);
        } else if ((double)(usedMemory / maxMemory) > this.warnPercentage) {
            g.setColor(this.warnColor);
        } else {
            g.setColor(this.normalColor);
        }
        g.fillRect(0, 0, (int)((long)this.getWidth() * usedMemory / maxMemory - 1L), this.getHeight() - 1);
        g.setColor(this.foregroundColor);
        g.drawRect(0, 0, (int)((long)this.getWidth() * usedMemory / maxMemory - 1L), this.getHeight() - 1);
        String usageMsg = usedMemory / 1024L / 1024L + " MiByte of " + maxMemory / 1024L / 1024L + " MiByte";
        int textWidth = g.getFontMetrics().stringWidth(usageMsg);
        int textHeight = g.getFontMetrics().getAscent();
        if (textWidth < this.getWidth() - 1 && textHeight < this.getHeight() - 1) {
            g.setColor(this.foregroundColor);
            g.drawString(usageMsg, (this.getWidth() - textWidth) / 2, this.getHeight() - (this.getHeight() - textHeight) / 2 - 2);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Runtime r = Runtime.getRuntime();
        return "<html>Current heap size is " + r.totalMemory() / 1024L / 1024L + " MiByte (of which " + r.freeMemory() / 1024L / 1024L + " MiByte are available).<br>The heap may grow up to " + r.maxMemory() / 1024L / 1024L + " MiByte.</html>";
    }
}

