/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.string;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class StringUtils {
    public static final NumberFormat TEN_DIGITS = new DecimalFormat("0000000000");
    public static final NumberFormat NINE_DIGITS = new DecimalFormat("000000000");
    public static final NumberFormat SIX_DIGITS = new DecimalFormat("000000");
    public static final NumberFormat FOUR_DIGITS = new DecimalFormat("0000");
    public static final NumberFormat THREE_DIGITS = new DecimalFormat("000");
    public static final NumberFormat TWO_DIGITS = new DecimalFormat("00");
    public static final NumberFormat TWO_DECIMAL_PLACES = new DecimalFormat("0.##");
    public static final NumberFormat SIX_DECIMAL_PLACES = new DecimalFormat("0.######");

    public static String roundedNumber(double number, int minDecimalPlaces, int maxDecimalPlaces) {
        assert (minDecimalPlaces <= maxDecimalPlaces);
        if (Double.isNaN(number)) {
            return "NOT-A-NUMBER";
        }
        if (Double.isInfinite(number)) {
            return "INFINITY";
        }
        BigDecimal decimal = new BigDecimal(Double.toString(number));
        decimal = decimal.setScale(maxDecimalPlaces, RoundingMode.HALF_UP);
        NumberFormat formatter = DecimalFormat.getInstance(Locale.ENGLISH);
        formatter.setGroupingUsed(false);
        formatter.setMinimumFractionDigits(minDecimalPlaces);
        formatter.setMaximumFractionDigits(maxDecimalPlaces);
        return formatter.format(decimal.doubleValue());
    }

    public static boolean containsWhitespace(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        return text.matches("(.*?)\\s(.*?)");
    }

    public static String escapeControlCodes(String inputText) {
        int codePoint;
        if (inputText == null || inputText.isEmpty()) {
            return inputText;
        }
        StringBuilder escapedText = new StringBuilder(inputText.length());
        boolean modified = false;
        block14: for (int index = 0; index < inputText.length(); index += Character.charCount(codePoint)) {
            codePoint = inputText.codePointAt(index);
            assert (Character.isValidCodePoint(codePoint)) : "Invalid code point (" + codePoint + ").";
            switch (codePoint) {
                case 0: {
                    escapedText.append("\\0");
                    modified = true;
                    continue block14;
                }
                case 7: {
                    escapedText.append("\\a");
                    modified = true;
                    continue block14;
                }
                case 8: {
                    escapedText.append("\\b");
                    modified = true;
                    continue block14;
                }
                case 9: {
                    escapedText.append("\\t");
                    modified = true;
                    continue block14;
                }
                case 10: {
                    escapedText.append("\\n");
                    modified = true;
                    continue block14;
                }
                case 11: {
                    escapedText.append("\\v");
                    modified = true;
                    continue block14;
                }
                case 12: {
                    escapedText.append("\\f");
                    modified = true;
                    continue block14;
                }
                case 13: {
                    escapedText.append("\\r");
                    modified = true;
                    continue block14;
                }
                case 27: {
                    escapedText.append("\\e");
                    modified = true;
                    continue block14;
                }
                case 34: {
                    escapedText.append("\\\"");
                    modified = true;
                    continue block14;
                }
                case 39: {
                    escapedText.append("\\'");
                    modified = true;
                    continue block14;
                }
                case 92: {
                    escapedText.append("\\\\");
                    modified = true;
                    continue block14;
                }
                default: {
                    escapedText.appendCodePoint(codePoint);
                }
            }
        }
        if (modified) {
            return escapedText.toString();
        }
        return inputText;
    }

    public static String replaceControlCodes(String inputText) {
        int codePoint;
        if (inputText == null || inputText.isEmpty()) {
            return inputText;
        }
        StringBuilder replacedText = new StringBuilder(inputText.length());
        boolean modified = false;
        block4: for (int index = 0; index < inputText.length(); index += Character.charCount(codePoint)) {
            codePoint = inputText.codePointAt(index);
            assert (Character.isValidCodePoint(codePoint)) : "Invalid code point (" + codePoint + ").";
            switch (codePoint) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    replacedText.append(Character.toChars(9216 + codePoint));
                    modified = true;
                    continue block4;
                }
                case 127: {
                    replacedText.append(Character.toChars(9249));
                    modified = true;
                    continue block4;
                }
                default: {
                    replacedText.appendCodePoint(codePoint);
                }
            }
        }
        if (modified) {
            return replacedText.toString();
        }
        return inputText;
    }

    public static String toHexString(long number, int width) {
        String buffer = "0000000000000000" + Long.toHexString(number);
        return buffer.substring(buffer.length() - width);
    }

    public static String toHexString(long number) {
        return StringUtils.toHexString(number, 16);
    }

    public static String toHexString(int number) {
        return StringUtils.toHexString(number, 8);
    }

    public static String toHexString(short number) {
        return StringUtils.toHexString(number, 4);
    }

    public static String toHexString(byte number) {
        return StringUtils.toHexString(number, 2);
    }

    public static String toHexString(byte[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder text = new StringBuilder(array.length * 2);
        for (byte b : array) {
            text.append(StringUtils.toHexString(b, 2));
        }
        return text.toString();
    }

    public static String toFormattedHexString(byte[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder text = new StringBuilder(array.length * 2 + array.length / 2 - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0 && i % 2 == 0) {
                text.append("-");
            }
            text.append(StringUtils.toHexString(array[i], 2));
        }
        return text.toString();
    }

    public static String toBinaryString(long number, int width) {
        String buffer = "0000000000000000000000000000000000000000000000000000000000000000" + Long.toBinaryString(number);
        return buffer.substring(buffer.length() - width);
    }

    public static String toBinaryString(long number) {
        return StringUtils.toBinaryString(number, 64);
    }

    public static String toBinaryString(int number) {
        return StringUtils.toBinaryString(number, 32);
    }

    public static String toBinaryString(short number) {
        return StringUtils.toBinaryString(number, 16);
    }

    public static String toBinaryString(byte number) {
        return StringUtils.toBinaryString(number, 8);
    }

    private static String toHumanReadableByteCount(long count, PrefixSystems prefix) {
        long value;
        StringBuilder result = new StringBuilder();
        String[] prefixList = null;
        long prefixFactor = 0L;
        switch (prefix) {
            case SI_SHORT: {
                prefixList = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
                prefixFactor = 1000L;
                break;
            }
            case SI_LONG: {
                prefixList = new String[]{"bytes", "kilobytes", "megabytes", "gigabytes", "terabytes", "petabytes", "exabytes", "zettabytes", "yottabytes"};
                prefixFactor = 1000L;
                break;
            }
            case IEC_SHORT: {
                prefixList = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
                prefixFactor = 1024L;
                break;
            }
            case IEC_LONG: {
                prefixList = new String[]{"bytes", "kibibytes", "mebibytes", "gibibytes", "tebibytes", "pebibytes", "exbibytes", "zebibytes", "yobibytes"};
                prefixFactor = 1024L;
            }
        }
        assert (prefixList != null) : "The list containing the prefix strings was not initialized!";
        assert (prefixFactor != 0L) : "The prefix factor was not initialized!";
        if (count >= 0L) {
            value = count;
        } else if (count == Long.MIN_VALUE) {
            result.append("-");
            value = Long.MAX_VALUE;
        } else {
            result.append("-");
            value = Math.abs(count);
        }
        if (value < prefixFactor) {
            switch (prefix) {
                case SI_LONG: 
                case IEC_LONG: {
                    if (value == 0L) {
                        result.append("zero bytes");
                        break;
                    }
                    if (value == 1L) {
                        result.append("1 byte");
                        break;
                    }
                    result.append(value).append(" bytes");
                    break;
                }
                case SI_SHORT: 
                case IEC_SHORT: {
                    result.append(value).append(' ').append((String)prefixList[0]);
                }
            }
        } else {
            int exp = Math.min((int)(Math.log(value) / Math.log(prefixFactor)), prefixList.length - 1);
            result.append(StringUtils.roundedNumber((double)value / Math.pow(prefixFactor, exp), 1, 1));
            result.append(" ");
            result.append(prefixList[exp]);
        }
        return result.toString();
    }

    public static String toShortIecByteCount(long count) {
        return StringUtils.toHumanReadableByteCount(count, PrefixSystems.IEC_SHORT);
    }

    public static String toLongIecByteCount(long count) {
        return StringUtils.toHumanReadableByteCount(count, PrefixSystems.IEC_LONG);
    }

    public static String toShortSiByteCount(long count) {
        return StringUtils.toHumanReadableByteCount(count, PrefixSystems.SI_SHORT);
    }

    public static String toLongSiByteCount(long count) {
        return StringUtils.toHumanReadableByteCount(count, PrefixSystems.SI_LONG);
    }

    public static String trimTrailing(String text) {
        if (text != null) {
            for (int i = text.length() - 1; i >= 0; --i) {
                if (Character.isWhitespace(text.charAt(i))) continue;
                return text.substring(0, i + 1);
            }
        }
        return text;
    }

    private static enum PrefixSystems {
        SI_SHORT,
        SI_LONG,
        IEC_SHORT,
        IEC_LONG;

    }
}

