/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.string;

import java.io.PrintStream;

public class PrintStreamFormatter {
    private static final int DEFAULT_WIDTH = 74;
    private static final String NEWLINE_SEPARATOR_PATTERN = "\n";
    private static final String WORD_SEPARATOR_PATTERN = "(?<=[-/\\s])";
    private static int consoleWidth = 74;

    public static void setConsoleWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Console width must be a positive number!");
        }
        consoleWidth = width;
    }

    public static void printWrapped(PrintStream prt, int firstLineIndent, int textIndent, String text) {
        assert (prt != null) : "Print stream must not be null!";
        if (text == null || text.length() == 0) {
            prt.println();
            return;
        }
        if (firstLineIndent <= 0 || firstLineIndent >= consoleWidth) {
            throw new IllegalArgumentException("First line indentation value must be in the range of [0.." + consoleWidth + "] but was " + firstLineIndent + "!");
        }
        if (textIndent <= 0 || textIndent >= consoleWidth) {
            throw new IllegalArgumentException("Text indentation value must be in the range of [0.." + consoleWidth + "] but was " + textIndent + "!");
        }
        int indent = firstLineIndent;
        String margin = new String(new char[firstLineIndent]).replace('\u0000', ' ');
        for (String paragraph : text.split(NEWLINE_SEPARATOR_PATTERN, -1)) {
            StringBuilder line = new StringBuilder(margin);
            for (String word : paragraph.split(WORD_SEPARATOR_PATTERN, -1)) {
                if (line.length() + word.length() > consoleWidth) {
                    prt.println(line);
                    if (indent != textIndent) {
                        indent = textIndent;
                        margin = new String(new char[textIndent]).replace('\u0000', ' ');
                    }
                    line = new StringBuilder(margin);
                }
                line.append(word);
            }
            prt.println(line);
        }
    }

    public static void printWrapped(PrintStream prt, int indent, String text) {
        PrintStreamFormatter.printWrapped(prt, indent, indent, text);
    }

    public static void printWrapped(PrintStream prt) {
        assert (prt != null) : "Print stream must not be null!";
        prt.println();
    }

    private PrintStreamFormatter() {
    }
}

