/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.segy;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.geo.Ellipsoid;
import de.gfz_potsdam.gipp.common.geo.LatLonPoint;
import de.gfz_potsdam.gipp.common.seis.segy.SegyException;
import de.gfz_potsdam.gipp.common.seis.segy.SegyFile;
import de.gfz_potsdam.gipp.common.seis.segy.SegyUtils;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class StandardSegy
implements SegyFile {
    private final ByteBuffer fileHeader = ByteBuffer.allocate(3600);
    private final ByteBuffer traceHeader = ByteBuffer.allocate(240);
    private ByteBuffer traceData;
    private final RandomAccessFile segyFile;
    private final String segyName;

    public StandardSegy(File file) throws FileNotFoundException, IOException {
        this.fileHeader.order(ByteOrder.BIG_ENDIAN);
        this.traceHeader.order(ByteOrder.BIG_ENDIAN);
        this.segyFile = new RandomAccessFile(file, "rwd");
        this.segyName = file.getName();
        if (this.segyFile.length() == 0L) {
            this.initFileHeader();
            this.initTraceHeader();
            this.segyFile.write(this.fileHeader.array());
        } else {
            this.segyFile.seek(0L);
            this.segyFile.read(this.fileHeader.array());
            this.segyFile.seek(this.fileHeader.capacity());
            this.initTraceHeader();
        }
        this.traceData = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.segyFile != null) {
                this.segyFile.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void closeFile() {
        FileUtils.flushClose(this.segyFile);
    }

    @Override
    public void appendTraceToFile() throws IOException {
        this.segyFile.seek(this.segyFile.length());
        this.segyFile.write(this.traceHeader.array(), 0, 240);
        this.segyFile.write(this.traceData.array());
        long savedPos = this.segyFile.getFilePointer();
        this.segyFile.seek(0L);
        this.segyFile.write(this.fileHeader.array(), 0, 3600);
        this.segyFile.seek(savedPos);
    }

    private void initFileHeader() {
        for (int i = 1; i < 40; ++i) {
            this.fileHeader.put(SegyUtils.textToCard(i, ""));
        }
        this.fileHeader.put(SegyUtils.textToCard(40, "END TEXTUAL HEADER"));
        this.fileHeader.putShort(3214, (short)0);
        this.fileHeader.putShort(3254, (short)1);
        this.fileHeader.putShort(3224, (short)1);
    }

    private void initTraceHeader() {
        this.traceHeader.putShort(28, (short)1);
        this.traceHeader.putShort(166, (short)4);
    }

    @Override
    public String getFileName() {
        if (this.segyName != null) {
            return this.segyName;
        }
        return "";
    }

    @Override
    public int maxTraceLength() {
        return Short.MAX_VALUE;
    }

    @Override
    public void setTraceFFID(int ffid) {
        this.traceHeader.putInt(8, ffid);
    }

    @Override
    public void setTraceChannel(int channel) {
        this.traceHeader.putInt(12, channel);
    }

    @Override
    public void setTraceTiming(TimeMoment triggerTime, TimeMoment recordingStart, TimeMoment firstSample) {
        assert (triggerTime != null) : "Argument 'triggerTime' must not be null!";
        assert (recordingStart != null) : "Argument 'recordingStart' must not be null!";
        assert (firstSample != null) : "Argument 'firstSample' must not be null!";
        this.traceHeader.putShort(156, (short)triggerTime.getYear());
        this.traceHeader.putShort(158, (short)triggerTime.getDayOfYear());
        this.traceHeader.putShort(160, (short)triggerTime.getHour());
        this.traceHeader.putShort(162, (short)triggerTime.getMinute());
        this.traceHeader.putShort(164, (short)triggerTime.getSecond());
        double msecDelay = triggerTime.before(recordingStart) ? TimeSpan.diff(triggerTime, recordingStart).getSeconds() * 1000.0 : -TimeSpan.diff(triggerTime, recordingStart).getSeconds() * 1000.0;
        double msecLagA = recordingStart.before(firstSample) ? TimeSpan.diff(recordingStart, firstSample).getSeconds() * 1000.0 : -TimeSpan.diff(recordingStart, firstSample).getSeconds() * 1000.0;
        if (msecDelay != 0.0 || msecLagA != 0.0) {
            short[] scalingFactors;
            for (short scalar : scalingFactors = new short[]{-1000, -100, -10, 1, 10, 100, 1000, 10000}) {
                double delay = scalar > 0 ? msecDelay / (double)scalar : msecDelay * (double)(-scalar);
                double lagA = scalar > 0 ? msecLagA / (double)scalar : msecLagA * (double)(-scalar);
                if (delay > 32767.0 || delay < -32768.0 || lagA > 32767.0 || lagA < -32768.0) continue;
                this.traceHeader.putShort(214, scalar);
                this.traceHeader.putShort(104, (short)Math.round(lagA));
                this.traceHeader.putShort(108, (short)Math.round(delay));
                break;
            }
        }
    }

    @Override
    public void setTraceGeomety(LatLonPoint shotLatLon, double shotElevation, LatLonPoint receiverLatLon, double receiverElevation) {
        assert (shotLatLon != null) : "Argument 'shotLatLon' must not be null!";
        assert (receiverLatLon != null) : "Argument 'receiverLatLon' must not be null!";
        this.traceHeader.putShort(88, (short)4);
        this.traceHeader.putShort(70, (short)-100);
        this.traceHeader.putShort(68, (short)1);
        this.traceHeader.putInt(72, SegyUtils.toSegyDMS(shotLatLon.getLongitude()));
        this.traceHeader.putInt(76, SegyUtils.toSegyDMS(shotLatLon.getLatitude()));
        this.traceHeader.putInt(44, (int)Math.round(shotElevation));
        this.traceHeader.putInt(80, SegyUtils.toSegyDMS(receiverLatLon.getLongitude()));
        this.traceHeader.putInt(84, SegyUtils.toSegyDMS(receiverLatLon.getLatitude()));
        this.traceHeader.putInt(40, (int)Math.round(receiverElevation));
        double dist = Math.abs(Ellipsoid.WGS84.distance(shotLatLon, receiverLatLon));
        if (dist >= 2.147483647E9) {
            this.traceHeader.putInt(36, Integer.MAX_VALUE);
        } else {
            this.traceHeader.putInt(36, (int)Math.round(dist));
        }
    }

    @Override
    public void setTraceOptional(List<Float> optional) {
        int bytesPerFloat = 4;
        for (int index = 0; index < optional.size(); ++index) {
            int offset = 240 - (index + 1) * 4;
            this.traceHeader.putFloat(offset, optional.get(index).floatValue());
        }
    }

    @Override
    public void setTraceData(double[] samples, TimeSpan period) {
        assert (samples != null) : "Argument 'samples' must not be null!";
        if (samples.length > this.maxTraceLength()) {
            throw new SegyException("The trace is to long (" + samples.length + "samples) for the SEG-Y format! At most " + this.maxTraceLength() + " samples can be stored.");
        }
        int seqNumber = 1 + this.fileHeader.getShort(3212);
        this.fileHeader.putShort(3220, (short)samples.length);
        this.traceHeader.putShort(114, (short)samples.length);
        this.fileHeader.putShort(3216, (short)(period.getSeconds() * 1000000.0));
        this.traceHeader.putShort(116, (short)(period.getSeconds() * 1000000.0));
        this.fileHeader.putShort(3212, (short)seqNumber);
        this.traceHeader.putInt(0, seqNumber);
        this.traceHeader.putInt(4, seqNumber);
        this.traceData = ByteBuffer.allocate(samples.length * 32 / 8);
        this.traceData.order(ByteOrder.BIG_ENDIAN);
        for (double value : samples) {
            this.traceData.putInt(SegyUtils.floatToIbmRealBits((float)value));
        }
    }

    private static class TraceHeader {
        public static final int SIZE = 240;
        public static final int TRACE_SEQUENCE_NUMBER_LINE = 0;
        public static final int TRACE_SEQUENCE_NUMBER_REEL = 4;
        public static final int FFID = 8;
        public static final int CHANNEL = 12;
        public static final int TRACE_ID = 28;
        public static final int SHOT_RECEIVER_DISTANCE = 36;
        public static final int RECEIVER_ELEVATION = 40;
        public static final int SHOT_ELEVATION = 44;
        public static final int ELEVATION_SCALAR = 68;
        public static final int COORDINATE_SCALAR = 70;
        public static final int SHOT_LONGITUDE = 72;
        public static final int SHOT_LATITUDE = 76;
        public static final int RECEIVER_LONGITUDE = 80;
        public static final int RECEIVER_LATITUDE = 84;
        public static final int COORDINATE_SYSTEM = 88;
        public static final int LAG_TIME_A = 104;
        public static final int RECORDING_DELAY = 108;
        public static final int SAMPLE_COUNT = 114;
        public static final int SAMPLE_PERIOD = 116;
        public static final int SHOTTIME_YEAR = 156;
        public static final int SHOTTIME_DOY = 158;
        public static final int SHOTTIME_HOUR = 160;
        public static final int SHOTTIME_MINUTE = 162;
        public static final int SHOTTIME_SECONDS = 164;
        public static final int TIME_BASE = 166;
        public static final int TIMING_SCALAR = 214;

        private TraceHeader() {
        }
    }

    private static class BinaryHeader {
        public static final int SIZE = 400;
        public static final int NUMBER_OF_DATA_TRACES = 3212;
        public static final int NUMBER_OF_AUX_TRACES = 3214;
        public static final int SAMPLE_PERIOD = 3216;
        public static final int NUMBER_OF_SAMPLES = 3220;
        public static final int DATA_SAMPLE_FORMAT = 3224;
        public static final int MEASUREMENT_SYSTEM = 3254;

        private BinaryHeader() {
        }
    }

    private static class TextHeader {
        public static final int NUMBER_OF_CARDS = 40;
        public static final int CARD_SIZE = 80;
        public static final int SIZE = 3200;

        private TextHeader() {
        }
    }
}

