/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.segy;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.geo.Ellipsoid;
import de.gfz_potsdam.gipp.common.geo.LatLonPoint;
import de.gfz_potsdam.gipp.common.geo.UtmPoint;
import de.gfz_potsdam.gipp.common.geo.projection.UniversalTransverseMercator;
import de.gfz_potsdam.gipp.common.seis.segy.SegyException;
import de.gfz_potsdam.gipp.common.seis.segy.SegyFile;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class SeismicUnix
implements SegyFile {
    private final ByteBuffer traceHeader;
    private ByteBuffer traceData;
    ByteOrder byteOrder;
    private final RandomAccessFile suFile;
    private final String suName;

    public SeismicUnix(File file, ByteOrder order) throws FileNotFoundException, IOException {
        this.suFile = new RandomAccessFile(file, "rwd");
        this.suName = file.getName();
        if (this.suFile.length() != 0L) {
            this.suFile.seek(this.suFile.length());
        }
        this.byteOrder = order;
        this.traceHeader = ByteBuffer.allocate(240);
        this.traceHeader.order(this.byteOrder);
        this.initTraceHeader();
        this.traceData = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.suFile != null) {
                this.suFile.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void closeFile() {
        FileUtils.flushClose(this.suFile);
    }

    @Override
    public void appendTraceToFile() throws IOException {
        this.suFile.seek(this.suFile.length());
        this.suFile.write(this.traceHeader.array(), 0, 240);
        this.suFile.write(this.traceData.array());
    }

    private void initTraceHeader() {
        this.traceHeader.putShort(28, (short)1);
        this.traceHeader.putShort(166, (short)4);
    }

    @Override
    public String getFileName() {
        if (this.suName != null) {
            return this.suName;
        }
        return "";
    }

    @Override
    public int maxTraceLength() {
        return 65535;
    }

    @Override
    public void setTraceFFID(int ffid) {
        this.traceHeader.putInt(8, ffid);
    }

    @Override
    public void setTraceChannel(int channel) {
        this.traceHeader.putInt(12, channel);
    }

    @Override
    public void setTraceTiming(TimeMoment triggerTime, TimeMoment recordingStart, TimeMoment firstSample) {
        assert (triggerTime != null) : "Argument 'triggerTime' must not be null!";
        assert (recordingStart != null) : "Argument 'recordingStart' must not be null!";
        assert (firstSample != null) : "Argument 'firstSample' must not be null!";
        this.traceHeader.putShort(156, (short)triggerTime.getYear());
        this.traceHeader.putShort(158, (short)triggerTime.getDayOfYear());
        this.traceHeader.putShort(160, (short)triggerTime.getHour());
        this.traceHeader.putShort(162, (short)triggerTime.getMinute());
        this.traceHeader.putShort(164, (short)triggerTime.getSecond());
        double msecDelay = triggerTime.before(recordingStart) ? Math.min(TimeSpan.diff(triggerTime, recordingStart).getSeconds() * 1000.0, 32767.0) : Math.max(-TimeSpan.diff(triggerTime, recordingStart).getSeconds() * 1000.0, -32768.0);
        double msecLagA = recordingStart.before(firstSample) ? Math.min(TimeSpan.diff(recordingStart, firstSample).getSeconds() * 1000.0, 32767.0) : Math.max(-TimeSpan.diff(recordingStart, firstSample).getSeconds() * 1000.0, -32768.0);
        if (msecDelay != 0.0 || msecLagA != 0.0) {
            this.traceHeader.putShort(104, (short)Math.round(msecLagA));
            this.traceHeader.putShort(108, (short)Math.round(msecDelay));
        }
    }

    @Override
    public void setTraceGeomety(LatLonPoint shotLatLon, double shotElevation, LatLonPoint receiverLatLon, double receiverElevation) {
        assert (shotLatLon != null) : "Argument 'shotLatLon' must not be null!";
        assert (receiverLatLon != null) : "Argument 'receiverLatLon' must not be null!";
        UniversalTransverseMercator map = new UniversalTransverseMercator(Ellipsoid.WGS84);
        this.traceHeader.putShort(88, (short)1);
        this.traceHeader.putShort(70, (short)1);
        this.traceHeader.putShort(68, (short)1);
        UtmPoint utm = map.project(shotLatLon);
        this.traceHeader.putFloat(72, (float)utm.getX());
        this.traceHeader.putFloat(76, (float)utm.getY());
        this.traceHeader.putInt(44, (int)Math.round(shotElevation));
        utm = map.project(receiverLatLon);
        this.traceHeader.putFloat(80, (float)utm.getX());
        this.traceHeader.putFloat(84, (float)utm.getY());
        this.traceHeader.putInt(40, (int)Math.round(receiverElevation));
        double dist = Math.abs(Ellipsoid.WGS84.distance(shotLatLon, receiverLatLon));
        if (dist >= 2.147483647E9) {
            this.traceHeader.putInt(36, Integer.MAX_VALUE);
        } else {
            this.traceHeader.putInt(36, (int)Math.round(dist));
        }
    }

    @Override
    public void setTraceOptional(List<Float> optional) {
        int bytesPerFloat = 4;
        for (int index = 0; index < optional.size(); ++index) {
            int offset = 240 - (index + 1) * 4;
            this.traceHeader.putFloat(offset, optional.get(index).floatValue());
        }
    }

    @Override
    public void setTraceData(double[] samples, TimeSpan period) {
        assert (samples != null) : "Argument 'samples' must not be null!";
        if (samples.length > this.maxTraceLength()) {
            throw new SegyException("The trace is to long (" + samples.length + "samples) for the SEG-Y format! At most " + this.maxTraceLength() + " samples can be stored.");
        }
        int sampleSize = 4;
        int count = 0;
        try {
            count = (int)(this.suFile.length() / (long)(240 + samples.length * 4));
        }
        catch (IOException e) {
            throw new SegyException("");
        }
        this.traceHeader.putShort(114, (short)(samples.length & 0xFFFF));
        this.traceHeader.putShort(116, (short)(period.getSeconds() * 1000000.0));
        this.traceHeader.putInt(0, count + 1);
        this.traceHeader.putInt(4, count + 1);
        this.traceData = ByteBuffer.allocate(samples.length * 4);
        this.traceData.order(this.byteOrder);
        for (double value : samples) {
            this.traceData.putFloat((float)value);
        }
    }

    private static class TraceHeader {
        public static final int SIZE = 240;
        public static final int TRACE_SEQUENCE_NUMBER_LINE = 0;
        public static final int TRACE_SEQUENCE_NUMBER_REEL = 4;
        public static final int FFID = 8;
        public static final int CHANNEL = 12;
        public static final int TRACE_ID = 28;
        public static final int SHOT_RECEIVER_DISTANCE = 36;
        public static final int RECEIVER_ELEVATION = 40;
        public static final int SHOT_ELEVATION = 44;
        public static final int ELEVATION_SCALAR = 68;
        public static final int COORDINATE_SCALAR = 70;
        public static final int SHOT_LONGITUDE = 72;
        public static final int SHOT_LATITUDE = 76;
        public static final int RECEIVER_LONGITUDE = 80;
        public static final int RECEIVER_LATITUDE = 84;
        public static final int COORDINATE_SYSTEM = 88;
        public static final int LAG_TIME_A = 104;
        public static final int RECORDING_DELAY = 108;
        public static final int SAMPLE_COUNT = 114;
        public static final int SAMPLE_PERIOD = 116;
        public static final int SHOTTIME_YEAR = 156;
        public static final int SHOTTIME_DOY = 158;
        public static final int SHOTTIME_HOUR = 160;
        public static final int SHOTTIME_MINUTE = 162;
        public static final int SHOTTIME_SECONDS = 164;
        public static final int TIME_BASE = 166;

        private TraceHeader() {
        }
    }
}

