/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.segy;

import de.gfz_potsdam.gipp.common.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class SegyUtils {
    public static byte[] textToCard(int number, String text) {
        int CARD_SIZE = 80;
        String ebcdic = "Cp1047";
        byte[] card = null;
        String line = "C" + StringUtils.TWO_DIGITS.format(number) + " " + text + "                                                                                ";
        try {
            card = Charset.isSupported("Cp1047") ? line.substring(0, 80).getBytes("Cp1047") : line.substring(0, 80).getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return card;
    }

    public static int toSegyDMS(double value) {
        double fraction = Math.abs(value);
        int degree = (int)fraction;
        fraction = (fraction - (double)degree) * 60.0;
        int minute = (int)fraction;
        fraction = (fraction - (double)minute) * 60.0;
        int seconds = (int)fraction;
        fraction = (fraction - (double)seconds) * 100.0;
        int result = degree * 1000000 + minute * 10000 + seconds * 100 + (int)fraction;
        if (value >= 0.0) {
            return result;
        }
        return -result;
    }

    public static int floatToIbmRealBits(float ieeeFloat) {
        int ibmFloat;
        if (ieeeFloat != 0.0f) {
            int sign = (double)ieeeFloat < 0.0 ? 1 : 0;
            float ieeeAbsolut = Math.abs(ieeeFloat);
            int exponent = (int)Math.ceil(Math.log(ieeeAbsolut) / Math.log(16.0) + 1.0E-6);
            if (Math.abs(exponent) < 64) {
                double temp = (double)ieeeAbsolut / Math.pow(16.0, exponent);
                int fraction = (int)Math.floor(temp * 1.6777216E7);
                ibmFloat = fraction | exponent + 64 << 24 | sign << 31;
            } else {
                ibmFloat = 0;
            }
        } else {
            ibmFloat = 0;
        }
        return ibmFloat;
    }

    public static float ibmRealBitsToFloat(int ibmFloat) {
        boolean sign = (ibmFloat & Integer.MIN_VALUE) != 0;
        int exponent = ((ibmFloat & 0x7F000000) >> 24) - 64;
        int fraction = ibmFloat & 0xFFFFFF;
        if (sign) {
            return (float)((double)(-fraction) / 1.6777216E7 * Math.pow(16.0, exponent));
        }
        return (float)((double)fraction / 1.6777216E7 * Math.pow(16.0, exponent));
    }
}

