/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.resample;

import de.gfz_potsdam.gipp.common.math.Function;
import de.gfz_potsdam.gipp.common.seis.EquallySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.Sample;
import de.gfz_potsdam.gipp.common.seis.TimeSeries;
import de.gfz_potsdam.gipp.common.seis.UnevenlySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.resample.ResampleAlgorithm;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class SincResampler
implements ResampleAlgorithm {
    private static final int DEFAULT_TABLE_SIZE = 1024;
    private final double[] lookUpTable;
    private List<Sample> inBuffer;
    private EquallySpacedTimeSeries outBuffer;
    private final boolean includeTransient;
    private final TimeSpan samplePeriod;
    private final int windowLength;
    private TimeMoment startTime;
    private boolean endOfTimeSeries;

    public SincResampler(TimeSpan samplePeriod, int filterLength) {
        this(samplePeriod, filterLength, false, 1024 * filterLength);
    }

    public SincResampler(TimeSpan samplePeriod, int filterLength, boolean includeTransient) {
        this(samplePeriod, filterLength, includeTransient, 1024 * filterLength);
    }

    public SincResampler(TimeSpan samplePeriod, int filterLength, boolean includeTransient, int tableSize) {
        if (samplePeriod == null) {
            throw new NullPointerException("Initialization of '" + SincResampler.class.getSimpleName() + "' with a 'null' argument.");
        }
        if (samplePeriod.isZeroLength()) {
            throw new IllegalArgumentException("Initialization of '" + SincResampler.class.getSimpleName() + "' with a target sample period of zero.");
        }
        if (filterLength <= 0) {
            throw new IllegalArgumentException("Initialization of '" + SincResampler.class.getSimpleName() + "' with a negative or zero window length.");
        }
        if (tableSize < 0) {
            throw new IllegalArgumentException("Initialization of '" + SincResampler.class.getSimpleName() + "' with a negative lookup table size.");
        }
        this.samplePeriod = samplePeriod;
        this.windowLength = filterLength;
        this.includeTransient = includeTransient;
        this.endOfTimeSeries = false;
        this.startTime = null;
        this.inBuffer = null;
        this.outBuffer = null;
        this.lookUpTable = new double[tableSize];
        this.prepareTable(samplePeriod, filterLength);
        this.reset();
    }

    protected void prepareTable(TimeSpan T, int N) {
        assert (this.lookUpTable != null) : "Uninitialized lookup table!";
        for (int i = 0; i < this.lookUpTable.length; ++i) {
            double deltaT = (double)i * T.getSeconds() * (double)N / (double)this.lookUpTable.length;
            double window = Function.blackmannNuttallWindow(deltaT, this.samplePeriod.getSeconds(), this.windowLength);
            double sinc = Function.sinc(deltaT, this.samplePeriod.getSeconds());
            this.lookUpTable[i] = window * sinc;
        }
    }

    protected double lookupValue(double t, double T, double N) {
        double i = (double)this.lookUpTable.length * Math.abs(t) / (N * T);
        double i1 = Math.floor(i);
        if (i1 >= (double)(this.lookUpTable.length - 1)) {
            return 0.0;
        }
        double y1 = this.lookUpTable[(int)i1];
        double y2 = this.lookUpTable[(int)i1 + 1];
        double w = i - i1;
        double y = y1 * (1.0 - w) + y2 * w;
        return y;
    }

    @Override
    public void reset() {
        this.inBuffer = null;
        this.outBuffer = null;
        this.startTime = null;
        this.endOfTimeSeries = false;
    }

    public String toString() {
        return "windowed 'sinc' interpolation (sample period = " + this.samplePeriod + ", normalized Blackmann-Nuttall window of length = " + this.windowLength + ")";
    }

    @Override
    public boolean isReady() {
        return this.inBuffer != null && this.inBuffer.size() > 0 || this.outBuffer != null && this.outBuffer.getNumberOfSamples() > 0 || !this.endOfTimeSeries;
    }

    @Override
    public void appendSamples(TimeSeries timeSeries) {
        if (timeSeries == null || timeSeries.getNumberOfSamples() == 0) {
            this.endOfTimeSeries = true;
        } else {
            if (this.inBuffer == null) {
                this.inBuffer = new ArrayList<Sample>(timeSeries.getNumberOfSamples());
            }
            for (int i = 0; i < timeSeries.getNumberOfSamples(); ++i) {
                this.inBuffer.add(timeSeries.getSampleAtIndex(i));
            }
        }
    }

    public void appendSamples(UnevenlySpacedTimeSeries timeSeries) {
        if (timeSeries == null || timeSeries.getNumberOfSamples() == 0) {
            this.endOfTimeSeries = true;
        } else if (this.inBuffer == null) {
            this.inBuffer = new ArrayList<Sample>(timeSeries.getAllSamples());
        } else {
            this.inBuffer.addAll(timeSeries.getAllSamples());
        }
    }

    @Override
    public EquallySpacedTimeSeries getProcessedSamples() {
        EquallySpacedTimeSeries result = this.outBuffer;
        this.outBuffer = null;
        return result;
    }

    @Override
    public void process() {
        if (this.inBuffer == null || this.inBuffer.isEmpty()) {
            return;
        }
        if (this.startTime == null) {
            BigDecimal firstSampleCount = this.includeTransient ? new BigDecimal(this.inBuffer.get(0).getTime().getBigCount()) : new BigDecimal(TimeSpan.add(this.inBuffer.get(0).getTime(), this.samplePeriod.multiply(this.windowLength)).getBigCount());
            BigDecimal samplePeriodCount = new BigDecimal(this.samplePeriod.getBigCount());
            BigInteger startSampleCount = firstSampleCount.divide(samplePeriodCount, RoundingMode.CEILING).multiply(samplePeriodCount).toBigIntegerExact();
            this.startTime = new TimeMoment(startSampleCount);
        }
        TimeMoment stopTime = this.inBuffer.get(this.inBuffer.size() - 1).getTime();
        if (!this.endOfTimeSeries || !this.includeTransient) {
            stopTime = TimeSpan.subtract(stopTime, this.samplePeriod.multiply(this.windowLength));
        }
        int indexStart = 0;
        int indexStop = 0;
        if (this.startTime.beforeOrAt(stopTime)) {
            TimeMoment timeJ;
            int count = (int)Math.floor(TimeSpan.diff(stopTime, this.startTime).divide(this.samplePeriod)) + 1;
            double[][] y = new double[this.inBuffer.get(0).getNumberOfChannels()][count];
            double period = this.samplePeriod.getSeconds();
            for (int j = 0; j < count && !(timeJ = TimeSpan.add(this.startTime, this.samplePeriod.multiply(j))).after(stopTime); ++j) {
                TimeMoment time;
                TimeMoment windowStart = TimeSpan.subtract(timeJ, this.samplePeriod.multiply(this.windowLength));
                TimeMoment windowStop = TimeSpan.add(timeJ, this.samplePeriod.multiply(this.windowLength));
                int i = indexStart;
                while (i < this.inBuffer.size() && !(time = this.inBuffer.get(i).getTime()).after(windowStart)) {
                    indexStart = i++;
                }
                i = indexStop;
                while (i < this.inBuffer.size() && !windowStop.before(time = this.inBuffer.get(i).getTime())) {
                    indexStop = i++;
                }
                for (int channel = 0; channel < this.inBuffer.get(0).getNumberOfChannels(); ++channel) {
                    for (int i2 = indexStart; i2 <= indexStop; ++i2) {
                        TimeMoment sampleTime = this.inBuffer.get(i2).getTime();
                        double sampleValue = this.inBuffer.get(i2).getValue(channel);
                        double deltaT = sampleTime.before(timeJ) ? -1.0 * TimeSpan.diffAsDoubleValue(sampleTime, timeJ) : TimeSpan.diffAsDoubleValue(sampleTime, timeJ);
                        if (this.lookUpTable.length > 0) {
                            double[] dArray = y[channel];
                            int n = j;
                            dArray[n] = dArray[n] + sampleValue * this.lookupValue(deltaT, period, this.windowLength);
                            continue;
                        }
                        double window = Function.blackmannNuttallWindow(deltaT, period, this.windowLength);
                        double sinc = Function.sinc(deltaT, period);
                        double[] dArray = y[channel];
                        int n = j;
                        dArray[n] = dArray[n] + sampleValue * window * sinc;
                    }
                }
            }
            EquallySpacedTimeSeries result = new EquallySpacedTimeSeries(this.startTime, this.samplePeriod, y);
            this.outBuffer = EquallySpacedTimeSeries.concatenate(this.outBuffer, result);
            this.startTime = TimeSpan.add(this.outBuffer.getStopTime(), this.samplePeriod);
        }
        if (this.endOfTimeSeries) {
            this.inBuffer.clear();
        } else {
            this.inBuffer.subList(0, indexStart).clear();
        }
    }
}

