/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.resample;

import de.gfz_potsdam.gipp.common.seis.EquallySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.Sample;
import de.gfz_potsdam.gipp.common.seis.TimeSeries;
import de.gfz_potsdam.gipp.common.seis.UnevenlySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.resample.ResampleAlgorithm;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class LinearResampler
implements ResampleAlgorithm {
    private List<Sample> inBuffer;
    private EquallySpacedTimeSeries outBuffer;
    private final TimeSpan samplePeriod;
    private TimeMoment startTime;
    private boolean endOfTimeSeries;

    public LinearResampler(TimeSpan samplePeriod) {
        if (samplePeriod == null) {
            throw new NullPointerException("Initialization of '" + LinearResampler.class.getSimpleName() + "' with a 'null' argument.");
        }
        if (samplePeriod.isZeroLength()) {
            throw new IllegalArgumentException("Initialization  of '" + LinearResampler.class.getSimpleName() + "' with a target sample period of zero.");
        }
        this.samplePeriod = samplePeriod;
        this.inBuffer = null;
        this.outBuffer = null;
        this.startTime = null;
        this.endOfTimeSeries = false;
        this.reset();
    }

    @Override
    public void reset() {
        this.inBuffer = null;
        this.outBuffer = null;
        this.startTime = null;
        this.endOfTimeSeries = false;
    }

    public String toString() {
        return "linear interpolation (sample period = " + this.samplePeriod + ")";
    }

    @Override
    public boolean isReady() {
        return this.inBuffer != null && this.inBuffer.size() > 0 || this.outBuffer != null && this.outBuffer.getNumberOfSamples() > 0 || !this.endOfTimeSeries;
    }

    @Override
    public void appendSamples(TimeSeries timeSeries) {
        if (timeSeries == null || timeSeries.getNumberOfSamples() == 0) {
            this.endOfTimeSeries = true;
        } else {
            if (this.inBuffer == null) {
                this.inBuffer = new ArrayList<Sample>(timeSeries.getNumberOfSamples());
            }
            for (int i = 0; i < timeSeries.getNumberOfSamples(); ++i) {
                this.inBuffer.add(timeSeries.getSampleAtIndex(i));
            }
        }
    }

    public void appendSamples(UnevenlySpacedTimeSeries timeSeries) {
        if (timeSeries == null || timeSeries.getNumberOfSamples() == 0) {
            this.endOfTimeSeries = true;
        } else if (this.inBuffer == null) {
            this.inBuffer = new ArrayList<Sample>(timeSeries.getAllSamples());
        } else {
            this.inBuffer.addAll(timeSeries.getAllSamples());
        }
    }

    @Override
    public EquallySpacedTimeSeries getProcessedSamples() {
        EquallySpacedTimeSeries result = this.outBuffer;
        this.outBuffer = null;
        return result;
    }

    @Override
    public void process() {
        if (this.inBuffer == null || this.inBuffer.isEmpty()) {
            return;
        }
        if (this.startTime == null) {
            BigDecimal sampleCount = new BigDecimal(this.inBuffer.get(0).getTime().getBigCount());
            BigDecimal periodCount = new BigDecimal(this.samplePeriod.getBigCount());
            BigInteger startCount = sampleCount.divide(periodCount, RoundingMode.CEILING).multiply(periodCount).toBigIntegerExact();
            this.startTime = new TimeMoment(startCount);
        }
        TimeMoment stopTime = this.inBuffer.get(this.inBuffer.size() - 1).getTime();
        int index = 0;
        if (this.startTime.beforeOrAt(stopTime)) {
            int count = (int)Math.floor(TimeSpan.diff(stopTime, this.startTime).divide(this.samplePeriod)) + 1;
            double[][] y = new double[this.inBuffer.get(0).getNumberOfChannels()][count];
            for (int j = 0; j < count; ++j) {
                int channel;
                TimeMoment time;
                TimeMoment timeJ = TimeSpan.add(this.startTime, this.samplePeriod.multiply(j));
                assert (stopTime.afterOrAt(timeJ)) : "Must not interpolate past the last input sample";
                int i = index;
                while (i < this.inBuffer.size() && !(time = this.inBuffer.get(i).getTime()).after(timeJ)) {
                    index = i++;
                }
                if (timeJ.equals(this.inBuffer.get(index).getTime())) {
                    for (channel = 0; channel < this.inBuffer.get(0).getNumberOfChannels(); ++channel) {
                        y[channel][j] = this.inBuffer.get(index).getValue(channel);
                    }
                    continue;
                }
                for (channel = 0; channel < this.inBuffer.get(0).getNumberOfChannels(); ++channel) {
                    y[channel][j] = this.inBuffer.get(index).getValue(channel) + (this.inBuffer.get(index + 1).getValue(channel) - this.inBuffer.get(index).getValue(channel)) * TimeSpan.divide(TimeSpan.diff(timeJ, this.inBuffer.get(index).getTime()), TimeSpan.diff(this.inBuffer.get(index + 1).getTime(), this.inBuffer.get(index).getTime()));
                }
            }
            this.outBuffer = EquallySpacedTimeSeries.concatenate(this.outBuffer, new EquallySpacedTimeSeries(this.startTime, this.samplePeriod, y));
            this.startTime = TimeSpan.add(this.outBuffer.getStopTime(), this.samplePeriod);
        }
        if (this.endOfTimeSeries) {
            this.inBuffer.clear();
        } else {
            this.inBuffer.subList(0, index).clear();
        }
    }
}

