/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.resample;

import de.gfz_potsdam.gipp.common.seis.EquallySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.Sample;
import de.gfz_potsdam.gipp.common.seis.TimeSeries;
import de.gfz_potsdam.gipp.common.seis.UnevenlySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.resample.ResampleAlgorithm;
import de.gfz_potsdam.gipp.common.seis.resample.SincResampler;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.util.ArrayList;
import java.util.List;

public class FixedClockResampler
implements ResampleAlgorithm {
    private List<Sample> inBuffer = null;
    private EquallySpacedTimeSeries outBuffer = null;
    private boolean endOfTimeSeries = false;
    private final TimeSpan samplePeriod;
    private TimeMoment nextStartTime;

    public FixedClockResampler(TimeSpan period) {
        if (period == null) {
            throw new NullPointerException("Initialization of '" + SincResampler.class.getSimpleName() + "' with a 'null' argument.");
        }
        if (period.isZeroLength()) {
            throw new IllegalArgumentException("Initialization of '" + SincResampler.class.getSimpleName() + "' with a target sample period of zero.");
        }
        this.samplePeriod = period;
        this.nextStartTime = null;
        this.reset();
    }

    @Override
    public void reset() {
        this.inBuffer = null;
        this.outBuffer = null;
        this.endOfTimeSeries = false;
        this.nextStartTime = null;
    }

    public String toString() {
        StringBuilder info = new StringBuilder("fixed clock resampler");
        if (this.inBuffer != null) {
            info.append(", input buffer " + this.inBuffer.size() + " samples");
        }
        if (this.outBuffer != null) {
            info.append(", output buffer " + this.outBuffer.getNumberOfSamples() + " samples");
        }
        return info.toString();
    }

    @Override
    public boolean isReady() {
        return this.inBuffer != null && this.inBuffer.size() > 0 || this.outBuffer != null && this.outBuffer.getNumberOfSamples() > 0 || !this.endOfTimeSeries;
    }

    @Override
    public void appendSamples(TimeSeries timeSeries) {
        if (timeSeries == null || timeSeries.getNumberOfSamples() == 0) {
            this.endOfTimeSeries = true;
        } else {
            if (this.inBuffer == null) {
                this.inBuffer = new ArrayList<Sample>(timeSeries.getNumberOfSamples());
            }
            for (int i = 0; i < timeSeries.getNumberOfSamples(); ++i) {
                this.inBuffer.add(timeSeries.getSampleAtIndex(i));
            }
        }
    }

    public void appendSamples(UnevenlySpacedTimeSeries timeSeries) {
        if (timeSeries == null || timeSeries.getNumberOfSamples() == 0) {
            this.endOfTimeSeries = true;
        } else if (this.inBuffer == null) {
            this.inBuffer = new ArrayList<Sample>(timeSeries.getAllSamples());
        } else {
            this.inBuffer.addAll(timeSeries.getAllSamples());
        }
    }

    @Override
    public EquallySpacedTimeSeries getProcessedSamples() {
        EquallySpacedTimeSeries result = this.outBuffer;
        this.outBuffer = null;
        return result;
    }

    @Override
    public void process() {
        if (this.inBuffer == null || this.inBuffer.isEmpty()) {
            return;
        }
        if (this.nextStartTime == null) {
            this.nextStartTime = this.inBuffer.get(0).getTime();
        }
        int numberOfSamples = this.inBuffer.size();
        int numberOfChannels = this.inBuffer.get(0).getNumberOfChannels();
        double[][] values = new double[numberOfChannels][numberOfSamples];
        for (int i = 0; i < numberOfSamples; ++i) {
            for (int channel = 0; channel < numberOfChannels; ++channel) {
                values[channel][i] = this.inBuffer.get(i).getValue(channel);
            }
        }
        this.outBuffer = new EquallySpacedTimeSeries(this.nextStartTime, this.samplePeriod, values);
        this.nextStartTime = TimeSpan.add(this.outBuffer.getStopTime(), this.samplePeriod);
        this.inBuffer.clear();
    }
}

