/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.miniseed;

import de.gfz_potsdam.gipp.common.array.ArrayUtils;
import de.gfz_potsdam.gipp.common.seis.miniseed.EncodingFormat;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class Trace {
    private SortedSet<Record> mseedRecords;

    public Trace() {
        this.mseedRecords = new TreeSet<Record>();
    }

    public Trace(Record first) {
        this.mseedRecords = new TreeSet<Record>();
        this.add(first);
    }

    protected Trace(SortedSet<Record> records) {
        assert (records != null) : "The 'records' argument must not be null!";
        assert (Record.isContinuous(records) || records.isEmpty()) : "The 'records' set must be continuous (or empty)!";
        this.mseedRecords = records;
    }

    protected SortedSet<Record> getAllRecords() {
        assert (this.mseedRecords != null) : "The internal set of records must not be null!";
        return this.mseedRecords;
    }

    protected Record getFirstRecord() {
        assert (this.mseedRecords != null) : "The internal set of records must not be null!";
        if (this.getRecordCount() > 0) {
            return this.mseedRecords.first();
        }
        return null;
    }

    protected Record getLastRecord() {
        assert (this.mseedRecords != null) : "The internal set of records must not be null!";
        if (this.getRecordCount() > 0) {
            return this.mseedRecords.last();
        }
        return null;
    }

    public void clear() {
        this.mseedRecords.clear();
    }

    public String toString() {
        return "" + this.getSampleCount() + " samples (" + this.getStationId() + ", " + this.getChannelId() + ", " + this.getStartTime() + " to " + this.getStopTime() + ")";
    }

    public String getStationId() {
        if (this.mseedRecords.size() > 0) {
            return this.mseedRecords.first().getStationId();
        }
        return "";
    }

    public String getChannelId() {
        if (this.mseedRecords.size() > 0) {
            return this.mseedRecords.first().getChannelId();
        }
        return "";
    }

    public String getNetworkId() {
        if (this.mseedRecords.size() > 0) {
            return this.mseedRecords.first().getNetworkId();
        }
        return "";
    }

    public String getLocationId() {
        if (this.mseedRecords.size() > 0) {
            return this.mseedRecords.first().getLocationId();
        }
        return "";
    }

    public TimeMoment getStartTime() {
        if (this.mseedRecords.size() > 0) {
            return this.mseedRecords.first().getStartTime();
        }
        return null;
    }

    public TimeMoment getStopTime() {
        if (this.mseedRecords.size() > 0) {
            return this.mseedRecords.last().getStopTime();
        }
        return null;
    }

    public int getSampleCount() {
        int totalCount = 0;
        for (Record record : this.mseedRecords) {
            int recordCount = record.getSampleCount();
            if (recordCount > Integer.MAX_VALUE - totalCount) {
                throw new ArithmeticException("Integer overflow while calculating trace length.");
            }
            totalCount += recordCount;
        }
        return totalCount;
    }

    public int getRecordCount() {
        return this.mseedRecords.size();
    }

    public double getSamplePeriod() {
        if (this.mseedRecords.size() > 0) {
            return this.mseedRecords.first().getSamplePeriod();
        }
        return 0.0;
    }

    public boolean add(Trace other) {
        if (other == null) {
            return false;
        }
        if (other.getRecordCount() == 0) {
            return true;
        }
        if (this.mseedRecords.size() == 0 || Record.isContinuous(this.mseedRecords.last(), other.mseedRecords.first()) || Record.isContinuous(other.mseedRecords.last(), this.mseedRecords.first())) {
            for (Record record : other.mseedRecords) {
                this.mseedRecords.add(Record.duplicate(record));
            }
            return true;
        }
        return false;
    }

    public boolean add(Record record) {
        if (record == null) {
            return false;
        }
        if (record.getSampleCount() == 0) {
            return true;
        }
        if (this.getRecordCount() == 0 || Record.isContinuous(this.mseedRecords.last(), record) || Record.isContinuous(record, this.mseedRecords.first())) {
            this.mseedRecords.add(record);
            return true;
        }
        return false;
    }

    public int trim(TimeMoment start, TimeSpan length) {
        TimeMoment newStart = start == null ? this.getStartTime() : start;
        TimeMoment newStop = length == null ? TimeSpan.add(this.getStopTime(), TimeSpan.SECOND) : TimeSpan.add(newStart, length);
        TreeSet<Record> newTrace = new TreeSet<Record>();
        double prevSampleValue = 0.0;
        for (Record record : this.mseedRecords) {
            Record trimmed;
            if (record.getStopTime().before(newStart) || record.getStartTime().equals(newStop) || record.getStartTime().after(newStop)) continue;
            if ((record.getStartTime().after(newStart) || record.getStartTime().equals(newStart)) && record.getStopTime().before(newStop)) {
                prevSampleValue = record.lastSampleValue();
                newTrace.add(record);
                continue;
            }
            long first = record.getFirstIndexAfter(newStart, true);
            long last = record.getLastIndexBefore(newStop, false);
            if (first < 0L) {
                first = 0L;
            }
            if (last >= (long)record.getSampleCount()) {
                last = record.getSampleCount() - 1;
            }
            assert (first >= 0L && first <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'first': " + first;
            assert (last >= 0L && last <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'last' : " + last;
            double[] samples = record.getSampleData();
            for (long index = first; index <= last; index += (long)trimmed.getSampleCount()) {
                boolean isApplied;
                trimmed = Record.duplicate(record);
                trimmed.clearData();
                trimmed.putSampleData(samples, (int)index, (int)(last - index + 1L), prevSampleValue);
                int correction = record.buffer.getInt(Record.FixedHeader.TICK_CORRECTION.offset());
                boolean bl = isApplied = 2 == (record.buffer.get(Record.FixedHeader.ACTIVITY_FLAG.offset()) & 2);
                if (isApplied) {
                    trimmed.setStartTime(record.getTimeAt((int)index), correction, false);
                } else {
                    trimmed.setStartTime(record.getTimeAt((int)index).subtract(TimeSpan.TICK.multiply(correction)), correction, true);
                }
                prevSampleValue = trimmed.lastSampleValue();
                newTrace.add(trimmed);
            }
        }
        this.mseedRecords = newTrace;
        return this.getSampleCount();
    }

    public int trim(TimeSpan length, TimeMoment stop) {
        TimeMoment newStop = stop == null ? this.getStopTime() : stop;
        TimeMoment newStart = length == null ? new TimeMoment.Builder().build() : TimeSpan.subtract(newStop, length);
        TreeSet<Record> newTrace = new TreeSet<Record>();
        double prevSampleValue = 0.0;
        for (Record record : this.mseedRecords) {
            Record trimmed;
            if (record.getStopTime().before(newStart) || record.getStopTime().equals(newStart) || record.getStartTime().after(newStop)) continue;
            if (record.getStartTime().after(newStart) && (record.getStopTime().equals(newStop) || record.getStopTime().before(newStop))) {
                prevSampleValue = record.lastSampleValue();
                newTrace.add(record);
                continue;
            }
            long first = record.getFirstIndexAfter(newStart, false);
            long last = record.getLastIndexBefore(newStop, true);
            if (first < 0L) {
                first = 0L;
            }
            if (last >= (long)record.getSampleCount()) {
                last = record.getSampleCount() - 1;
            }
            assert (first >= 0L && first <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'first': " + first;
            assert (last >= 0L && last <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'last' : " + last;
            double[] samples = record.getSampleData();
            for (long index = first; index <= last; index += (long)trimmed.getSampleCount()) {
                boolean isApplied;
                trimmed = Record.duplicate(record);
                trimmed.clearData();
                trimmed.putSampleData(samples, (int)index, (int)(last - index + 1L), prevSampleValue);
                int correction = record.buffer.getInt(Record.FixedHeader.TICK_CORRECTION.offset());
                boolean bl = isApplied = 2 == (record.buffer.get(Record.FixedHeader.ACTIVITY_FLAG.offset()) & 2);
                if (isApplied) {
                    trimmed.setStartTime(record.getTimeAt((int)index), correction, false);
                } else {
                    trimmed.setStartTime(record.getTimeAt((int)index).subtract(TimeSpan.TICK.multiply(correction)), correction, true);
                }
                prevSampleValue = trimmed.lastSampleValue();
                newTrace.add(trimmed);
            }
        }
        this.mseedRecords = newTrace;
        return this.getSampleCount();
    }

    public int trim(TimeMoment start, TimeMoment stop) {
        TimeMoment newStart = start == null ? this.getStartTime() : start;
        TimeMoment newStop = stop == null ? this.getStopTime() : stop;
        TreeSet<Record> newTrace = new TreeSet<Record>();
        double prevSampleValue = 0.0;
        for (Record record : this.mseedRecords) {
            Record trimmed;
            if (record.getStopTime().before(newStart) || record.getStartTime().after(newStop)) continue;
            if ((record.getStartTime().equals(newStart) || record.getStartTime().after(newStart)) && (record.getStopTime().equals(newStop) || record.getStopTime().before(newStop))) {
                prevSampleValue = record.lastSampleValue();
                newTrace.add(record);
                continue;
            }
            long first = record.getFirstIndexAfter(newStart, true);
            long last = record.getLastIndexBefore(newStop, true);
            if (first < 0L) {
                first = 0L;
            }
            if (last >= (long)record.getSampleCount()) {
                last = record.getSampleCount() - 1;
            }
            assert (first >= 0L && first <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'first': " + first;
            assert (last >= 0L && last <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'last' : " + last;
            double[] samples = record.getSampleData();
            for (long index = first; index <= last; index += (long)trimmed.getSampleCount()) {
                boolean isApplied;
                trimmed = Record.duplicate(record);
                trimmed.clearData();
                trimmed.putSampleData(samples, (int)index, (int)(last - index + 1L), prevSampleValue);
                int correction = record.buffer.getInt(Record.FixedHeader.TICK_CORRECTION.offset());
                boolean bl = isApplied = 2 == (record.buffer.get(Record.FixedHeader.ACTIVITY_FLAG.offset()) & 2);
                if (isApplied) {
                    trimmed.setStartTime(record.getTimeAt((int)index), correction, false);
                } else {
                    trimmed.setStartTime(record.getTimeAt((int)index).subtract(TimeSpan.TICK.multiply(correction)), correction, true);
                }
                prevSampleValue = trimmed.lastSampleValue();
                newTrace.add(trimmed);
            }
        }
        this.mseedRecords = newTrace;
        return this.getSampleCount();
    }

    public int pad(TimeMoment start, TimeMoment stop) {
        if (this.getRecordCount() == 0) {
            throw new IllegalArgumentException("Will not pad an empty trace!");
        }
        double padValue = this.arithmeticMean();
        return this.pad(start, stop, padValue);
    }

    public int pad(TimeMoment start, TimeMoment stop, double value) {
        Record record;
        if (this.getRecordCount() == 0) {
            throw new IllegalArgumentException("Will not pad an empty trace!");
        }
        int padCount = 0;
        double[] padding = new double[5000];
        Arrays.fill(padding, value);
        TimeSpan period = new TimeSpan.Builder().addSeconds(this.getSamplePeriod()).build();
        while (this.getStartTime().after(start) && TimeSpan.diff(this.getStartTime(), start).moreThan(period)) {
            boolean isApplied;
            record = Record.duplicate(this.mseedRecords.first());
            long last = record.getLastIndexBefore(this.getStartTime(), false);
            long first = record.getFirstIndexAfter(start, true);
            record.clearData();
            record.putSampleData(padding, 0, (int)Math.min((long)padding.length, last - first + 1L), value);
            int correction = record.buffer.getInt(Record.FixedHeader.TICK_CORRECTION.offset());
            boolean bl = isApplied = 2 == (record.buffer.get(Record.FixedHeader.ACTIVITY_FLAG.offset()) & 2);
            if (isApplied) {
                record.setStartTime(record.getTimeAt(-record.getSampleCount()), correction, false);
            } else {
                record.setStartTime(record.getTimeAt(-record.getSampleCount()).subtract(TimeSpan.TICK.multiply(correction)), correction, true);
            }
            this.add(record);
            padCount += record.getSampleCount();
        }
        while (this.getStopTime().before(stop) && TimeSpan.diff(this.getStopTime(), stop).moreThan(period)) {
            boolean isApplied;
            record = Record.duplicate(this.mseedRecords.last());
            int first = record.getSampleCount();
            long last = record.getLastIndexBefore(stop, true);
            record.clearData();
            record.putSampleData(padding, 0, (int)Math.min((long)padding.length, last - (long)first + 1L), value);
            int correction = record.buffer.getInt(Record.FixedHeader.TICK_CORRECTION.offset());
            boolean bl = isApplied = 2 == (record.buffer.get(Record.FixedHeader.ACTIVITY_FLAG.offset()) & 2);
            if (isApplied) {
                record.setStartTime(record.getTimeAt(first), correction, false);
            } else {
                record.setStartTime(record.getTimeAt(first).subtract(TimeSpan.TICK.multiply(correction)), correction, true);
            }
            this.add(record);
            padCount += record.getSampleCount();
        }
        return padCount;
    }

    public double arithmeticMean() {
        double sum = 0.0;
        int count = this.getSampleCount();
        if (count == 0) {
            return 0.0;
        }
        for (Record record : this.mseedRecords) {
            for (double sample : record.getSampleData()) {
                sum += sample;
            }
        }
        return sum / (double)count;
    }

    public List<Trace> split(TimeSpan length) {
        if (length == null || length.isZeroLength() || this.getRecordCount() == 0) {
            return this.split((TimeMoment[])null);
        }
        return this.split(TimeMoment.EPOCH, length);
    }

    public List<Trace> split(TimeMoment anchor, TimeSpan length) {
        if (anchor == null || length == null || length.isZeroLength() || this.getRecordCount() == 0) {
            return this.split((TimeMoment[])null);
        }
        ArrayList<TimeMoment> splitTimes = new ArrayList<TimeMoment>();
        long n1 = Math.round(Math.floor(TimeSpan.diff(this.getStartTime(), anchor).divide(length) * (double)this.getStartTime().compareTo(anchor)));
        long n2 = Math.round(Math.ceil(TimeSpan.diff(this.getStopTime(), anchor).divide(length) * (double)this.getStopTime().compareTo(anchor)));
        for (long i = n1; i <= n2; ++i) {
            if (i < 0L) {
                splitTimes.add(TimeSpan.subtract(anchor, TimeSpan.multiply(length, Math.abs(i))));
                continue;
            }
            splitTimes.add(TimeSpan.add(anchor, TimeSpan.multiply(length, i)));
        }
        return this.split(splitTimes.toArray(new TimeMoment[(int)(n2 - n1)]));
    }

    public List<Trace> split(TimeMoment ... splitTimes) {
        ArrayList<Trace> traceSegments = new ArrayList<Trace>();
        TreeSet<TimeMoment> segmentBoundaries = new TreeSet<TimeMoment>();
        if (splitTimes == null || splitTimes.length == 0 || this.getRecordCount() == 0) {
            traceSegments.add(this);
            return traceSegments;
        }
        for (TimeMoment time : splitTimes) {
            if (time == null) continue;
            segmentBoundaries.add(time);
        }
        if (segmentBoundaries.isEmpty() || ((TimeMoment)segmentBoundaries.first()).after(this.getStopTime()) || ((TimeMoment)segmentBoundaries.last()).before(this.getStartTime()) || ((TimeMoment)segmentBoundaries.last()).equals(this.getStartTime())) {
            traceSegments.add(this);
            return traceSegments;
        }
        if (((TimeMoment)segmentBoundaries.last()).before(this.getStopTime()) || ((TimeMoment)segmentBoundaries.last()).equals(this.getStopTime())) {
            segmentBoundaries.add(TimeSpan.add(this.getStopTime(), new TimeSpan.Builder().addNanoSeconds(1L).build()));
        }
        TimeMoment currentStart = this.getStartTime();
        double previousSample = 0.0;
        for (TimeMoment nextStart : segmentBoundaries) {
            if (nextStart == null) {
                throw new IllegalArgumentException("Cannot split trace at time 'null'!");
            }
            if (this.getStopTime().before(currentStart) || nextStart.before(this.getStartTime())) continue;
            if ((this.getStartTime().equals(currentStart) || this.getStartTime().after(currentStart)) && this.getStopTime().before(nextStart)) {
                traceSegments.add(this);
                return traceSegments;
            }
            Trace trace = new Trace();
            for (Record record : this.mseedRecords) {
                if (record.getStopTime().before(currentStart) || record.getStartTime().after(nextStart) || record.getStartTime().equals(nextStart)) continue;
                if ((record.getStartTime().equals(currentStart) || record.getStartTime().after(currentStart)) && record.getStopTime().before(nextStart)) {
                    previousSample = record.lastSampleValue();
                    trace.add(record);
                    continue;
                }
                long first = record.getFirstIndexAfter(currentStart, true);
                long last = record.getLastIndexBefore(nextStart, false);
                if (first < 0L) {
                    first = 0L;
                }
                if (last >= (long)record.getSampleCount()) {
                    last = record.getSampleCount() - 1;
                }
                assert (first >= 0L && first <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'first': " + first;
                assert (last >= 0L && last <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'last' : " + last;
                double[] samples = record.getSampleData();
                int copyStart = (int)first;
                while ((long)copyStart <= last) {
                    boolean isApplied;
                    Record snippet = Record.duplicate(record);
                    snippet.clearData();
                    int copyLength = snippet.putSampleData(samples, copyStart, (int)(last - (long)copyStart + 1L), previousSample);
                    int correction = record.buffer.getInt(Record.FixedHeader.TICK_CORRECTION.offset());
                    boolean bl = isApplied = 2 == (record.buffer.get(Record.FixedHeader.ACTIVITY_FLAG.offset()) & 2);
                    if (isApplied) {
                        snippet.setStartTime(record.getTimeAt(copyStart), correction, false);
                    } else {
                        snippet.setStartTime(record.getTimeAt(copyStart).subtract(TimeSpan.TICK.multiply(correction)), correction, true);
                    }
                    previousSample = snippet.lastSampleValue();
                    trace.add(snippet);
                    copyStart += copyLength;
                }
            }
            if (trace.getRecordCount() > 0) {
                traceSegments.add(trace);
            }
            currentStart = nextStart;
        }
        return traceSegments;
    }

    public void write(OutputStream outStream) throws IntegrityException, IOException {
        for (Record record : this.mseedRecords) {
            record.write(outStream);
        }
    }

    public Trace recode(int size, ByteOrder order, EncodingFormat codec, Boolean use1001) {
        Trace recodedTrace = new Trace();
        if (this.mseedRecords.isEmpty()) {
            return recodedTrace;
        }
        int seqenceNumber = this.mseedRecords.first().getSequenceNumber();
        int newSize = size <= 0 ? this.mseedRecords.first().size() : size;
        ByteOrder newOrder = order == null ? this.mseedRecords.first().getByteOrder() : order;
        EncodingFormat newCodec = codec == null ? this.mseedRecords.first().getCodec() : codec;
        boolean newUse1001 = use1001 == null ? this.mseedRecords.first().hasBlockette(1001) : use1001.booleanValue();
        double[] samples = this.sampleArray();
        int index = 0;
        double bias = 0.0;
        while (index < samples.length) {
            if (seqenceNumber <= 0 || seqenceNumber >= 1000000) {
                seqenceNumber = 1;
            }
            Record record = new Record(newSize, newOrder, newCodec, newUse1001);
            record.setSequenceNumber(seqenceNumber++);
            record.setStationId(this.getStationId());
            record.setLocationId(this.getLocationId());
            record.setChannelId(this.getChannelId());
            record.setNetworkId(this.getNetworkId());
            record.setSamplePeriod(this.getSamplePeriod());
            record.setStartTime(this.mseedRecords.first().getTimeAt(index));
            record.putSampleData(samples, index, bias);
            bias = samples[(index += record.getSampleCount()) - 1];
            recodedTrace.add(record);
        }
        return recodedTrace;
    }

    public double[] sampleArray() {
        double[] result = new double[this.getSampleCount()];
        int count = 0;
        for (Record record : this.mseedRecords) {
            record.getSampleData(result, count, 0, record.getSampleCount());
            count += record.getSampleCount();
        }
        return result;
    }

    public double[] sampleArray(TimeMoment windowStart, int traceLength) throws IntegrityException {
        assert (traceLength >= 0) : "Cannot obtain a negative number of values.";
        if (this.mseedRecords.isEmpty()) {
            throw new IntegrityException("The trace contains no data.");
        }
        if (windowStart.after(this.getStopTime())) {
            throw new IntegrityException("The requested time window is after the trace end.");
        }
        double[] result = null;
        int remaining = traceLength;
        for (Record record : this.mseedRecords) {
            if (record.getStopTime().before(windowStart)) continue;
            long start = Math.max(0L, record.getFirstIndexAfter(windowStart, true));
            long length = Math.min((long)record.getSampleCount() - start, (long)remaining);
            assert (start >= 0L && start <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'start': " + start;
            assert (length >= 0L && length <= (long)record.getSampleCount()) : "Invalid value for 'length' : " + length;
            result = ArrayUtils.concatArrays(result, ArrayUtils.copySubArray(record.getSampleData(), (int)start, (int)length));
            remaining = traceLength - result.length;
            if (result.length < traceLength) continue;
            if (result.length == traceLength) {
                return result;
            }
            throw new IntegrityException("Decoded more data from the miniSEED trace than requested!");
        }
        throw new IntegrityException("Could not extract enough data from the miniSEED trace!");
    }

    public double[] sampleArray(TimeMoment start, TimeMoment stop) throws IllegalArgumentException {
        TimeMoment windowStart;
        double[] result = null;
        if (this.mseedRecords.size() == 0) {
            return null;
        }
        TimeMoment windowStop = stop == null ? this.getStopTime() : stop;
        if (windowStop.before(windowStart = start == null ? this.getStartTime() : start)) {
            throw new IllegalArgumentException("The start time (" + windowStart + ") must be before the stop time (" + windowStop + ").");
        }
        if (windowStart.before(this.getStartTime()) || windowStop.after(this.getStopTime())) {
            throw new IntegrityException("Requested time window extends beyond the miniSEED trace.");
        }
        for (Record record : this.mseedRecords) {
            long startIndex;
            if (record.getStopTime().before(windowStart)) continue;
            if (record.getStartTime().after(windowStop)) break;
            if (record.getStartTime().before(windowStart) && (record.getStopTime().equals(windowStart) || record.getStopTime().after(windowStart))) {
                startIndex = record.getFirstIndexAfter(windowStart, true);
                assert (startIndex >= 0L && startIndex <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'startIndex': " + startIndex;
                result = ArrayUtils.concatArrays(result, ArrayUtils.copySubArray(record.getSampleData(), (int)startIndex, record.getSampleCount() - (int)startIndex));
                continue;
            }
            if ((record.getStartTime().after(windowStart) || record.getStartTime().equals(windowStart)) && (record.getStopTime().before(windowStop) || record.getStopTime().equals(windowStop))) {
                result = ArrayUtils.concatArrays(result, record.getSampleData());
                continue;
            }
            if ((record.getStartTime().before(windowStop) || record.getStartTime().equals(windowStop)) && record.getStopTime().after(windowStop)) {
                long stopIndex = record.getLastIndexBefore(windowStop, true);
                assert (stopIndex >= 0L && stopIndex <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'stopIndex': " + stopIndex;
                result = ArrayUtils.concatArrays(result, ArrayUtils.copySubArray(record.getSampleData(), 0, (int)stopIndex));
                continue;
            }
            if ((record.getStartTime().before(windowStart) || record.getStartTime().equals(windowStart)) && (record.getStopTime().equals(windowStop) || record.getStopTime().after(windowStop))) {
                startIndex = record.getFirstIndexAfter(windowStart, true);
                long stopIndex = record.getLastIndexBefore(windowStop, true);
                assert (startIndex >= 0L && startIndex <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'startIndex': " + startIndex;
                assert (stopIndex >= 0L && stopIndex <= (long)(record.getSampleCount() - 1)) : "Invalid value for 'stopIndex': " + stopIndex;
                result = ArrayUtils.concatArrays(result, ArrayUtils.copySubArray(record.getSampleData(), (int)startIndex, (int)(stopIndex - startIndex)));
                continue;
            }
            throw new AssertionError((Object)"Unhandled position of 'record' relative to 'trace'.");
        }
        return result;
    }
}

