/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.miniseed;

import de.gfz_potsdam.gipp.common.seis.miniseed.ArithmeticOverflowException;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.MiniseedCodec;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class SteimTwoCodec
implements MiniseedCodec {
    private static final int FRAMESIZE = 64;
    private static final int WORDSIZE = 4;
    private static final Logger log = Logger.getLogger(SteimTwoCodec.class.getName());

    @Override
    public int decodeSamples(ByteBuffer src, int srcPos, double[] dest, int destPos, int length) throws IntegrityException, ArrayIndexOutOfBoundsException {
        if (length < 0) {
            throw new IllegalArgumentException("Cannot decode " + length + " samples.");
        }
        if (length == 0) {
            return 0;
        }
        int count = 0;
        double lastValue = 0.0;
        src.position(srcPos);
        boolean ignoreDiff = true;
        if (src.remaining() % 64 != 0) {
            throw new IntegrityException("Illegal data area size (" + src.remaining() + " bytes). Must be multiple of " + 64 + " bytes!");
        }
        block20: while (src.remaining() >= 64) {
            int nibble = src.getInt();
            block21: for (int index = 0; index < 15; ++index) {
                int code = nibble >> 28 - (index << 1) & 3;
                switch (code) {
                    case 0: {
                        switch (count) {
                            case 0: {
                                dest[destPos] = src.getInt();
                                count = 1;
                                break;
                            }
                            case 1: {
                                lastValue = src.getInt();
                                if (length != 1) continue block21;
                                break block20;
                            }
                            default: {
                                src.getInt();
                                break;
                            }
                        }
                        continue block21;
                    }
                    case 1: {
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.get();
                        if (ignoreDiff) {
                            ignoreDiff = false;
                        } else {
                            ++count;
                        }
                        if (count == length) break block20;
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.get();
                        if (++count == length) break block20;
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.get();
                        if (++count == length) break block20;
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.get();
                        if (++count != length) continue block21;
                        break block20;
                    }
                    case 2: {
                        int word = src.getInt();
                        int dnib = word >> 30 & 3;
                        switch (dnib) {
                            case 1: {
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 2 >> 2);
                                if (ignoreDiff) {
                                    ignoreDiff = false;
                                } else {
                                    ++count;
                                }
                                if (count != length) continue block21;
                                break block20;
                            }
                            case 2: {
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 2 >> 17);
                                if (ignoreDiff) {
                                    ignoreDiff = false;
                                } else {
                                    ++count;
                                }
                                if (count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 17 >> 17);
                                if (++count != length) continue block21;
                                break block20;
                            }
                            case 3: {
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 2 >> 22);
                                if (ignoreDiff) {
                                    ignoreDiff = false;
                                } else {
                                    ++count;
                                }
                                if (count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 12 >> 22);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 22 >> 22);
                                if (++count != length) continue block21;
                                break block20;
                            }
                            default: {
                                throw new IntegrityException("Illegal 'decode nibble' flag ('" + dnib + "'). Valid values are '1', '2' or '3' when the 'nibble' flag is set to " + nibble + ".");
                            }
                        }
                    }
                    case 3: {
                        int word = src.getInt();
                        int dnib = word >> 30 & 3;
                        switch (dnib) {
                            case 0: {
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 2 >> 26);
                                if (ignoreDiff) {
                                    ignoreDiff = false;
                                } else {
                                    ++count;
                                }
                                if (count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 8 >> 26);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 14 >> 26);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 20 >> 26);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 26 >> 26);
                                if (++count != length) continue block21;
                                break block20;
                            }
                            case 1: {
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 2 >> 27);
                                if (ignoreDiff) {
                                    ignoreDiff = false;
                                } else {
                                    ++count;
                                }
                                if (count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 7 >> 27);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 12 >> 27);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 17 >> 27);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 22 >> 27);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 27 >> 27);
                                if (++count != length) continue block21;
                                break block20;
                            }
                            case 2: {
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 4 >> 28);
                                if (ignoreDiff) {
                                    ignoreDiff = false;
                                } else {
                                    ++count;
                                }
                                if (count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 8 >> 28);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 12 >> 28);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 16 >> 28);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 20 >> 28);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 24 >> 28);
                                if (++count == length) break block20;
                                dest[destPos + count] = dest[destPos + count - 1] + (double)(word << 28 >> 28);
                                if (++count != length) continue block21;
                                break block20;
                            }
                            default: {
                                throw new IntegrityException("Illegal 'decode nibble' flag ('" + dnib + "'). Valid values are '0', '1' or '2' when the 'nibble' flag is set to " + nibble + ".");
                            }
                        }
                    }
                    default: {
                        throw new IntegrityException("Illegal 'nibble' flag ('" + nibble + "'). Valid values are '0', '1', '2' or '3'.");
                    }
                }
            }
        }
        int overflowCount = 0;
        int underflowCount = 0;
        for (int i = 0; i < count; ++i) {
            if (dest[destPos + i] > 2.147483647E9) {
                ++overflowCount;
            }
            if (!(dest[destPos + i] < -2.147483648E9)) continue;
            ++underflowCount;
        }
        if (overflowCount > 0) {
            log.warning("Questionable data quality! Detected " + overflowCount + " sample values in the miniSEED record that are larger than " + Integer.MAX_VALUE + " (i.e. do not fit into a signed, 32-bit integer value)!");
        }
        if (underflowCount > 0) {
            log.warning("Questionable data quality! Detected " + underflowCount + " sample values in the miniSEED record that are smaller than " + Integer.MIN_VALUE + " (i.e. do not fit into a signed, 32-bit integer value)!");
        }
        if (dest[destPos + count - 1] != lastValue) {
            throw new IntegrityException("The value of the last sample in the time series and the integration constant given in the header of the miniSEED record are not equal.");
        }
        return count;
    }

    @Override
    public int encodeSamples(double[] src, int srcPos, ByteBuffer dest, int destPos, int length, double bias) throws IllegalArgumentException, IntegrityException {
        if (src == null) {
            throw new IllegalArgumentException("The sample source is \"null\".");
        }
        if (src.length == 0) {
            throw new IllegalArgumentException("The source contains no samples.");
        }
        if (srcPos >= src.length) {
            throw new IllegalArgumentException("The source does not contain enough samples to start reading from this offset.");
        }
        if (dest == null) {
            throw new IllegalArgumentException("The destination buffer is \"null\".");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Cannot encode " + length + " samples.");
        }
        int nibble = 0;
        int nibblePos = destPos;
        int wordIndex = 3;
        dest.position(destPos + wordIndex * 4);
        long[] diff = new long[7];
        int srcIndex = srcPos;
        while (srcIndex < src.length && srcIndex - srcPos < length) {
            int diffCount = 0;
            int maxSize = 0;
            int curSize = 0;
            for (int i = 0; i < diff.length; ++i) {
                if (srcIndex + i < src.length && srcIndex + i - srcPos < length) {
                    if (srcIndex == srcPos && i == 0) {
                        diff[0] = Math.round(src[srcIndex]) - Math.round(bias);
                    } else {
                        diff[i] = Math.round(src[srcIndex + i]) - Math.round(src[srcIndex + i - 1]);
                    }
                    ++diffCount;
                } else {
                    diff[i] = 0L;
                }
                if (diff[i] <= 7L && diff[i] >= -8L) {
                    curSize = 4;
                } else if (diff[i] <= 15L && diff[i] >= -16L) {
                    curSize = 5;
                } else if (diff[i] <= 31L && diff[i] >= -32L) {
                    curSize = 6;
                } else if (diff[i] <= 127L && diff[i] >= -128L) {
                    curSize = 8;
                } else if (diff[i] <= 511L && diff[i] >= -512L) {
                    curSize = 10;
                } else if (diff[i] <= 16383L && diff[i] >= -16384L) {
                    curSize = 15;
                } else if (diff[i] <= 0x1FFFFFFFL && diff[i] >= -536870912L) {
                    curSize = 30;
                } else {
                    throw new ArithmeticOverflowException("The difference between two samples (" + diff[i] + ") is to large for encoding with STEIM-2. At most 30 bit (ranging from -536870912 to 536870911) are available to encode differences with this algorithm! Please use a different encoding scheme such as STEIM-1 or INT32.");
                }
                maxSize = Math.max(maxSize, curSize);
                if (maxSize * diffCount == 32) break;
                if (maxSize * diffCount < 32 || maxSize * diffCount <= 32) continue;
                --diffCount;
                break;
            }
            int word = 0;
            switch (diffCount) {
                case 7: {
                    word |= Integer.MIN_VALUE;
                    word |= ((int)diff[0] & 0xF) << 24;
                    word |= ((int)diff[1] & 0xF) << 20;
                    word |= ((int)diff[2] & 0xF) << 16;
                    word |= ((int)diff[3] & 0xF) << 12;
                    word |= ((int)diff[4] & 0xF) << 8;
                    word |= ((int)diff[5] & 0xF) << 4;
                    dest.putInt(word |= (int)diff[6] & 0xF);
                    nibble |= 3 << 30 - (wordIndex << 1);
                    break;
                }
                case 6: {
                    word |= 0x40000000;
                    word |= ((int)diff[0] & 0x1F) << 25;
                    word |= ((int)diff[1] & 0x1F) << 20;
                    word |= ((int)diff[2] & 0x1F) << 15;
                    word |= ((int)diff[3] & 0x1F) << 10;
                    word |= ((int)diff[4] & 0x1F) << 5;
                    dest.putInt(word |= (int)diff[5] & 0x1F);
                    nibble |= 3 << 30 - (wordIndex << 1);
                    break;
                }
                case 5: {
                    word |= 0;
                    word |= ((int)diff[0] & 0x3F) << 24;
                    word |= ((int)diff[1] & 0x3F) << 18;
                    word |= ((int)diff[2] & 0x3F) << 12;
                    word |= ((int)diff[3] & 0x3F) << 6;
                    dest.putInt(word |= (int)diff[4] & 0x3F);
                    nibble |= 3 << 30 - (wordIndex << 1);
                    break;
                }
                case 4: {
                    dest.put((byte)diff[0]);
                    dest.put((byte)diff[1]);
                    dest.put((byte)diff[2]);
                    dest.put((byte)diff[3]);
                    nibble |= 1 << 30 - (wordIndex << 1);
                    break;
                }
                case 3: {
                    word |= 0xC0000000;
                    word |= ((int)diff[0] & 0x3FF) << 20;
                    word |= ((int)diff[1] & 0x3FF) << 10;
                    dest.putInt(word |= (int)diff[2] & 0x3FF);
                    nibble |= 2 << 30 - (wordIndex << 1);
                    break;
                }
                case 2: {
                    word |= Integer.MIN_VALUE;
                    word |= ((int)diff[0] & Short.MAX_VALUE) << 15;
                    dest.putInt(word |= (int)diff[1] & Short.MAX_VALUE);
                    nibble |= 2 << 30 - (wordIndex << 1);
                    break;
                }
                case 1: {
                    word |= 0x40000000;
                    dest.putInt(word |= (int)diff[0] & 0x3FFFFFFF);
                    nibble |= 2 << 30 - (wordIndex << 1);
                    break;
                }
                default: {
                    throw new IntegrityException("Cannot store " + diffCount + " differences in 4 bytes!");
                }
            }
            srcIndex += diffCount;
            if (wordIndex >= 15) {
                dest.putInt(nibblePos, nibble);
                if (dest.remaining() < 64) break;
                wordIndex = 1;
                nibble = 0;
                nibblePos = dest.position();
                dest.position(nibblePos + 4);
                continue;
            }
            ++wordIndex;
        }
        if (wordIndex != 1) {
            dest.putInt(nibblePos, nibble);
        }
        dest.putInt(destPos + 4, (int)Math.round(src[srcPos]));
        dest.putInt(destPos + 8, (int)Math.round(src[srcIndex - 1]));
        return srcIndex - srcPos;
    }

    @Override
    public double getFirstSample(ByteBuffer src, int srcPos) {
        return src.getInt(srcPos + 4);
    }

    @Override
    public double getLastSample(ByteBuffer src, int srcPos, int length) {
        return src.getInt(srcPos + 8);
    }
}

