/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.miniseed;

import de.gfz_potsdam.gipp.common.seis.miniseed.ArithmeticOverflowException;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.MiniseedCodec;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class SteimOneCodec
implements MiniseedCodec {
    private static final int FRAMESIZE = 64;
    private static final int WORDSIZE = 4;
    private static final Logger log = Logger.getLogger(SteimOneCodec.class.getName());

    @Override
    public int decodeSamples(ByteBuffer src, int srcPos, double[] dest, int destPos, int length) throws IntegrityException, ArrayIndexOutOfBoundsException {
        if (length < 0) {
            throw new IllegalArgumentException("Cannot decode " + length + " samples.");
        }
        if (length == 0) {
            return 0;
        }
        int count = 0;
        double lastValue = 0.0;
        src.position(srcPos);
        boolean ignoreDiff = true;
        if (src.remaining() % 64 != 0) {
            throw new IntegrityException("Illegal data area size.(" + src.remaining() + " bytes). Must be multiple of " + 64 + " bytes!");
        }
        block10: while (src.remaining() >= 64) {
            int nibble = src.getInt();
            block11: for (int index = 0; index < 15; ++index) {
                int code = nibble >> 28 - (index << 1) & 3;
                switch (code) {
                    case 0: {
                        switch (count) {
                            case 0: {
                                dest[destPos] = src.getInt();
                                count = 1;
                                break;
                            }
                            case 1: {
                                lastValue = src.getInt();
                                if (length != 1) continue block11;
                                break block10;
                            }
                            default: {
                                src.getInt();
                                break;
                            }
                        }
                        continue block11;
                    }
                    case 1: {
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.get();
                        if (ignoreDiff) {
                            ignoreDiff = false;
                        } else {
                            ++count;
                        }
                        if (count == length) break block10;
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.get();
                        if (++count == length) break block10;
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.get();
                        if (++count == length) break block10;
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.get();
                        if (++count != length) continue block11;
                        break block10;
                    }
                    case 2: {
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.getShort();
                        if (ignoreDiff) {
                            ignoreDiff = false;
                        } else {
                            ++count;
                        }
                        if (count == length) break block10;
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.getShort();
                        if (++count != length) continue block11;
                        break block10;
                    }
                    case 3: {
                        dest[destPos + count] = dest[destPos + count - 1] + (double)src.getInt();
                        if (ignoreDiff) {
                            ignoreDiff = false;
                        } else {
                            ++count;
                        }
                        if (count != length) continue block11;
                        break block10;
                    }
                    default: {
                        throw new IntegrityException("Illegal 'nibble' flag ('" + nibble + "'). Valid values are '0', '1', '2' or '3'.");
                    }
                }
            }
        }
        int overflowCount = 0;
        int underflowCount = 0;
        for (int i = 0; i < count; ++i) {
            if (dest[destPos + i] > 2.147483647E9) {
                ++overflowCount;
            }
            if (!(dest[destPos + i] < -2.147483648E9)) continue;
            ++underflowCount;
        }
        if (overflowCount > 0) {
            log.warning("Questionable data quality! Detected " + overflowCount + " sample values in the miniSEED record that are larger than " + Integer.MAX_VALUE + " (i.e. do not fit into a signed, 32-bit integer value)!");
        }
        if (underflowCount > 0) {
            log.warning("Questionable data quality! Detected " + underflowCount + " sample values in the miniSEED record that are smaller than " + Integer.MIN_VALUE + " (i.e. do not fit into a signed, 32-bit integer value)!");
        }
        if (dest[destPos + count - 1] != lastValue) {
            throw new IntegrityException("The value of the last sample in the time series and the integration constant given in the header of the miniSEED record are not equal.");
        }
        return count;
    }

    @Override
    public int encodeSamples(double[] src, int srcPos, ByteBuffer dest, int destPos, int length, double bias) throws IllegalArgumentException, IntegrityException {
        int srcIndex;
        int diffCount;
        if (src == null) {
            throw new IllegalArgumentException("The sample source is \"null\".");
        }
        if (src.length == 0) {
            throw new IllegalArgumentException("The source contains no samples.");
        }
        if (srcPos >= src.length) {
            throw new IllegalArgumentException("The source does not contain enough samples to start reading from this offset.");
        }
        if (dest == null) {
            throw new IllegalArgumentException("The destination buffer is \"null\".");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Cannot encode " + length + " samples.");
        }
        int nibble = 0;
        int nibblePos = destPos;
        int wordIndex = 3;
        dest.position(destPos + wordIndex * 4);
        long[] diff = new long[4];
        for (srcIndex = srcPos; srcIndex < src.length && srcIndex - srcPos < length; srcIndex += diffCount) {
            diffCount = 0;
            int maxSize = 0;
            int curSize = 0;
            for (int i = 0; i < diff.length; ++i) {
                if (srcIndex + i < src.length && srcIndex + i - srcPos < length) {
                    if (srcIndex == srcPos && i == 0) {
                        diff[0] = Math.round(src[srcIndex]) - Math.round(bias);
                    } else {
                        diff[i] = Math.round(src[srcIndex + i]) - Math.round(src[srcIndex + i - 1]);
                    }
                    ++diffCount;
                } else {
                    diff[i] = 0L;
                }
                if (diff[i] <= 127L && diff[i] >= -128L) {
                    curSize = 1;
                } else if (diff[i] <= 32767L && diff[i] >= -32768L) {
                    curSize = 2;
                } else if (diff[i] <= Integer.MAX_VALUE && diff[i] >= Integer.MIN_VALUE) {
                    curSize = 4;
                } else {
                    throw new ArithmeticOverflowException("The difference between two samples (" + diff[i] + ") is to large for encoding with STEIM-1. At most 32 bit (ranging from " + Integer.MIN_VALUE + " to " + Integer.MAX_VALUE + ") are available to encode differences with this algorithm! Please use a different encoding scheme such as INT32.");
                }
                maxSize = Math.max(maxSize, curSize);
                if (maxSize * diffCount == 4) break;
                if (maxSize * diffCount < 4 || maxSize * diffCount <= 4) continue;
                --diffCount;
                break;
            }
            switch (diffCount) {
                case 4: {
                    dest.put((byte)diff[0]);
                    dest.put((byte)diff[1]);
                    dest.put((byte)diff[2]);
                    dest.put((byte)diff[3]);
                    nibble |= 1 << 30 - (wordIndex << 1);
                    break;
                }
                case 3: {
                    --diffCount;
                }
                case 2: {
                    dest.putShort((short)diff[0]);
                    dest.putShort((short)diff[1]);
                    nibble |= 2 << 30 - (wordIndex << 1);
                    break;
                }
                case 1: {
                    dest.putInt((int)diff[0]);
                    nibble |= 3 << 30 - (wordIndex << 1);
                    break;
                }
                default: {
                    throw new IntegrityException("Cannot store " + diffCount + " differences in 4 bytes!");
                }
            }
            if (wordIndex >= 15) {
                dest.putInt(nibblePos, nibble);
                if (dest.remaining() < 64) break;
                wordIndex = 1;
                nibble = 0;
                nibblePos = dest.position();
                dest.position(nibblePos + 4);
                continue;
            }
            ++wordIndex;
        }
        if (wordIndex != 1) {
            dest.putInt(nibblePos, nibble);
        }
        dest.putInt(destPos + 4, (int)Math.round(src[srcPos]));
        dest.putInt(destPos + 8, (int)Math.round(src[srcIndex - 1]));
        return srcIndex - srcPos;
    }

    @Override
    public double getFirstSample(ByteBuffer src, int srcPos) {
        return src.getInt(srcPos + 4);
    }

    @Override
    public double getLastSample(ByteBuffer src, int srcPos, int length) {
        return src.getInt(srcPos + 8);
    }
}

